/*
	FrosOS_Init.cpp: OS dependant functions called by the Z-Machine.
	Copyright (C) 2005 Fabio Concas

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/


#include "StdAfx.h"

#include "Frostz.h"
#include "StoryInfo.h"



static bool bWasUsingColours;
static bool bWasUsingStyles;
static int nOldFontHeight;
static int nOldFontWidth;

extern StoryInfo acInfocomReleases[NO_INFOCOM_STORIES];


extern BYTE* imgData; // Defined in OS_Pict.cpp

extern "C" {
#include "Frotz/Frotz.h"
#include "ZTools/pix2gif.h"



// Zork Zero unsupported in blind mode
extern char cBlindMode;

extern DWORD WINAPI FullScreen (LPVOID lpParameter);

extern void reset_memory (void);
extern int init_sound (void);

//****************************************************************************
// os_init_screen
//****************************************************************************
void os_init_screen (void)
{	
	// Save current settings
	bWasUsingColours = Application.UseColours;
	bWasUsingStyles = Application.UseStyles;
	nOldFontHeight = Application.FontHeight;
	nOldFontWidth = Application.FontWidth;


	SetWindowText (Application.GetMainWnd (), L"(Unknown title)");
	// Try to recognise story
	for (int nStoryNo = 0; nStoryNo < NO_INFOCOM_STORIES; nStoryNo++)
	{
		// Found story information?
		if (acInfocomReleases[nStoryNo].nRelease == h_release
			&& strcmp( acInfocomReleases[nStoryNo].achSerialNo, (char *) h_serial ) == 0)
		{
			//unsigned short strStoryName[128];
			//mbstowcs (strStoryName, acInfocomReleases[nStoryNo].achStoryName, 128);
			char* strStoryName = acInfocomReleases[nStoryNo].achStoryName;

			//***** Set story ID for buggy stories *****
			if (!strncmp (strStoryName, "Arthur", 6)) // Arthur - Quest for Excalibur
				story_id = ARTHUR;
			else if (!strncmp (strStoryName, "Beyond", 6)) // Beyond Zork
				story_id = BEYOND_ZORK;
			else if (!strncmp (strStoryName, "Journe", 6)) // Journey
				story_id = JOURNEY;
			else if (!strncmp (strStoryName, "Lurkin", 6)) // Lurking Horror
				story_id = LURKING_HORROR;
			else if (!strncmp (strStoryName, "Sherlo", 6)) // Sherlock - Riddle of the Crown Jewels
				story_id = SHERLOCK;
			else if (!strncmp (strStoryName, "Shogun", 6)) // Shogun
				story_id = SHOGUN;
			else if (!strncmp (strStoryName, "Zork Zero", 9)) // Zork Zero - Revenge of Megaboz
				story_id = ZORK_ZERO;
			else
				story_id = UNKNOWN;
			//******************************************

			// Zork Zero unsupported in blind mode
			if (cBlindMode && story_id == ZORK_ZERO)
			{
				MessageBox (Application.GetMainWnd (), L"Zork Zero not supported in blind mode.",
					L"Frostz", MB_OK | MB_ICONSTOP);
				Application.GoFullScreen ();
				return;
			}

			// Check if story is supported
			if ((acInfocomReleases[nStoryNo].nSettings & STORY_NOSUPPORT) != 0)
			{
				unsigned short strDisplay[256];

				mbstowcs (strDisplay, strStoryName, strlen (strStoryName) + 1);

				wcscat (strDisplay, L" is not supported by Frostz");
				
				// Display message
				MessageBox (Application.GetMainWnd (), strDisplay, L"Frostz", MB_OK | MB_ICONSTOP);
				Application.GoFullScreen ();
				return;
			}

			// Check if story is supported
			if ((acInfocomReleases[nStoryNo].nSettings & STORY_LIMITEDSUPPORT) != 0)
			{
				unsigned short strDisplay[256];

				mbstowcs (strDisplay, strStoryName, strlen (strStoryName) + 1);

				wcscat (strDisplay, L" is not properly supported by Frostz");

				// Display message
				MessageBox (Application.GetMainWnd (), strDisplay, L"Frostz", MB_OK | MB_ICONEXCLAMATION);
			}

			// Story requires small font?
			if ((acInfocomReleases[nStoryNo].nSettings & STORY_SMALLFONT) != 0)
			{
				Application.FontHeight = 8;//TERMINAL_FONT_HEIGHT;
				Application.FontWidth = 4;//TERMINAL_FONT_WIDTH;
			}

			// Story doesn't want colours?
			if ((acInfocomReleases[nStoryNo].nSettings & STORY_NOCOLOURS) != 0)
			{
				Application.UseColours = false;
			}

			// Story uses graphics chars?
			if ((acInfocomReleases[nStoryNo].nSettings & STORY_GFXCHARS) != 0)
			{
				Application.UseEuroChars = false;
			}

			// Set window title
			{
				unsigned short wTitle[64];
				mbstowcs (wTitle, strStoryName, 64);
				SetWindowText (Application.GetMainWnd (), wTitle);
			}
			break;
		}
	}

	// CBM interpreters don't support text styles
	if (Application.InterpreterNumber == INTERP_CBM_64 ||
		Application.InterpreterNumber == INTERP_CBM_128)
		Application.UseStyles = false;

	// Update menus
	SendMessage (Application.GetMainWnd (), WM_UPDATE_MENU, 0, 0);


	//*** Try to get V6/Beyond Zork image directory ***
	if (h_version == V6 || story_id == BEYOND_ZORK)
	{
		char szFileName[256];
		header_t imgHeader;

		// Build file name
		//memset (szFileName, 0, 256);
		for (unsigned int Cnt = 0; Cnt < strlen (Application.sStoryFile); ++Cnt)
			if (Application.sStoryFile[Cnt] != '.')
				szFileName[Cnt] = Application.sStoryFile[Cnt];
			else
			{
				szFileName[Cnt] = 0;
				break;
			}

		strcat (szFileName, ".mg1");

		// Reset values
		Application.imgCount = 0;
		Application.imgVersion = 0;
		if (Application.imgDir)
			LocalFree (Application.imgDir);
		if (Application.imgFile)
			fclose (Application.imgFile);

		// Open file
		if ((Application.imgFile = fopen (szFileName, "rb")) != NULL)
		{
			FILE *fp = Application.imgFile;

			// Read image file header
			fread (&imgHeader.part,		1, 1, fp);
			fread (&imgHeader.flags,	1, 1, fp);
			fread (&imgHeader.unknown1, 2, 1, fp);
			fread (&imgHeader.images,	2, 1, fp);
			fread (&imgHeader.unknown2, 2, 1, fp);
			fread (&imgHeader.dir_size, 1, 1, fp);
			fread (&imgHeader.unknown3, 1, 1, fp);
			fread (&imgHeader.checksum, 2, 1, fp);
			fread (&imgHeader.unknown4, 2, 1, fp);
			fread (&imgHeader.version,	2, 1, fp);

			// Store image count
			Application.imgCount = imgHeader.images;

			// Allocate image directories memory
			Application.imgDir = (pdirectory_t *)LocalAlloc (LPTR,
				sizeof (pdirectory_t) * imgHeader.images);

			if (Application.imgDir == NULL)
			{
				MessageBox (GetActiveWindow (), L"Out of memory allocating V6 img dir buffer", L"Frostz",
					MB_APPLMODAL | MB_ICONSTOP);
				fclose (fp);
			}
			else
			{
				pdirectory_t *dir = Application.imgDir;
				// Process directory entries
				for (int Cnt = 0; (unsigned int) Cnt < (unsigned int) imgHeader.images; Cnt++)
				{
					fread (&dir[Cnt].image_number, 2, 1, fp);
					fread (&dir[Cnt].image_width, 2, 1, fp);
    				fread (&dir[Cnt].image_height, 2, 1, fp);
    				fread (&dir[Cnt].image_flags, 2, 1, fp);
    				dir[Cnt].image_data_addr = (unsigned long) fgetc (fp) << 16;
    				dir[Cnt].image_data_addr += (unsigned long) fgetc (fp) << 8;
    				dir[Cnt].image_data_addr += (unsigned long) fgetc (fp);
					if ((unsigned int) imgHeader.dir_size == 14)
					{
						dir[Cnt].image_cm_addr = (unsigned long) fgetc (fp) << 16;
						dir[Cnt].image_cm_addr += (unsigned long) fgetc (fp) << 8;
						dir[Cnt].image_cm_addr += (unsigned long) fgetc (fp);
					}
					else
					{
						dir[Cnt].image_cm_addr = 0;
						(void) fgetc (fp);
					}
				} // Processed directories OK
			} // Dir memory allocated OK
		} // File opened OK
		/*** DEBUG ***
		else
		{
			TCHAR wMsg[256];
			mbstowcs (wMsg, szFileName, 256);
			wcscat (wMsg, L" not found!");
			MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
			//Application.GoFullScreen ();
		}
		/*************/
	}
	//*************************************


	// Initialise screen
	Application.InitializeScreen ();

	// Set screen dimensions
    h_screen_width = h_screen_cols = Application.GetWidth ();
    h_screen_height = h_screen_rows = Application.GetHeight ();


	/* Set the interpreter number (a constant telling the game which
		operating system it runs on) and the interpreter version. The
		interpreter number has effect on all V6 games and Beyond Zork.
	   Also, disable colors for interpreters which do not support them.
	*/
		  
	h_interpreter_number = Application.InterpreterNumber;//INTERP_MSDOS;
	switch (h_interpreter_number)
	{
		case INTERP_AMIGA:
			h_interpreter_version = 'J';
			break;

		case INTERP_MSDOS:
		case INTERP_MACINTOSH:
			h_interpreter_version = 'E';
			break;

		case INTERP_APPLE_IIC:
		case INTERP_APPLE_IIGS:
			h_interpreter_version = 'C';
			Application.UseColours = false;
			break;

		case INTERP_CBM_64:
		case INTERP_CBM_128:
			h_interpreter_version = 'A';
			break;

		default:
			h_interpreter_version = 'F';
			break;
	}


	// Set config flags
    if (h_version == V3 && Application.TandyBit)
		h_config |= CONFIG_TANDY;

	if (h_version == V3)
		h_config |= CONFIG_SPLITSCREEN;
		  
	if (h_version >= V4)
	{
		h_config |= CONFIG_FIXED | CONFIG_TIMEDINPUT;

		if (Application.UseStyles)
			h_config |= CONFIG_BOLDFACE | CONFIG_EMPHASIS;
	}
	
	if (h_version >= V5 && Application.UseColours)
		h_config |= CONFIG_COLOUR;

	if (h_version >= V5)
		if (h_interpreter_number != INTERP_DEC_20 &&
			h_interpreter_number != INTERP_CBM_64 &&
			h_interpreter_number != INTERP_CBM_128 &&
			h_interpreter_number != INTERP_MACINTOSH)
			h_config |= CONFIG_PICTURES;
		  
	/* Handle various game flags. These flags are set if the game wants
	to use certain features. The flags must be cleared if the feature
	is not available. */
		  
    if (h_flags & GRAPHICS_FLAG && story_id!=BEYOND_ZORK )
		h_flags &= ~GRAPHICS_FLAG;
		  
    if (h_version == V3 && (h_flags & OLD_SOUND_FLAG))
		if (!init_sound ())
			h_flags &= ~OLD_SOUND_FLAG;
		  
    if (h_flags & SOUND_FLAG)
		if (!init_sound ())
			h_flags &= ~SOUND_FLAG;
		  
    if (h_version >= V5 && (h_flags & UNDO_FLAG))
	if (!option_undo_slots)
	    h_flags &= ~UNDO_FLAG;

    if (h_flags & COLOUR_FLAG)
	    h_flags &= ~COLOUR_FLAG;

	h_flags &= ~MENU_FLAG;

	// Clear the mouse flag for systems which don't support it
	if (h_version >= V5)
		if (h_interpreter_number == INTERP_DEC_20 ||
			h_interpreter_number == INTERP_APPLE_IIE ||
			h_interpreter_number == INTERP_CBM_64 ||
			h_interpreter_number == INTERP_CBM_128)
		h_flags &= ~MOUSE_FLAG;

	// Set some options
	{
		option_ignore_errors = Application.ignore_errors;
		option_expand_abbreviations = Application.expand_abbreviations;
	}
	
	// Make sure we've still got the focus
	//Application.GoFullScreen ();
	SetForegroundWindow (Application.GetMainWnd ());
	SendMessage(Application.GetMainWnd (), WM_TAKE_FOCUS, 0, 0);

	// Show cursor
	//os_cursor_on ();

	// Flag that initialized
	Application.Initialized = true;

	// Be sure to go fullscreen
	DWORD tmp;
	HANDLE hThread = CreateThread (NULL, 0,
			(LPTHREAD_START_ROUTINE )FullScreen,
			(LPVOID)NULL, 0, &tmp);

	if (hThread == 0)
	{
		unsigned short wMsg[256];
		wsprintf (wMsg, L"Error #%d", GetLastError ());
		MessageBox (Application.GetMainWnd (), L"Could not start FullScreen thread", wMsg, MB_OK | MB_ICONEXCLAMATION);
	}
	else
		ResumeThread (hThread);
}



//****************************************************************************
// os_process_arguments
//****************************************************************************
void	os_process_arguments (int argc, char *argv[])
{
	// Not really useful
}
//****************************************************************************



//****************************************************************************
// os_fatal
//****************************************************************************
void os_fatal (const char *s)
{
	unsigned short strError[256];

	memset (strError, 0, sizeof (unsigned short) * 256);
	mbstowcs (strError, s, strlen (s));

	// Display error
	MessageBox (Application.GetMainWnd (), strError, L"Frostz", MB_OK | MB_ICONSTOP);
	Application.GoFullScreen ();

	// Z machine running?
	if (Application.isZmachineRunning)
	{
		// Reset memory
		reset_memory ();

		// Flag that Z machine is no longer running
		Application.isZmachineRunning = FALSE;

		if(Application.Initialized)
		// Reset display
		os_reset_screen ();
	}

	Application.SetBgImage (IDB_FROSTZBG);

	// Stop execution of Z machine thread 
	ExitThread (1);
}



//****************************************************************************
// os_reset_screen
//****************************************************************************
void os_reset_screen (void) 
{
	// Clear screen
	Application.ClearScreen( TRUE );

	// Turn off cursor
	os_cursor_off ();

	// Reset screen
	Application.ResetScreen ();

	// Set window title
	SetWindowText (Application.GetMainWnd (), L"Frostz for PocketPC");

	// Flag that not initialized
	Application.Initialized = false;

	// Restore previous settings
	Application.UseEuroChars = true;
	Application.UseColours = bWasUsingColours;
	Application.UseStyles = bWasUsingStyles;
	Application.FontHeight = nOldFontHeight;
	Application.FontWidth = nOldFontWidth;

	// Update menus
	SendMessage (Application.GetMainWnd (), WM_UPDATE_MENU, 0, 0);

	// Free image memory
	if (imgData)
		LocalFree (imgData);
}



//****************************************************************************
// os_random_seed
//	Return current time as random seed
//****************************************************************************
int os_random_seed (void) 
{ 
	SYSTEMTIME Time;

	GetLocalTime (&Time);

	return (int)Time.wMilliseconds;
}



}	// extern "C"
