#if _WIN32_WCE < 210

#include "stdafx.h"
#include "FrotzCEIO.h"

class CFrotzFile : public CFile
{
public:
	CFrotzFile( );
	CFrotzFile( int hFile );
	CFrotzFile( LPCTSTR lpszFileName, UINT nOpenFlags );

	BOOL
		m_bError;
};

CFrotzFile::CFrotzFile( )
: m_bError( FALSE )
{
}

CFrotzFile::CFrotzFile( int hFile )
: CFile( hFile ), m_bError( FALSE )
{
}

CFrotzFile::CFrotzFile( LPCTSTR lpszFileName, UINT nOpenFlags )
: CFile( lpszFileName, nOpenFlags ), m_bError( FALSE )
{
}


extern "C" FILE *fopen( const char *filename, const char *mode )
{
CFrotzFile *pcFile;
int nFileMode = 0;
CString strFileName = filename;

	// Check file mode
	if (strchr( mode, 'r' ) != NULL) 
	{
		if (strchr( mode, '+' ) != NULL) nFileMode = CFrotzFile::modeReadWrite;
		else nFileMode = CFrotzFile::modeRead;
	}
	else if (strchr( mode, 'w' ) != NULL) 
	{
		if (strchr( mode, '+' ) != NULL) nFileMode = CFrotzFile::modeReadWrite;
		else nFileMode = CFrotzFile::modeWrite;
		
		nFileMode |= CFrotzFile::modeCreate;
	}
	else if (strchr( mode, 'a' ) != NULL) 
	{
		if (strchr( mode, '+' ) != NULL) nFileMode = CFrotzFile::modeReadWrite;
		else nFileMode = CFrotzFile::modeWrite;
		
		nFileMode |= CFrotzFile::modeCreate | CFrotzFile::modeNoTruncate;
	}
	if (strchr( mode, 'b' ) != NULL) nFileMode |= CFrotzFile::typeBinary;
	else nFileMode |= CFrotzFile::typeText;

	// Create new file object
	if((pcFile = new CFrotzFile) != NULL)
	{
		// Open file
		if (pcFile->Open( strFileName, nFileMode ) == 0)
		{
			delete pcFile;
			pcFile = NULL;
		}
	}

	return pcFile;
}

extern "C" size_t fread( void *buffer, size_t size, size_t count, FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;

	// Read specified no. of bytes from file
	return (size_t) (pcFile->Read( buffer, size*count ) / size);
}

extern "C" int fseek( FILE *stream, long offset, int origin )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
UINT nFrom;
int nReturn = 0;

	// Check seek origin
	switch (origin)
	{
	case SEEK_SET:
		nFrom = CFrotzFile::begin;
		break;
	case SEEK_CUR:
		nFrom = CFrotzFile::current;
		break;
	case SEEK_END:
		nFrom = CFrotzFile::end;
		break;
	}

	TRY
	{
		// Seek to specified offset
		pcFile->Seek( offset, nFrom );
	}
	CATCH( CFileException, e )
	{
		pcFile->m_bError = TRUE;
		nReturn = -1;
	}
	END_CATCH

	return nReturn;
}

extern "C" long ftell( FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
DWORD dwCurrPos = pcFile->GetPosition();

	// Return actual file position
	return (long) pcFile->Seek( dwCurrPos, CFrotzFile::begin );
}

extern "C" int fclose( FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;

	// Close file
	pcFile->Close();

	// Delete file object
	delete pcFile;
	pcFile = NULL;

	return 0;
}

extern "C" int fgetc( FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
unsigned char ch;

	// Read a byte from the file	
	if (pcFile->Read( &ch, 1 )) return (int) ch;
	else return EOF;
}

extern "C" int ferror( FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;

	return pcFile->m_bError;
}

extern "C" size_t fwrite( const void *buffer, size_t size, size_t count, FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
size_t nReturn = size * count;

	TRY
	{
		// Write buffer to file
		pcFile->Write( buffer, size * count );
	}
	CATCH( CFileException, e )
	{
		pcFile->m_bError = TRUE;
		nReturn = 0;
	}
	END_CATCH

	return nReturn;
}

extern "C" int fputc( int c, FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
unsigned char ch = (unsigned char) c;
int nReturn = c;

	TRY
	{
		// Write char to file
		pcFile->Write( &ch, 1 );
	}
	CATCH( CFileException, e )
	{
		pcFile->m_bError = TRUE;
		nReturn = EOF;
	}
	END_CATCH

	return nReturn;
}

extern "C" void debug_msg( const char *pszString, int nNum )
{
CString strDebug, strMsg = pszString;

	strDebug.Format( TEXT("%s - %d"), (LPCTSTR) strMsg , nNum);
	AfxMessageBox( strDebug);
}

extern "C" int fputs( const char *string, FILE *stream )
{
CFrotzFile *pcFile = (CFrotzFile *) stream;
size_t nReturn = strlen( string );

	TRY
	{
		// Write string to file
		pcFile->Write( string, nReturn );
	}
	CATCH( CFileException, e )
	{
		pcFile->m_bError = TRUE;
		nReturn = EOF;
	}
	END_CATCH

	return nReturn;
}

#endif