
// Minimum size of a sound file (the header itself)
#define MIN_HEADER_SIZE 10

// Frotz sound file header definition
typedef struct 
{
    WORD nPrefix;
    BYTE nRepeats;
    BYTE nBaseNote;
    WORD nFrequency;
    WORD nUnused;
    WORD nLength;
} FrotzSoundHeader;

// FrotzCE Sound engine
class CFrotzCESnd
{
private:
	char 
		// Sample buffer
		*m_pachSampleData;

	int 
		// Current sample loaded
		m_nCurrentSample;

	BOOL
		// Currently playing a sound?
		m_bPlayingSound;

	FrotzSoundHeader
		// Sample header
		m_sHeader;

public:
	CFrotzCESnd();
	~CFrotzCESnd();

	void 
		// Makes a beep
		Beep( int nNumber );
	BOOL 
		// Loads the specified sample
		LoadSample( int nNumber );
	void 
		// Starts playing the specified sample
		StartSample( int nNumber, int nVolume, int nRepeats );
	void 
		// Stop playing sample
		StopSample();
	void 
		// Reset sound
		ResetSound();
};
