// FrotzCEView.h : interface of the CFrotzCEView class
//
/////////////////////////////////////////////////////////////////////////////

#define FROTZCEVIEW ((CFrotzCEView *)(((CMainFrame *) AfxGetApp()->m_pMainWnd)->GetActiveView()))

#define KEYBUFFER_SIZE 128

#define WM_CREATE_CURSOR (WM_USER + 1)
#define WM_UPDATE_CURSOR (WM_USER + 2)
#define WM_SHOW_CURSOR (WM_USER + 3)
#define WM_TAKE_FOCUS (WM_USER + 4)

#define ID_UPDATE_TIMER 1

#define SPECIAL_KEY_HOME 223
#define SPECIAL_KEY_END 224
#define SPECIAL_KEY_WORD_LEFT 225
#define SPECIAL_KEY_WORD_RIGHT 226
#define SPECIAL_KEY_DELETE 227
#define SPECIAL_KEY_INSERT 228
#define SPECIAL_KEY_PAGE_UP 229
#define SPECIAL_KEY_PAGE_DOWN 230
#define SPECIAL_KEY_DELETE_WORD 231
#define SPECIAL_KEY_TRANSPOSE 232
#define SPECIAL_KEY_DELETE_LEFT 233

#define UP_ARROW_KEY	129
#define LEFT_ARROW_KEY	131
#define RIGHT_ARROW_KEY 132
#define DOWN_ARROW_KEY	130

#define BACKSPACE_KEY	8
#define TAB_KEY			9
#define ENTER_KEY		13
#define ESC_KEY			27

#define STATE_NONE 0
#define STATE_MOVING 1
#define STATE_LOOKING 2
#define STATE_OPENING 3
#define STATE_TAKING 4
#define STATE_GOING 5

#define NUM_COLOURS 4

#define PALLETTE_BLACK 0
#define PALLETTE_DARKGREY 1
#define PALLETTE_LIGHTGREY 2
#define PALLETTE_WHITE 3

#define NORMAL_STYLE 0

#define DEF_TEXT_STYLE NORMAL_STYLE
#define DEF_TEXT_COLOUR ((PALLETTE_WHITE << 2) | PALLETTE_BLACK)

#define NUM_STYLE_BITS 4

#define STYLE(x) ((x)&(0xff>>NUM_STYLE_BITS))
#define COLOUR(x) ((x)>>NUM_STYLE_BITS)

#if _WIN32_WCE < 200
#define TERMINAL_FONT_HEIGHT 8
#define SMALL_FONT_HEIGHT 10
#else
#define TERMINAL_FONT_HEIGHT 13
#define SMALL_FONT_HEIGHT 14
#endif
#define TERMINAL_FONT_WIDTH 3
#define SMALL_FONT_WIDTH 8

#define FROTZCE_UPDATE_MS 250

class CFrotzCEView : public CView
{
private:
	int
		// Character dimensions
		m_nCharWidth,
		m_nCharHeight,

		// Screen dimensions
		m_nWidth,
		m_nHeight,
		
		// Cursor position
		m_nCursorCol,
		m_nCursorRow;

	BOOL
		// Cursor state
		m_bCursorOn,
		m_bCursorSet;

	TCHAR*
		// Screen buffer
		m_pScreen;

	BYTE* 
		// Attributes buffer
		m_pAttributes;

	COLORREF
		// Colour pallette
		m_acPallette[NUM_COLOURS];

	BYTE
		// Text styles and colour
		m_nCurrentStyle,
		m_nCurrentFont,
		m_nCurrentColour;

	HFONT 
		// Current font used for screen
		m_hCurrentFont;

	BOOL
		// Flags copied from CFrotzCEApp
		m_bUseStyles,
		m_bUseEuroChars,
		m_bUseColours;

	int
		// Values copied from CFrotzCEApp
		m_nDefaultStyle,
		m_nDefaultFontHeight,
		m_nDefaultFontWidth;

	HANDLE
		// Event object used to signal keypresses
		m_hKeyEvent;

	BOOL
		// Currently expecting input?
		m_bExpectingInput;

	BOOL
		// Should redraw the screen?
		m_bRedraw;

	BOOL
		// Should refresh the screen immediately?
		m_bInstantRefresh;

	UINT
		// Handle to update timer
		m_hUpdateTimer;

	int
		// Current state
		m_nState;

	CRITICAL_SECTION 
		// Critical section object used to serialize access to keyboard buffer
		m_cKbdCriticalSection,
		// Critical section object used to serialize access to screen
		m_cScrnCriticalSection;

	int
		// Keyboard buffer
		m_acKeyBuffer[KEYBUFFER_SIZE],
		// Current read position in keyboard buffer
		*m_pcReadKeyBuffer,
		// Current write position in keyboard buffer
		*m_pcWriteKeyBuffer;

protected: // create from serialization only
	CFrotzCEView();
	DECLARE_DYNCREATE(CFrotzCEView)

	void
		// Set current text colour
		SetColour( CDC* pDC, BYTE nColour );

	HFONT
		// Set current text style
		SetStyle( CDC* pDC, BYTE nStyle, BOOL bForce=FALSE );

	void 
		// Redraw the specified screen area
		UpdateScreenArea( CDC* pDC, int nTop, int nLeft, int nBottom, int nRight );

// Attributes
public:
	CFrotzCEDoc* 
		GetDocument();

	int
		GetWidth() {return m_nWidth;}

	int
		GetHeight() {return m_nHeight;}

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFrotzCEView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	void 
		// Clears the screen 
		ClearScreen( BOOL bUpdate=TRUE );

	void 
		// Display character at current cursor position
		DisplayChar( char ch, BOOL bUpdateCaret=FALSE );

	void 
		// Display string at current cursor position
		DisplayString( const char* acString );

	void 
		// Erases an area of the screen
		EraseScreenArea( int nTop, int nLeft, int nBottom, int nRight );

	void 
		// Gets current cursor pos
		GetCursorPos( int *pnRow, int *pnCol );

	int
		// Gets a key
		GetKey( int nTimeOut );

	int
		// Gets a line
		GetLine( char *acBuffer, int nMax, int nTimeOut );

	void
		// Initialises the display
		InitialiseScreen();

	void
		// Resets the display
		ResetScreen();

	void
		// Scrolls an area of the screen
		ScrollScreenArea( int nTop, int nLeft, int nBottom, int nRight, int nUnits );

	void 
		// Sets the cursor position
		SetCursorPos( int nRow, int nCol, BOOL bUpdate=FALSE );

	void
		// Sets the cursor state
		SetCursorState( BOOL bCursorOn );

	void
		// Sets the current text colour
		SetTextColour( int nFgCol, int nBkCol );

	void
		// Sets the current text style
		SetTextStyle( int nStyle );

	void 
		// Stuffs a string into the keyboard buffer
		StuffKeyboard( const char *pchChars, BOOL bReturn=FALSE, BOOL bEsc=FALSE );

	virtual ~CFrotzCEView();
#ifdef _DEBUG
	virtual void 
		AssertValid() const;
	virtual void 
		Dump(CDumpContext& dc) const;
#endif

protected:
	void
		// Updates the cursor position
		UpdateCaretPos();

// Generated message map functions
protected:
	//{{AFX_MSG(CFrotzCEView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnCreateCursor();
	afx_msg void OnUpdateCursor();
	afx_msg void OnShowCursor( UINT bShow );
	afx_msg void OnTakeFocus();
	afx_msg void OnDown();
	afx_msg void OnEast();
	afx_msg void OnInventory();
	afx_msg void OnLook();
	afx_msg void OnNorth();
	afx_msg void OnSouth();
	afx_msg void OnTake();
	afx_msg void OnUp();
	afx_msg void OnWest();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRestore();
	afx_msg void OnSave();
	afx_msg void OnUndo();
	afx_msg void OnOpen();
	afx_msg void OnGo();
	afx_msg void OnDrop();
	afx_msg void OnQuit();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in FrotzCEView.cpp
inline CFrotzCEDoc* CFrotzCEView::GetDocument()
   { return (CFrotzCEDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
