/*
 * random.c
 *
 * Z-machine random number generator
 *
 */

#include "frotz.h"
#include "s5api.h"


/*
 * seed_random
 *
 * Set the seed value for the random number generator.
 *
 */

/*void seed_random (short value)
{

    if (value == 0) {		
	A = os_random_seed ();
	interval = 0;
    } else if (value < 1000) {	
	counter = 0;
	interval = value;
    } else {		
	A = value;
	interval = 0;
    }

}
*/
/* seed_random */

/*
 * z_random, store a random number or set the random number seed.
 *
 *	zargs[0] = range (positive) or seed value (negative)
 *
 */

void z_random (struct sg *g)
{

    if ((short) (g->zargs[0]) <= 0) {	/* set random seed */

	//seed_random (- (short) zargs[0]);
	store (g,0);

    } else {				/* generate random number */

	zword result;

	if (g->interval != 0) {		/* ...in special mode */
	    result = (g->counter)++;
	    if (g->counter == g->interval) g->counter = 0;
	} else {			/* ...in standard mode */
	    result = SrvRandom(g);
	}

	store (g,(zword) (result % (g->zargs[0]) + 1));

    }

}/* z_random */
