// S5api.h

#define FILE void
#ifndef far
#define far
#endif
#ifndef NULL
#define NULL 0
#endif

#include "frotz.h"
#include "s5frotz.h"
#include <e32std.h>

#ifndef HISTORY_BUFSIZE
#define HISTORY_BUFSIZE 500
#endif
#define MAX_NESTING 16


struct sg
{
	void *papp;
void *ss; /* = RMainServ*/
char thestoryname[128];
TInt64 seed;
unsigned char filebuffin[512];
unsigned char filebuffout[512];
short script_valid;
short locked;
short flag;
short pos;
void *hbuff[2+MAX_UNDO_SLOTS]; // 0 = story, 1 = reserved, 2+ = undo
void *aFs;
void *thisthread;
short first_restart;
zchar decoded[10];
zword encoded[3];
struct {
    enum story story_id;
    short pic;
    short pic1;
    short pic2;
} mapper[28];
struct {
    zword y_pos;
    zword x_pos;
    zword y_size;
    zword x_size;
    zword y_cursor;
    zword x_cursor;
    zword left;
    zword right;
    zword nl_routine;
    zword nl_countdown;
    zword style;
    zword colour;
    zword font;
    zword font_size;
    zword attribute;
    zword line_count;
} wp[8], *cwp;
short current_bg;
short current_fg;
short current_style;
short current_font;
byte text_bg;
byte text_fg;
short bg;
short fg;
byte scrn_attr;
short cursor_x;
short cursor_y;
byte far *graphics_font;
byte far *mcga_font;
byte far *mcga_width;
word far *serif_font;
byte far *serif_width;
long limit;
struct {
    zchar buffer[HISTORY_BUFSIZE];
    short latest;
    short current;
    short prefix_len;
} history;
struct {
    zchar *buffer;
    short pos;
    short length;
    short max_length;
    short width;
    short max_width;
} input;
short overwrite;
short keytimeout;
char *progname;
char stripped_story_name[10];
short display;
short user_background;
short user_foreground;
short user_emphasis;
short user_bold_typing;
short user_reverse_bg;
short user_reverse_fg;
short user_screen_height;
short user_screen_width;
short user_tandy_bit;
short user_random_seed;
short user_font;
byte old_video_mode;
struct {
    zword xsize;
    zword table;
    zword width;
    zword total;
} redirect[MAX_NESTING];
void (*op0_opcodes[0x10]) (struct sg *);
void (*op1_opcodes[0x10]) (struct sg *);
void (*var_opcodes[0x40]) (struct sg *);
void (*ext_opcodes[0x1d]) (struct sg *);
zword zargs[8];
short zargc;
char *optarg;
char script_name[MAX_FILE_NAME + 1];
char command_name[MAX_FILE_NAME + 1];
struct {
	enum story story_id;
	zword release;
	zbyte serial[7];
    } records[25];
unsigned char Header[64];
char save_name[MAX_FILE_NAME + 1];
char auxilary_name[MAX_FILE_NAME + 1];
zbyte far *undo[MAX_UNDO_SLOTS];
zchar buffer[TEXT_BUFFER_SIZE];
char *story_name;
enum story story_id;
long story_size;
zbyte h_version;
zbyte h_config;
zword h_release;
zword h_resident_size;
zword h_start_pc;
zword h_dictionary;
zword h_objects;
zword h_globals;
zword h_dynamic_size;
zword h_flags;
zbyte h_serial[6];
zword h_abbreviations;
zword h_file_size;
zword h_checksum;
zbyte h_interpreter_number;
zbyte h_interpreter_version;
zbyte h_screen_rows;
zbyte h_screen_cols;
zword h_screen_width;
zword h_screen_height;
zbyte h_font_height;
zbyte h_font_width;
zword h_functions_offset;
zword h_strings_offset;
zbyte h_default_background;
zbyte h_default_foreground;
zword h_terminating_keys;
zword h_line_width;
zbyte h_standard_high;
zbyte h_standard_low;
zword h_alphabet;
zword h_extension_table;
zbyte h_user_name[8];
zword hx_table_size;
zword hx_mouse_x;
zword hx_mouse_y;
zword hx_unicode_table;
zword stack[STACK_SIZE];
zword *sp;
zword *fp;
short ostream_screen;
short ostream_script;
short ostream_memory;
short ostream_record;
short istream_replay;
short message;
short cwin;
short mwin;
short mouse_y;
short mouse_x;
short enable_wrapping;
short enable_scripting;
short enable_scrolling;
short enable_buffering;
short option_attribute_assignment;
short option_attribute_testing;
short option_context_lines;
short option_object_locating;
short option_object_movement;
short option_left_margin;
short option_right_margin;
short option_ignore_errors;
short option_piracy;
short option_undo_slots;
short option_expand_abbreviations;
short option_script_cols;
long reserve_mem;
short bufpos;
zchar prev_c;
zbyte far *zmp;
zbyte far *pcp;
FILE *story_fp;
short undo_slots;
short undo_count;
short undo_valid;
short script_width;
FILE *sfp;
FILE *rfp;
FILE *pfp;
short optind;
short optopt;
short finished;
short interval;
short counter;
short depth;
short font_height;
short font_width;
short input_redraw;
short more_prompts;
short discarding;
short cursor;
short input_window;
zchar tempstr[255]; 	//Work area for strings in os_display_string
zchar displstr[255]; 	//Work area for displaying to server
zchar padstr[255]; 		//Work area for padding strings in pad_status_line

};

void __extended__ (struct sg *g);
void __illegal__ (struct sg *g);
int SrvDlgOpen(struct sg *g, char *pathsrc, char *file);
int SrvDlgSave(struct sg *g, char *pathsrc, char *file);
short frotzmain (short argc, char *argv[], struct sg *g);
void SrvConnect(struct sg *g, void *tr);
void SrvDisconnect(struct sg *g);
unsigned short SrvGetTimedCh(struct sg *g, int delay);
void SrvBeep(struct sg *g, int pitch);
FILE *SrvOpenRead(struct sg *g, const char *filename); // uses RFile, returns NULL if error
FILE *SrvOpenWrite(struct sg *g, const char *filename); // returns NULL if error
FILE *SrvOpenRWText(struct sg *g, const char *filename); // Read/Write && text mode
FILE *SrvOpenWText(struct sg *g, const char *filename); // Write && text mode
FILE *SrvOpenRText(struct sg *g, const char *filename); // Read && text mode
void SrvClose(struct sg *g, FILE *file);
void SrvSeek(struct sg *g, FILE *file, int offset, int origin);
int  SrvTell(struct sg *g, FILE *file);
int  SrvRead (struct sg *g, void *buff, int width, int count, FILE *file);  // returns <= 'count' !
int  SrvWrite(struct sg *g, void *buff, int width, int count, FILE *file); // returns <= 'count' !
int  SrvPutc (struct sg *g, int c, FILE *file); // return the char written
int  SrvGetc(struct sg *g, FILE *file); // EOF = returns 0
void SrvSetFileSize(struct sg *g, FILE *file, int adjust);
int  SrvError(struct sg *g, FILE *file); // return always 0....
char *Srvstrchr(const char *str, char c);
int  Srvstrlen(char *str);
void Srvmemcpy(void *dst, void *src, int count);
void Srvmemmove (void *dst, void *src, int count);
char *Srvstrcpy(char *dst, const char *src); // returns dst
char *Srvstrcat(char *dst, const char *src); // returns dst
void *SrvMalloc(struct sg *g, int num, int size); // uses HBufC, alloc size+4 (pointer to HBufC) TDes->Ptr()
void SrvFree(struct sg *g, int num, void *buff);  // uses delete
void *SrvRealloc(struct sg *g, int num, void *buff, int size);

void SrvExit(struct sg *g); // To check, all exit conditions...

void SrvEraseRect(struct sg *g, int top, int left, int bottom, int right, int rev);
void SrvScroll(struct sg *g, int top, int left, int bottom, int right, int units, int rev);
void SrvSwitchCursor(struct sg *g, int cursor);
void SrvTextAttr(struct sg *g, int attr); // bit 1 = reverse, 2 = emphasis, 3 = bold
void SrvPrintf(struct sg *g, const char *msg);
void SrvPutChar(struct sg *g, int x, int y, unsigned char c);
void SrvPutString(struct sg *g, int x, int y, zchar *s);
void SrvSetCursor(struct sg *g, int x, int y);
void SrvGetStoryName(struct sg *g, char **sn);
void SrvScreenSize(struct sg *g, int *w, int *h);
/* Return an appropriate random seed value in the range from 0 to
 * 32767, possibly by using the current system time.*/
int SrvRandom(struct sg *g);
