/*
Frostz.cpp : Defines the entry point for the application.
Copyright (C) 2005 Fabio Concas
Copyright (C) 2007 Vladimir Korablin

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/


#include "StdAfx.h"
#include <sipapi.h>
#include <winuser.h>

#include "Zroft.h"
#include "CoverPage.h"
#include "About.h"
#include "Macros.h"
#include "Utils.h"

extern "C" {
#include "Frotz/Frotz.h"
}

static SHACTIVATEINFO s_sai;
static short oldOrientation;
static unsigned long oldDisplayOrientation;

ZroftApp Application;

// Blind users don't need gfx, nor a status line.
extern "C" {
    char cBlindMode = 0;
}

bool SIPPanelIsOn()
{
    SIPINFO info;
    memset(&info, 0, sizeof(info));
    info.cbSize = sizeof(info);
    info.dwImDataSize = 0;
    SipGetInfo(&info);
    return info.fdwFlags & SIPF_ON;
}

//****************************************************************************
//	Main ZroftApp window procedure.
//****************************************************************************
#pragma warning ( disable : 4101 )
LRESULT CALLBACK WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    int wmId, wmEvent;

    static bool sipPanelWasOn;// = SIPPanelIsOn();

    switch (message)
    {
    case WM_COMMAND:
        {
            HMENU hMenu;
            DWORD Ret, Val;

            wmId    = LOWORD(wParam);
            wmEvent = HIWORD(wParam);

#define GetOptionsMenu()	hMenu = (HMENU)SendMessage (SHFindMenuBar (hWnd), SHCMBM_GETSUBMENU, (WPARAM)0, (LPARAM)ID_MENU_OPTIONS);
#define GetGameFileMenu()	hMenu = (HMENU)SendMessage (SHFindMenuBar (hWnd), SHCMBM_GETSUBMENU, (WPARAM)0, (LPARAM)ID_GAMEMENU_FILE);

            switch (wmId)
            {
                //
                // Menu handling.
                //
            case ID_MENU_LOADSTORY:
                Application.OnStoryOpen ();
                break;

            case ID_MENU_TIMER125:
                if (Application.UpdateTimerMs != 125)
                {
                    Application.UpdateTimerMs = 125;
                    GetOptionsMenu();
                    CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_CHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_UNCHECKED);
                }
                break;

            case ID_MENU_TIMER250:
                if (Application.UpdateTimerMs != FROSTZ_UPDATE_MS)
                {
                    Application.UpdateTimerMs = FROSTZ_UPDATE_MS;
                    GetOptionsMenu();
                    CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_CHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_UNCHECKED);
                }
                break;

            case ID_MENU_TIMER500:
                if (Application.UpdateTimerMs != 500)
                {
                    Application.UpdateTimerMs = 500;
                    GetOptionsMenu();
                    CheckMenuItem (hMenu, ID_MENU_TIMER125, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER250, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_TIMER500, MF_BYCOMMAND | MF_CHECKED);
                }
                break;

            case BASE_MRU_ID:
            case BASE_MRU_ID + 1:
            case BASE_MRU_ID + 2:
            case BASE_MRU_ID + 3:
                Application.OnLoadRecent (wmId - BASE_MRU_ID);
                break;

            case ID_MENU_CLRMRU:
                Application.ClearMRUList ();
                break;

            case ID_MENU_EXIT:
            case ID_GAMEMENU_QUITAPP:
                if (Application.isZmachineRunning)
                    os_reset_screen ();
                SendMessage (hWnd, WM_DESTROY, 0, 0);
                break;

            case ID_IGNORERTERRORS:
                Application.ignore_errors = (Application.ignore_errors != 0)?
                    0 : 1;
                Val = (Application.ignore_errors != 0)? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_IGNORERTERRORS, MF_BYCOMMAND | Val);
                break;


            case ID_MENU_EXPAND:
                Application.expand_abbreviations = (Application.expand_abbreviations != 0)?
                    0 : 1;
                Val = (Application.expand_abbreviations != 0)? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_EXPAND, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_TANDY:
                Application.TandyBit = !Application.TandyBit;
                Val = Application.TandyBit? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_TANDY, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_TEXTSTYLES:
                Application.UseStyles = !Application.UseStyles;
                Val = Application.UseStyles? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_TEXTSTYLES, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_INT_DEC20:
                Application.InterpreterNumber = INTERP_DEC_20;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_APPLE2E:
                Application.InterpreterNumber = INTERP_APPLE_IIE;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_MAC:
                Application.InterpreterNumber = INTERP_MACINTOSH;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_AMIGA:
                Application.InterpreterNumber = INTERP_AMIGA;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_ATARIST:
                Application.InterpreterNumber = INTERP_ATARI_ST;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_MSDOS:
                Application.InterpreterNumber = INTERP_MSDOS;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_C128:
                Application.InterpreterNumber = INTERP_CBM_128;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_C64:
                Application.InterpreterNumber = INTERP_CBM_64;
                Application.UpdateMenuItems ();
                break;

            case ID_MENU_INT_APPLE2C:
                Application.InterpreterNumber = INTERP_APPLE_IIC;
                Application.UpdateMenuItems ();
                /*if (Application.UseColours)
                {
                MessageBox (hWnd, L"This interpreter should be used without colors.\nThe option will be automaticcaly switched off.",
                APP_NAME, MB_ICONEXCLAMATION);
                GetOptionsMenu();
                CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | MF_UNCHECKED);
                Application.UseColours = false;
                Application.GoFullScreen ();
                return TRUE;
                }*/
                break;

            case ID_MENU_INT_APPLE2GS:
                Application.InterpreterNumber = INTERP_APPLE_IIGS;
                Application.UpdateMenuItems ();
                /*
                if (Application.UseColours)
                {
                MessageBox (hWnd, L"This interpreter should be used without colors.\nThe option will be automaticcaly switched off.",
                APP_NAME, MB_ICONEXCLAMATION);
                GetOptionsMenu();
                CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | MF_UNCHECKED);
                Application.UseColours = false;
                Application.GoFullScreen ();
                return TRUE;
                }
                */
                break;

            case ID_MENU_INT_TANDY:
                Application.InterpreterNumber = INTERP_TANDY;
                Application.UpdateMenuItems ();
                if (!Application.TandyBit)
                    if (MessageBox (Application.hWnd, L"Do you want to set the Tandy Bit?",
                        APP_NAME, MB_YESNO) == IDYES)
                    {
                        GetOptionsMenu();
                        CheckMenuItem (hMenu, ID_MENU_TANDY, MF_BYCOMMAND | MF_CHECKED);
                        Application.TandyBit = true;
                    }
                    Application.GoFullScreen ();
                    break;

            case ID_MENU_SIMCBM:
                Application.SimulateCBM = !Application.SimulateCBM;
                Val = Application.SimulateCBM? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_SIMCBM, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_6x10:
                if (Application.FontHeight != 10)
                {
                    GetOptionsMenu ();
                    Application.FontWidth = 6;
                    Application.FontHeight = 10;
                    CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_CHECKED);
                    CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
                }
                break;

            case ID_MENU_8x12:
                if (Application.FontHeight != 12)
                {
                    GetOptionsMenu();
                    Application.FontWidth = 8;
                    Application.FontHeight = 12;
                    CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_CHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
                }
                break;

            case ID_MENU_4x11:
                if (Application.FontHeight != 11)
                {
                    GetOptionsMenu();
                    Application.FontWidth = 4;
                    Application.FontHeight = 11;
                    CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_CHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_UNCHECKED);
                }
                break;

            case ID_MENU_4x8:
                if (Application.FontHeight != 8)
                {
                    GetOptionsMenu();
                    Application.FontWidth = 4;
                    Application.FontHeight = 8;
                    CheckMenuItem (hMenu, ID_MENU_6x10, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_8x12, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x11, MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem (hMenu, ID_MENU_4x8, MF_BYCOMMAND | MF_CHECKED);
                }
                break;

            case ID_EMPH_BOLD:
                Application.bUnderlineInsteadOfBold = false;
                GetOptionsMenu();
                CheckMenuItem (hMenu, ID_EMPH_BOLD, MF_BYCOMMAND | MF_CHECKED);
                CheckMenuItem (hMenu, ID_EMPH_UNDERL, MF_BYCOMMAND | MF_UNCHECKED);
                break;

            case ID_EMPH_UNDERL:
                Application.bUnderlineInsteadOfBold = true;
                GetOptionsMenu();
                CheckMenuItem (hMenu, ID_EMPH_BOLD, MF_BYCOMMAND | MF_UNCHECKED);
                CheckMenuItem (hMenu, ID_EMPH_UNDERL, MF_BYCOMMAND | MF_CHECKED);
                break;

            case ID_MENU_USECOLORS:
                Application.UseColours = !Application.UseColours;
                Val = Application.UseColours? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_USECOLORS, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_SOUND:
                Application.UseSounds = !Application.UseSounds;
                Val = Application.UseSounds? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_SOUND, MF_BYCOMMAND | Val);
                break;

            case ID_MENU_BLINDMODE:
                cBlindMode = cBlindMode? 0 : 1;
                Val = cBlindMode? MF_CHECKED : MF_UNCHECKED;
                GetOptionsMenu();
                Ret = CheckMenuItem (hMenu, ID_MENU_BLINDMODE, MF_BYCOMMAND | Val);
                // Show/Hide SIP too
                Application.UpdateSipState();
                Application.UpdateClientSize(); // !
                //Application.ClientRect.bottom = cBlindMode? 303 : 215;
                Application.GoFullScreen ();
                break;

            case ID_MENU_ABOUT:
            case ID_GAMEMENU_ABOUT:
                Application.ShowAboutBox();
                //DialogBox (Application.hInstance, MAKEINTRESOURCE (IDD_ABOUT), hWnd, (DLGPROC)DlgAbout);
                break;
            case ID_GAMEMENU_COVERPAGE:
                Application.ShowCoverPage();
                break;

            case ID_MENU_TOGGLESIP:
                Application.bShowSip = !Application.bShowSip;
                Application.UpdateSipState();
                Application.UpdateClientSize(); // !
                Application.GoFullScreen ();
                //MessageBox (GetActiveWindow (), L"Sip toggled", L"DEBUG", MB_ICONINFORMATION);
                //Application.ClientRect.bottom =
                    //(Application.bShowSip && !cBlindMode)? 215 : 303;
                break;

            case ID_GAMEMENU_EDITMACROS:
                Application.ShowMacros();
                break;

            case ID_GAMEMENU_COMPASS:
                Application.ShowCompass = !Application.ShowCompass;
                Val = Application.ShowCompass? MF_CHECKED : MF_UNCHECKED;
                GetGameFileMenu();
                Ret = CheckMenuItem (hMenu, ID_GAMEMENU_COMPASS, MF_BYCOMMAND | Val);
                // Redraw area
                {
                    RECT Rect = { 180, 20, 229, 69 };
                    InvalidateRect (Application.hWnd, &Rect, true);
                }
                break;

            case ID_GAMEMENU_RESUME:
                if (Application.ExpectingInput)
                    Application.StuffKeyboard ("Restore", true, true);
                break;

            case ID_GAMEMENU_SAVE:
                if (Application.ExpectingInput)
                    Application.StuffKeyboard ("Save", true, true);
                break;

            case ID_GAMEMENU_RESTART:
                if (Application.ExpectingInput)
                    Application.StuffKeyboard ("Restart", true, true);
                break;

            case ID_GAMEMENU_QUITSTORY:
                if (Application.ExpectingInput)
                    Application.StuffKeyboard ("Quit", true, true);
                break;

            case ID_GAMEMENU_UNDO:
                if (Application.ExpectingInput)
                    Application.OnUndo ();
                break;

            case ID_GAMEMENU_LOOK:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_LOOKING;
                    Application.StuffKeyboard ("Look ", false, true);
                }
                break;

            case ID_GAMEMENU_LOOKAT:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_LOOKING;
                    Application.StuffKeyboard ("Look at ", false, true);
                }
                break;

            case ID_GAMEMENU_LOOKIN:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_LOOKING;
                    Application.StuffKeyboard ("Look inside ", false, true);
                }
                break;

            case ID_GAMEMENU_LOOKOUT:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_LOOKING;
                    Application.StuffKeyboard ("Look outside ", false, true);
                }
                break;

            case ID_GAMEMENU_LOOKUNDER:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_LOOKING;
                    Application.StuffKeyboard ("Look under ", false, true);
                }
                break;

            case ID_GAMEMENU_TAKE:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_TAKING;
                    Application.StuffKeyboard ("Take ", false, true);
                }
                break;

            case ID_GAMEMENU_DROP:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_TAKING;
                    Application.StuffKeyboard ("Drop ", false, true);
                }
                break;

            case ID_GAMEMENU_INV:
                if (Application.ExpectingInput)
                    Application.StuffKeyboard ("Inventory", true, true);
                break;

            case ID_GAMEMENU_GOTO:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_GOING;
                    Application.StuffKeyboard ("Go to ", false, true);
                }
                break;

            case ID_GAMEMENU_OPEN:
                if (Application.ExpectingInput)
                {
                    Application.State = STATE_OPENING;
                    Application.StuffKeyboard ("Open ", false, true);
                }
                break;

            case ID_GAMEMENU_CBMPAL:
                Application.CycleCBMPalette ();
                break;

            default:
                //*** Check for macros ***
                if (Application.ExpectingInput &&
                    wmId >= BASE_MACRO_ID && wmId < (int)(BASE_MACRO_ID + MAX_MACROS))
                {
                    bool bReturn = false;
                    char Str[32];
                    if (Application.Macros[wmId - BASE_MACRO_ID].nlStyle == 1)
                        bReturn = true; // Macro wants immediate newline
                    else if (Application.Macros[wmId - BASE_MACRO_ID].nlStyle == 2)
                        Application.State = STATE_MACRONL; // Return after input
                    wcstombs (Str, Application.Macros[wmId - BASE_MACRO_ID].wAction, 32);
                    Application.StuffKeyboard (Str, bReturn, true);
                }
                //*** *** *** *** *** ***
                else
                    return DefWindowProc (hWnd, message, wParam, lParam);
            }
        }	break;

    case WM_TIMER:
        if(wParam == ID_SIPCHECK_TIMER) {
            Application.HideSipButton();
        } else {
            Application.OnTimer ();
        }
        break;

    case WM_PAINT:
        Application.OnPaint ();
        Application.HideSipButton();
        break;

    //case WM_IM_INFO:
    //    Application.UpdateSipState();
    //    break;

    case WM_SETFOCUS:
        Application.OnSetFocus ();
        break;

    case WM_SIZE:
        //if(GetForegroundWindow() != Application.GetMainWnd()) {
            //return 1;
        //}
        if(SIPPanelIsOn() != sipPanelWasOn && !Application.disregardWmSize) {
            sipPanelWasOn = !sipPanelWasOn;
            Application.UpdateSipState();
            Application.GoFullScreen();
            //Application.UpdateClientSize();
            return 0;
        }
        return 1;
        break;

    case WM_CREATE:
        // Initialize the shell activate info structure
        memset (&s_sai, 0, sizeof (s_sai));
        s_sai.cbSize = sizeof (s_sai);
        sipPanelWasOn = SIPPanelIsOn();
        break;

    case WM_DESTROY:
        Application.disregardWmSize = true;
        Application.OnExit ();
        if (Application.hMenuBar)
            CommandBar_Destroy (Application.hMenuBar);
        PostQuitMessage (0);
        break;

    case WM_SETTINGCHANGE:
        sipPanelWasOn = sipPanelWasOn;
        SHHandleWMSettingChange (hWnd, wParam, lParam, &s_sai);
        break;

    case WM_CHAR:
        Application.OnChar ((UINT)wParam,
            0, 0); // Unused parameters
        break;

    case WM_LBUTTONDOWN:
        Application.OnLButtonDown (wParam, LOWORD(lParam), HIWORD(lParam));
        break;

    case WM_KEYDOWN:
        Application.OnKeyDown ((UINT)wParam,
            0, 0); // Unused parameters
        break;

        //*** Custom window messages ***
    case WM_UPDATE_MENU:
        Application.OnUpdateMenu ();
        return TRUE;

    case WM_LOAD_STORY:
        Application.LoadStory((wchar_t*)wParam);
        return TRUE;

    case WM_CREATE_CURSOR:
        if (hWnd == Application.hWnd)
            CreateCaret (hWnd, NULL, Application.CharWidth, Application.CharHeight);
        return TRUE;

    case WM_UPDATE_CURSOR:
        Application.OnUpdateCursor ();
        return TRUE;

    case WM_SHOW_CURSOR:
        if (wParam)
            ShowCaret (hWnd);
        else
            HideCaret (hWnd);
        return TRUE;

    case WM_TAKE_FOCUS:
        SetFocus (hWnd);
        return TRUE;

    default:
        return DefWindowProc (hWnd, message, wParam, lParam);
    }

    return 0;
}
#pragma warning ( default : 4101 )




//****************************************************************************
//		GetAppDir
//	Code taken from Mini vMac by Paul Pratt
//****************************************************************************
bool GetAppDir (LPWSTR pathName, HINSTANCE appInstance)
{
    if (GetModuleFileName (appInstance, pathName, 256) == 0)
        return false;

    LPWSTR p0 = pathName;
    LPWSTR p = (LPWSTR)0;
    wchar_t c;

    while ((c = *p0++) != 0)
        if (c == (wchar_t)'\\')
            p = p0;

    if (p == 0)
        return false;

    *p = (wchar_t)0;
    return true;
}



//****************************************************************************
//		WinMain
//	Everything starts here
//****************************************************************************
int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPTSTR    lpCmdLine,
                   int       nCmdShow)
{
    MSG msg;
    DEVMODE dm;
    // - Experimental -
    wchar_t FontFile[256];

    /*** Register our fonts ***/
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"frostz.ttf");
    if (AddFontResource (FontFile) == 0)
    {
        wchar_t wMsg[32], wTxt[128];
        wsprintf (wMsg, L"Error #%d", GetLastError ());
        wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
        MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
    }
    else
        SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"bzork.ttf");
    if (AddFontResource (FontFile) == 0)
    {
        wchar_t wMsg[32], wTxt[128];
        wsprintf (wMsg, L"Error #%d", GetLastError ());
        wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
        MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
    }
    else
        SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"CBM.ttf");
    if (AddFontResource (FontFile) == 0)
    {
        wchar_t wMsg[32], wTxt[128];
        wsprintf (wMsg, L"Error #%d", GetLastError ());
        wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
        MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
    }
    else
        SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"CBM-BZ.ttf");
    if (AddFontResource (FontFile) == 0)
    {
        wchar_t wMsg[32], wTxt[128];
        wsprintf (wMsg, L"Error #%d", GetLastError ());
        wsprintf (wTxt, L"Could not add \"%s\"", FontFile);
        MessageBox (NULL, wTxt, wMsg, MB_ICONSTOP);
    }
    else
        SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    /**************************/

    // initialize the DEVMODE structure
    ZeroMemory (&dm, sizeof (dm));
    dm.dmSize = sizeof (dm);

    // Backup old values
    EnumDisplaySettings (NULL, ENUM_CURRENT_SETTINGS, &dm);
    oldOrientation = dm.dmOrientation;
    oldDisplayOrientation = dm.dmDisplayOrientation;

    // Switch to Portrait mode
    dm.dmOrientation = DMORIENT_PORTRAIT;
    dm.dmDisplayOrientation = DMDO_0;
    dm.dmFields = DM_ORIENTATION | DM_DISPLAYORIENTATION;
    if (ChangeDisplaySettingsEx (NULL, &dm, NULL, 0, 0) != DISP_CHANGE_SUCCESSFUL)
        MessageBox (NULL, L"Could not change display orientation!", APP_NAME, MB_ICONEXCLAMATION);

    if (!Application.Initialize (hInstance, nCmdShow))
        return 0;

    
    // This is too annoying. A menu item should be enough.
    //Application.ShowAboutBox();

    // Initialize COM (we need this for XML)
    HRESULT hr = CoInitializeEx(NULL, COINIT_MULTITHREADED);
    if(hr != S_OK && hr != S_FALSE) {
        ReportError(L"Unable to initialize COM. Story metadata will be unavailable.");
    }

    //Application.SetBgImage (IDB_FROSTZBG);
    
    Application.UpdateClientSize();
    Application.UpdateSipState();
    Application.GoFullScreen ();

    // Register for receiving software input panel notifications.
    //{
    //    HWND window = Application.GetMainWnd();
    //    // SipRegisterNotification doesn't work on my device. WTF? -- VK
    //    BOOL result = SipRegisterNotification(window);
    //    result = result;
    //}

    // Were we provided a story as a parameter?  Then load it.
    if(lpCmdLine[0] != '\0') {
        Application.LoadStory(lpCmdLine);
    }    
    // Main message loop:
    while (GetMessage (&msg, NULL, 0, 0)) 
    {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    /* - Experimental - */
    /*** Un-register our fonts ***/
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"frostz.ttf");
    RemoveFontResource (FontFile);
    SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"bzork.ttf");
    RemoveFontResource (FontFile);
    SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"CBM.ttf");
    RemoveFontResource (FontFile);
    SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    GetAppDir (FontFile, hInstance);
    wcscat (FontFile, L"CBM-BZ.ttf");
    RemoveFontResource (FontFile);
    SendMessage (HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    /*****************************/

    // Switch back to previous orientation mode
    dm.dmOrientation = oldOrientation;
    dm.dmDisplayOrientation = oldDisplayOrientation;
    dm.dmFields = DM_ORIENTATION | DM_DISPLAYORIENTATION;
    if (ChangeDisplaySettingsEx (NULL, &dm, NULL, 0, 0) != DISP_CHANGE_SUCCESSFUL)
        MessageBox (NULL, L"Could not change display orientation!", APP_NAME, MB_ICONEXCLAMATION);

    return msg.wParam;
}
