#include "giz.ipp"

Constant ZIO_LOWER_BUFFER_SIZE = 2048;

/* !! Our maximum upper window size is 254 x 254 */
Constant ZIO_UPPER_VECTOR_SIZE = 254;
Constant ZIO_UPPER_GRID_SIZE = 64516;

Global zio_undo_file;
Global zio_undo_stream;
Global zio_undo_num_frames;
Global zio_undo_dyn_mem_size;
Global zio_undo_sp = -1;
Global zio_undo_fp;
Global zio_undo_pc;
Global zio_flags2;

Array zio_lower_buffer -> ZIO_LOWER_BUFFER_SIZE;
Array zio_lower_style_buffer -> ZIO_LOWER_BUFFER_SIZE;
Global zio_lower_buffer_pos = 0;

Array zio_upper_buffer -> ZIO_UPPER_GRID_SIZE;
Array zio_upper_style_buffer -> ZIO_UPPER_GRID_SIZE;


[zio_init win stat;
    zio_current_style = 0;

    zio_reset_height = false;
    zio_changed_height = false;
    zio_pending_height = -1;

    if (zio_lower ~= 0)
    {
        /* !! close all windows except for this one */
        while(glk($0022) ~= zio_lower)
            glk($0024, glk($0030, zio_lower), 0);
    }
    
    if (z_ver <= 3)
    {
        stat = glk($0023, win, winmethod_Above | winmethod_Fixed,
                   1, wintype_TextGrid, 0);
        zio_status = stat;
        zio_lower = win;

        if (z_ver == 3)
            zio_upper = glk($0023, win, winmethod_Above |
                            winmethod_Fixed, 0, wintype_TextGrid, 0);
    
        zio_root = glk($0029, win);

    }
    else
    {
        zio_lower = win;
        zio_upper = glk($0023, win, winmethod_Above | winmethod_Fixed,
                        0, wintype_TextGrid, 0);
        zio_root = glk($0029, win);
    }

    zio_set_window(zio_lower);
    if (z_ver >= 3)
        zio_set_upper_dimensions();

    
    /* !! set up undo files and streams */
    zio_undo_file = glk($0060, fileusage_BinaryMode, 0);
    /* !! work around a bug in UNIX versions of GLK */
    zio_undo_stream = glk($0042, zio_undo_file, filemode_Write, 0);
    glk($0044, zio_undo_stream, 0);
    zio_undo_stream = glk($0042, zio_undo_file, filemode_ReadWrite, 0);
    readw(zio_undo_dyn_mem_size, $0e);
];

[zio_clear win i j n;
    glk($002a, win);

    if (win == zio_upper)
    {
        for (i = 0 : i < zio_height : i++)
        {
            for (j = 0 : j < zio_width : j++)
            {
                n = j + (i * zio_width);
                zio_upper_buffer->n = ' ';
                zio_upper_style_buffer->n = 0;
            }
        }
    
        zio_set_cursor(zio_x, zio_y);
    }
];

[zio_set_style style stream;
    if (zio_current_style ~= style)
    {
        zio_current_style = style;
/* !        stream = glk($002c, zio_lower); */
/* !        glk($0087, stream, z_style_to_glulx(style)); */

/* !        if (zio_upper) */
/* !        { */
/* !            stream = glk($002c, zio_upper); */
/* !            glk($0087, stream, z_style_to_glulx(style)); */
/* !        } */
    }
];

[zio_flush_upper i j n s style markstyle;
    s = glk($002c, zio_upper);
    markstyle = -1;
    
    for (i = 0 : i < zio_height : i++)
    {
        for (j = 0 : j < zio_width : j++)
        {
            n = j + (i * zio_width);
            style = zio_upper_style_buffer->n;

            if (style ~= markstyle)
            {
                markstyle = style;
                glk($0087, s, style);
            }

            glk($002b, zio_upper, j, i);
            glk($0081, s, zio_upper_buffer->n);
        }
    }
    zio_set_cursor(zio_x, zio_y);
];


[zio_flush_lower i s style mark markstyle;

    s = glk($002c, zio_lower);
    
    mark = 0;
    
    if (zio_lower_buffer_pos > 0)
        markstyle = zio_lower_style_buffer->0 & $0000ff00;
    
    for (i = 0 : i < zio_lower_buffer_pos : i++)
    {
        style = zio_lower_style_buffer->i;

        if (style ~= markstyle)
        {
            if (i - mark > 0)
            {
                glk($0087, s, markstyle);
                glk($0085, s, zio_lower_buffer + mark, i - mark);
            }
            mark = i;
            markstyle = style;
        }
     }
    if (i - mark > 0)
    {
        glk($0087, s, markstyle);
        glk($0085, s, zio_lower_buffer + mark, i - mark);
    }

    zio_lower_buffer_pos = 0;
];    
    
         
[zio_put_char c is_unicode tbl pos style;
    if (c > 0)/*  !! recall that 0 is legal output, but has no effect */
    {
        if (stream_tbl_index < 0)
        {
            if (is_unicode == 0) c = zscii_charset->c;

            if (output_one)
            {
                if (zio_pending_input == zio_current)
                {
                    glk($00d1, zio_current, event_struct);
                    zio_pending_input = false;
                }

                if (zio_current == zio_lower)
                {
                    if (zio_force_fixed_pitch)
                        style = z_style_to_glulx(zio_current_style | 8);
                    else
                        style = z_style_to_glulx(zio_current_style);
                    
                    if (zio_lower_buffer_pos == ZIO_LOWER_BUFFER_SIZE)
                        zio_flush_lower();
                    zio_lower_style_buffer->zio_lower_buffer_pos = style;
                    zio_lower_buffer->zio_lower_buffer_pos++ = c;
                }
                else
                {
                    style = z_style_to_glulx(zio_current_style | 8);
                    tbl = zio_x + (zio_y * zio_width);
                    zio_upper_buffer->tbl = c;
                    zio_upper_style_buffer->tbl = style;

                    if (c == 10 || zio_x++ >= zio_width)
                    {
                        zio_x = 0;
                        zio_y++;
                    }
                    zio_set_cursor(zio_x, zio_y);
                }
            }
            
            if (zio_transcript_stream && zio_current == zio_lower)
                glk($0081, zio_transcript_stream, c);
        }
        else
        {
            tbl = StreamTables-->stream_tbl_index;
            pos = StreamTablePositions-->stream_tbl_index;
            StreamTablePositions-->stream_tbl_index = pos + 1;
            pos = pos + tbl;
            writeb(pos, c);
        }
    }
];

[zio_set_cursor x y;

/*     !! apparently, there are broken games (e.g. bear.z5), which rely */
/*     !! on 'terps adjusting the size of the upper window when they */
/*     !! select a line that does not exist in that window... */

    if (x >= zio_width)
        return;

    if (y >= zio_height)
        zio_split_window(y + 1);

/*     !! we actually move the cursor so the it will be properly placed */
/*     !! for input */
    glk($002b, zio_upper, x, y);
    zio_x = x;
    zio_y = y;
];

[zio_set_window win s;
    zio_current = win;
    s = glk($002c, win);
    glk($0047, s);

    if (win == zio_upper)
        zio_set_cursor(0, 0);
];

[zio_set_upper_dimensions resetCursor width height i j;
    glk($0025, zio_upper, ref_args, ref_args + 4);
    width = ref_args-->0;
    height = ref_args-->1;

    if (width > ZIO_UPPER_VECTOR_SIZE)
        width = ZIO_UPPER_VECTOR_SIZE;
    if (height > ZIO_UPPER_VECTOR_SIZE)
        height = ZIO_UPPER_VECTOR_SIZE;

    i = zio_width * zio_height;
    j = width * height;

    while (i < j)
    {
        zio_upper_buffer->i = ' ';
        zio_upper_style_buffer->i = 0;
        i++;
    }
    
    zio_width = width;
    zio_height = height;
    
    zmem->$21 = zio_width;
    writew($22, zio_width);
    
    if (resetCursor)
        zio_set_cursor(0, 0);
];

[zio_split_window i;
    if (zio_changed_height && i < zio_height)
    {
        zio_pending_height = i;
    }
    else
    {
        zio_pending_height = -1;
        zio_changed_height = true;
        glk($0026, zio_root, winmethod_Above | winmethod_Fixed, i, 0);
        if (z_ver == 3)
            zio_clear(zio_upper);
        zio_set_upper_dimensions();
    }
    
];

[zio_erase_line i;
    for (i = zio_x : i < zio_width : i++)
        zio_put_char(' ');
    zio_set_cursor(zio_x, zio_y);
];

[zio_alert str num style; 
    style = zio_current_style;
    glk($0086, 6); /* !! alert style */
    
    print "[Alert: ", (string) str, " (", num, ")]^";
    glk($0086, z_style_to_glulx(style));
];


[print_status_line width str score moves len cur tmp;

    cur = zio_current;
    zio_set_window(zio_status);
    glk($002a, zio_status);
    glk($0025, zio_status, ref_args, ref_args + 4);
    width = ref_args-->0;
    @aloads zglobals 0 tmp;
    str = zo_get_name(tmp);
    zscii_decode(str, zio_put_char);

    @aloads zglobals 1 score;
    @aloads zglobals 2 moves;

    if (z_ver == 3 && (zmem->1 & $00000010))
    {
        glk($002b, zio_status, width - 12, 0);
        @streamstr "Time: ";
        if (score < 10)
            @streamstr "0";
        @streamnum score;
        @streamstr ":";
        if (moves < 10)
            @streamstr "0";
        @streamnum moves;
    }
    else
    {
        len = 20 + num_digits(score) + num_digits(moves);
        glk($002b, zio_status, width - (1 + len), 0);
        @streamstr "Score: ";
        @streamnum score;
        @streamstr "      ";
        @streamstr "Moves: ";
        @streamnum moves;
    }
    zio_set_window(cur);
];

[zio_save_undo;
    zio_undo_num_frames = numFrames;
    zio_undo_sp = sp;
    zio_undo_fp = fp;
    zio_undo_pc = pc;
    glk($0045, zio_undo_stream, 0, 0);
    glk($0085, zio_undo_stream, zmem, zio_undo_dyn_mem_size);
    glk($0085, zio_undo_stream, zstack, zio_undo_sp * 4);
    readw(zio_flags2, $10);
];

[zio_restore_undo;
    numFrames = zio_undo_num_frames;
    sp = zio_undo_sp;
    fp = zio_undo_fp;
    pc = zio_undo_pc;
    glk($0045, zio_undo_stream, 0, 0);
    glk($0092, zio_undo_stream, zmem, zio_undo_dyn_mem_size);
    glk($0092, zio_undo_stream, zstack, zio_undo_sp * 4);
    writew($10, zio_flags2);
];

[zio_start_transcript;
    if (~~ zio_transcript_stream)
    {
        if (~~ zio_transcript_file)
            zio_transcript_file = glk($0062, fileusage_TextMode,
                                      filemode_Write, 0);
        
        zio_transcript_stream = glk($0042, zio_transcript_file,
                                    filemode_WriteAppend, 0);
        zmem->$11 = zmem->$11 | $$00000001;
    }
];

[zio_stop_transcript;
    if (zio_transcript_stream)
    {
        glk($0044, zio_transcript_stream, 0);
        zmem->$11 = zmem->$11 & $$11111110;
        zio_transcript_stream = 0;
    }
];


        
[zio_start_command_record;
    if (~~ zio_command_stream)
    {
        zio_command_file = glk($0062, fileusage_BinaryMode,
                               filemode_Write, 0);

        zio_command_stream = glk($0042, zio_command_file,
                                 filemode_Write, 0);
    }
];

[zio_stop_command_record;
    if (zio_command_stream)
    {
        glk($0044, zio_command_stream, 0);
        glk($0063, zio_command_file);
        zio_command_stream = 0;
        zio_command_file = 0;
    }
];


[zio_print_num n fn power s;
    if (n == 0)
    {
        indirect(fn, '0');
    }
    else
    {
        if (n < 0)
        {
            indirect(fn, '-');
            n = ~(n - 1);
        }

        /* !! since Z-machine numbers are 16 bits wide, they can never be */
/*         !! represented by more than 5 digits in base 10 */
        switch (num_digits(n))
        {
         1: power = 1;
         2: power = 10;
         3: power = 100;
         4: power = 1000;
         5: power = 10000;
        }

        while (power > 0)
        {
            s = n / power;
            indirect(fn, s + '0');
            n = n - (s * power);
            power = power / 10;
        }
    }
];

[zio_print_to_command c;
    glk($0081, zio_command_stream, c);
];
