/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import org.zmpp.blorb.BlorbImage;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.ColorTranslator;
import org.zmpp.swingui.CursorWindow;
import org.zmpp.swingui.FontFactory;
import org.zmpp.swingui.ScreenFont;
import org.zmpp.swingui.TextCursorImpl;
import org.zmpp.swingui.Viewport6;
import org.zmpp.swingui.WindowArea;
import org.zmpp.swingui.WindowStyle;
import org.zmpp.swingui.WordWrapper;
import org.zmpp.vm.StoryFileHeader;
import org.zmpp.vm.TextCursor;
import org.zmpp.vm.Window6;

public class Window6Impl
implements Window6,
CursorWindow {
    private TextCursor cursor;
    private FontFactory fontFactory;
    private int interruptRoutine;
    private int interruptCount;
    private int linecount;
    private int background;
    private int foreground;
    private ScreenFont font;
    private Viewport6 viewport;
    private WindowArea area;
    private WindowStyle style;
    private int windownum;
    private StringBuilder streambuffer;

    public Window6Impl(Viewport6 viewport6, FontFactory fontFactory, int n) {
        this.viewport = viewport6;
        this.fontFactory = fontFactory;
        this.windownum = n;
        this.streambuffer = new StringBuilder();
        this.cursor = new TextCursorImpl(this);
        this.area = new WindowArea();
        this.style = new WindowStyle();
    }

    public TextCursor getCursor() {
        return this.cursor;
    }

    public void displayCursor(boolean bl) {
        Color color = bl ? this.getForegroundColor() : this.getBackgroundColor();
        this.getCanvas().fillRect(color, this.getCurrentX(), this.getCurrentY() - this.getCanvas().getFontAscent(this.getFont()), this.getFontWidth(), this.getFontHeight());
    }

    public void drawPicture(BlorbImage blorbImage, int n, int n2) {
        Dimension dimension = blorbImage.getSize(this.viewport.getWidth(), this.viewport.getHeight());
        this.getCanvas().drawImage(blorbImage.getImage(), this.area.getStartX() + (n2 - 1), this.area.getStartY() + (n - 1), dimension.width, dimension.height);
    }

    public void erasePicture(BlorbImage blorbImage, int n, int n2) {
        Dimension dimension = blorbImage.getSize(this.viewport.getWidth(), this.viewport.getHeight());
        this.getCanvas().fillRect(this.getBackgroundColor(), this.area.getStartX() + (n2 - 1), this.area.getStartY() + (n - 1), dimension.width, dimension.height);
    }

    public void move(int n, int n2) {
        this.area.setPosition(n2, n);
    }

    public void setBufferMode(boolean bl) {
        this.style.setIsWrapped(bl);
    }

    public void setSize(int n, int n2) {
        this.area.setSize(n2, n);
    }

    public void setStyle(int n, int n2) {
        this.style.setFlags(n, n2);
    }

    public void setMargins(int n, int n2) {
        this.area.setMargins(n, n2);
    }

    public int getProperty(int n) {
        int n2 = 0;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = this.area.getProperty(n);
                break;
            }
            case 5: {
                n2 = this.cursor.getColumn();
                break;
            }
            case 4: {
                n2 = this.cursor.getLine();
                break;
            }
            case 9: {
                n2 = this.interruptCount;
                break;
            }
            case 8: {
                n2 = this.interruptRoutine;
                break;
            }
            case 12: {
                n2 = this.font.getNumber();
                break;
            }
            case 10: {
                n2 = this.font.getStyle();
                break;
            }
            case 11: {
                n2 = this.getColorData();
                break;
            }
            case 13: {
                n2 = this.getFontSize();
                break;
            }
            case 14: {
                n2 = this.style.getFlags();
                break;
            }
            case 15: {
                n2 = this.linecount;
                break;
            }
        }
        return n2;
    }

    private String getPropertyName(int n) {
        switch (n) {
            case 0: {
                return "y_coord";
            }
            case 1: {
                return "x_coord";
            }
            case 2: {
                return "y_size";
            }
            case 3: {
                return "x_size";
            }
            case 4: {
                return "y_cursor";
            }
            case 5: {
                return "x_cursor";
            }
            case 6: {
                return "l_margin";
            }
            case 7: {
                return "r_margin";
            }
            case 9: {
                return "interrupt_count";
            }
            case 8: {
                return "interrupt_routine";
            }
            case 12: {
                return "fontnum";
            }
            case 10: {
                return "textstyle";
            }
            case 11: {
                return "colordata";
            }
            case 13: {
                return "fontsize";
            }
            case 14: {
                return "attributes";
            }
            case 15: {
                return "linecount";
            }
        }
        return "";
    }

    public void putProperty(int n, short s) {
        switch (n) {
            case 9: {
                this.interruptCount = s;
                break;
            }
            case 8: {
                this.interruptRoutine = s;
                break;
            }
            case 15: {
                this.linecount = s;
                break;
            }
            default: {
                System.out.println("unsupported property to set: " + n);
            }
        }
    }

    private int getFontSize() {
        return this.getFontHeight() << 8 & 0xFF00 | this.getFontWidth() & 0xFF;
    }

    private int getFontHeight() {
        StoryFileHeader storyFileHeader = this.viewport.getMachine().getGameData().getStoryFileHeader();
        return storyFileHeader.getFontHeight();
    }

    private int getFontWidth() {
        StoryFileHeader storyFileHeader = this.viewport.getMachine().getGameData().getStoryFileHeader();
        return storyFileHeader.getFontWidth();
    }

    private int getColorData() {
        return this.background << 8 & 0xFF00 | this.foreground & 0xFF;
    }

    public void setBackground(int n) {
        if (n != 0) {
            this.background = n;
        }
    }

    public void setForeground(int n) {
        if (n != 0) {
            this.foreground = n;
        }
    }

    public int setFont(int n) {
        ScreenFont screenFont = this.fontFactory.getFont(n);
        if (screenFont == null) {
            return this.font.getNumber();
        }
        this.font = screenFont;
        return this.font.getNumber();
    }

    public void setTextStyle(int n) {
        this.font = this.fontFactory.getTextStyle(this.font, n);
    }

    public void eraseLine(int n) {
        Canvas canvas = this.getCanvas();
        if (n == 1) {
            int n2 = this.getCurrentX();
            this.area.clip(canvas);
            canvas.fillRect(this.getBackgroundColor(), n2, this.getCurrentY() - canvas.getFontAscent(this.font.getFont()), this.area.getOutputWidth() - n2, this.getFontHeight());
        } else {
            this.area.clip(canvas);
            canvas.fillRect(this.getBackgroundColor(), this.getCurrentX(), this.getCurrentY() - canvas.getFontAscent(this.font.getFont()), n, this.getFontHeight());
        }
    }

    public int getHeight() {
        return this.area.getHeight();
    }

    public void resize(int n) {
        int n2 = this.getCanvas().getFontHeight(this.getFont()) * n;
        this.area.setPosition(1, 1);
        this.area.setSize(this.getCanvas().getWidth(), n2);
        this.cursor.setPosition(1, 1);
    }

    public void setVerticalBounds(int n, int n2) {
        this.area.setPosition(1, n);
        this.area.setSize(this.getCanvas().getWidth(), n2);
        this.cursor.setPosition(1, 1);
    }

    public void printChar(char c, boolean bl) {
        if (this.isZorkZeroSpecial()) {
            this.printCharZorkZeroSpecial(c, bl);
        } else {
            this.printCharStandard(c, bl);
        }
    }

    public void updateCursorCoordinates() {
    }

    public void flushBuffer() {
        if (this.streambuffer.length() > 0) {
            this.printString(this.streambuffer.toString());
            this.streambuffer = new StringBuilder();
        }
    }

    public void backspace(char c) {
        Canvas canvas = this.getCanvas();
        int n = canvas.getCharWidth(this.getFont(), c);
        canvas.fillRect(this.getBackgroundColor(), this.getCurrentX() - n, this.getCurrentY() - canvas.getFontAscent(this.getFont()), n, canvas.getFontHeight(this.getFont()));
        this.cursor.setColumn(this.cursor.getColumn() - n);
    }

    public void clear() {
        this.area.fill(this.getCanvas(), this.getBackgroundColor());
        this.resetCursorToHome();
    }

    public void scroll(int n) {
        this.getCanvas().scroll(this.getBackgroundColor(), this.area.getStartX(), this.area.getStartY(), this.area.getWidth(), this.area.getHeight(), n);
    }

    private Canvas getCanvas() {
        return this.viewport.getCanvas();
    }

    protected Font getFont() {
        return this.font.getFont();
    }

    private Color getBackgroundColor() {
        if (this.background == -1) {
            return this.getCanvas().getColorAtPixel(this.getCurrentX(), this.getCurrentY());
        }
        return ColorTranslator.getInstance().translate(this.background, this.viewport.getDefaultBackground());
    }

    private Color getForegroundColor() {
        if (this.foreground == -1) {
            return this.getCanvas().getColorAtPixel(this.getCurrentX(), this.getCurrentY());
        }
        return ColorTranslator.getInstance().translate(this.foreground, this.viewport.getDefaultForeground());
    }

    private Color getTextBackground() {
        return this.font.isReverseVideo() ? this.getForegroundColor() : this.getBackgroundColor();
    }

    private Color getTextColor() {
        return this.font.isReverseVideo() ? this.getBackgroundColor() : this.getForegroundColor();
    }

    private int getCurrentX() {
        return this.area.getStartX() + (this.cursor.getColumn() - 1);
    }

    private int getCurrentY() {
        Font font = this.getFont();
        Canvas canvas = this.getCanvas();
        return this.area.getStartY() + (this.cursor.getLine() - 1) + (this.getFontHeight() - canvas.getFontDescent(font));
    }

    private void resetCursorToHome() {
        this.getCursor().setPosition(1, 1);
    }

    private void scrollIfNeeded() {
        int n = this.getCanvas().getFontDescent(this.getFont());
        this.area.clip(this.getCanvas());
        while (this.getCurrentY() > this.area.getStartY() + this.area.getHeight() - n) {
            this.getCanvas().scroll(this.getBackgroundColor(), this.area.getStartX(), this.area.getStartY(), this.area.getWidth(), this.area.getHeight(), this.getFontHeight());
            this.getCursor().setLine(this.getCursor().getLine() - this.getFontHeight());
        }
    }

    private void printCharStandard(char c, boolean bl) {
        if (this.isNewLineInterrupt(c)) {
            this.callNewLineInterrupt();
        } else if (bl || !this.style.outputIsBuffered()) {
            this.printString(String.valueOf(c));
        } else {
            this.streambuffer.append(c);
        }
    }

    private void printString(String string) {
        int n = this.area.getOutputWidth();
        WordWrapper wordWrapper = new WordWrapper(n, this.getCanvas(), this.getFont(), this.style.isWrapped());
        String[] stringArray = wordWrapper.wrap(this.getCurrentX(), string);
        this.printLines(stringArray);
    }

    private void printLines(String[] stringArray) {
        Color color = this.getTextColor();
        Color color2 = this.getTextBackground();
        if ((this.getFont().getStyle() & 1) > 0 && !this.font.isReverseVideo()) {
            color = color.brighter();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.printLine(string, color2, color);
            if (!Window6Impl.endsWithNewLine(string)) continue;
            this.newline();
        }
    }

    private void printLine(String string, Color color, Color color2) {
        Canvas canvas = this.getCanvas();
        this.area.clip(canvas);
        canvas.fillRect(color, this.getCurrentX(), this.getCurrentY() - this.getFontHeight() + canvas.getFontDescent(this.getFont()), canvas.getStringWidth(this.getFont(), string), this.getFontHeight());
        this.scrollIfNeeded();
        canvas.drawString(color2, this.getFont(), this.getCurrentX(), this.getCurrentY(), string);
        this.cursor.setColumn(this.cursor.getColumn() + canvas.getStringWidth(this.getFont(), string));
    }

    private static boolean endsWithNewLine(String string) {
        return string.length() > 0 && string.charAt(string.length() - 1) == '\n';
    }

    private void newline() {
        this.cursor.setLine(this.cursor.getLine() + this.getFontHeight());
        this.cursor.setColumn(1);
    }

    private boolean isNewLineInterrupt(char c) {
        return c == '\n' && this.interruptCount > 0;
    }

    private void callNewLineInterrupt() {
        --this.linecount;
        if (this.linecount <= 0) {
            this.linecount = 0;
            this.viewport.getMachine().getCpu().callInterrupt(this.interruptRoutine);
            --this.interruptCount;
        }
    }

    private boolean isZorkZeroSpecial() {
        StoryFileHeader storyFileHeader = this.viewport.getMachine().getGameData().getStoryFileHeader();
        return storyFileHeader.getInterpreterNumber() == 6 && storyFileHeader.getRelease() == 393 && "890714".equals(storyFileHeader.getSerialNumber());
    }

    private void printCharZorkZeroSpecial(char c, boolean bl) {
        if (this.isNewLineInterrupt(c)) {
            this.newline();
            this.callNewLineInterrupt();
        } else if (bl || !this.style.outputIsBuffered()) {
            this.printString(String.valueOf(c));
        } else {
            this.streambuffer.append(c);
        }
    }
}

