/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zmpp.base.Interruptable;
import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.vm.Cpu;
import org.zmpp.vm.GameData;
import org.zmpp.vm.Instruction;
import org.zmpp.vm.InstructionDecoder;
import org.zmpp.vm.Machine;
import org.zmpp.vm.RoutineContext;
import org.zmpp.vmutil.FastShortStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuImpl
implements Cpu,
Interruptable {
    private static final int STACKSIZE = 32768;
    private Machine machine;
    private int programCounter;
    private FastShortStack stack;
    private List<RoutineContext> routineContextStack;
    private int globalsAddress;
    private InstructionDecoder decoder;
    private boolean running;
    private boolean interruptDidOutput;
    private boolean executeInterrupt;

    public CpuImpl(Machine machine, InstructionDecoder instructionDecoder) {
        this.machine = machine;
        this.decoder = instructionDecoder;
        this.running = true;
    }

    @Override
    public void reset() {
        GameData gameData = this.machine.getGameData();
        this.decoder.initialize(this.machine, gameData.getMemoryAccess());
        this.stack = new FastShortStack(32768);
        this.routineContextStack = new ArrayList<RoutineContext>();
        this.globalsAddress = gameData.getStoryFileHeader().getGlobalsAddress();
        if (gameData.getStoryFileHeader().getVersion() == 6) {
            this.call(gameData.getStoryFileHeader().getProgramStart(), 0, new short[0], (short)0);
        } else {
            this.programCounter = gameData.getStoryFileHeader().getProgramStart();
        }
    }

    @Override
    public int getProgramCounter() {
        return this.programCounter;
    }

    @Override
    public void setProgramCounter(int n) {
        this.programCounter = n;
    }

    @Override
    public void incrementProgramCounter(int n) {
        this.programCounter += n;
    }

    @Override
    public Instruction nextStep() {
        return this.decoder.decodeInstruction(this.getProgramCounter());
    }

    @Override
    public int translatePackedAddress(int n, boolean bl) {
        GameData gameData = this.machine.getGameData();
        switch (gameData.getStoryFileHeader().getVersion()) {
            case 1: 
            case 2: 
            case 3: {
                return n * 2;
            }
            case 4: 
            case 5: {
                return n * 4;
            }
            case 6: 
            case 7: {
                return n * 4 + 8 * (bl ? gameData.getStoryFileHeader().getRoutineOffset() : gameData.getStoryFileHeader().getStaticStringOffset());
            }
        }
        return n * 8;
    }

    @Override
    public int computeBranchTarget(short s, int n) {
        return this.getProgramCounter() + n + s - 2;
    }

    @Override
    public void halt(String string) {
        this.machine.getOutput().print(new ZsciiString(string));
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public int getStackPointer() {
        return this.stack.getStackPointer();
    }

    private void setStackPointer(int n) {
        int n2 = this.stack.getStackPointer() - n;
        for (int i = 0; i < n2; ++i) {
            this.stack.pop();
        }
    }

    @Override
    public short getStackTopElement() {
        if (this.stack.size() > 0) {
            return this.stack.top();
        }
        return -1;
    }

    @Override
    public void setStackTopElement(short s) {
        this.stack.replaceTopElement(s);
    }

    @Override
    public short getStackElement(int n) {
        return this.stack.getValueAt(n);
    }

    @Override
    public short popUserStack(int n) {
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        int n2 = memoryAccess.readUnsignedShort(n);
        memoryAccess.writeUnsignedShort(n, ++n2);
        return memoryAccess.readShort(n + n2 * 2);
    }

    @Override
    public boolean pushUserStack(int n, short s) {
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        int n2 = memoryAccess.readUnsignedShort(n);
        if (n2 > 0) {
            memoryAccess.writeShort(n + n2 * 2, s);
            memoryAccess.writeUnsignedShort(n, n2 - 1);
            return true;
        }
        return false;
    }

    @Override
    public short getVariable(int n) {
        Cpu.VariableType variableType = CpuImpl.getVariableType(n);
        if (variableType == Cpu.VariableType.STACK) {
            if (this.stack.size() == this.getInvocationStackPointer()) {
                System.err.println("stack underflow error");
                return 0;
            }
            return this.stack.pop();
        }
        if (variableType == Cpu.VariableType.LOCAL) {
            int n2 = this.getLocalVariableNumber(n);
            this.checkLocalVariableAccess(n2);
            return this.getCurrentRoutineContext().getLocalVariable(n2);
        }
        return this.machine.getGameData().getMemoryAccess().readShort(this.globalsAddress + this.getGlobalVariableNumber(n) * 2);
    }

    private int getInvocationStackPointer() {
        return this.getCurrentRoutineContext() == null ? 0 : this.getCurrentRoutineContext().getInvocationStackPointer();
    }

    @Override
    public void setVariable(int n, short s) {
        Cpu.VariableType variableType = CpuImpl.getVariableType(n);
        if (variableType == Cpu.VariableType.STACK) {
            this.stack.push(s);
        } else if (variableType == Cpu.VariableType.LOCAL) {
            int n2 = this.getLocalVariableNumber(n);
            this.checkLocalVariableAccess(n2);
            this.getCurrentRoutineContext().setLocalVariable(n2, s);
        } else {
            this.machine.getGameData().getMemoryAccess().writeShort(this.globalsAddress + this.getGlobalVariableNumber(n) * 2, s);
        }
    }

    public static Cpu.VariableType getVariableType(int n) {
        if (n == 0) {
            return Cpu.VariableType.STACK;
        }
        if (n < 16) {
            return Cpu.VariableType.LOCAL;
        }
        return Cpu.VariableType.GLOBAL;
    }

    @Override
    public void pushRoutineContext(RoutineContext routineContext) {
        routineContext.setInvocationStackPointer(this.getStackPointer());
        this.routineContextStack.add(routineContext);
    }

    @Override
    public void popRoutineContext(short s) {
        if (this.routineContextStack.size() > 0) {
            RoutineContext routineContext = this.routineContextStack.remove(this.routineContextStack.size() - 1);
            routineContext.setReturnValue(s);
            this.setStackPointer(routineContext.getInvocationStackPointer());
            this.setProgramCounter(routineContext.getReturnAddress());
            int n = routineContext.getReturnVariable();
            if (n != -1) {
                this.setVariable(n, s);
            }
        } else {
            throw new IllegalStateException("no routine context active");
        }
    }

    @Override
    public RoutineContext getCurrentRoutineContext() {
        if (this.routineContextStack.size() == 0) {
            return null;
        }
        return this.routineContextStack.get(this.routineContextStack.size() - 1);
    }

    @Override
    public List<RoutineContext> getRoutineContexts() {
        return Collections.unmodifiableList(this.routineContextStack);
    }

    @Override
    public void setRoutineContexts(List<RoutineContext> list) {
        this.routineContextStack.clear();
        for (RoutineContext routineContext : list) {
            this.routineContextStack.add(routineContext);
        }
    }

    public int getRoutineStackPointer() {
        return this.routineContextStack.size();
    }

    @Override
    public RoutineContext call(int n, int n2, short[] sArray, short s) {
        int n3 = this.translatePackedAddress(n, true);
        int n4 = sArray == null ? 0 : sArray.length;
        RoutineContext routineContext = this.decodeRoutine(n3);
        routineContext.setNumArguments(n4);
        routineContext.setReturnAddress(n2);
        if (s == -1) {
            routineContext.setReturnVariable(-1);
        } else {
            routineContext.setReturnVariable(s);
        }
        int n5 = Math.min(routineContext.getNumLocalVariables(), n4);
        for (int i = 0; i < n5; ++i) {
            routineContext.setLocalVariable(i, sArray[i]);
        }
        routineContext.setInvocationStackPointer(this.getStackPointer());
        this.pushRoutineContext(routineContext);
        this.setProgramCounter(routineContext.getStartAddress());
        return routineContext;
    }

    private RoutineContext decodeRoutine(int n) {
        GameData gameData = this.machine.getGameData();
        MemoryAccess memoryAccess = gameData.getMemoryAccess();
        int n2 = memoryAccess.readUnsignedByte(n);
        short[] sArray = new short[n2];
        int n3 = n + 1;
        if (gameData.getStoryFileHeader().getVersion() <= 4) {
            for (int i = 0; i < n2; ++i) {
                sArray[i] = memoryAccess.readShort(n3);
                n3 += 2;
            }
        }
        RoutineContext routineContext = new RoutineContext(n3, n2);
        for (int i = 0; i < n2; ++i) {
            routineContext.setLocalVariable(i, sArray[i]);
        }
        return routineContext;
    }

    private int getLocalVariableNumber(int n) {
        return n - 1;
    }

    private int getGlobalVariableNumber(int n) {
        return n - 16;
    }

    private void checkLocalVariableAccess(int n) {
        if (this.routineContextStack.size() == 0) {
            throw new IllegalStateException("no routine context set");
        }
        if (n >= this.getCurrentRoutineContext().getNumLocalVariables()) {
            throw new IllegalStateException("access to non-existent local variable: " + n);
        }
    }

    @Override
    public boolean interruptDidOutput() {
        return this.interruptDidOutput;
    }

    @Override
    public short callInterrupt(int n) {
        this.interruptDidOutput = false;
        this.executeInterrupt = true;
        int n2 = this.getRoutineContexts().size();
        RoutineContext routineContext = this.call(n, this.machine.getCpu().getProgramCounter(), new short[0], (short)-1);
        do {
            Instruction instruction = this.nextStep();
            instruction.execute();
            if (!instruction.isOutput()) continue;
            this.interruptDidOutput = true;
        } while (this.getRoutineContexts().size() != n2);
        this.executeInterrupt = false;
        return routineContext.getReturnValue();
    }

    @Override
    public void setInterruptRoutine(int n) {
    }

    public boolean isExecutingInterrupt() {
        return this.executeInterrupt;
    }
}

