/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.zmpp.io.OutputStream;
import org.zmpp.swingui.BottomWindow;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.CanvasImpl;
import org.zmpp.swingui.ColorTranslator;
import org.zmpp.swingui.CursorWindow;
import org.zmpp.swingui.DisplaySettings;
import org.zmpp.swingui.LineEditor;
import org.zmpp.swingui.ScreenOutputStream;
import org.zmpp.swingui.SubWindow;
import org.zmpp.swingui.TopWindow;
import org.zmpp.swingui.Viewport;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StoryFileHeader;
import org.zmpp.vm.TextCursor;

public class TextViewport
extends JComponent
implements ScreenModel,
Viewport {
    private static final long serialVersionUID = 1L;
    private BufferedImage imageBuffer;
    private Canvas canvas;
    private boolean initialized;
    private ScreenOutputStream outputstream;
    private static final int WINDOW_BOTTOM = 0;
    private static final int WINDOW_TOP = 1;
    private DisplaySettings settings;
    private int defaultForeground;
    private int defaultBackground;
    private Font standardFont;
    private Font fixedFont;
    private Machine machine;
    private LineEditor editor;
    private SubWindow[] windows;
    private int activeWindow;
    private static final boolean DEBUG = false;

    public TextViewport(Machine machine, LineEditor lineEditor, DisplaySettings displaySettings) {
        this.machine = machine;
        this.editor = lineEditor;
        this.settings = displaySettings;
        this.standardFont = new Font("Dialog", 0, displaySettings.getStdFontSize());
        this.fixedFont = new Font("Monospaced", 0, displaySettings.getFixedFontSize());
        this.outputstream = new ScreenOutputStream(machine, this);
        this.windows = new SubWindow[2];
        this.activeWindow = 0;
        this.setOpaque(true);
        this.setDoubleBuffered(false);
    }

    public CursorWindow getCurrentWindow() {
        return this.windows[this.activeWindow];
    }

    public LineEditor getLineEditor() {
        return this.editor;
    }

    public int getDefaultBackground() {
        return this.defaultBackground;
    }

    public int getDefaultForeground() {
        return this.defaultForeground;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void reset() {
        this.setScreenProperties();
        this.windows[1].clear();
        this.resizeWindows(0);
        this.windows[0].clear();
        this.repaintInUiThread();
    }

    public void eraseWindow(int n) {
        if (n == -1) {
            this.resizeWindows(0);
            this.windows[0].clear();
        } else if (n == -2) {
            this.windows[1].clear();
            this.windows[0].clear();
        } else {
            this.windows[n].clear();
        }
    }

    public void eraseLine(int n) {
        if (n == 1) {
            this.windows[this.activeWindow].eraseLine();
        }
    }

    public TextCursor getTextCursor() {
        this.windows[this.activeWindow].flushBuffer();
        return this.windows[this.activeWindow].getCursor();
    }

    public void setTextCursor(int n, int n2, int n3) {
        this.windows[this.activeWindow].setCursorPosition(n, n2);
    }

    public void splitWindow(int n) {
        this.resizeWindows(n);
        if (this.machine.getGameData().getStoryFileHeader().getVersion() == 3) {
            this.windows[1].clear();
        }
    }

    public void setWindow(int n) {
        this.getOutputStream().flush();
        this.activeWindow = n;
        if (this.activeWindow == 1) {
            this.windows[this.activeWindow].resetCursorToHome();
        }
    }

    public void setTextStyle(int n) {
        this.getOutputStream().flush();
        int n2 = n == 0 ? 0 : this.windows[this.activeWindow].getFont().getStyle();
        Font font = (n & 8) > 0 || this.activeWindow == 1 ? this.fixedFont : this.standardFont;
        this.windows[this.activeWindow].setReverseVideo((n & 1) > 0);
        n2 |= (n & 2) > 0 ? 1 : 0;
        this.windows[this.activeWindow].setFont(font.deriveFont(n2 |= (n & 4) > 0 ? 2 : 0));
    }

    public void setBufferMode(boolean bl) {
        this.getOutputStream().flush();
        this.windows[0].setBufferMode(bl);
    }

    public void setPaging(boolean bl) {
        this.windows[0].setPagingEnabled(bl);
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized() {
        this.initialized = true;
        this.notifyAll();
    }

    public synchronized void waitInitialized() {
        while (!this.isInitialized()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.imageBuffer == null) {
            this.imageBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.canvas = new CanvasImpl(this.imageBuffer, this, this.settings.getAntialias());
            this.setDefaultColors(this.machine.getGameData().getStoryFileHeader(), 9, 2);
            this.windows[1] = new TopWindow(this);
            this.windows[1].setFont(this.fixedFont);
            this.windows[1].setFontNumber(4);
            this.windows[0] = new BottomWindow(this);
            this.windows[0].setFont(this.standardFont);
            this.windows[0].setFontNumber(1);
            this.activeWindow = 0;
            Graphics graphics2 = this.imageBuffer.getGraphics();
            this.resizeWindows(0);
            this.windows[1].resetCursorToHome();
            this.windows[0].resetCursorToHome();
            this.setScreenProperties();
            graphics2.setColor(ColorTranslator.getInstance().translate(this.defaultBackground));
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.windows[1].setBackground(this.defaultBackground);
            this.windows[1].setForeground(this.defaultForeground);
            this.windows[0].setBackground(this.defaultBackground);
            this.windows[0].setForeground(this.defaultForeground);
            this.setInitialized();
        }
        graphics.drawImage(this.imageBuffer, 0, 0, this);
    }

    public void setForegroundColor(int n, int n2) {
        if (n > 0) {
            this.getOutputStream().flush();
            this.windows[1].setForeground(n);
            this.windows[0].setForeground(n);
        }
    }

    public void setBackgroundColor(int n, int n2) {
        if (n > 0) {
            this.getOutputStream().flush();
            this.windows[1].setBackground(n);
            this.windows[0].setBackground(n);
        }
    }

    public void redraw() {
        this.repaintInUiThread();
    }

    public int setFont(int n) {
        this.getOutputStream().flush();
        int n2 = this.windows[this.activeWindow].getFontNumber();
        switch (n) {
            case 4: {
                this.windows[this.activeWindow].setFont(this.fixedFont);
                this.windows[this.activeWindow].setFontNumber(n);
                break;
            }
            case 1: {
                this.windows[this.activeWindow].setFont(this.standardFont);
                this.windows[this.activeWindow].setFontNumber(n);
                break;
            }
            case 3: {
                this.windows[this.activeWindow].setFont(this.fixedFont);
                this.windows[this.activeWindow].setFontNumber(n);
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public synchronized void displayCursor(boolean bl) {
        this.windows[this.activeWindow].drawCursor(bl);
    }

    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    public void resetPagers() {
        this.windows[1].resetPager();
        this.windows[0].resetPager();
    }

    private void updateDimensionsInHeader() {
        StoryFileHeader storyFileHeader = this.machine.getGameData().getStoryFileHeader();
        if (storyFileHeader.getVersion() >= 4) {
            FontMetrics fontMetrics = this.imageBuffer.getGraphics().getFontMetrics(this.fixedFont);
            int n = this.imageBuffer.getWidth() / fontMetrics.charWidth('0');
            int n2 = this.imageBuffer.getHeight() / fontMetrics.getHeight();
            storyFileHeader.setScreenWidth(n);
            storyFileHeader.setScreenHeight(n2);
            if (storyFileHeader.getVersion() >= 5) {
                storyFileHeader.setScreenWidthUnits(n);
                storyFileHeader.setScreenHeightUnits(n2);
            }
        }
    }

    private void determineStandardFont() {
        if (this.machine.getGameData().getStoryFileHeader().isEnabled(StoryFileHeader.Attribute.FORCE_FIXED_FONT)) {
            this.standardFont = this.fixedFont;
        }
    }

    private void resizeWindows(int n) {
        this.windows[1].resize(n);
        int n2 = this.windows[1].getHeight();
        this.windows[0].setVerticalBounds(n2, this.getHeight() - n2);
    }

    private void setScreenProperties() {
        StoryFileHeader storyFileHeader = this.machine.getGameData().getStoryFileHeader();
        if (storyFileHeader.getVersion() <= 3) {
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.DEFAULT_FONT_IS_VARIABLE, true);
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_STATUSLINE, true);
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_SCREEN_SPLITTING, true);
        }
        if (storyFileHeader.getVersion() >= 4) {
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_BOLD, true);
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_FIXED_FONT, true);
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_ITALIC, true);
        }
        if (storyFileHeader.getVersion() >= 5) {
            storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_COLOURS, true);
            storyFileHeader.setDefaultBackgroundColor(9);
            storyFileHeader.setDefaultForegroundColor(2);
            storyFileHeader.setFontWidth(1);
            storyFileHeader.setFontHeight(1);
            this.overrideDefaults(storyFileHeader);
        }
        this.determineStandardFont();
        this.updateDimensionsInHeader();
    }

    private void repaintInUiThread() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    if (TextViewport.this.imageBuffer != null) {
                        TextViewport.this.getGraphics().drawImage(TextViewport.this.imageBuffer, 0, 0, TextViewport.this);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void overrideDefaults(StoryFileHeader storyFileHeader) {
        String string = storyFileHeader.getRelease() + "." + storyFileHeader.getSerialNumber();
        if (this.isBeyondZork(string)) {
            storyFileHeader.setInterpreterNumber(3);
            this.standardFont = this.fixedFont;
        } else if (this.isVaricella(string) || this.isOnlyAfterDark(string)) {
            this.setDefaultColors(storyFileHeader, 2, 9);
            this.windows[0].clear();
        }
    }

    private boolean isVaricella(String string) {
        return string.equals("1.990831");
    }

    private boolean isOnlyAfterDark(String string) {
        return string.equals("2.000913") || string.equals("1.990915");
    }

    private boolean isBeyondZork(String string) {
        return string.equals("47.870915") || string.equals("49.870917") || string.equals("51.870923") || string.equals("57.871221");
    }

    private void setDefaultColors(StoryFileHeader storyFileHeader, int n, int n2) {
        this.defaultBackground = this.settings.getDefaultBackground() != -1000 ? this.settings.getDefaultBackground() : n;
        this.defaultForeground = this.settings.getDefaultForeground() != -1000 ? this.settings.getDefaultForeground() : n2;
        storyFileHeader.setDefaultBackgroundColor(this.defaultBackground);
        storyFileHeader.setDefaultForegroundColor(this.defaultForeground);
    }
}

