/*
 * Decompiled with CFR 0.152.
 */
package zpplet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JPanel;
import zpplet.ZUserConfig;
import zpplet.machine.ZMachine;
import zpplet.system.ZScreen;

public final class Zpplet
extends JApplet {
    private JPanel jContentPane = null;
    private ZScreen zScreen = null;
    private ZMachine zm = null;
    boolean failed = false;

    public Zpplet() {
        this.init();
    }

    public void init() {
        this.setSize(400, 300);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getZScreen(), "Center");
        }
        return this.jContentPane;
    }

    private ZScreen getZScreen() {
        if (this.zScreen == null) {
            this.zScreen = new ZScreen();
        }
        return this.zScreen;
    }

    byte[] getStream(InputStream s) throws IOException {
        byte[] oldbuffer;
        int currentbytes = 0;
        int buffersize = 2048;
        byte[] buffer = new byte[buffersize];
        int bytesleft = buffersize;
        int got = 0;
        while (got != -1) {
            currentbytes += got;
            if ((bytesleft -= got) == 0) {
                oldbuffer = buffer;
                buffer = new byte[buffersize + currentbytes];
                System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
                oldbuffer = null;
                bytesleft = buffersize;
            }
            got = s.read(buffer, currentbytes, bytesleft);
        }
        if (buffer.length != currentbytes) {
            oldbuffer = buffer;
            buffer = new byte[currentbytes];
            System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
        }
        return buffer;
    }

    void startz(String codefile) {
        block10: {
            URL url = null;
            byte[] image = null;
            try {
                url = new URL(this.getDocumentBase(), codefile);
                InputStream ins = url.openStream();
                image = this.getStream(ins);
            }
            catch (MalformedURLException malformedURLException) {
                this.add("North", new Label("Bad URL " + url.toString()));
            }
            catch (IOException iOException) {
                this.add("North", new Label("I/O Error"));
            }
            if (image == null) {
                return;
            }
            try {
                String fixedonly;
                if (this.zm != null) {
                    this.zm.kill();
                    this.zm.join();
                }
                this.zm = ZMachine.NewZMachine(image, this.zScreen);
                if (this.zm == null) {
                    throw new Exception("Could not load file");
                }
                String fontsize = this.getParameter("FontSize");
                if (fontsize != null) {
                    ZUserConfig.fontsize = Integer.parseInt(fontsize);
                }
                if ((fixedonly = this.getParameter("FixedOnly")) != null && Boolean.parseBoolean(fixedonly)) {
                    ZUserConfig.normalfont = ZUserConfig.fixedfont;
                }
                this.zm.start();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block10;
                this.add("North", new Label("ERROR: " + e.getMessage()));
            }
        }
    }

    public void start() {
        if (!(this.failed || this.zm != null && this.zm.isAlive())) {
            String source = this.getParameter("StoryFile");
            this.startz(source);
        }
    }

    public void destroy() {
        if (this.zm != null) {
            this.zm.kill();
        }
        this.zm = null;
        this.remove(this.zScreen);
        this.zScreen = null;
    }
}

