/*
 * Decompiled with CFR 0.152.
 */
package zpplet.misc;

import java.io.IOException;
import java.util.Stack;
import zpplet.iff.IFF;
import zpplet.iff.IFFInput;
import zpplet.iff.IFFOutput;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.ops.ZStackFrame;

public class ZState {
    private ZMachine zm;
    private Stack st;
    private int pc;
    private byte[] dynamic;
    private int[] l;
    private static final int QUETZAL_PROCEDURE = 16;

    public ZState(ZMachine zm) {
        this.zm = zm;
        this.snapshot();
    }

    public void snapshot() {
        this.dynamic = new byte[this.zm.hd.getStaticBase()];
        System.arraycopy(this.zm.getMem(), 0, this.dynamic, 0, this.dynamic.length);
        this.st = (Stack)this.zm.st.clone();
        this.l = (int[])this.zm.l.clone();
        this.pc = this.zm.pc;
    }

    public void restoreSnapshot() {
        System.arraycopy(this.dynamic, 0, this.zm.getMem(), 0, this.dynamic.length);
        this.zm.st = (Stack)this.st.clone();
        this.zm.l = (int[])this.l.clone();
        this.zm.pc = this.pc;
        boolean t = this.zm.hd.getTranscripting();
        this.zm.setHeaderFlags();
        this.zm.hd.setTranscripting(t);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadQuetzalFile(String fname) throws IOException, ZError {
        block28: {
            IFFInput infile = null;
            try {
                long ifhdend;
                IFF.ChunkInfo chunkinfo;
                block29: {
                    block26: {
                        infile = new IFFInput(fname);
                        chunkinfo = infile.openChunk();
                        if (!chunkinfo.type.equals("FORMIFZS")) {
                            throw new IOException("Invalid file type (expecting Quetzal format)");
                        }
                        chunkinfo = infile.skipToChunk("IFhd");
                        if (chunkinfo == null) {
                            throw new IOException("Missing 'IFhd' chunk");
                        }
                        int release = infile.readShort() & 0xFFFF;
                        byte[] serial = new byte[6];
                        infile.read(serial);
                        int checksum = infile.readShort() & 0xFFFF;
                        if (release != this.zm.hd.getRelease()) {
                            throw new ZError("Release does not match (game " + this.zm.hd.getRelease() + ", file " + release + ")");
                        }
                        if (checksum != this.zm.hd.getChecksum()) {
                            throw new ZError("Checksum does not match (game 0x" + Integer.toHexString(this.zm.hd.getChecksum()) + ", file 0x" + Integer.toHexString(checksum) + ")");
                        }
                        byte[] zmserial = this.zm.hd.getSerialNumber();
                        int i = 0;
                        while (true) {
                            if (i >= serial.length) {
                                this.pc = (infile.readByte() & 0xFF) << 16;
                                this.pc += infile.readShort() & 0xFFFF;
                                infile.closeChunk();
                                ifhdend = infile.getFilePointer();
                                chunkinfo = infile.skipToChunk("UMem");
                                if (chunkinfo != null) {
                                    if (chunkinfo.length == this.zm.hd.getStaticBase()) break;
                                    throw new IOException("Dynamic memory area is " + chunkinfo.length + ", expected " + this.zm.hd.getStaticBase());
                                }
                                break block26;
                            }
                            if (serial[i] != zmserial[i]) {
                                throw new ZError("Serial number does not match");
                            }
                            ++i;
                        }
                        this.dynamic = new byte[chunkinfo.length];
                        infile.read(this.dynamic);
                        break block29;
                    }
                    infile.seek(ifhdend);
                    chunkinfo = infile.skipToChunk("CMem");
                    if (chunkinfo == null) {
                        throw new IOException("Missing 'CMem' or 'UMem' chunk");
                    }
                    this.dynamic = new byte[this.zm.hd.getStaticBase()];
                    System.arraycopy(this.zm.restart.dynamic, 0, this.dynamic, 0, this.zm.hd.getStaticBase());
                    int length = chunkinfo.length;
                    int nbytesout = 0;
                    boolean runmode = false;
                    while (length-- > 0) {
                        if (nbytesout >= this.zm.hd.getStaticBase()) {
                            throw new IOException("'CMem' exceeded dynamic memory size");
                        }
                        byte ch = infile.readByte();
                        if (runmode) {
                            runmode = false;
                            nbytesout += (ch & 0xFF) + 1;
                            continue;
                        }
                        if (ch != 0) {
                            int n = nbytesout++;
                            this.dynamic[n] = (byte)(this.dynamic[n] ^ ch);
                            continue;
                        }
                        runmode = true;
                    }
                }
                infile.closeChunk();
                infile.seek(ifhdend);
                chunkinfo = infile.skipToChunk("Stks");
                if (chunkinfo == null) {
                    throw new IOException("Missing 'Stks' chunk");
                }
                this.st = new Stack();
                int[] prevlocals = null;
                block5: while (true) {
                    int i;
                    int[] framelocals;
                    int evalwords;
                    block27: {
                        ZStackFrame sf;
                        block30: {
                            if (infile.getChunkPosition() < chunkinfo.length) break block30;
                            this.l = prevlocals;
                            infile.closeChunk();
                            break;
                        }
                        int framepc = (infile.readByte() & 0xFF) << 16;
                        framepc += infile.readShort() & 0xFFFF;
                        byte flags = infile.readByte();
                        byte resultvar = infile.readByte();
                        byte argmask = infile.readByte();
                        evalwords = infile.readShort() & 0xFFFF;
                        int numlocals = flags & 0xF;
                        framelocals = new int[numlocals];
                        i = 0;
                        while (true) {
                            if (i >= numlocals) {
                                if (prevlocals != null) {
                                    sf = new ZStackFrame();
                                    sf.interrupt = false;
                                    sf.store = (flags & 0x10) != 0 ? -1 : (int)resultvar;
                                }
                                break block27;
                            }
                            framelocals[i] = infile.readShort() & 0xFFFF;
                            ++i;
                        }
                        if ((argmask & argmask + 1) != 0) {
                            throw new IOException("This Quetzal implementation does not support noncontiguous arguments");
                        }
                        int argcount = 0;
                        while (true) {
                            if (argmask <= 0) {
                                sf.pc = framepc;
                                sf.args = argcount;
                                sf.l = prevlocals;
                                this.st.push(sf);
                                break;
                            }
                            ++argcount;
                            argmask = (byte)(argmask >> 1);
                        }
                    }
                    prevlocals = framelocals;
                    i = 0;
                    while (true) {
                        if (i >= evalwords) continue block5;
                        this.st.push(new Integer(infile.readShort() & 0xFFFF));
                        ++i;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (infile != null) {
                    infile.close();
                }
                throw throwable;
            }
            {
                Object var20_24 = null;
                if (infile == null) break block28;
            }
            infile.close();
        }
        this.restoreSnapshot();
    }

    /*
     * Unable to fully structure code
     */
    private void writeCMemChunk(IFFOutput outfile) throws IOException {
        runsize = 0;
        outfile.openChunk("CMem");
        i = 0;
        while (i < this.zm.hd.getStaticBase()) {
            block3: {
                if (this.dynamic[i] != this.zm.restart.dynamic[i]) ** GOTO lbl15
                ++runsize;
                break block3;
lbl-1000:
                // 1 sources

                {
                    outfile.writeByte(0);
                    if (runsize >= 256) {
                        outfile.writeByte(-1);
                        runsize -= 256;
                        continue;
                    }
                    outfile.writeByte((byte)(runsize - 1));
                    runsize = 0;
lbl15:
                    // 3 sources

                    ** while (runsize > 0)
                }
lbl16:
                // 1 sources

                outfile.writeByte((byte)(this.dynamic[i] ^ this.zm.restart.dynamic[i]));
            }
            ++i;
        }
        outfile.closeChunk();
    }

    int[] nextLocals(Object[] e, int i) {
        while (i < e.length) {
            if (e[i] instanceof ZStackFrame) {
                return ((ZStackFrame)e[i]).l;
            }
            ++i;
        }
        return this.l;
    }

    /*
     * Exception decompiling
     */
    public void saveQuetzalFile(String fname) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 516->520)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

