/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.misc.ZState;
import zpplet.ops.ZStackFrame;

public class ZInstruction {
    protected ZMachine zm;
    protected int op;
    protected int[] o;
    protected int noperands;
    protected int startpc;
    protected int nargs;
    protected boolean interrupting;
    protected IOP[] ops;
    private static final int OP_LARGE = 0;
    private static final int OP_SMALL = 1;
    private static final int OP_VARIABLE = 2;
    private static final int OP_OMITTED = 3;
    private BufferedReader debugtrace;

    public ZInstruction(ZMachine zm) {
        this.zm = zm;
        this.o = new int[8];
        this.interrupting = false;
        this.initOps();
    }

    public void callMain() {
        this.zm.pc = this.zm.hd.getInitialPC();
    }

    private int getOperand(int type) throws ZError {
        switch (type) {
            case 1: {
                return this.zm.getCodeByte();
            }
            case 0: {
                return this.zm.getCodeWord();
            }
            case 2: {
                return this.zm.getVariable(this.zm.getCodeByte());
            }
        }
        throw new ZError("Invalid operand type " + type);
    }

    void fetchVarOperands(int typeinfo, int max) throws ZError {
        while (max-- > 0) {
            int optype = typeinfo >> max * 2 & 3;
            if (optype == 3) break;
            this.o[this.noperands++] = this.getOperand(optype);
        }
    }

    public void decode() throws ZError {
        this.startpc = this.zm.pc;
        int opcode = this.zm.getCodeByte();
        if (opcode == 190) {
            this.op = 256 + this.zm.getCodeByte();
            this.noperands = 0;
            this.fetchVarOperands(this.zm.getCodeByte(), 4);
        } else if ((opcode & 0xC0) == 192) {
            this.op = opcode;
            this.noperands = 0;
            if ((opcode & 0x20) == 0) {
                this.op = opcode & 0x1F;
            }
            if (this.op == 236 || this.op == 250) {
                this.fetchVarOperands(this.zm.getCodeWord(), 8);
            } else {
                this.fetchVarOperands(this.zm.getCodeByte(), 4);
            }
        } else if ((opcode & 0xC0) == 128) {
            int optype = opcode >> 4 & 3;
            if (optype == 3) {
                this.op = opcode;
                this.noperands = 0;
            } else {
                this.op = opcode & 0x8F;
                this.noperands = 1;
                this.o[0] = this.getOperand(optype);
            }
        } else {
            this.op = opcode & 0x1F;
            this.noperands = 2;
            int optype = ((opcode & 0x40) >> 6) + 1;
            this.o[0] = this.getOperand(optype);
            optype = ((opcode & 0x20) >> 5) + 1;
            this.o[1] = this.getOperand(optype);
        }
    }

    protected void doStore(int val) {
        this.zm.setVariable(this.zm.getCodeByte(), val);
    }

    protected void doBranch(boolean result) {
        int b = this.zm.getCodeByte();
        boolean branchtype = (b & 0x80) != 0;
        int branchoffset = b & 0x3F;
        if ((b & 0x40) == 0) {
            branchoffset = (branchoffset & 0x20) == 0 ? branchoffset << 8 | this.zm.getCodeByte() : 0xFFFFC000 | branchoffset << 8 | this.zm.getCodeByte();
        }
        if (result == branchtype) {
            switch (branchoffset) {
                case 0: 
                case 1: {
                    this.doReturn(branchoffset);
                    break;
                }
                default: {
                    this.zm.pc += branchoffset - 2;
                }
            }
        }
    }

    private void debugLinkToTrace() {
        try {
            this.debugtrace = new BufferedReader(new FileReader("trace.txt"));
        }
        catch (Exception exception) {}
    }

    private String debugFindTraceLine(int addr) {
        boolean pass1 = true;
        try {
            if (this.debugtrace == null) {
                this.debugLinkToTrace();
            }
            while (this.debugtrace.ready() || pass1) {
                String line;
                int colon;
                if (!this.debugtrace.ready()) {
                    pass1 = false;
                    this.debugtrace.close();
                    this.debugLinkToTrace();
                }
                if ((colon = (line = this.debugtrace.readLine()).indexOf(58)) < 0) continue;
                int thisaddr = -1;
                try {
                    thisaddr = Integer.parseInt(line.substring(0, colon).trim(), 16);
                }
                catch (Exception exception) {
                    thisaddr = -1;
                }
                if (thisaddr != addr) continue;
                return line;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void debugShowInstruction(boolean trace) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.noperands) {
            s.append(", ");
            s.append(this.o[i]);
            ++i;
        }
        s.append(" locals [");
        i = 0;
        while (i < this.zm.l.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.zm.l[i]);
            ++i;
        }
        s.append("]");
        System.out.println("pc = 0x" + Integer.toHexString(this.startpc) + ", opcode = " + this.op + s);
        if (trace) {
            String traceline = this.debugFindTraceLine(this.startpc);
            if (traceline == null) {
                System.out.println("No trace found.");
            } else {
                System.out.println("\t" + traceline);
            }
        }
    }

    public final void execute() throws ZError {
        try {
            this.ops[this.op].x();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ZError("Invalid operation #" + this.op);
        }
        catch (NullPointerException nullPointerException) {
            throw new ZError("Invalid operation #" + this.op);
        }
    }

    public final int interrupt(int addr) {
        if (this.interrupting) {
            System.err.println("Interrupt interrupted!");
            return 0;
        }
        int i = 0;
        while (i < this.noperands) {
            this.zm.st.push(new Integer(this.o[i]));
            ++i;
        }
        this.zm.st.push(new Integer(this.noperands));
        this.noperands = 1;
        this.o[0] = addr;
        this.doCall(false);
        try {
            this.interrupting = true;
            do {
                this.decode();
                this.execute();
            } while (this.interrupting);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                e.printStackTrace();
                System.err.println("INTERRUPT FAILED: " + e.getMessage());
            }
            this.interrupting = false;
            return 0;
        }
        int result = this.zm.getVariable(0);
        this.noperands = (Integer)this.zm.st.pop();
        int i2 = this.noperands - 1;
        while (i2 >= 0) {
            this.o[i2] = (Integer)this.zm.st.pop();
            --i2;
        }
        return result;
    }

    protected void initOps() {
        this.ops = new IOP[285];
        this.ops[1] = new OP_JE();
        this.ops[2] = new OP_JL();
        this.ops[3] = new OP_JG();
        this.ops[4] = new OP_DEC_CHK();
        this.ops[5] = new OP_INC_CHK();
        this.ops[6] = new OP_JIN();
        this.ops[7] = new OP_TEST();
        this.ops[8] = new OP_OR();
        this.ops[9] = new OP_AND();
        this.ops[10] = new OP_TEST_ATTR();
        this.ops[11] = new OP_SET_ATTR();
        this.ops[12] = new OP_CLEAR_ATTR();
        this.ops[13] = new OP_STORE();
        this.ops[14] = new OP_INSERT_OBJ();
        this.ops[15] = new OP_LOADW();
        this.ops[16] = new OP_LOADB();
        this.ops[17] = new OP_GET_PROP();
        this.ops[18] = new OP_GET_PROP_ADDR();
        this.ops[19] = new OP_GET_NEXT_PROP();
        this.ops[20] = new OP_ADD();
        this.ops[21] = new OP_SUB();
        this.ops[22] = new OP_MUL();
        this.ops[23] = new OP_DIV();
        this.ops[24] = new OP_MOD();
        this.ops[128] = new OP_JZ();
        this.ops[129] = new OP_GET_SIBLING();
        this.ops[130] = new OP_GET_CHILD();
        this.ops[131] = new OP_GET_PARENT();
        this.ops[132] = new OP_GET_PROP_LEN();
        this.ops[133] = new OP_INC();
        this.ops[134] = new OP_DEC();
        this.ops[135] = new OP_PRINT_ADDR();
        this.ops[137] = new OP_REMOVE_OBJ();
        this.ops[138] = new OP_PRINT_OBJ();
        this.ops[139] = new OP_RET();
        this.ops[140] = new OP_JUMP();
        this.ops[141] = new OP_PRINT_PADDR();
        this.ops[142] = new OP_LOAD();
        this.ops[143] = new OP_NOT();
        this.ops[176] = new OP_RTRUE();
        this.ops[177] = new OP_RFALSE();
        this.ops[178] = new OP_PRINT();
        this.ops[179] = new OP_PRINT_RET();
        this.ops[180] = new OP_NOP();
        this.ops[181] = new OP_SAVE();
        this.ops[182] = new OP_RESTORE();
        this.ops[183] = new OP_RESTART();
        this.ops[184] = new OP_RET_POPPED();
        this.ops[185] = new OP_POP();
        this.ops[186] = new OP_QUIT();
        this.ops[187] = new OP_NEW_LINE();
        this.ops[224] = new OP_CALL();
        this.ops[225] = new OP_STOREW();
        this.ops[226] = new OP_STOREB();
        this.ops[227] = new OP_PUT_PROP();
        this.ops[228] = new OP_READ();
        this.ops[229] = new OP_PRINT_CHAR();
        this.ops[230] = new OP_PRINT_NUM();
        this.ops[231] = new OP_RANDOM();
        this.ops[232] = new OP_PUSH();
        this.ops[233] = new OP_PULL();
    }

    /*
     * Unable to fully structure code
     */
    void detachObj(int obj) throws ZError {
        parent = this.zm.objs.getParent(obj);
        if (parent == 0) {
            return;
        }
        cursor = this.zm.objs.getChild(parent);
        if (cursor != obj) ** GOTO lbl10
        this.zm.objs.setChild(parent, this.zm.objs.getSibling(obj));
        return;
lbl-1000:
        // 1 sources

        {
            if ((cursor = this.zm.objs.getSibling(cursor)) != 0) continue;
            throw new ZError("Malformed object tree");
lbl10:
            // 2 sources

            ** while (this.zm.objs.getSibling((int)cursor) != obj)
        }
lbl11:
        // 1 sources

        this.zm.objs.setSibling(cursor, this.zm.objs.getSibling(obj));
    }

    protected void doSave() {
        try {
            String fname = this.zm.s.getFileName("Save Game", true);
            if (fname != null) {
                new ZState(this.zm).saveQuetzalFile(fname);
                this.doBranch(true);
                return;
            }
        }
        catch (IOException iOException) {}
        this.doBranch(false);
    }

    protected void doRestore() {
        try {
            String fname = this.zm.s.getFileName("Load Game", false);
            if (fname != null) {
                new ZState(this.zm).loadQuetzalFile(fname);
            }
            this.doBranch(true);
        }
        catch (Exception exception) {
            this.doBranch(false);
        }
    }

    protected void doRead() throws ZError {
        int tbuf = this.o[0];
        int parseaddr = this.o[1];
        int timeout = this.noperands < 3 ? 0 : this.o[2];
        int timeoutroutine = this.noperands < 4 ? 0 : this.o[3];
        this.zm.updateStatusLine();
        this.zm.curw.flush();
        this.zm.curw.resetLineCount();
        int tsize = this.zm.getByte(tbuf) + 1;
        if (tsize < 3) {
            throw new ZError("Text buffer < 3 bytes");
        }
        int count = 0;
        while (tsize-- > 0) {
            int ch = this.zm.getInput(true, timeout, timeoutroutine);
            if (ch == -1) {
                throw new ZError(null);
            }
            if (this.zm.zc.isTerminator(ch)) break;
            if (ch >= 65 && ch <= 90) {
                ch += 32;
            }
            this.zm.setByte(tbuf + 1 + count++, ch);
        }
        this.zm.setByte(tbuf + 1 + count, 0);
        this.zm.zd.tokenize(tbuf + 1, count, parseaddr, true);
    }

    protected void doCall(boolean stores) {
        if (this.o[0] == 0) {
            if (stores) {
                this.doStore(0);
            }
            return;
        }
        this.zm.st.push(new ZStackFrame(this.zm, stores));
    }

    protected final void doReturn(int retval) {
        Object tos;
        while (!((tos = this.zm.st.pop()) instanceof ZStackFrame)) {
        }
        ((ZStackFrame)tos).restore(this.zm, retval);
    }

    protected void loadParameters(int count) {
        int i = 0;
        while (i < count) {
            int initval = this.zm.getCodeWord();
            this.zm.l[i] = i + 1 < this.noperands ? this.zm.zi.o[i + 1] : initval;
            ++i;
        }
    }

    protected interface IOP {
        public void x() throws ZError;
    }

    class OP_JE
    implements IOP {
        OP_JE() {
        }

        public void x() {
            boolean result = false;
            int i = 1;
            while (i < ZInstruction.this.noperands) {
                if (ZInstruction.this.o[0] == ZInstruction.this.o[i]) {
                    result = true;
                    break;
                }
                ++i;
            }
            ZInstruction.this.doBranch(result);
        }
    }

    class OP_JL
    implements IOP {
        OP_JL() {
        }

        public void x() {
            ZInstruction.this.doBranch((short)ZInstruction.this.o[0] < (short)ZInstruction.this.o[1]);
        }
    }

    class OP_JG
    implements IOP {
        OP_JG() {
        }

        public void x() {
            ZInstruction.this.doBranch((short)ZInstruction.this.o[0] > (short)ZInstruction.this.o[1]);
        }
    }

    class OP_DEC_CHK
    implements IOP {
        OP_DEC_CHK() {
        }

        public void x() {
            short x = (short)ZInstruction.this.zm.getVariable(ZInstruction.this.o[0]);
            x = (short)(x - 1);
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], x);
            ZInstruction.this.doBranch(x < (short)ZInstruction.this.o[1]);
        }
    }

    class OP_INC_CHK
    implements IOP {
        OP_INC_CHK() {
        }

        public void x() {
            short x = (short)ZInstruction.this.zm.getVariable(ZInstruction.this.o[0]);
            x = (short)(x + 1);
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], x);
            ZInstruction.this.doBranch(x > (short)ZInstruction.this.o[1]);
        }
    }

    class OP_JIN
    implements IOP {
        OP_JIN() {
        }

        public void x() {
            ZInstruction.this.doBranch(ZInstruction.this.zm.objs.getParent(ZInstruction.this.o[0]) == ZInstruction.this.o[1]);
        }
    }

    class OP_TEST
    implements IOP {
        OP_TEST() {
        }

        public void x() {
            ZInstruction.this.doBranch((ZInstruction.this.o[0] & ZInstruction.this.o[1]) == ZInstruction.this.o[1]);
        }
    }

    class OP_OR
    implements IOP {
        OP_OR() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.o[0] | ZInstruction.this.o[1]);
        }
    }

    class OP_AND
    implements IOP {
        OP_AND() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.o[0] & ZInstruction.this.o[1]);
        }
    }

    class OP_TEST_ATTR
    implements IOP {
        OP_TEST_ATTR() {
        }

        public void x() {
            ZInstruction.this.doBranch(ZInstruction.this.zm.objs.getAttribute(ZInstruction.this.o[0], ZInstruction.this.o[1]));
        }
    }

    class OP_SET_ATTR
    implements IOP {
        OP_SET_ATTR() {
        }

        public void x() {
            ZInstruction.this.zm.objs.setAttribute(ZInstruction.this.o[0], ZInstruction.this.o[1], true);
        }
    }

    class OP_CLEAR_ATTR
    implements IOP {
        OP_CLEAR_ATTR() {
        }

        public void x() {
            ZInstruction.this.zm.objs.setAttribute(ZInstruction.this.o[0], ZInstruction.this.o[1], false);
        }
    }

    class OP_STORE
    implements IOP {
        OP_STORE() {
        }

        public void x() {
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], ZInstruction.this.o[1]);
        }
    }

    class OP_INSERT_OBJ
    implements IOP {
        OP_INSERT_OBJ() {
        }

        public void x() throws ZError {
            int obj = ZInstruction.this.o[0];
            ZInstruction.this.detachObj(obj);
            int dest = ZInstruction.this.o[1];
            int dchild = ZInstruction.this.zm.objs.getChild(dest);
            ZInstruction.this.zm.objs.setChild(dest, obj);
            ZInstruction.this.zm.objs.setSibling(obj, dchild);
            ZInstruction.this.zm.objs.setParent(obj, dest);
        }
    }

    class OP_LOADW
    implements IOP {
        OP_LOADW() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.getWord(ZInstruction.this.o[0] + ZInstruction.this.o[1] * 2));
        }
    }

    class OP_LOADB
    implements IOP {
        OP_LOADB() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.getByte(ZInstruction.this.o[0] + ZInstruction.this.o[1]));
        }
    }

    class OP_GET_PROP
    implements IOP {
        OP_GET_PROP() {
        }

        public void x() {
            int p = ZInstruction.this.zm.objs.getProp(ZInstruction.this.o[0], ZInstruction.this.o[1]);
            ZInstruction.this.doStore(p);
        }
    }

    class OP_GET_PROP_ADDR
    implements IOP {
        OP_GET_PROP_ADDR() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.objs.getPropAddr(ZInstruction.this.o[0], ZInstruction.this.o[1]));
        }
    }

    class OP_GET_NEXT_PROP
    implements IOP {
        OP_GET_NEXT_PROP() {
        }

        public void x() throws ZError {
            ZInstruction.this.doStore(ZInstruction.this.zm.objs.getNextProp(ZInstruction.this.o[0], ZInstruction.this.o[1]));
        }
    }

    class OP_ADD
    implements IOP {
        OP_ADD() {
        }

        public void x() {
            ZInstruction.this.doStore((short)ZInstruction.this.o[0] + (short)ZInstruction.this.o[1]);
        }
    }

    class OP_SUB
    implements IOP {
        OP_SUB() {
        }

        public void x() {
            ZInstruction.this.doStore((short)ZInstruction.this.o[0] - (short)ZInstruction.this.o[1]);
        }
    }

    class OP_MUL
    implements IOP {
        OP_MUL() {
        }

        public void x() {
            ZInstruction.this.doStore((short)ZInstruction.this.o[0] * (short)ZInstruction.this.o[1]);
        }
    }

    class OP_DIV
    implements IOP {
        OP_DIV() {
        }

        public void x() throws ZError {
            if (ZInstruction.this.o[1] == 0) {
                throw new ZError("Division by zero");
            }
            ZInstruction.this.doStore((short)ZInstruction.this.o[0] / (short)ZInstruction.this.o[1]);
        }
    }

    class OP_MOD
    implements IOP {
        OP_MOD() {
        }

        public void x() throws ZError {
            if (ZInstruction.this.o[1] == 0) {
                throw new ZError("Mod by zero");
            }
            ZInstruction.this.doStore((short)ZInstruction.this.o[0] % (short)ZInstruction.this.o[1]);
        }
    }

    class OP_JZ
    implements IOP {
        OP_JZ() {
        }

        public void x() {
            ZInstruction.this.doBranch(ZInstruction.this.o[0] == 0);
        }
    }

    class OP_GET_SIBLING
    implements IOP {
        OP_GET_SIBLING() {
        }

        public void x() {
            int v = ZInstruction.this.zm.objs.getSibling(ZInstruction.this.o[0]);
            ZInstruction.this.doStore(v);
            ZInstruction.this.doBranch(v != 0);
        }
    }

    class OP_GET_CHILD
    implements IOP {
        OP_GET_CHILD() {
        }

        public void x() {
            int v = ZInstruction.this.zm.objs.getChild(ZInstruction.this.o[0]);
            ZInstruction.this.doStore(v);
            ZInstruction.this.doBranch(v != 0);
        }
    }

    class OP_GET_PARENT
    implements IOP {
        OP_GET_PARENT() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.objs.getParent(ZInstruction.this.o[0]));
        }
    }

    class OP_GET_PROP_LEN
    implements IOP {
        OP_GET_PROP_LEN() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.objs.getPropLen(ZInstruction.this.o[0]));
        }
    }

    class OP_INC
    implements IOP {
        OP_INC() {
        }

        public void x() {
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], ZInstruction.this.zm.getVariable(ZInstruction.this.o[0]) + 1);
        }
    }

    class OP_DEC
    implements IOP {
        OP_DEC() {
        }

        public void x() {
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], ZInstruction.this.zm.getVariable(ZInstruction.this.o[0]) - 1);
        }
    }

    class OP_PRINT_ADDR
    implements IOP {
        OP_PRINT_ADDR() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.printStringAt(ZInstruction.this.o[0]);
        }
    }

    class OP_REMOVE_OBJ
    implements IOP {
        OP_REMOVE_OBJ() {
        }

        public void x() throws ZError {
            ZInstruction.this.detachObj(ZInstruction.this.o[0]);
            ZInstruction.this.zm.objs.setParent(ZInstruction.this.o[0], 0);
            ZInstruction.this.zm.objs.setSibling(ZInstruction.this.o[0], 0);
        }
    }

    class OP_PRINT_OBJ
    implements IOP {
        OP_PRINT_OBJ() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.printStringAt(ZInstruction.this.zm.objs.getShortNameAddr(ZInstruction.this.o[0]));
        }
    }

    class OP_RET
    implements IOP {
        OP_RET() {
        }

        public void x() {
            ZInstruction.this.doReturn(ZInstruction.this.o[0]);
        }
    }

    class OP_JUMP
    implements IOP {
        OP_JUMP() {
        }

        public void x() {
            ZInstruction.this.zm.pc += (short)ZInstruction.this.o[0] - 2;
        }
    }

    class OP_PRINT_PADDR
    implements IOP {
        OP_PRINT_PADDR() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.printStringAt(ZInstruction.this.zm.unpackSAddr(ZInstruction.this.o[0]));
        }
    }

    class OP_LOAD
    implements IOP {
        OP_LOAD() {
        }

        public void x() {
            ZInstruction.this.doStore(ZInstruction.this.zm.getVariable(ZInstruction.this.o[0]));
        }
    }

    class OP_NOT
    implements IOP {
        OP_NOT() {
        }

        public void x() {
            ZInstruction.this.doStore(~ZInstruction.this.o[0]);
        }
    }

    class OP_RTRUE
    implements IOP {
        OP_RTRUE() {
        }

        public void x() {
            ZInstruction.this.doReturn(1);
        }
    }

    class OP_RFALSE
    implements IOP {
        OP_RFALSE() {
        }

        public void x() {
            ZInstruction.this.doReturn(0);
        }
    }

    class OP_PRINT
    implements IOP {
        OP_PRINT() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.printStringAt(ZInstruction.this.zm.pc);
            while ((ZInstruction.this.zm.getCodeWord() & 0x8000) == 0) {
            }
        }
    }

    class OP_PRINT_RET
    implements IOP {
        OP_PRINT_RET() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.printStringAt(ZInstruction.this.zm.pc);
            ZInstruction.this.zm.printAsciiChar(13);
            ZInstruction.this.doReturn(1);
        }
    }

    class OP_NOP
    implements IOP {
        OP_NOP() {
        }

        public void x() {
        }
    }

    class OP_SAVE
    implements IOP {
        OP_SAVE() {
        }

        public void x() {
            ZInstruction.this.doSave();
        }
    }

    class OP_RESTORE
    implements IOP {
        OP_RESTORE() {
        }

        public void x() {
            ZInstruction.this.doRestore();
        }
    }

    class OP_RESTART
    implements IOP {
        OP_RESTART() {
        }

        public void x() {
            ZInstruction.this.zm.restart();
        }
    }

    class OP_RET_POPPED
    implements IOP {
        OP_RET_POPPED() {
        }

        public void x() {
            ZInstruction.this.doReturn(ZInstruction.this.zm.getVariable(0));
        }
    }

    class OP_POP
    implements IOP {
        OP_POP() {
        }

        public void x() {
            ZInstruction.this.zm.getVariable(0);
        }
    }

    class OP_QUIT
    implements IOP {
        OP_QUIT() {
        }

        public void x() {
            ZInstruction.this.zm.printAsciiString("***END OF SESSION***\r");
            ZInstruction.this.zm.s.repaint();
            ZInstruction.this.zm.running = false;
        }
    }

    class OP_NEW_LINE
    implements IOP {
        OP_NEW_LINE() {
        }

        public void x() {
            ZInstruction.this.zm.printAsciiChar(13);
        }
    }

    class OP_CALL
    implements IOP {
        OP_CALL() {
        }

        public void x() {
            ZInstruction.this.doCall(true);
        }
    }

    class OP_STOREW
    implements IOP {
        OP_STOREW() {
        }

        public void x() {
            ZInstruction.this.zm.setWord(ZInstruction.this.o[0] + ZInstruction.this.o[1] * 2, ZInstruction.this.o[2]);
        }
    }

    class OP_STOREB
    implements IOP {
        OP_STOREB() {
        }

        public void x() {
            ZInstruction.this.zm.setByte(ZInstruction.this.o[0] + ZInstruction.this.o[1], ZInstruction.this.o[2]);
        }
    }

    class OP_PUT_PROP
    implements IOP {
        OP_PUT_PROP() {
        }

        public void x() throws ZError {
            ZInstruction.this.zm.objs.setProp(ZInstruction.this.o[0], ZInstruction.this.o[1], ZInstruction.this.o[2]);
        }
    }

    class OP_READ
    implements IOP {
        OP_READ() {
        }

        public void x() throws ZError {
            ZInstruction.this.doRead();
        }
    }

    class OP_PRINT_CHAR
    implements IOP {
        OP_PRINT_CHAR() {
        }

        public void x() {
            ZInstruction.this.zm.printAsciiChar(ZInstruction.this.o[0]);
        }
    }

    class OP_PRINT_NUM
    implements IOP {
        OP_PRINT_NUM() {
        }

        public void x() {
            ZInstruction.this.zm.printAsciiString(Short.toString((short)ZInstruction.this.o[0]));
        }
    }

    class OP_RANDOM
    implements IOP {
        OP_RANDOM() {
        }

        public void x() {
            short n = (short)ZInstruction.this.o[0];
            if (n == 0) {
                ZInstruction.this.zm.random = new Random();
                ZInstruction.this.doStore(0);
            } else if (n < 0) {
                ZInstruction.this.zm.random = new Random(-n);
                ZInstruction.this.doStore(0);
            } else {
                ZInstruction.this.doStore(ZInstruction.this.zm.random.nextInt(n) + 1);
            }
        }
    }

    class OP_PUSH
    implements IOP {
        OP_PUSH() {
        }

        public void x() {
            ZInstruction.this.zm.setVariable(0, ZInstruction.this.o[0]);
        }
    }

    class OP_PULL
    implements IOP {
        OP_PULL() {
        }

        public void x() {
            ZInstruction.this.zm.setVariable(ZInstruction.this.o[0], ZInstruction.this.zm.getVariable(0));
        }
    }
}

