/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#include "stdafx.h"


#include "states.h"
#include "FlagTable.h"
#include "ObjectList.h"
#include "stdafx.h"

#include "cparser.hpp"
#include "condactsarray.h"
#include "ccondact.hpp"
#include "condacts.h"
#include "MessageList.h"
#include "ObjectDef.h"
#include "ProcessTable.h"
#include "AdvMap.h"
#include "CompilerDlg.h"
#include "acecompiler.h"

CAceCompiler::CAceCompiler(void)
: dlg(NULL)
{
	SourceLine=0;
	BlanksOK=false;
	ProcessTableCount=0;
	
}

CAceCompiler::~CAceCompiler(void)
{
}


int CAceCompiler::GetVocab()
{
	char Input[255];
	char Word[50];
	char Type[50];
	int Num;
	int Status;
	int WordType;
	char *IsEof;

	IsEof = my_fgets(Input, 255, InFile);
	if( IsEof == NULL )
	{
		print_error(_T("Unexpected end of file."));
		return COMP_ERROR;
	}
	else
		if ( Input[0] == '/' )
		{
			Input[4]='\0'; //Ignore the rest of the Line
			if ( strcmp ( "/STX", Input ) != 0 )
			{
				print_error(_T("/STX Expected"));
				return COMP_ERROR;
			}
			else
			{
				return STX; //Next Section
			}
		}
		else
		{
			Status=sscanf(Input,"%s%d%s",Word,&Num,Type );
			if ( Status != 3 )
			{
				print_error(_T("Syntax Error"));
				return COMP_ERROR;
			}
		
			WordType= GetWordType( CString(Type) );
			if (WordType == -1 )
			{
				print_error(_T("Incorrect word type"));
				return COMP_ERROR;
			}

		switch( WordType )
		{
		case V_NOUN:
			Vocabulary.SetNoun( CString(Word), Num );
			break;
	
		case V_VERB:
			Vocabulary.SetVerb( CString(Word), Num );
			break;

		case V_ADJECTIVE:
			Vocabulary.SetAdjective( CString(Word), Num );
			break;

		case V_ADVERB:
			Vocabulary.SetAdverb( CString(Word), Num );
			break;

		case V_PREPOSITION:
			Vocabulary.SetPreposition( CString(Word), Num );
			break;

		case V_PRONOUN:
			Vocabulary.SetPronoun( CString(Word), Num );
			break;

		case V_CONJUGATION:
			Vocabulary.SetConjugation( CString(Word), Num );
			break;
		}


	}
return VOC;
}


int CAceCompiler::GetWordType( CString Word )
{
	Word.MakeUpper();
	if ( Word == "VERB" ) return V_VERB;
	if ( Word == "NOUN" ) return V_NOUN;
	if ( Word == "ADJECTIVE" ) return V_ADJECTIVE;
	if ( Word == "ADVERB" ) return V_ADVERB;
	if ( Word == "PREPOSITION" ) return V_PREPOSITION;
	if ( Word == "PRONOUN" ) return V_PRONOUN;
	if ( Word == "CONJUGATION" ) return V_CONJUGATION;

	return -1;
}

int CAceCompiler::GetSysMsgs( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastMessage = -1; // Cannot be below 60
	int MessageNum=0;
	char temp;
	CString MessageText,TempString;
	bool NewLineRequired = true;


	if (my_fgets(CurrentLine, 1024, InFile)==NULL)
		return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T("Syntax Error / expected "));
			return COMP_ERROR;
		}

		CurrentLine[5]='\0';
		SysMsgs.MaxMessages = MessageNum;
		if ( strncmp ( CurrentLine, "/MTX",4 ) == 0)
		{
			wchar_t temp[255];
			swprintf(temp,_T("%d System Messages processed\n"),MessageNum );
			print_error(temp);
			return MTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &MessageNum ) != 2 )
		{
			print_error(_T("Message Number Expected"));
			return COMP_ERROR;
		}

		/*if (MessageNum < 0 )
		{
			printf("Error System Messages Begin at 60\n");
			return COMP_ERROR;
		}*/

		if (MessageNum <= LastMessage++ )
		{
			print_error(_T("Message Number Out Of Step"));
			return COMP_ERROR;
		}

		if(my_fgets (CurrentLine, 1024, InFile)==NULL)
			return COMP_ERROR;
			
		while ( CurrentLine[0] != '/' )
			{
				/*if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
				*/
				TempString = CurrentLine;
				if ( CurrentLine[0] =='\n' )
				{
					if ( NewLineRequired )
					{
						MessageText = MessageText + _T("\n") ;
						NewLineRequired=false;
					}
				}
				else
				{
					NewLineRequired=true;//reset new line flag
				}

//				if ( TempString.GetAt( TempString.GetLength() ) == '\n' )
//					TempString= TempString.Left( TempString.GetLength()-1);
				if ( MessageText != "" )
					MessageText = MessageText + _T(" ") +TempString;
				else
					MessageText = TempString;
				
				if(my_fgets( CurrentLine, 1024, InFile )==NULL)
					return COMP_ERROR;
			}

			SysMsgs.SetMessage( MessageNum, MessageText );
			MessageText = "";

	}
	return COMP_ERROR;
}


int CAceCompiler::GetStdMsgs( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastMessage = -1; // Cannot be below 0
	int MessageNum=0;
	char temp;
	CString MessageText,TempString;
	bool NewLineRequired;


	if(my_fgets( CurrentLine, 1024, InFile )==NULL)
		return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T(" / expected "));
			return COMP_ERROR;
		}

		StdMsgs.MaxMessages = MessageNum;
		CurrentLine[5]='\0';
		if ( strncmp ( CurrentLine, "/OTX",4 ) == 0)
		{
			wchar_t temp[255];
			swprintf(temp,_T("%d User messages processed\n"),MessageNum );
			print_error( temp );
			return OTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &MessageNum ) != 2 )
		{
			print_error(_T("Message Number Expected"));
			return COMP_ERROR;
		}

		
		if (MessageNum <= LastMessage++ )
		{
			print_error(_T("Message Number Out Of Step"));
			return COMP_ERROR;
		}

		if (my_fgets( CurrentLine, 1024, InFile )==NULL)
			return COMP_ERROR;
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/
				TempString = CurrentLine;
				
				if ( CurrentLine[0] =='\n' )
				{
					if ( NewLineRequired )
					{
						MessageText = MessageText + _T("\n") ;
						NewLineRequired=false;
					}
				}
				else
				{
					NewLineRequired=true;//reset new line flag
				}


//				if ( TempString.GetAt( TempString.GetLength() ) == '\n' )
//					TempString= TempString.Left( TempString.GetLength()-1);
				if ( MessageText != "" )
					MessageText = MessageText + _T(" ") +TempString;
				else
					MessageText = TempString;
				if(my_fgets( CurrentLine, 1024, InFile )==NULL)
					return COMP_ERROR;
			}

			StdMsgs.SetMessage( MessageNum, MessageText );
			MessageText = "";

	}
	return COMP_ERROR;
}

int CAceCompiler::GetObjectText( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastObject = -1; // Cannot be below 0
	int ObjectNum;
	char temp;
	CString ObjectText,TempString;

	if(my_fgets( CurrentLine, 1024, InFile )==NULL)
		return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T(" / expected "));
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';
		if ( strcmp ( CurrentLine, "/LTX" ) == 0)
		{
			wchar_t temp[255];
			swprintf(temp,_T("%d Object Texts Processed\n"),ObjectNum+1 );
			print_error( temp );
			return LTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &ObjectNum ) != 2 )
		{
			print_error(_T("Object Number Expected"));
			return COMP_ERROR;
		}

		
		if (ObjectNum <= LastObject++ )
		{
			print_error(_T("Object Number Out Of Step"));
			return COMP_ERROR;
		}

		if(my_fgets( CurrentLine, 1024, InFile )==NULL)
			return COMP_ERROR;
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/
				TempString = CurrentLine;
				ObjectText = ObjectText + TempString;
				if (my_fgets( CurrentLine, 1024, InFile )==NULL)
					return COMP_ERROR;
			}

			ObjectList.SetObjectDesc( ObjectNum, ObjectText );
			ObjectText = "";

	}
	return COMP_ERROR;
}

int CAceCompiler::GetLocationText( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastLocation = -1; // Cannot be below 1
	int LocationNum=0;
	char temp;
	CString LocationText,TempString;

	if (my_fgets( CurrentLine, 1024, InFile )==NULL) return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T(" / expected "));
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';

		Locations.MaxLocation = LocationNum;

		if ( strcmp ( CurrentLine, "/CON" ) == 0)
		{
			BlanksOK=false;
			wchar_t temp[255];
			swprintf(temp,_T("%d Location Texts Processed\n"),LocationNum+1);
			print_error( temp );
			return CON;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &LocationNum ) != 2 )
		{
			print_error(_T("Location Number Expected"));
			return COMP_ERROR;
		}

		
		if (LocationNum <= LastLocation++ )
		{
			print_error(_T("Location Number Out Of Step"));
			return COMP_ERROR;
		}

		BlanksOK = true;

		if (my_fgets( CurrentLine, 1024, InFile )==NULL) return COMP_ERROR;
			
		while ( CurrentLine[0] != '/' )
			{
				TempString = CurrentLine;
				LocationText = LocationText + TempString;
				if (my_fgets( CurrentLine, 1024, InFile )==NULL) return COMP_ERROR;
			}

			Locations.SetDescription( LocationNum, LocationText );
			LocationText = "";

	}
	return COMP_ERROR;
}

int CAceCompiler::GetConnections( void )
{
	char CurrentLine[255];
	int Finished = 0;
	int LastLocation = -1; // Cannot be below 0
	int LocationNum;
	char temp;
	char Word[10];
	int Verb;
	int LocNum;
	

	if(my_fgets( CurrentLine, 255, InFile )==NULL) return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T("/ expected "));
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';
		if ( strcmp ( CurrentLine, "/OBJ" ) == 0)
		{
			wchar_t temp[255];
			swprintf (temp,_T("%d Connections Processed\n"),LocationNum+1);
			print_error( temp );
			return OBJ;
		}
		if (sscanf( CurrentLine, "%c%d", &temp, &LocationNum ) != 2 )
		{
			print_error(_T("Location Number Expected"));
			return COMP_ERROR;
		}

		
		if (LocationNum <= LastLocation++ )
		{
			print_error(_T("Location Number Out Of Step"));
			return COMP_ERROR;
		}

		if (LocationNum > Locations.MaxLocation )
		{
			print_error(_T("Error location Doesn't Exist"));
			return COMP_ERROR;
		}

		if(my_fgets( CurrentLine, 255, InFile )==NULL) return COMP_ERROR;
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/	
				if (sscanf( CurrentLine,"%s%d",(LPCTSTR)Word,&LocNum ) != 2 )
				{
					print_error(_T("Syntax Error"));
					return COMP_ERROR;
				}
				
				Verb = Vocabulary.GetVerb ( CString(Word) );
				if ( Verb == -1 ) 
				{
					wchar_t temp[255];
					swprintf (temp,_T("Verb - %s Not found"),Word);
					print_error(temp);
					return COMP_ERROR;
				}
				Locations.SetConnection( LocationNum, Verb, LocNum );
				if( my_fgets( CurrentLine, 255, InFile )==NULL) return COMP_ERROR;


			}

	}
	return COMP_ERROR;
}

int CAceCompiler::GetObjectDefs()
{
char CurrentLine[255];
	char temp;
	int Finished = 0;
	int LastObject = -1; 
	int CurrentObject;
	char StartLoc[10];
	int Location;
	char Wearable[10];
	char Container[10];
	int Weight;
	char StringWeight[10];
	char Noun[11];
	char Adjective[11];
	int NounNo, AdjectiveNo;
	CObjectDef *Object;


	if(my_fgets( CurrentLine, 255, InFile )==NULL) return COMP_ERROR;

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(_T(" / expected "));
			return COMP_ERROR;
		}

		if (strncmp( "/PRO", CurrentLine,4 ) == 0)
		{
			wchar_t temp[255];
			swprintf(temp,_T("%d Object Definitions Processed\n"),CurrentObject+1);
			print_error( temp );

			return PRO;
		}

		if (sscanf( CurrentLine, "%c%d%s%s%s%s%s%s",&temp,
												  &CurrentObject,
												  StartLoc,
												  StringWeight,
												  Container,
												  Wearable,
												  Noun,
												  Adjective) != 8 )
		{
			print_error(_T("Not Enough Paramaters"));
			return COMP_ERROR;
		}

		if (StringWeight[0] == '_' ) Weight=0;
		else
			sscanf(StringWeight,"%d",&Weight);

		if (CurrentObject != (LastObject+1) )
		{
			print_error(_T("Object Number Out Of Step"));
			return COMP_ERROR;
		}
		
		NounNo = Vocabulary.GetNoun ( CString(Noun) ); //Validate Noun
				if ( NounNo == -1 ) 
				{
					if ( Noun[0] != '_' ) //NULL WORD
					{
						wchar_t temp[255];
						swprintf(temp,_T("Noun - %s Not found"),Noun);
						print_error(temp);
						return COMP_ERROR;
					}
				}
				
		AdjectiveNo = Vocabulary.GetAdjective( CString(Adjective) ); //Validate Adjective
				if( AdjectiveNo == -1 )
				{
					if (Adjective[0] != '_' )
					{
						wchar_t temp[255];
						swprintf(temp,_T("Adjective - %s Not Found"),Adjective );
						print_error( temp );
						return COMP_ERROR;
					}
				}
				if ((AdjectiveNo!=-1) && ( NounNo == -1 ))
				{
					print_error(_T("You must specify a Noun"));
					return COMP_ERROR;
				}

				if ( (Weight > 63 ) || (Weight < 0) )
				{
					print_error(_T("Weight must me in the range 0 - 63"));
					return COMP_ERROR;
				}

				if ( StartLoc[0]=='C' ) Location = OBJ_CARRIED;
				else if ( StartLoc[0]=='W' ) Location = OBJ_WORN;
				else if ( StartLoc[0]=='_' ) Location = OBJ_NOT_CREATED;
				else if ( sscanf( StartLoc,"%d",&Location ) != 1 )
						{
							print_error(_T("Location Does Not Exist" ));
							return COMP_ERROR;
						}
				Object = new CObjectDef();
				Object -> Adjective = AdjectiveNo;
				Object -> Noun = NounNo;
				Object -> StartLocation = Location;
				Object -> ObjWeight = Weight;
				Object -> Wearable = ( Wearable[0]=='Y' );
				Object -> Container = ( Container[0] == 'Y' );
				ObjectList.SetObject( CurrentObject, Object );

		LastObject++;
		if (my_fgets(CurrentLine, 255, InFile )==NULL) return COMP_ERROR;
	}
	return COMP_ERROR;
}

int CAceCompiler::GetProcessTables()
{
	char CurrentLine[255];
	//char *temp; //remove after debugging!!!
	CProcessTable* p_ProcessTable;
	bool EndOfFile = false , EndOfTable = false;
	char Verb[20], Noun[20], CondAct[20];
	int Param1, Param2;
	CString StrParam1, StrParam2;
	int NounNo, VerbNo;
	int CondActNo;
	int CondActCounter=0;
	int ConditionCounter=0;
	CCondAct *p_CondAct;
	Condition *p_Condition;

	char TempString1[100];
	char TempString2[100];
	char TempString[100];
	int TempInt;

	
	while (!EndOfFile)
	{
		char *temp;
		CondActCounter=0;
		ConditionCounter=0;
		EndOfTable=false;
		Tables[ProcessTableCount]=new CProcessTable;
		p_ProcessTable=Tables[ProcessTableCount];
		if ((temp=my_fgets(CurrentLine, 255, InFile )) == NULL )
		{
			print_error(_T("Unexpected End Of File Reached"));
			return COMP_ERROR;
		}

		while(!EndOfTable)
		{
			Param1=0;
			Param2=0;
			sscanf(CurrentLine,"%s%s%s%s%s",Verb,Noun,CondAct,TempString1, TempString2); /* Read input */

			NounNo = Vocabulary.GetNoun ( CString(Noun) ); //Validate Noun
				if ( NounNo == -1 ) 
				{
					if ( Noun[0] != '_' ) //NULL WORD
					{
						wchar_t temp[255];
						swprintf (temp,_T("Noun - %s Not found"),Noun);
						print_error(temp);
						return COMP_ERROR;
					}
				}

			VerbNo = Vocabulary.GetVerb ( CString(Verb) ); //Validate Verb
				if ( VerbNo == -1 ) 
				{
					if ( Verb[0] != '_' ) //NULL WORD
					{
						wchar_t temp[255];
						swprintf (temp,_T("Verb - %s Not found"),Verb);
						print_error( temp);
						return COMP_ERROR;
					}
				}
				
			CondActNo = GetCondActNum( CondAct );
				if ( CondActNo == -1 )
				{
					print_error(_T("CondAct Not Recognised " ));
					return COMP_ERROR;
				}
				StrParam1=TempString1;
				StrParam2=TempString2;

				switch ( CondActNo )
				{
				case	ADJECT1:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adjective - %s Not found"),StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case	ADVERB:
					Param1 = Vocabulary.GetAdverb( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adverb - %s Not found"),StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case	PREP:
					Param1 = Vocabulary.GetPreposition( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Preposition - %s Not found"),StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case NOUN2:
					Param1 = Vocabulary.GetNoun( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Noun - %s Not found"),StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case ADJECT2:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adjective - %s Not found"),StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				default:
					wchar_t temp[255];
					if (CondactActArray[CondActNo].type1 != NONE ) 
					{
						
						if ( !CheckParam( CondactActArray[CondActNo].type1, StrParam1, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
					
					if (CondactActArray[CondActNo].type2 != NONE ) 
					{
						if ( !CheckParam( CondactActArray[CondActNo].type2, StrParam2, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
				}
					if ( StrParam1 == "HERE" )		Param1 = OBJ_HERE;
					if ( StrParam1 == "CARRIED" )	Param1 = OBJ_CARRIED;
					if ( StrParam1 == "WORN" )		Param1 = OBJ_WORN;
					if ( StrParam2 == "HERE" )		Param2 = OBJ_HERE;
					if ( StrParam2 == "CARRIED" )	Param2 = OBJ_CARRIED;
					if ( StrParam2 == "WORN" )		Param2 = OBJ_WORN;

					if ( Param1 == 0 ) swscanf( StrParam1.GetBuffer(),_T("%d"),&Param1 );
					if ( Param2 == 0 ) swscanf( StrParam2.GetBuffer(),_T("%d"),&Param2 );
				

				p_Condition=new Condition;
				p_Condition->CondAct=CondActCounter;
				p_Condition->Verb=VerbNo;
				p_Condition->Noun=NounNo;
				p_ProcessTable->Conditions.Add(p_Condition);
				p_ProcessTable->ConditionCount++;

				p_CondAct= new CCondAct;
				CondActCounter++;
				p_CondAct->OpCode = CondActNo;
				p_CondAct->Param1 = Param1;
				p_CondAct->Param2 = Param2;
				p_CondAct->First = true;
				p_ProcessTable->Processes.Add(p_CondAct);
				p_ProcessTable->ProcessCount++;
				
				if ((temp=my_fgets(CurrentLine, 255, InFile ))==NULL)
				{
					EndOfFile=true;
					EndOfTable=true;
				}

				if(!EndOfTable)
				{

					while( CurrentLine[0]==' ' || CurrentLine[0]=='\t' )
					{
						sscanf(CurrentLine,"%s%s%s",CondAct,TempString1, TempString2); /* Read input */
					
						CondActNo = GetCondActNum( CondAct );
						if ( CondActNo == -1 )
						{
							print_error(_T("CondAct Not Recognised"));
							return COMP_ERROR;
						}
				Param1=Param2=0;

				StrParam1=TempString1;
				StrParam2=TempString2;
		
				switch ( CondActNo )
				{
				case	ADJECT1:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adjective - %s Not found"),StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case	ADVERB:
					Param1 = Vocabulary.GetAdverb( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adverb - %s Not found"),StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case	PREP:
					Param1 = Vocabulary.GetPreposition( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Preposition - %s Not found"),StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case NOUN2:
					Param1 = Vocabulary.GetNoun( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Noun - %s Not found"),StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case ADJECT2:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						wchar_t temp[255];
						swprintf (temp,_T("Adjective - %s Not found"),StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				default:
					if (CondactActArray[CondActNo].type1 != NONE ) 
					{
						wchar_t output[255];
						if ( !CheckParam( CondactActArray[CondActNo].type1, StrParam1, output ) )
						{
							print_error(output);
							return COMP_ERROR;
						}
					}
					
					if (CondactActArray[CondActNo].type2 != NONE ) 
					{
						wchar_t output[255];

						if ( !CheckParam( CondactActArray[CondActNo].type2, StrParam2, output ) )
						{
							print_error(output);
							return COMP_ERROR;
						}
					}
				}
					if ( StrParam1 == "HERE" )		Param1 = OBJ_HERE;
					if ( StrParam1 == "CARRIED" )	Param1 = OBJ_CARRIED;
					if ( StrParam1 == "WORN" )		Param1 = OBJ_WORN;
					if ( StrParam2 == "HERE" )		Param2 = OBJ_HERE;
					if ( StrParam2 == "CARRIED" )	Param2 = OBJ_CARRIED;
					if ( StrParam2 == "WORN" )		Param2 = OBJ_WORN;

					if ( Param1 == 0 ) swscanf( StrParam1.GetBuffer(),_T("%d"),&Param1 );
					if ( Param2 == 0 ) swscanf( StrParam2.GetBuffer(),_T("%d"),&Param2 );
				

						p_CondAct= new CCondAct;
						CondActCounter++;
						p_CondAct->OpCode = CondActNo;
						p_CondAct->Param1 = Param1;
						p_CondAct->Param2 = Param2;
						p_CondAct->First = false;
						p_ProcessTable->Processes.Add(p_CondAct);
						p_ProcessTable->ProcessCount++;
					
						if (my_fgets(CurrentLine, 255, InFile )==NULL )
						{
							EndOfTable=true;
							EndOfFile=true;
							CurrentLine[0]=(char)255;
							continue; //Ugh Yuk
						}
					}

					sscanf( CurrentLine,"%s%d", TempString, &TempInt );
					if ( strcmp( TempString,"/PRO" ) == 0 )
						{
							EndOfTable = true;
						}
					}
			}

		p_Condition = new Condition;
		p_Condition->Noun = -2; /* Mark the end point - used for searialization */
		p_ProcessTable->Conditions.Add(p_Condition);
	
		ProcessTableCount++;

		if ( (ProcessTableCount != TempInt) && (!EndOfFile) )
		{
			wchar_t temp[255];
			swprintf(temp,_T("Process Table Number %d Expected"),ProcessTableCount );
			print_error( temp );
			return COMP_ERROR;
		}
	
	}
	wchar_t temp2[255];
	swprintf( temp2,_T("%d Process Tables Processed"),ProcessTableCount );
	print_error( temp2 );
	return COMP_END;
}

int CAceCompiler::GetCondActNum( char *Text )
{
	int count;
	for(count=0; count<1000; count++)
	{
		if (strcmp( Text,CondactActArray[count].Name)==0) return count;
		if (CondactActArray[count].Name[0]=='*') return -1;
	}
	return -1; /*should never get here i hope!! 1000 condacts is ambitious but leaves room for
				expansion!!!!!*/



}

char *CAceCompiler::my_fgets( char *string, int count, FILE *stream ) 
{
	char *temp;
	string[0] = '#';

	
	while ( (string[0] == '#') || ((string[0] == '\n') && (!BlanksOK ))  ) //discard blank lines an comments 
	{
		SourceLine++;
		temp = fgets( string, count, stream );

		 if (temp == NULL ) return NULL;
		if (!check_for_lnk(string)) return NULL;
	}

	if ( (temp != NULL) && (!BlanksOK) )
	{
		string[ strlen( string )-1 ] = '\0';
	}
	return temp;
}

bool CAceCompiler::check_for_lnk( char *string )
{
	char temp[50];
	strncpy( temp, string,4 );
	temp[4]='\0';
	if( strcmp( "/LNK", temp ) == 0 )
	{
		sscanf( string,"%s%s",temp,filename );
		print_error(_T("Opening File "),CString(filename) );
		fclose( InFile );
		InFile = fopen( filename,"r");
		string[0]='#';
		SourceLine=0;
		if ( InFile == NULL ) 
		{
			print_error(_T("Error Opening File  "),CString(filename) );
			print_error( _wcserror(errno) );
			return false;
		}
	}
	return true;
}

void CAceCompiler::print_error( wchar_t *error_text, CString Param1)
{
	CString Temp;
	if ( Param1 != "" )
		Temp = CString(error_text) + Param1;
	else
		Temp = error_text;

	char buffer[1024];
	sprintf(buffer,"- %s at line %d. Filename %s",Temp, SourceLine, filename );

	dlg->addText( buffer );
}

bool CAceCompiler::CheckParam( int type, CString Param1, wchar_t *output )
{
	int param1;
	
	swscanf(Param1.GetBuffer(),_T("%d"),&param1);

	switch ( type )
	{
	case FLAG:
		if ((param1 > 999) || ( param1 < 0 ))
		{
			swprintf(output,_T("Flag number out of range ( 0 -> 999 ) "));
			return false;
		}
		break;

	case LOCATION:
		if ( !Locations.validate( param1 ) )
		{
			swprintf(output,_T("Location %d does not exist "),param1 );
			return false;
		}
		break;

	case SYSTEMMESS:
		if ( !SysMsgs.validate( param1 ) )
		{
			swprintf( output,_T("System Message %d not defined "),param1 );
			return false;
		}
		break;

	case USRMESS:
		if ( !StdMsgs.validate( param1 ))
		{
			swprintf( output,_T("User Message %d not defined"),param1 );
			return false;
		}
		break;

	case OBJECT:
		if( !ObjectList.validate( param1 ) )
		{
			swprintf( output, _T("Object %d undefined "),param1 );
			return false;
		}
		break;

	}

	return true; //validated!!!!
}

// Get The PArty Started!!
bool CAceCompiler::Compile(wchar_t * InputFilename, wchar_t * OutputFilename, bool debugVersion, CCompilerDlg * ParentWnd)
{
	int state=CTL;
	int vocab_entries=0;
	SourceLine = 0;
	CFile f;
	char buf[512];
	int Counter;


	dlg = ParentWnd;

	print_error( _T("Opening Inital File - "),CString(InputFilename));

	if ( (InFile = _wfopen (InputFilename,_T("r")))== NULL )
	{
		print_error(_T("Error Opening Input File \n"));
		return false;
	}

	if( !f.Open( (LPCTSTR)OutputFilename, CFile::modeCreate | CFile::modeWrite ) ) 
	{
		print_error(_T("Cannot write to file"));
		return false;
	}

//	strcpy ( filename, argv[1] ); //copy filename;


	CArchive ar( &f, CArchive::store, 512, buf );

	while (state != COMP_END )
	{
		switch( state )

		{
		case CTL:
			state = VOC;
			break;

		case VOC:
			vocab_entries++;
			state = GetVocab();
			break;

		case STX:
			wchar_t temp[255];
			swprintf( temp,_T("%d Vocabulary entries processed\n"),vocab_entries);
			print_error( temp );
			state = GetSysMsgs();
			break;

		case MTX:
			BlanksOK=true;
			state = GetStdMsgs();
			break;

		case OTX:
			BlanksOK=true;
			state = GetObjectText();
			break;

		case LTX:
			BlanksOK=true;
			state = GetLocationText();
			break;

		case CON:
			BlanksOK=false;
			state = GetConnections();
			break;

		case OBJ:
			 state = GetObjectDefs();
			break;

		case PRO:
			//do PRO stuff
			state = GetProcessTables();
			break;

		case COMP_ERROR:
			if (Tables != NULL )
	return false;

		default: //Should never get here!!!!!!
				print_error(_T("Compiler Internal Error"));
				exit(-1);
				break;
		}
	}

	Vocabulary.Serialize( ar );
	SysMsgs.Serialize( ar );
	StdMsgs.Serialize( ar );
	ObjectList.Serialize( ar );
	Locations.Serialize( ar );
	ar<<ProcessTableCount;

	for ( Counter=0; Counter<ProcessTableCount; Counter++ )
	{
		Tables[Counter]->Serialize( ar );
	}


	ar << (int) 1;//REGISTERED FLAG (NOT USED ATM)

	Debug = debugVersion;

	ar << Debug;

	fclose ( InFile );

	ar.Flush();
	ar.Close();

	dlg->addText("\r\nSuccess\r\n**********\r\n");
	return true;
}
