/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// CompilerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Compiler.h"
#include "CompilerDlg.h"
#include "AceCompiler.h"
#include "compilerdlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CCompilerDlg dialog



CCompilerDlg::CCompilerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCompilerDlg::IDD, pParent)
	, inputFilename(_T(""))
	, outputFilename(_T(""))
	, debugEnabled(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCompilerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_INPUT, inputFilename);
	DDX_Text(pDX, IDC_OUTPUT, outputFilename);
	DDX_Check(pDX, IDC_DEBUG, debugEnabled);
	DDX_Control(pDX, IDC_EDITBOX, outputTextBox);
}

BEGIN_MESSAGE_MAP(CCompilerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_INPUTBUTTON, OnBnClickedInputbutton)
	ON_BN_CLICKED(IDC_OUTPUTBUTTON, OnBnClickedOutputbutton)
	ON_EN_CHANGE(IDC_EDITBOX, OnEnChangeEditbox)
END_MESSAGE_MAP()


// CCompilerDlg message handlers

BOOL CCompilerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCompilerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCompilerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCompilerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CCompilerDlg::OnBnClickedButton2()
{
	
}

void CCompilerDlg::OnBnClickedButton1()
{
	
}

void CCompilerDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	//OnOK();

	UpdateData();
	CAceCompiler *cmp = new CAceCompiler();

	CString Text(_T("Starting Compiler\r\n=====================\r\n\r\n"));
	outputTextBox.SetWindowText( Text );
	outputTextBox.UpdateData(false);
	outputTextBox.UpdateWindow();

	bool success = cmp->Compile(inputFilename.GetBuffer(), outputFilename.GetBuffer(), debugEnabled, this );

	delete( cmp );



	

}

void CCompilerDlg::addText(char * text)
{
	CString Text;
	outputTextBox.GetWindowText(Text);
	Text += text;
	Text += "\r\n";
	outputTextBox.SetWindowText( Text );
	outputTextBox.UpdateData(false);
	outputTextBox.UpdateWindow();

	outputTextBox.SetSel(Text.GetLength(),Text.GetLength(),0);
	outputTextBox.SetFocus();


}

void CCompilerDlg::OnBnClickedInputbutton()
{
	UpdateData();

	CFileDialog fileDialog( true, NULL, inputFilename );
	if ( fileDialog.DoModal() == IDOK )
	{
		inputFilename = fileDialog.GetPathName();
		UpdateData( false );
	}

}

void CCompilerDlg::OnBnClickedOutputbutton()
{
	UpdateData();

	CFileDialog fileDialog( true, NULL, outputFilename );
	if ( fileDialog.DoModal() == IDOK )
	{
		outputFilename = fileDialog.GetPathName();
		UpdateData( false );
	}
}

void CCompilerDlg::OnEnChangeEditbox()
{
	
}
