/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// Kernel.h: interface for the CKernel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KERNEL_H__94E5330A_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_KERNEL_H__94E5330A_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Condacts.h"
#include "CCondact.hpp"
#include "ADVMAP.H"
#include "UndoCache.h"
#include "FlagTable.h"
#include "MessageList.h"
#include "Event.h"
#include "ProcessTable.h"
#include "ObjectList.h"
#include "CParser.hpp"
#include "OutputStream.H"


#define PROC_DESC	0
#define PROC_END	1
#define PROC_EXIT	2
#define PROC_COND_EXIT 3
#define PROC_OK		4
#define PROC_START  5
#define PROC_QUIT	6
#define PROC_RESTART 7
#define PROC_NOTDONE 8
#define PROC_LOAD 9
#define PROC_UNDO 10
#define PROC_AGAIN 11
#define PROC_SAVED 12
#define PROC_UNDOCLR 13

#include "ProcessContext.h"

class CKernel : public CObject 
{
public:
	bool Quit;
	int Registered;
	int Process( CCondAct *p_CondAct );
		
	CKernel(CAdvMap *AdvMap,CFlagTable *FlagList, CMessageList *Sys, CMessageList *User, CObjectList *Objs, CParser *parser, CUndoCache *undoCache);
	virtual ~CKernel();
	//int Process1(); //Scan Process Table 1
	//int Process2(); //Scan Process Table 2
	//int Process0(int Verb, int Noun ); //Scan The Response Table
	int DoProcessTbl( int,int,int);//process a table
	void InitProcessTables( CArchive &ar );
	int Doall( int location );

	CObjectList *Objects;
	CFlagTable *Flags;
	CMessageList *SysMsgs, *UserMsgs;
	CAdvMap *Map;
	CParser *Parser;
	CUndoCache *undoCache;
	COutputStream OutStream;

	int PTableCount;
	CArray < CProcessTable *, CProcessTable * > ProcessTables;
	CList < CProcessContext *, CProcessContext *> ProcessStack;

private:
	int currentCondAct;
	int currentTable;
	int MaxProcessTable;
};

#endif // !defined(AFX_KERNEL_H__94E5330A_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
