/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// WinAceDoc.h : interface of the CWinAceDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINACEDOC_H__306AB4FF_F476_4E0E_B5BE_01C878B6A5F0__INCLUDED_)
#define AFX_WINACEDOC_H__306AB4FF_F476_4E0E_B5BE_01C878B6A5F0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CAdvMain;
class CWinAceView;
class CFlagTable;
class CObjectList;

#include "OutputStream.h"


class CWinAceDoc : public CDocument
{
protected: // create from serialization only
	CWinAceDoc();
	DECLARE_DYNCREATE(CWinAceDoc)
	CWinAceView *p_mainView; 
	COutputStream OutputStream;
	CString Filename;

// Attributes
public:


// Operations
public:
	CString getFileName(){return Filename; };
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinAceDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	int getLocationCount();
	CObjectList * getObjects();
	bool isDebugable();
	void restart();
	void NewCommand(CString command);
	void PreInput();
	void LoadGame( CString fileName );
	void SetMainView( CWinAceView *mainView ){p_mainView = mainView; }
    CFlagTable *getFlags();

	virtual ~CWinAceDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWinAceDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	CAdvMain *AceCore;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINACEDOC_H__306AB4FF_F476_4E0E_B5BE_01C878B6A5F0__INCLUDED_)
