#ifndef PC

#ifndef ST

#define ST 1

#endif

#endif



#include "xlang.h"



#include <string.h>

#ifdef ST

#include <osbind.h>

#endif

#ifdef PC

#include <dos.h>

#endif



#define COMMAND 1

#define FNAME 2



#include "xdef.h"

#define MAIN TRUE

#include "xglobals.h"

#include "xfuncs.h"



/* This routine should turn the cursor on */



void crson()

{

#ifdef PC

   union REGS in,out;

   in.h.ah= 0x01;

   in.h.ch= 0x00;

   in.h.cl= 0x0e;

   int86(0x10,&in,&out);

#endif

#ifdef ST

   printf("%c%c", 27, 'e');   /* enable cursor */

#endif

}



/* This routine should turn the cursor off */



void crsoff()

{

#ifdef PC

   union REGS in,out;

   in.h.ah= 0x01;

   in.h.ch= 0x00;

   in.h.cl= 0x00;

   int86(0x10,&in,&out);

#endif

#ifdef ST

   printf("%c%c", 27, 'f');   /* disable cursor */

#endif

}



/* This routine clears the screen and homes the cursor */



void cls()

{

#ifdef PC

   union REGS in,out;

   in.h.ah= 0x06;

   in.h.al= 0;

   in.h.bh= 15;

   in.h.ch= 0;

   in.h.cl= 0;

   in.h.dh= 24;

   in.h.dl= 79;

   int86(0x10,&in,&out);

   in.h.ah= 0x02;

   in.h.bh= 0;

   in.h.dh= 0;

   in.h.dl= 0;

   int86(0x10,&in,&out);

#endif

#ifdef ST

   printf("%c%c", 27, 'E');   /* Clr / home */

#endif

}



/* This routine scrolls lines 2 to 24 of the display, leaving 0/1 intact */



void wrap()

{

#ifdef PC

   union REGS in,out;

   in.h.ah= 0x06;

   in.h.al= 1;

   in.h.bh= 15;

   in.h.ch= 2;

   in.h.cl= 0;

   in.h.dh= 24;

   in.h.dl= 79;

   int86(0x10,&in,&out);

   in.h.ah= 0x02;

   in.h.bh= 0;

   in.h.dh= 24;

   in.h.dl= 1;

   int86(0x10,&in,&out);

#endif

#ifdef ST

   printf("%c%c", 27, 'j');

   printf("%c%c%c%c", 27, 'Y', 32+2, 32+0);

   printf("%c%c", 27, 'M');

   printf("%c%c", 27, 'k');

   printf("%c%c", 27, 'l');

#endif

}



/* This routine prints the room description, score and turns

   on the top line of the screen - in inverse */

   

void phead()

{

#ifdef PC

   union REGS in,out;

   short int row, column;

   in.h.ah= 0x03;

   in.h.bh= 0;

   int86(0x010,&in,&out);

   row= out.h.dh;

   column= out.h.dl;

   in.h.ah= 0x06;

   in.h.al= 0;

   in.h.bh= 7*16;

   in.h.ch= 0;

   in.h.cl= 0;

   in.h.dh= 0;

   in.h.dl= 79;

   int86(0x010,&in,&out);

   in.h.ah= 0x02;

   in.h.bh= 0;

   in.h.dh= 0;

   in.h.dl= 1;

   int86(0x010,&in,&out);



   if ISDARK

      printf("%s", msg[M_DARKNESS]);

   else

      printf("%s", rms[odet[player][2]]);



   in.h.ah= 0x02;

   in.h.bh= 0;

   in.h.dh= 0;

   in.h.dl= 57;

   int86(0x010,&in,&out);



   printf("Score=%04d Turns=%04d", score, turns);



   in.h.ah= 0x02;

   in.h.bh= 0;

   in.h.dh= row;

   in.h.dl= column;

   int86(0x010,&in,&out);

#endif

#ifdef ST

   int xx;

   printf("%c%c", 27, 'j');      /* save cursor */

   printf("%c%c", 27, 'H');      /* home cursor */

   printf("%c%c", 27, 'p');      /* inverse on */

   printf("%c%c", 27, 'l');      /* clear line */

   xx=width();

   if (xx==40)

      printf("%39s", "");

   else

      printf("%79s", "");

   printf("%c%c", 27, 'H');      /* home cursor */

   if ISDARK

      printf(" %s", msg[M_DARKNESS]);

   else

      printf(" %s", rms[odet[player][2]]);

   printf("%c%c%c%c", 27, 'Y', 32, 32+width()-22); /* position */

   printf("Score=%04d Turns=%04d", score, turns);

   printf("%c%c", 27, 'q');      /* inverse off */

   printf("%c%c", 27, 'k');      /* restore cursor posn */

#endif

}



void decrypt(s)

char *s;

{

#ifdef DECRYPT

   char *p;



   static char *code1= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

   static char *code2= "qazwsxedcrfvtgbyhnujmikolpMNBVCXZQWERTYUIOPGHJKLFDSA";



   while (*s)

   {

      p= strchr(code2,*s);

      if (p)

         *s= code1[p-code2];

      s++;

   }

#endif

}



centre(l)

char *l;

{

   int i, w;

   w= width();

   for (i=0; i<((w-strlen(l))/2);i++)

      printf(" ");

   printf("%s", l);

}



main()

{

   FILE *title;

   char l[82];

   int i;

   BOOLEAN more= FALSE, got_cmd, go_on=FALSE, start_again= TRUE, saved= FALSE;



   setbuf(stdout, NULL);

   

   crsoff();

   cls();

   title= fopen("title.txt", "r");

   if (title != NULL)

   {

      while (fgets(l,80,title)!=NULL)

         centre(l);

      fclose(title);

   }

   printf("\n");

   centre("Created with the\n");

   centre("C Adventure Toolkit by Tony Stiles\n");

   printf("\n");

   centre("103a Ludlow Road\n");

   centre("Itchen, Southampton\n");

   centre("Hants, SO2 7ER\n");

   centre("United Kingdom\n");



   i=0;

   while (strlen(vsynt[i]))

   {

      decrypt(vsynt[i]);

      ++i;

   }



   i=0;

   while (strlen(osynt[i]))

   {

      decrypt(osynt[i]);

      ++i;

   }



   i=0;

   while (strlen(osht[i]))

   {

      decrypt(osht[i]);

      ++i;

   } 



   i=0;

   while (strlen(olng[i]))

   {

      decrypt(olng[i]);

      ++i;

   }



   i=0;

   while (strlen(rms[i]))

   {

      decrypt(rms[i]);

      ++i;

   }



   i=0;

   while (strlen(rms[i]))

   {

      decrypt(rml[i]);

      ++i;

   }



   i=0;

   while (strlen(msg[i]))

   {

      decrypt(msg[i]);

      ++i;

   }



   i=0;

   while (strlen(oqual[i]))

   {

      decrypt(oqual[i]);

      ++i;

   }



   i=0;

   while (strlen(oqualo[i]))

   {

      decrypt(oqualo[i]);

      ++i;

   }



   i=0;

   while (strlen(vprep[i]))

   {

      decrypt(vprep[i]);

      ++i;

   }



   for (i=0; i<500; i++)

      cnt[0]=0;

   cnt[496]= -1;



   waitkey();



   while (start_again)

   {

      cls();

      printf("\n\n");

   

      printf(" ");

      init();

      if (!saved)

      {

         save(FALSE);

         saved=TRUE;

      }

      WHOAMI;

      LOOK;



      do

      {

         if ((!go_on) || (!more))

         {

            newline(FALSE);

            newline(FALSE);

            if (turns < 10)

               PMSG(M_WHAT_NOW);

            else

               prt_text(">");

            get_input(COMMAND);

         }

         get_cmd(&more, &got_cmd);

         if (got_cmd)

            go_on= prc_cmd();

         else

         {

            newline(FALSE);

            PMSG(M_NO_COMMAND);

         }

      } while (!dead);

      newline(FALSE);

      UNSCRIPT;

      PMSG(M_PLAY_AGAIN);

      start_again= yesno();

      if (start_again)

      {

         load(FALSE);

         usc=0;

         x=3;

         verbose= FALSE;

         dead= FALSE;

         verbose= FALSE;

         newline(TRUE);

      }

   }

   unlink("START123.SAV");

   crson();

}





