unit Imfedit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ClipBrd, Statbaru,
  PanClock;

type
  TFSedit = class(TForm)
    Memo: TMemo;
    EditMenu: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    FSEpannel: TPanel;
    FseCancel: TBitBtn;
    FSEok: TBitBtn;
    FSEPanelClock: TPanelClock;
    procedure UpdateMenus;
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FSedit: TFSedit;

implementation

{$R *.DFM}

procedure TFSEdit.UpdateMenus;
var
  HasSelection: Boolean;
begin
  Paste1.Enabled := Clipboard.HasFormat(CF_TEXT);
  HasSelection := Memo.SelLength <> 0;
  Cut1.Enabled := HasSelection;
  Copy1.Enabled := HasSelection;
{  Delete1.Enabled := HasSelection;}
end;

procedure TFSedit.Cut1Click(Sender: TObject);
begin
     memo.cutToClipBoard;
end;

procedure TFSedit.Copy1Click(Sender: TObject);
begin
     memo.copyToClipboard;
end;

procedure TFSedit.Paste1Click(Sender: TObject);
begin
     memo.PasteFromClipboard;
end;

end.
