/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
    
#include <signal.h>    
#include <stdlib.h>

#include "screen.h"
#include "win.h"
#include "event.h"
#include "glk.h"

static void (*int_handler)(void);

static int num_tmp_file;
static int max_tmp_file;
static int *tmp_file;  

static void lglk_kill() {
	int at;
	char name[13];
	
	for(at = 0; at < num_tmp_file; at++) {
		sprintf(name, "GLK%d.TMP", tmp_file[at]);
		unlink(name);
	}
	
	lglk_screen_close();

	exit(0);
}

static void lglk_sigint(int sig) {
	if(int_handler != NULL)
		int_handler();

	lglk_kill();
}

void glk_set_interrupt_handler(void (*func)(void)) {
	int_handler = func;
}

int lglk_add_tmp(int num) {
	if(tmp_file == NULL) {
		tmp_file = malloc(sizeof(int) * 16);
		if(tmp_file == NULL)
			return -1;
		max_tmp_file = 16;
	}
	
	if(num_tmp_file >= max_tmp_file) {
		int *new_tmp = realloc(tmp_file, sizeof(int) * max_tmp_file * 2);
		if(new_tmp == NULL)
			return -1;
		tmp_file = new_tmp;
		
		max_tmp_file *= 2;
	}
	
	tmp_file[num_tmp_file++] = num;
	
	return 0;
}

void glk_exit(void) {
	lglk_event_getchar("[ Press any key to exit ]");
	lglk_kill();
}

int main(int narg, char **args) {
	signal(SIGINT, lglk_sigint);

	lglk_screen_clear();

	glk_main();
             
	glk_exit();             
	return 0;
}