! ROOM_Objects.h, where all room definitions are stored.

! By C.E. Forman.
Class AGTRoom
 with
  n_to
  [;
   print "You can't go north from here!^";
   return self;
  ],
  s_to
  [;
   print "You can't go south from here!^";
   return self;
  ],
  e_to
  [;
   print "You can't go east from here!^";
   return self;
  ],
  w_to
  [;
   print "You can't go west from here!^";
   return self;
  ],
  u_to
  [;
   print "You can't go up from here!^";
   return self;
  ],
  d_to
  [;
   print "You can't go down from here!^";
   return self;
  ],
  ne_to
  [;
   print "You can't go northeast from here!^";
   return self;
  ],
  nw_to
  [;
   print "You can't go northwest from here!^";
   return self;
  ],
  se_to
  [;
   print "You can't go southeast from here!^";
   return self;
  ],
  sw_to
  [;
   print "You can't go southwest from here!^";
   return self;
  ],
  in_to
  [;
   print "You can't go in from here!^";
   return self;
  ],
  out_to
  [;
   print "You can't go out from here!^";
   return self;
  ],
  short_name
  [;
   print "<< ";
   print (object)self;
   print " >>";
   rtrue;
  ]
 has
;

! Limbo - a special room.
AGTRoom ROOM_Limbo "Limbo"
 with
  description "Limbo is a special room, not intended to be visited.",
  name "limbo"
 has
  enterable
  light
;

! Chief's office.
AGTRoom ROOM_Chief "Chief's office"
 with
  description "You are standing in the Chief's office. He is telling you ~The Mayor was murdered yeaterday night at 12:03 am. I want you to solve it before we get any bad publicity or the FBI has to come in. ~Yessir!~ You reply. He hands you a sheet of paper. Once you have read it, go north or west.",
  n_to ROOM_Outside1,	! Outside 1
  w_to ROOM_Closet1	! Closet 1
 has
  enterable
  light
  scored
;

! Closet 1.
AGTRoom ROOM_Closet1 "Closet"
 with
  description "You are in a closet. There is a gun on the floor. Better get it. To exit, go east.",
  e_to ROOM_Chief	! The Chief's office (yes, a TWO-WAY door).
 has
  enterable
  light
;

! Outside 1.
AGTRoom ROOM_Outside1 "Outside"
 with
  description "You are outside in the cold. To the east is a dead end. To the west is the rest of the street. Papers are blowing around. It's amazingly cold for this time of year.",
  w_to ROOM_Outside2	! Outside 2
 has
  enterable
  light
;

! Outside 2.
AGTRoom ROOM_Outside2 "Outside"
 with
  description "You are still on the streets. To the north is a restraunt where the mayor ate often. To the east is the Mayor's home.",
  e_to ROOM_MayorsHouse,	! Mayor's house.
  n_to ROOM_Restaurant,		! Restraunt (sic).
 has
  enterable
  light
  scored
;

! The restraunt (sic).
AGTRoom ROOM_Restaurant "Restraunt"
 with
  description
  [;
   ! High-class thugs do you in.
   deadflag=self.number;
   "You are about to enter the restraunt when two guys jump you. They take your wallet and beat you a bit. Then you flash your badge and that riles them. Your body was discovered in a river 10 miles away.";
  ],
  number 1
 has
  enterable
  light
;

! The Mayor's house.
AGTRoom ROOM_MayorsHouse "Mayor's house"
 with
  description "You are in the house, at the scene of the crime. You enter and flash your badge before a cop. He admits you. To the north is the upstairs. To the east is the living room and to the west is the dining room.",
  e_to ROOM_Living,	! Living room.
  n_to ROOM_Upstairs,	! Upstairs hallway.
  w_to ROOM_Dining	! Dining room.
 has
  enterable
  light
  scored
;

! The dining room.
AGTRoom ROOM_Dining "Dining room"
 with
  description "You are in the dining room. You look around and see a note on the table. You can go back east.",
  e_to ROOM_MayorsHouse,	! The Mayor's house proper.
 has
  enterable
  light
;

! The living room.
AGTRoom ROOM_Living "Living room"
 with
  description "You are standing in the living room. You see a battered piece of wood. You wonder ~Should I pick this thing up?~. Well, whether you do or don't the only way out of the room is back west.",
  w_to ROOM_MayorsHouse		! Mayor's house.
 has
  enterable
  light
;

! The upstairs hallway.
AGTRoom ROOM_Upstairs "Upstairs hallway"
 with
  description "You are in the hallway of the large house of the mayor. It is an amazingly large house. You can go north, south, east or west.",
  e_to ROOM_Bath,		! Bathroom.
  n_to ROOM_Hallway1,		! Hallway 1.
  s_to ROOM_MayorsHouse,	! Mayors' house.
  w_to ROOM_Closet2		! Closet 2.
 has
  enterable
  light
  scored
;

! Closet 2.
AGTRoom ROOM_Closet2 "Closet"
 with
  description "You are in a closet. The closet is of the walk in variety, with about thirty pairs of tennis shoes, ten pairs of heels and about ninety coats and shirts. You start to get claustrophobia. Better get out.",
  e_to ROOM_Upstairs,	! Upstairs hallway.
 has
  enterable
  light
;

! The bathroom.
AGTRoom ROOM_Bath "Bathroom"
 with
  description "You are in the first bathroom, out of the 5 there is. You notice that it is almost as big as your apartment. You see a knife on the floor here.",
  w_to ROOM_Upstairs	! Upstairs hallway.
 has
  enterable
  light
;

! Hallway 1.
AGTRoom ROOM_Hallway1 "Hallway"
 with
  description "You are at the end of the hallway. To the north is a room, while to the west is the rest of the hallway.",
  n_to ROOM_Closet3,	! Closet 3
  w_to ROOM_Hallway2	! Hallway 2
 has
  enterable
  light
;

! Closet 3.
AGTRoom ROOM_Closet3 "Closet"
 with
  description "You are in a closet. There is no reason to be in here. Go south.",
  s_to ROOM_Hallway1,	! Hallway 1
 has
  enterable
  light
;

! Hallway 2.
AGTRoom ROOM_Hallway2 "Hallway"
 with
  description "You are in the hallway. To the north is more hallway, and to the east is a door marked ~Guests~.",
  e_to ROOM_Guest1,	! Guest room 1.
  n_to ROOM_Hallway3,	! Hallway 3.
 has
  enterable
  light
;

! Guest room 1.
AGTRoom ROOM_Guest1 "Guest Room"
 with
  description "You are in one of the many guest rooms. It is a nice room, big screen TV in one corner, 2 king size beds in the back of the room, strategically placed so that you can see the TV while comfortably propped up in bed. You see nothing of intrest, you should go west.",
  w_to ROOM_Hallway2	! Hallway 2
 has
  enterable
  light
;

! Hallway 3
AGTRoom ROOM_Hallway3 "Hallway"
 with
  description "You are STILL in the hallway. There is EVEN MORE hallway to the north, and a room to the west and a room to the east of you.",
  e_to ROOM_Closet5,	! Closet 5
  n_to ROOM_Hallway4,	! Hallway 4
  w_to ROOM_Closet4	! Closet 4
 has
  enterable
  light
;

! Closet 4
AGTRoom ROOM_Closet4 "Closet"
 with
  description "You are in a closet. There is no reason to be in here. Go west.",
  w_to ROOM_Hallway3	! Hallway 3
 has
  enterable
  light
;

! Closet 5
AGTRoom ROOM_Closet5 "Closet"
 with
  description "You are in a small closet. The room is bare. Why not go east and get back to the situation at hand?",
  e_to ROOM_Hallway3,	! Hallway 3
 has
  enterable
  light
;

! Hallway 4
AGTRoom ROOM_Hallway4 "Hallway"
 with
  description "You are still in the hallway. You can go north to where there is a police officer who will let you outside, or you can go east or west.",
  e_to ROOM_Guest2,	! Guest room 2
  n_to ROOM_Outside3,	! Outside 3
  w_to ROOM_Bed		! Bedroom.
 has
  enterable
  light
;

! Guest room 2
AGTRoom ROOM_Guest2 "Guest Room"
 with
  description "You are in a guest room. You see that there isn't much here, the murderers ransacked the room. You can go west.",
  w_to ROOM_Hallway4	! Hallway 4
 has
  enterable
  light
;

! The bedroom.
AGTRoom ROOM_Bed "Bedroom"
 with
  description "You are in the bedroom. You noticed that there was a guard guarding the stairs to the 3rd story, because there is remodelling going on there. You see nothing of importance. Go east.",
  e_to ROOM_Hallway4
 has
  enterable
  light
  scored
;

! Outside 3
AGTRoom ROOM_Outside3 "Outside"
 with
  description "You pass the guard. He nods at you. You are now outside standing on the street. You can go north and east, your choice. To the north is more of the street, and to the east is a video store.",
  e_to ROOM_Video1,	! Video store 1
  n_to ROOM_DeadEnd1,	! Dead end 1
 has
  enterable
  light
  scored
;

! 'Dead end'.
AGTRoom ROOM_DeadEnd1 "Dead End"
 with
  description "You are at a dead end. You can go south or west. Which way?",
  s_to ROOM_Outside3,
  w_to ROOM_Lounge	! Murderer's Lounge.
 has
  enterable
  light
;

! The Murderer's lounge.
AGTRoom ROOM_Lounge "Murderer's Lounge"
 with
  description
  [;
   deadflag=self.number;	! Someone call the funeral home...
   "You are in the so called ~Murderers Lounge~. Unfortunately, there ARE murderers here, and when you check around, they get angry. But, that's life. Ya lose!";
  ],
  number 1
 has
  enterable
  light
;

! Video store 1
AGTRoom ROOM_Video1 "Video Store"
 with
  description "You are in a video store called Brickbuster Video. There are about 3,000 videos here. You can go north, or east.",
  e_to ROOM_Video2,	! Video store 2
  n_to ROOM_Backroom,	! Backroom
 has
  enterable
  light
;

! The backroom
AGTRoom ROOM_Backroom "Backroom"
 with
  description "You are in the backroom of Brickbuster Video. You see a small video on the floor, but you dismiss it as having no potential value to the crime. You can go south.",
  s_to ROOM_Video1,	! Video store 1
 has
  enterable
  light
;

! Video store 2
AGTRoom ROOM_Video2 "Video Store"
 with
  description "You are still in the video store. You can go north, or east.",
  e_to ROOM_Outside4,	! Outside 4
  n_to ROOM_Closet6,	! Closet 6
 has
  enterable
  light
  scored
;

! Closet 6
AGTRoom ROOM_Closet6 "Closet"
 with
  description "You are in a closet. There is no use for being here. Gotta go south.",
  s_to ROOM_Video2
 has
  enterable
  light
;

! Outside 4
AGTRoom ROOM_Outside4 "Outside"
 with
  description "You are outside. You can go north, south, east or west.",
  e_to ROOM_House,	! House
  n_to ROOM_Outside5,	! Outside 5
  s_to ROOM_McDonalds,	! McDonalds
  w_to ROOM_Video2	! Video store 2
 has
  enterable
  light
;

! McDonalds.
AGTRoom ROOM_McDonalds "McDonalds"
 with
  description "You are in a McDonalds. You pay the guy behind the counter. Now there is a hamburger there. When you have picked it up, go north.",
  n_to ROOM_Outside4
 has
  enterable
  light
;

! House
AGTRoom ROOM_House "House"
 with
  description
  [;
   deadflag=self.number;
   "You enter the house. A man charges down the stairs. Before you even have time to say anything, he shoots you. You lose!";
  ],
  number 1
 has
  enterable
  light
;

! Outside 5
AGTRoom ROOM_Outside5 "Outside"
 with
  description "You are still outside. You hit a dead end, then notice that you can go east only.",
  e_to ROOM_Music1,	! Music store 1
 has
  enterable
  light
  scored
;

! Music store 1
AGTRoom ROOM_Music1 "Music Store"
 with
  description "You are in a music store. You ask the man behind the counter if he knew any information. ~Uhh... nope! But the guy back there might be able ta help.~ You politly thank him and head to the back. You can only go north.",
  n_to ROOM_BackMusic,	! Back of music store
 has
  enterable
  light
  scored
;

! Back of music store.
AGTRoom ROOM_BackMusic "Back of Music Store"
 with
  description "You are in the back of the music store. You ask the guy who's looking at the cool tapes. He looks up at you. ~Duh.. no... don't t'ink so... lemme see...~ You decide that he's no help. To the west there is a dazed looking man and to the north there is an exit.",
  n_to ROOM_Alley,	! Alley
  w_to ROOM_Music2	! Music store 2
 has
  enterable
  light
  scored
;

! Music store 2
AGTRoom ROOM_Music2 "Music Store"
 with
  before
  [;
   Go:
    if (NPC_Dazed in location)	! Not with the man here!
    {
     "The dazed man blocks your way!";
    }
  ],
  ! The next bit is so moronic that it's just catatonic.
  description "You walk over to the guy. He jumps up with a wild look, and says ~Freeze!~. You stop. He motions you to the exit. But you know he'll probably just kill you. You NEED to get the weapon from him or kill him. Best chance: use your gun.",
  e_to ROOM_BackMusic,	! Back of music store
 has
  enterable
  light
;

! Alley
AGTRoom ROOM_Alley "Alley"
 with
  description "You are in an alley. A drunken man stagers up to you and says ~Boycott FDR! <HICKUP>.~. You just walk away. You can go north, east or west. Your call.",
  e_to ROOM_Drug,	! Drug house
  n_to ROOM_Police,	! Police station
  w_to ROOM_Mob		! Mob house
 has
  enterable
  light
  scored
;

! Drug house
AGTRoom ROOM_Drug "Drug House"
 with
  description
  [;
   deadflag=self.number;	! Death by dying.
   "You are in a druggies house.^Guys look over at you. ~Hey! It's a cop! Get 'im!~ One yells.^They all grab their guns and aim' em at you. When the police find you 2 days later, you are scattered across the room - literally.";
  ],
  number 1	! Death.
 has
  enterable
  light
;

! Mob house
AGTRoom ROOM_Mob "Mob House"
 with
  description
  [;
   deadflag=self.number;	! Death by dying.
   "You enter the infamous ~Mob House~.^When you enter a hush quiets the room as guys in ugly pin striped suits look over at you. Fearing for your life, you turn to run away. But before you can do that, a big thug comes by with a .44 and shoots you in the head. A grisly death, for sure.";
  ],
  number 1	! Death.
 has
  enterable
  light
;

! Police station
AGTRoom ROOM_Police "Police Station"
 with
  description "You are in the 3rd precinct police station. This isn't your station. You get admitance from the guy at the desk and go to the holding cells. You ask each offender if they know anything. You promise a lighter sentence for the ones who help. But one guy really sets you straight. ~I got caught wit' t'ree ounces o' crack. I'm supposed to get 20 years but I'll be out in 2. You can't make me talk cuz it don't matter to me. If I squeal, da guys who did it are gonna come lookin' for me. I know but I ain't gonna tell ya. Now git outta my face.~. You are surprised but used to it. You can go north to the outside, south to go back to the alley and west or east to talk to more guys.",
  e_to ROOM_Holding2,	! Holding cells 2
  n_to ROOM_Outside6,	! Outside 6
  s_to ROOM_Alley,	! Alley
  w_to ROOM_Holding1	! Holding cells 1
 has
  enterable
  light
  scored
;

! Holding cells 1
AGTRoom ROOM_Holding1 "Holding Cells"
 with
  description "You are talking to more guys. But none of them tell you what you want. You can only go east.",
  e_to ROOM_Police,	! Police station
 has
  enterable
  light
;

! Holding cells 2
AGTRoom ROOM_Holding2 "Holding Cells"
 with
  description "You are talking to more guys. But none tell you what you need to know. You can only go west.",
  w_to ROOM_Police	! Police station
 has
  enterable
  light
;

! Outside 6
AGTRoom ROOM_Outside6 "Outside"
 with
  description "You are outside. it's bitter cold and you pull your jacket around yourself. To the north is a nice, warm Holiday Inn hotel, where the killer is rumoured to be staying. Or you could go to his favourite hang out, the Wall, to the west, or to the east is the place where he is supposed to be working, the Doughnut King.",
  e_to ROOM_Doughnut,	! Doughnut King
  n_to ROOM_Holiday,	! Holiday Inn
  w_to ROOM_Wall	! The Wall
 has
  enterable
  light
  scored
;

! The Wall
AGTRoom ROOM_Wall "The Wall"
 with
  description "You don't see him here. You ought to go east.",
  e_to ROOM_Outside6	! Outside 6
 has
  enterable
  light
  scored
;

! Doughnut King
AGTRoom ROOM_Doughnut "Doughnut King"
 with
  description "You are in the Doughnut King, where the greasiest doughnuts on earth reside. He isn't here, no one seems to be for that matter, so you should go west.",
  w_to ROOM_Outside6	! Outside 6
 has
  enterable
  light
  scored
;

! Holiday Inn
AGTRoom ROOM_Holiday "Holiday Inn"
 with
  description "You are in the Holiday Inn registration room. You talk to some suspicious guys, but they don't talk until you hold your gun to their side. ~Alright! Alright! I'll talk! He's on the 15th floor! That's all I can tell ya!~ You shove them away. You walk up to the registration desk and show the woman there your badge. She gives you the master ring. You now have access to all of the facilitys on the 15th floor. But the problem is that the 15th floor is the suite level, and there are 30 suites, and 5 pools, 2 saunas and 5 game rooms. Big problem! Well, you have all night. You get a picture of all on the 15th floor, the people up there have to show their drivers license to be admitted, and the license is secretly xeroxed. You look at them all. Well, better get started. You see one person who stands out. You get his room number from the lady. Room 30. Now you have to find it. To get started, go north.",
  n_to ROOM_Holiday15th,	! Holiday Inn 15th floor
 has
  enterable
  light
  scored
;

! Holiday Inn 15th Floor
AGTRoom ROOM_Holiday15th "Holiday Inn 15th Floor"
 with
  description "You go up the elevator. When you step out, you see the wallpaper is pink, with little flowers on it. You can go east or west.",
  e_to ROOM_Dead2,	! Dead end 2
  w_to ROOM_Hallway5	! Hallway 5
 has
  enterable
  light
  scored
;

! Dead end 2
AGTRoom ROOM_Dead2 "Dead End"
 with
  description "You hit a dead end. There is a fire extinguisher here, but it is of no importance to you. You can only go west.",
  w_to ROOM_Holiday15th	! Holiday Inn 15th floor
 has
  enterable
  light
;

! Hallway 5
AGTRoom ROOM_Hallway5 "Hallway"
 with
  description
  [ Count;
   print "You are in the hallway. You see many doors... ";
   for (Count=1: Count<8: Count++)
   {
    print Count, "... ";
   }
   "boy, you have a long way to go. You can only go north.";
  ],
  n_to ROOM_Hallway6,	! Hallway 6
 has
  enterable
  light
  scored
;

! Hallway 6
AGTRoom ROOM_Hallway6 "Hallway"
 with
  description
  [;
   "You are still in the hallways. You can go west or east.";
  ],
  e_to ROOM_Dead3,	! Dead end 3
  w_to ROOM_Hallway7	! Hallway 7
 has
  enterable
  light
  scored
;

! Dead end 3
AGTRoom ROOM_Dead3 "Dead End"
 with
  description
  [;
   deadflag=self.number;	! Die here.
   "You are at a dead end. There is nothing to do but go west.";
  ],
  number 1			! Literally.
 has
  enterable
  light
;

! Hallway 7
AGTRoom ROOM_Hallway7 "Hallway"
 with
  description
  [ Count;
   print "You are in the hallway. You see numbers flash by as you run through the halls. ";
   for (Count=19: Count<23: Count++)
   {
    print Count, "... ";
   }
   "you are getting close! You can only go north.";
  ],
  n_to ROOM_Hallway8,	! Hallway 8
 has
  enterable
  light
  scored
;

! Hallway 8
AGTRoom ROOM_Hallway8 "Hallway"
 with
  description "You are in the hallway. You feel the heat from the sauna to the west, and to the east is a door marked ~Pool A~. To the north is more hall.",
  e_to ROOM_Pool,	! Pool
  n_to ROOM_30,		! Room #30
  w_to ROOM_Sauna	! Sauna
 has
  enterable
  light
  scored
;

! Sauna
AGTRoom ROOM_Sauna "Sauna"
 with
  description
  [;
   deadflag=self.number;	! Die.
   "You are in the sauna when from the steam steps the killer.^~So ya thought ya could get me eh?~ He flashes a gun. Well, let's not get into details.^You lose.";
  ],
  number 1			! Dead.
 has
  enterable
  light
;

! Pool
AGTRoom ROOM_Pool "Pool"
 with
  description
  [;
   deadflag=self.number;	! Geez!
   "You are in the pool when the killer shoots you from behind. You lose!";
  ],
  number 1			! Death.
 has
  enterable
  light
;

! Room #30
AGTRoom ROOM_30 "Room # 30"
 with
  description "You enter room 30... after a harrowing gun battle you conk him on the head and take him in. You get promoted and suddenly, with the ~Jurrasic Park~ theme song playing in your head, you feel proud to be an American. For special info about Exile Games, and to leave this darned game, go up.",
  each_turn
  [;
   if (self hasnt general)	! If you haven't already been awarded it, give the player...
   {
    score=score+100;		! ...100 points!
    give self general;		! And note that this has now been done.
   }
  ],
  u_to ROOM_Info		! Info
 has
  enterable
  light
;

! Info
AGTRoom ROOM_Info "Info"
 with
  description
  [;
   deadflag=self.number;	! You win.
   "Exile Games is a group of people who like text games.^We plan to get into graphic games sometime in 1995.^We don't ask for money, we just want to know if you like it or not.^Our support BBS is (510) 208-5657, the Ghostbuster Central BBS.^We have accounts on Compuserve and Prodigy. Exile Games is curently made up of:^^Matt Barringer, president and head programmer^Nathaniel Smith, advisor^Kurt Somogue, assistent programmer^And all the users of the Ghostbuster Central BBS, who give me ideas!";
  ],
  number 2			! Winning is done here.
 has
  enterable
  light
;