!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                  Part 5 - Elemental Rooms (Continued)
!**
!***************************************************************************

!***************************************************************************
!**
!**  "Metal" Area
!**
!***************************************************************************

Object rock "solid rock"
   with name "walls" "walls" "floor" "ceiling" "room" "chamber" "solid" 
             "rock" "granite",
        description
           "The chamber has been carved out of solid granite.",
        found_in Room4 Room4N Room4S Room4E Room4W,
   has  scenery;

Object Room4 "Rocky Chamber"
   with description [;
           print "This chamber has been carved out of solid rock. There are 
                  steps leading up, ";

           if (brass_ball hasnt general)
              "and exits to the north, south and east. A large steel plate  
              blocks the exit to the west.";
           else
              "and exits to the north, south, east, and west.";
        ],
        u_to [; virtual_loc = 56; PlayerTo(Maze); return 1; ],
        n_to Room4N,
        s_to Room4S,
        e_to Room4E,
        w_to [; 
           if (brass_ball hasnt general)
              "The way is blocked by a large steel plate.";
           else
              return Room4W;
        ],
   has  light;

Object -> steel_door "steel door"
   with name "large" "solid" "featureless" "plate" "steel",
        description
           "A solid, featureless plate of steel that blocks passage to the 
            west.",
        before [;
           Push, Pull, Open, Close:
              "You can't budge it.";
        ],
   has  scenery;

Object Room4N "Cube Room"
   with description
          "This chamber has been carved out of solid rock. A block of marble 
           occupies the center of the room. There is an exit to the south.",
        s_to Room4,
   has  light;

pedestal -> pedestal_4n "block of marble";

cube -> -> white_cube "white cube"
   with name "bright" "white" "cube",
        number 4;

Object Room4S "Work Room"
   with description
          "This chamber has been carved out of solid rock. A workbench runs 
           the length of one wall. The only exit lies to the north.",
        n_to Room4,
   has  light;

Object -> floor_hole "hole in the floor"
   with name "small" "hole" "in" "floor",
        description
           "A small hole is in the floor. ",
        before [;
           Take: LostMind(); rtrue;

           Search:
              if (child(self) == fuse)
                 "You can see a small electrical fuse at the bottom of the 
                  hole.";

           GetWith:
              if (second == steel_rod)
                 "Try putting ", (the) steel_rod, " in the hole.";

           Receive:
              if (noun == fuse)
                 "You don't want to do that.";
                 
              if (noun == steel_rod) {
                 if (gooey_gum in steel_rod && fuse in self) {
                    Achieved(3);
                    move fuse to player;
                    move steel_rod to player;
                    "You put the rod into the hole (gum-end in first) and 
                     retrieve the fuse. "; }
                 else rfalse; }

              else
                 "That doesn't fit.";
        ],
   has  scenery container ~openable open;

Object -> workbench "workbench"
   with name "workbench" "bench",
        description
           "A workbench, covered with various screws and washers, runs the 
            length of one wall. ",
   has  scenery supporter;

Object -> -> bench_junk "various screws and washers"
   with name "various" "screw" "screws" "washer" "washers",
        before [;
           Take: "You have no use for those things.";
           Search: "You find nothing useful.";
        ],
   has  scenery pluralname;

Object -> -> steel_rod "steel rod"
   with name "short" "end" "of" "piece" "steel" "metal" "rod",
        description [;
           print "A short piece of steel rod. ";
           
           if (gooey_gum in self)
              "A gooey piece of chewed gum is on one end of the rod.";
           else
              new_line; rtrue;
        ],
        before [;
           Take:
              if (self hasnt general) {
                 give self general;
                 move fuse to floor_hole;
                 give floor_hole ~scenery static;
                 move self to player;
                 "As you grab the rod, it sweeps across the table, knocking
                  various screws and washers off of the table, and along with 
                  them, what looks to be a small electrical fuse. It hits the 
                  ground and you are powerless but to watch it as it rolls 
                  in ever widening circles, finally sliding neatly into
                  a small hole in the floor near the wall."; }

           Receive:
              if (noun ~= gooey_gum)
                 "That doesn't work.";

           LetGo:
              if (gooey_gum in self)
                 "You can't - the gum has affixed itself to the rod.";

        ],
   has  supporter;

Object fuse "electrical fuse"
   with name "two" "contacts" "small" "electrical" "fuse" "plug",
        description [;
           if (self in socket)
              "A small electrical fuse, which is currently plugged into a
               socket.";
           else
              "A small electrical fuse, with two contacts on one end.";
        ],
        before [;
           Take:
              if (self in floor_hole)
                 "You can't reach it.";
        ];

Object Room4E "Brass Room"
   with description
          "This chamber has been carved out of solid rock. In the center of 
           the chamber is a wrought iron stand, which holds a brass sphere. 
           The only exit is to the west.",
        w_to Room4,
   has  light;

Object -> iron_stand "wrought iron stand"
   with name "ornately" "crafted" "wrought" "iron" "stand",
        description
           "The ornately crafted wrought iron stand, which rises to 
            approximately chest height, holds a brass sphere.",
   has  scenery;

! The brass_ball has general when the west door is open

Object -> brass_ball "brass sphere"
   with name "perfectly" "formed" "brass" "sphere" "surface",
        description
           "The perfectly formed brass sphere, which is approximately the 
            size of a basketball, gleams dully in the light. A small circular 
            glass plate is mounted on its surface. ",
        before [;
           Search: <<Search glass_plate>>;

           Take, Push, Pull, Turn:
              "It's firmly attached to the iron stand.";
        ],
   has  scenery;

! The clear plate has general when the thumbprint is visible.

Object -> glass_plate "glass plate"
   with name "small" "circular" "clear" "glass" "plate",
        number 0,
        description [;
           print "The clear glass plate has a ";

           if (self has general)
              print "black fingerprint";
           else
              print "faint smudge";

           " on it.";
        ],
        before [;
           Search:
              print "You can't see anything inside the brass sphere. However, 
                     a ";

              if (self has general)
                 print "black fingerprint";
              else
                 print "faint smudge";

              " is plainly visible on the glass plate.";

           Receive:
              if (noun == qty_of_soot && self hasnt general) {
                 give self general;
                 remove smudge;
                 remove qty_of_soot;
                 move fingerprint to location;
                 "As you sprinkle the soot on ", (the) self,
                 " a fingerprint becomes visible."; }

              if (noun == qty_of_soot && self has general)
                 "You've put enough soot on there already.";

              if (noun ~= qty_of_soot)
                 "That won't do any good.";

           Push, PushWith, Rub, Touch:
              print "As you touch the glass plate, a green glow, visible 
                     through the glass plate, emanates from within the brass 
                     sphere. ";

              if (self.number == 0) {
                 self.number++;
                 print "In fact, it appears as if the glass is being 
                        scanned. "; }

              if (self has general)
                 print "A black fingerprint ";
              else
                 print "A faint smudge ";
                 
              print "is visible on the plate. After a moment the glow 
                     fades.";

              if (self has general && brass_ball hasnt general) {
                 give brass_ball general;
                 remove steel_door;
                 Achieved(7);
                 "^^You hear a deep rumbling noise from somewhere nearby."; }

              if (self has general && brass_ball has general) {
                 give brass_ball ~general;
                 move steel_door to Room4;
                 "^^You hear a deep rumbling noise from somewhere nearby."; }

              new_line; rtrue;
        ],
   has  scenery;

Object -> smudge "smudge"
   with name "smudge",
        description
           "It's hard to tell exactly what the smudge is.",
        before [;
           Receive: <<PutOn noun glass_plate>>;
        ],
   has  scenery;

Object fingerprint "fingerprint"
   with name "smudge" "fingerprint" "thumbprint",
        description
           "It looks like someone's thumbprint.",
   has  scenery;

Object Room4W "Material Storage Room"
   with description
          "The walls and floor of this chamber have been carved out of solid 
           rock. Many storage bins line the walls, each designed to hold a 
           different type of raw material. An exit leads east.",
        e_to Room4,
   has  light;

Object -> bins "bins"
   with name "storage" "bins",
        description
           "Each storage bin is labeled with the name of the 
            material it holds. Alphabetically, they are adamantine, 
            copper, gold, platinum, silver, stainless steel, and titanium.",
   has  scenery pluralname;

StorageBin -> ad_bin "adamantine bin"
   with name "adamantine" "bin";

StorageBin -> copper_bin "copper bin"
   with name "copper" "bin";

Ingot -> -> copper_bar "copper ingot"
   with name "rectangular" "ingot" "pure" "copper",
        description
           "A rectangular ingot of pure copper.";

StorageBin -> gold_bin "gold bin"
   with name "gold" "bin";

Ingot -> -> gold_bar "gold ingot"
   with name "rectangular" "ingot" "pure" "gold",
        description
           "A rectangular ingot of pure gold.";

StorageBin -> plat_bin "platinum bin"
   with name "platinum" "bin";

Ingot -> -> plat_bar "platinum ingot"
   with name "rectangular" "ingot" "pure" "platinum",
        description
           "A rectangular ingot of pure platinum.";

StorageBin -> silver_bin "silver bin"
   with name "silver" "bin";

Ingot -> -> silver_bar "silver ingot"
   with name "rectangular" "ingot" "silver",
        description
           "A rectangular ingot of pure silver.";

StorageBin -> steel_bin "stainless steel bin"
   with name "stainless" "steel" "bin";

Ingot -> -> steel_bar "stainless steel ingot"
   with name "rectangular" "ingot" "stainless" "steel",
        description
           "A rectangular ingot of stainless steel.";

StorageBin -> tit_bin "titanium bin"
   with name "titanium" "bin";

Ingot -> -> tit_bar "titanium ingot"
   with name "rectangular" "ingot" "pure" "titanium",
        description
           "A rectangular ingot of pure titanium.";

Object molten_silver "quantity of molten silver"
   with name "molten" "silver",
        description
           "A quantity of molten silver.",
        before [;
           Take, Remove:
              "Does the word 'molten' mean anything to you?";

           Empty: <<Empty asbestos_cup>>;

           EmptyT: <<EmptyT asbestos_cup second>>;
        ];

Object cooling_silver "quantity of rapidly cooling silver"
   with name "quantity" "rapidly" "cooling" "silver",
        description
           "The rapidly cooling silver is inside the mold.",
        before [;
           Take, Remove:
              "You can't - it's inside the mold.";

           Empty, EmptyT: <<Empty rect_mold>>;
        ];

HotIngot hot_copper_bar "hot copper ingot"
   with name "hot" "rectangular" "ingot" "pure" "copper",
        description
           "A rectangular ingot of pure copper. It is very hot.";

HotIngot hot_gold_bar "hot gold ingot"
   with name "hot" "rectangular" "ingot" "pure" "gold",
        description
           "A rectangular ingot of pure gold. It is very hot.";

HotIngot hot_plat_bar "hot platinum ingot"
   with name "rectangular" "ingot" "pure" "platinum",
        description
           "A rectangular ingot of pure platinum. It is very hot.";

HotIngot hot_steel_bar "hot stainless steel ingot"
   with name "hot" "rectangular" "ingot" "stainless" "steel",
        description
           "A rectangular ingot of stainless steel. It is very hot.";

HotIngot hot_tit_bar "hot titanium ingot"
   with name "hot" "rectangular" "ingot" "pure" "titanium",
        description
           "A rectangular ingot of pure titanium. It is very hot.";

silver_stone stone5 "silver Go stone"
   with number 6;

silver_stone stone6 "silver Go stone"
   with number 7;

silver_stone stone7 "silver Go stone"
   with number 8;

silver_stone stone8 "silver Go stone"
   with number 9;


!***************************************************************************
!**
!**  "Fire" Area
!**
!***************************************************************************

Object clay "clay walls"
   with name "walls" "walls" "floor" "ceiling" "room" "chamber" "clay",
        description
           "The walls, floor and ceiling of this room are made of clay.",
        found_in Room5 Room5N Room5S Room5E Room5W,
   has  scenery;

Object Room5 "Hot Zone"
   with description
          "This room is warm, but not uncomfortably so. A sign is posted on 
           one wall. There are steps leading up, and exits to the north, 
           south, east and west.",
        each_turn [ i j;
           j = 0;
           objectloop (i in player && i ofclass HotIngot) j++;
           if ((asbestos_cup in player && asbestos_cup has general) ||
               (match has light && match in player ||
               j > 0)) {
              deadflag = 1;
              "^The temperature in this room plummets. Rapidly. So rapidly 
               that before you can blink, you find that you've been turned 
               into a human popsicle. Didn't you read the sign?"; }
        ],
        u_to [; virtual_loc = 60; PlayerTo(Maze); return 1; ],
        n_to Room5N,
        s_to Room5S,
        e_to Room5E,
        w_to Room5W,
   has  light;

Object -> wall_sign "sign"
   with name "yellow" "background" "letters" "warning" "sign",
        description [;
           print "The sign is printed in large black letters on a yellow background. 
           It reads: ^^^";

           print "             WARNING^^";
           print "Absolutely no open flames or other^";
           print "heat sources allowed in this area!^";
        ],
   has  scenery;

Object Room5N "Cube Room"
   with description
           "This room is warm, but not uncomfortably so. A block of marble 
           occupies the center of this room, whose only exit is to the south.",
        s_to Room5,
   has  light;

pedestal -> pedestal_5n "block of marble";

cube red_cube "red cube" pedestal_5n
   with name "deep" "red" "cube",
        number 5;

Object Room5S "Oven Room"
   with description
           "A wave of heat hits you as you enter this room, which looks to be 
            a small operation for smelting and pouring metals. Hooks and 
            shelves line the walls, presumably for tools, but the room has 
            been stripped almost bare. All that is left is a large steel 
            table, and a medium sized oven, well worn from use. The only 
            exit lies to the north.",
        before [;
           Listen:
              if (gas_switch has general)
                 "The furnace pings softly as it cools.";
        ],
        n_to Room5,
   has  light;

Object -> hooks "hooks"
   with name "hook" "hooks",
   has  scenery pluralname;

Object -> shelf "shelves"
   with name "shelf" "shelves",
   has  scenery pluralname;

Object -> steel_table "steel table"
   with name "steel" "table",
        description
           "The steel table is approximately four feet long by three 
           feet wide by three feet tall.",
   has  scenery supporter;

Object -> oven "oven"
   with name "medium" "sized" "cylindrical" "cylinder" "squat" "oven",
        description [;
           print "The oven is a squat cylinder, approximately three feet tall 
                  and two feet in diameter. It consists of two parts. The 
                  lower part is the furnace, which provides heat. The upper 
                  part is the crucible, where the material to be melted is 
                  placed. ";

           if (self hasnt general) {
              give self general;
              "^^And here you thought your teacher didn't like to bake..."; }
           else
              new_line; rtrue;
        ],
        before [;
           Burn:
              "You'll have to be a bit more specific.";
        ],
   has  scenery;

! Furnace has general when it is generating heat

Object -> squat_furnace "squat furnace"
   with name "furnace" "electrical" "cable",
        description
           "The furnace is located in the bottom half of the oven. Natural
           gas and electrical lines enter the rear of the furnace. There 
           is a socket on the side of the furnace. On the front is a sign, a
           light, a green button and a red button.",
        before [;
           Burn:
              "You'll have to be a bit more specific.";
        ],
   has  scenery;

Object -> sign "sign"
   with name "sign",
        description [;
           print "~Acme Gas Furnace Company^";
           print " Model 1273A^";
           print " Maximum Temperature: 1800 F~^";
        ],
   has  scenery nobehind;

Object -> furnace_power_light "available power light"
   with name "dull" "orange" "available" "power" "light",
        description [;
           print "The light shows if electrical power is available
           to ", (the) squat_furnace, ". It is currently ";
     
           if (water_valve has open)
              "glowing a dull orange.";
           else
              "off.";
        ],
   has  scenery;

! The small hole has general when the pilot light is lit.

Object -> socket "socket"
   with name "small" "socket",
        description [;
           print "The small socket is located on the side of the furnace. 
                  A label above the socket reads, ~Fuse.~ Currently, ";

           if (fuse notin self)
              "there's nothing in the socket.";
           else
              "a small electrical fuse is plugged into the socket.";
        ],
        before [;
           Receive:
              if (noun ~= fuse)
                 "That doesn't fit.";
              else rfalse;

           Search:
              if (fuse in self)
                 "A small electrical fuse is plugged in to the socket.";
              else
                 "There's nothing in the socket.";
        ],
   has  scenery container open ~openable;

Object -> blower_switch "green button"
   with name "green" "button",
        description
           "A green button is located on the front of the furnace. There is a 
           word printed on it, but time seems to have worn off some of the 
           letters. All that's visible now is ~  ower.~",
        before [;
           Push:
              if (water_valve hasnt open)
                 "The button depresses with a loud 'click' but nothing 
                  happens. I think it needs electricity to work.";
     
              print "The button depresses with a loud 'click.' In the 
                     distance hear an electric motor ";

              if (self hasnt on) {
                 give self on;
                 "start."; }

              if (self has on) {
                 give self ~on;
                 "wind down to a stop."; }
        ],
   has  scenery ~on;

Object -> gas_switch "red button"
   with name "red" "button",
        description
           "A red button is located on the front of the furnace. There is a 
           word printed on it, but time seems to have worn off some of the 
           letters. All that's visible now is ~  nit on.~",
        before [;
           Push:
              if (water_valve hasnt open   ||
                  fuse notin socket        ||
                  blower_switch hasnt on   ||
                  crucible has open)
                 "The button depresses with a loud 'click' but nothing 
                  happens.";

     
              if (fuse in socket && blower_switch has on && crucible hasnt open) {
                  give self general;
                  print "The button depresses with a loud 'click'. The furnace 
                         heats up to its maximum temperature - you can feel the
                         heat leaking through the furnace wall. After a short
                         time you hear another 'click'. The furnace shuts off
                         and begins to cool.";
     
                  if (asbestos_cup notin crucible) {
                      new_line;
                      rtrue; }
     
                  if (asbestos_cup in crucible) {
                     give asbestos_cup general;
                     switch(child(asbestos_cup)) {
     
                        silver_bar: remove silver_bar;
                                    move molten_silver to asbestos_cup;

                        copper_bar: remove copper_bar;
                                    move hot_copper_bar to asbestos_cup;

                        gold_bar:   remove gold_bar;
                                    move hot_gold_bar to asbestos_cup;

                        plat_bar:   remove plat_bar;
                                    move hot_plat_bar to asbestos_cup;

                        steel_bar:  remove steel_bar;
                                    move hot_steel_bar to asbestos_cup;

                        tit_bar:    remove tit_bar;
                                    move hot_tit_bar to asbestos_cup;
                     }
                  new_line; rtrue; }}
        ],
   has  scenery;

Object -> pipe_line "natural gas pipe"
   with name "natural" "gas" "pipe" "line" "lines",
        description
           "A natural gas pipe, which supplies gas to the furnace, enters 
            through the rear of the unit.",
   has  scenery;

Object -> elect_line "electrical line"
   with name "electrical" "line" "lines" "cable",
        description
           "A thick electrical cable, which supplies electricity to the 
            furnace, enters through the rear of the unit.",
   has  scenery;

Object -> crucible "crucible"
   with name "crucible" "lid",
        description [;
           print "The crucible consists of a circular chamber that 
           sits on top of the furnace. It is currently ";
           
           if (self has open)
              print "open and";
           else
              print "closed.";

           if (self has open) {
              if (children(self) == 0)
                 " empty.";
              else
                 " an asbestos cup rests inside."; }
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              if (noun ~= asbestos_cup)
                 "That doesn't go in there.";

           LetGo:
              if (asbestos_cup has general && gloves hasnt worn)
                 "It's too hot to pick up with your bare hands.";
        ],
   has  scenery container openable ~open;

Object asbestos_cup "asbestos cup" crucible
   with name "hot" "circular" "asbestos" "cup",
        capacity 1,
        short_name [;
           if (self has general)
              print "hot asbestos cup";
           else
              print "asbestos cup";
           rtrue;
        ],
        description [;
           print "The circular cup";

           if (self has general)
              print ", which is very hot,";
           
           print " is made of asbestos and is designed to hold material being 
                  melted in the crucible. ";

           if (children(self) ~= 0)
              <<Search self>>;
           else
              new_line; rtrue;
        ],
        before [;
           LookUnder:
              if (self notin player)
                 "You'll have to pick it up first.";
              else
                 "~Acme Asbestos Cup Company, Inc.~";

           Receive:
              if (noun ofclass Ingot or HotIngot)
                 rfalse;
              else
                 "That doesn't go in there.";
     
           Take:
              if (self has general && gloves hasnt worn)
                 "It's too hot to pick up with your bare hands.";
     
           Empty:
              if (child(self) == molten_silver)
                 "You need to specify a container to pour ", (the) self, 
                  " into.";

           EmptyT:
              if (self notin player)
                 "It would help if you were actually holding ", (the) self, ".";

              if (children(self) == 0)
                 "There's nothing in ", (the) self, ".";

              if (child(self) ~= molten_silver)
                 print_ret (The) child(self), " won't pour since it's still a 
                           solid.";

              if (second ~= rect_mold)
                 "I wouldn't advise that.";

              if (rect_mold notin steel_table)
                 print_ret (The) rect_mold, " should be on a solid work 
                    surface before you do that.";

              if (rect_mold in steel_table) {
                 remove molten_silver;
                 move cooling_silver to rect_mold;
                 print_ret "You carefully pour ", (the) molten_silver, 
                           " into ", (the) rect_mold, ". The silver, though 
                            still hot, quickly solidifies."; }
        ],
   has  container open;

Object Room5E "Kiln Room"
   with description
          "This room is warm, but not uncomfortably so. A pottery kiln
          is pushed up against one wall. There is an exit to the west.",
        w_to Room5,
   has  light;

Object -> kiln "pottery kiln"
   with name "old" "pottery" "kiln" "door" "rusted" "hinges",
        description
           "This old pottery kiln, its door hanging open on rusted hinges,
            has obviously seen better days.",
        before [;
           Enter: LostMind(); rtrue;

           Search:
              "The kiln is filled with pottery shards.";

           Close:
              "The hinges are so rusty the door won't move.";

           Open:
              "It's already open - and it looks like it's going to stay 
               that way.";
        ],
   has  container open ~openable scenery;

Object -> shards "pottery shards"
   with name "clay" "shard" "pottery" "shards" "molds" "items",
        description
           "The shards are from various broken clay molds and other pottery 
            items.",
        before [;
           Take:
              "The shards are broken and of no use to you.";

           Count:
              "There are 2,371 broken pieces of pottery.";

           Search, Push, Pull:
              if (self hasnt general) {
                 give self general;
                 move rect_mold to location;
                 "As you sift through the shards you find an unbroken mold."; }
              else
                 "You find nothing of interest.";
        ],
   has  pluralname scenery;

! The mold has general when it is filled with molten silver

Object rect_mold "rectangular clay mold"
   with name "rectangular" "one-piece" "one" "piece" "holes" "clay" "mold"
              "several" "small" "hairline" "fractures" "mould",
        description [;
           print "This rectangular mold is approximately 8~ long by 2~ wide 
           by 1~ thick. It has four holes for pouring liquid into it. Each
           hole is approximately 1~ in diameter. ";
     
           if (cooling_silver in self)
              "The mold is full of rapidly cooling silver. It appears that the
               heat has made the mold brittle - it has developed several 
               small hairline fractures.";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              if (noun ~= molten_silver)
                 "That doesn't fit in there.";
     
           Take:
              if (cooling_silver in self && gloves hasnt worn)
                 "That's too hot to pick up with your bare hands.";

           Empty, EmptyT:
              if (cooling_silver in self)
                 "You can't - the silver has solidified.";

           Attack: 
              "You'll have to tell me what you want to hit ", (the) self, 
              " with.";

           AttackWith:
              if (cooling_silver in self && second == baseball_bat) {
                 remove self;
                 Achieved(8);
                 move stone5 to location;
                 move stone6 to location;
                 move stone7 to location;
                 move stone8 to location;
                 #ifdef INCLUDE_HINTS;
                    move earth_menu to hint_menu;
                 #endif;
                 "Hitting the hot, brittle mold cracks it open, revealing 
                 four silver Go stones."; }
               else
                 rfalse;
        ],
   has  container open;

Object Room5W "Duct Room"
   with description
          "This room is a maze of pipes and ducts, all of various sizes. The
           only exit is to the east. ",
        e_to Room5,
   has  light;

Object -> pipes "pipes"
   with name "pipes",
        description
           "The pipes are all of various sizes. You get a headache as you 
           try to trace their convoluted paths through the room.",
   has  scenery pluralname;

Object -> ducts "ducts"
   with name "ducts",
        description
           "The ducts are all of various sizes. You get a headache as you 
           try to trace their convoluted paths through the room. One of 
           the ducts is labeled 'Furnace Exhaust ->' - the arrow shows which
           way air flows through the duct.",
   has  scenery pluralname;

Object -> furnace_duct "exhaust duct"
   with name "furnace" "exhaust" "duct",
        description [;
           print (The) self;

           if (blower_switch has on)
              print " (which has air moving through it)";

           " must have a leak, because one section is covered with black soot.";
        ],
   has  scenery;

Object -> black_soot "black soot"
   with name "dry" "powdery" "black" "soot",
        description
           "Dry, powdery, black soot.",
        before [;
           Take:
              if (qty_of_soot notin player) {
                 move qty_of_soot to player;
                 SetPronoun('it', qty_of_soot);
                 "You scrape a small quantity of soot from the duct."; }
              else
                 "You already have some ", self, ".";
        ],
   has  scenery;

Object qty_of_soot "small quantity of soot"
   with name "small" "quantity" "of" "black" "soot",
        description
           "A small quantity of black soot.",
        before [;
           Drop:
              if (location ofclass House)
                 "You'd only get the carpet dirty.";
              else {
                 remove self;
                 SetPronoun('it', black_soot);
                 "You toss the soot, which scatters and is lost."; }
        ];
