/*
	HDWINEXT.H

	contains extra definitions and data types
	for the Win32 Debugger

	Copyright (c) 1999-2006 by Kent Tessman
*/


int WhichWindow(int n);
int WhichHWND(HWND hwnd);
void ForceRedraw(HWND hwnd);
void RedrawDebuggerChild(int windex);
void SetWindowTitle(int windex);

/* From hewin.c, for window centering: */
void CenterWindow(HWND, HWND);
UINT APIENTRY CenterHookProc(HWND hwndDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);


#define DEBUG_CHILD_WINDOWS 7

#define CHILD_TEXT_WIDTH 125
#define CHILD_TEXT_HEIGHT 50

#define MAX_HELP_TEXT (CHILD_TEXT_WIDTH*CHILD_TEXT_HEIGHT)

typedef struct
{
	HWND hwnd;
	char *name;
	int xpos, ypos, width, height;
	int xoffset;	/* for Win32's visible window scrolling */
	char visible;
	int menuitem;	/* on HDWIN_MENUBAR */
	int view;	/* i.e. VIEW_... from hdinter.h */

	/* For storing the text/color grid */
	struct textgrid
	{
		char chr;	/* ASCII */
		int fcolor;
		int bgcolor;
	} textgrid[CHILD_TEXT_WIDTH][CHILD_TEXT_HEIGHT];
} debug_childwindow_struct;
