
! for WithOneHand() function
Global withonehandflag = false;

Object sc_2
  class Scene,
  with
	number 2,
	init_scene [;
		SetQuestion(q2_1);
	],
	begin_scene [ rock;
		switch (rock) {
			1: ! first time in
				GiveInitialTools();
				move activeplayer to WhiteJunction;
				give WhiteJunction ~general;
				withonehandflag = false;
				SaveToolPositions();
			2, -1, -2: ! all subsequent times (including boom/splat)
				move activeplayer to WhiteJunction;
				give WhiteJunction ~general; ! seen it once
				withonehandflag = false;
				give cornerdoor ~open;
				move boltwrench to largecrate;
				RestoreToolPositions();
				give panelhole ~general;	! not bloodied
				remove blood;				! ditto
				! yeah, RestoreToolPositions should get this, but anyway
				move package to panelcache;	
		}
	],
	end_scene [ rock subrock   var;
		switch (rock) {
			-1:
				SetAcidQuestions(subrock);
			-2:
				SetBlastQuestions(subrock);
			-3: ! security door open
				switch (subrock) {
					1:
						SetQuestion(q2_o1);
					2:
						SetQuestion(q2_o2);
					default:
						print "The door opens, only it's ajar. Ha! Ha! [BUG]^";
				}
			1: ! wrench set off metal-scan
				if (q2_d1 hasnt general) {
					give q2_d1 general;
					SetQuestion(q2_d1, subrock);
				}
				else if (q2_d1r hasnt general) {
					give q2_d1r general;
					SetQuestion(q2_d1r, subrock);
				}
				else {
					SetQuestion(q2_d1rr, subrock);
				}
			2: ! no scan problems, but walked into guards
				SetQuestion(q2_d2);
			3: ! with wrench and scrambler
				if (q2_d3 hasnt general) {
					give q2_d3 general;
					SetQuestion(q2_d3, subrock);
				}
				else {
					SetQuestion(q2_d3r, subrock);
				}
			4: ! moved wrench
				SetQuestion(q2_d4);
			5: ! left tools behind
				SetQuestion(q2_d5, subrock);
			6: ! no blood
				if (q2_d6 hasnt general) {
					give q2_d6 general;
					SetQuestion(q2_d6);
				}
				else {
					var = (package has moved);
					SetQuestion(q2_d6r, var);
				}
			7: ! blood, but player/man never saw package
				if (q2_d7 hasnt general) {
					give q2_d7 general;
					SetQuestion(q2_d7);
				}
				else {
					SetQuestion(q2_d7r);
				}
			8: ! blood, but player left package behind (in ceiling)
				SetQuestion(q2_d8);
			9: ! blood, but player left package behind (elsewhere)
				SetQuestion(q2_d9);
			10: ! left anything in panelcache
				if (q2_d10 hasnt general) {
					give q2_d10 general;
					SetQuestion(q2_d10, subrock);
				}
				else {
					SetQuestion(q2_d5, subrock);
				}
			20: ! success
				SetScene(sc_3);
		}
	];

Object q2_1
  class Question,
  with
	query "^The man turns the lockpick again in his fingers. ~This is nice,
		this truly is. We have nothing like it.~ A thoughtful blink.
		~...And this was the only piece of equipment you carried?~",
	time_limit 3,
	answer_yes [; 
		print "The man winces. ~I truly can't believe that. If you had
			one such clever trick, you had others.";
		SetQuestion(q2_2);
	],
	answer_no [;
		print "~Naturally not. I look forward to examining the others.";
		SetQuestion(q2_2);
	],
	answer_wait [;
		if (num_no_answers + num_yes_answers == 0) {
			print "The man drops his eyes for a moment, then meets yours again...
				perhaps with a hint of a smile. ~And you remain stubborn. It
				matters little.";
		}
		else if (num_wait_answers <= 1) {
			print "The man shakes his head. ~Suddenly silent... I had thought
				we were doing well. But";
		}
		else {
			print "~All right then. But";
		}
		print " I truly won't believe that you brought no other clever tricks.";
		SetQuestion(q2_2);
	];

Object q2_2
  class Question,
  with
	query " Not,~ he adds, ~that they did you good in the end.~",
	time_limit 2,
	answer_yes [;
		print "~They did? Little enough, as you're the one in the chair.~
			He shakes his head dismissively. ~Let's continue. You entered
			the complex...~^";
		BeginScene(1);
	],
	answer_no [;
		print "~No.~ He shrugs sympathetically. ~Let's continue. You entered
			the complex...~^";
		BeginScene(1);
	],
	answer_wait [;
		print "He raises an eyebrow. ~Embarrassed? Clever tricks or no, it was
			still one of you and all of us, and we're not ", (emphstring) "that",
			" weak. Are we.~ A sharp look from those eyes.
			~Let's continue. You entered the complex...~^";
		BeginScene(1);
	];

Object q2_d1
  class Question,
  with
	query "^~And then all the guards came thundering down on you? Captured before
		you'd done anything at all?~",
	time_limit 4,
	answer_yes [;
		num_blatant_lies++;
		print "~You certainly were not. There was no alarm and we both know it. 
			Now let's have it again.~^";
		BeginScene(2);
	],
	answer_no [;
		print "~Of course not. So don't pretend you set off any alarms.
			Now let's have it again.~^";
		BeginScene(2);
	],
	answer_wait [;
		num_blatant_lies++;
		print "Now the man does look impatient. ~There was no alarm -- not then,
			and not later -- and we both know it. Now let's
			have it again.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q2_d1r
  class Question,
  with
	query "^~We've been over this. We track all metal within the critical zones.
		I know you're good; you surely noticed the ceiling web.~",
	time_limit 3,
	answer_yes [;
		num_got_angry++;
		num_helpfuls++;
		print "~And you didn't";
		if (self.variant == 0)
			print " carry";
		else
			print " throw";
		print " metal past it. Stop wasting my time.~ He
			punches a control, harder than necessary.^";
		BeginScene(2);
	],
	answer_no [;
		num_got_angry++;
		num_stupids++;
		print "~As you like. But you didn't";
		if (self.variant == 0)
			print " carry";
		else
			print " throw";
		print " metal past it. 
			Stop wasting my time.~ He
			punches a control, harder than necessary.^";
		BeginScene(2);
	],
	answer_wait [;
		num_got_angry++;
		num_stubborns++;
		print "~As you like. But it's there, and you didn't";
		if (self.variant == 0)
			print " carry";
		else
			print " throw";
		print " metal past it. 
			Stop wasting my time.~ He
			punches a control, harder than necessary.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked
	
Object q2_d1rr
  class Question,
  with
	query [;
		print "^~This is tiring. I've been in this base all day and I heard no
			alarm.~ The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q2_d2
  class Question,
  with
	query "^The man raises an eyebrow. ~None of those guards saw you until 
		much later. Shall we try it again?~",
	time_limit 1,
	answer_yes [;
		print "The man touches a control.^";
		BeginScene(2);
	],
	answer_no [;
		num_stubborns++;
		print "~That was a rhetorical question.~ The man touches a control.^";
		BeginScene(2);
	],
	answer_wait [;
		print "The man touches a control.^";
		BeginScene(2);
	];

Object q2_d3
  class Question,
  with
	query [;
		print "^~...with the metal of the wrench
			hidden from our ever-watchful scan web. A wonderful artifact, your
			little orange pyramid.~ The man spreads his hands in assumed awe,
			then shakes his head. ~I don't think your techniques are quite that
			good. You could muffle the metal signature, I would say, but not
			perfectly. It would leave eddies. Small ones -- within the error
			tolerances of our scan, enough to hide the wrench for a few minutes
			-- but after that? A dozen acceptable errors within ten minutes
			is... not acceptable at all.^^~And we picked up no such suspicious
			sequence; and therefore, you did not";
		if (self.variant == 0)
			print " carry";
		else
			print " throw";
		print " the wrench across that line. Did you.~^";
		rtrue;
	],
	time_limit 5,
	daemon [;
		if (self.number == 2) {
			print "^~...Did you?~^";
		}
	],
	answer_yes [;
		num_stupids++;
		num_sneaky_lies++;
		print "He stares at you for a moment. ~Even if you claim your scrambler
			works perfectly,~ he continues, ~...we found
			the wrench sitting on the crate in the closet.~ He smiles briefly.^";
		BeginScene(2);
	],
	answer_no [;
		num_helpfuls++;
		print "He reaches for his controls. ~And besides,~ he adds, ~we found
			the wrench sitting on the crate.~ He smiles briefly.^";
		BeginScene(2);
	],
	answer_wait [;
		print "He reaches for his controls. ~And besides,~ he adds, ~we found
			the wrench sitting on the crate.~ He smiles briefly.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q2_d3r
  class Question,
  with
	query [;
		print "^~We've been over this. You could only have prevented us from
			detecting the wrench for a few minutes -- and we ", (emphstring) "know",
			" where you left it, anyway.~ 
			The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q2_d4
  class Question,
  with
	query [;
		print "^~Now, I know this is a small point; but you actually left
			that bolt wrench on the";
		if (boltwrench in smallcrate)
			print " larger";
		print " crate. That's where we found it. I have to get these minor matters
			clear, you understand, or the important ones will never be
			straightened out.~^";
		BeginScene(2);
	];

Object q2_d5
  class Question,
  with
	query [;
		print "^~Now, I know you're not that careless.";
		if (self.variant == 1)
			print " We didn't find anything";
		else
			print " We didn't find ", (the) self.variant, " or anything else";
		print " left behind";
		print ". It's a small matter but I can't let it slip.~^";
		BeginScene(2);
	];

Object q2_d6
  class Question,
  with
	query "^~I believe you're forgetting something.~ The man gazes at you
		levelly. ~Our forensics people went over the area very thoroughly
		after we captured you. And we found evidence that you'd been up in
		that open ceiling panel in the northwest corner. Did you think you
		could hide that from us?~",
	time_limit 6,
	daemon [;
		if (self.number == 4) {
			print "^The man leans back, watching you.^";
		}
	],
	answer_yes [;
		num_stubborns++;
		print "~You did? You can cover up memories, perhaps...~ Unexpectedly,
			he smiles. ~But 'Blood speaks
			loud where words fade away.' Eh? Now, this time, the truth.~^";
		BeginScene(2);
	],
	answer_no [;
		num_helpfuls++;
		print "~Not, certainly, if you're going to go bleeding all over the
			place. Now show me.~^";
		BeginScene(2);
	],
	answer_wait [;
		num_stubborns++;
		print "He shakes his head. ~You can't.
			You can cover up memories, perhaps...~ Unexpectedly,
			he smiles. ~But 'Blood speaks
			loud where words fade away.' Eh? Now, this time, the truth.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q2_d6r
  class Question,
  with
	query [;
		print "^~You're forgetting the blood traces again. Don't pretend you
			didn't jump up";
		if (self.variant == 0)
			print " to that missing panel. Now, what did you do there?";
		else
			print " for that package.";
		print "~ The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q2_d7
  class Question,
  with
	query "^He looks almost amused. ~Yes, yes. You swung from a ceiling panel,
		you bled a drop of blood, we found a drop of blood, everything is made
		clear as sunlight.~",
	time_limit 2,
	answer_yes [;
		num_got_angry = num_got_angry + 2;
		num_stubborns++;
		num_sneaky_lies++;
		print "~Yes, ", (emphstring) "no,", "~ the man breathes, and now he
			doesn't look amused at all. ~You were, what, just bored? Taking
			a bit of exercise? You were up there for a ", (emphstring) "reason,",
			" don't tell me you weren't. There isn't anything in that space
			now; we checked four times. So you jumped up there to take something
			away. I want to know ", (emphstring) "what.", "~ His finger stabs
			down.^";
		BeginScene(2);
	],
	answer_no [;
		num_got_angry = num_got_angry + 2;
		num_stubborns++;
		print "~It's ", (emphstring) "not?", " I'm astonished,~ the man breathes,
			and now he
			doesn't look amused at all. ~You weren't just taking
			a bit of exercise?~ He exhales. 
			~There isn't anything in that space
			now; we checked four times. So you jumped up there to take something
			away. I want to know ", (emphstring) "what.", "~ His finger stabs
			down.^";
		BeginScene(2);
	],
	answer_wait [;
		num_got_angry = num_got_angry + 2;
		num_stubborns = num_stubborns + 2;
		print "~", (emphstring) "Don't", " give me that look,~ the man breathes,
			and now he
			doesn't look amused at all. ~You were, what, just bored? Taking
			a bit of exercise? You were up there for a ", (emphstring) "reason,",
			" don't tell me you weren't. There isn't anything in that space
			now; we checked four times. So you jumped up there to take something
			away. I want to know ", (emphstring) "what.", "~ His finger stabs
			down.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q2_d7r
  class Question,
  with
	query [;
		print "^~You're dodging the question,~ the man says, more calmly now.
			~The ceiling panel.~ He touches a control.^";
		BeginScene(2);
	];

Object q2_d8
  class Question,
  with
	query [;
		print "^~Yes, yes, but we ", (emphstring) "did", " search the space
			above the missing panel.... four times.
			Whatever your mysterious package is, you didn't leave it up there.~
			He touches a control.^";
		BeginScene(2);
	];

Object q2_d9
  class Question,
  with
	query [;
		print "^~Yes, yes, but we've been going back over your trail. 
			Whatever your mysterious package is, you didn't leave it behind.~
			He touches a control.^";
		BeginScene(2);
	];

Object q2_d10
  class Question,
  with
	query [;
		print "^~After all that, the bloodstains, you think we didn't search
			the space over the ceiling gap?";
		if (q2_d7 hasnt general)
			print " Four times, in fact.";
		else
			print " Four times, as I believe I mentioned.";
		if (self.variant == 1)
			print " We didn't find anything";
		else
			print " We didn't find ", (the) self.variant, " or anything else";
		print ".~ He reaches for his controls before you can speak.^";
		BeginScene(2);
	]
  has ~general; ! general means it's been asked

Object q2_o1
  class Question,
  with
	query [;
		print "^~Of course, by now -- that is, by then -- there was once again
			an observer covering the alley door. Your original diversion was
			clever but brief. So you certainly didn't re-open the door, much less
			leave and then re-enter.~
			He touches a control.^";
		BeginScene(2);
	];

Object q2_o2
  class Question,
  with
	query [;
		print "^~That would be the logistics office. Five agents working at the
			time, very diligent men and women. None of whom recall their door
			popping open on them.~ He shakes his head. ~Your electronic key
			is a lovely toy, but you don't have to play with it for my sake.~
			He touches a control.^";
		BeginScene(2);
	];


! ------------- The gun-hiding scene

Object WhiteJunction "White Junction"
  with
	description [;
		if (self hasnt general) {
			give self general;
			print "You stand lightly";
		}
		else {
			print "You are";
		}
		print " in a bare tiled corridor, white tiles and cold white walls.
			The ceiling is acoustical panelling divided by";
		if (powercut == 0)
			print " illuminated";
		else
			print " barely-illuminated";
		" strips of plastic. The hall
			runs north and east, with a branch curving away to the southeast.";
	],
	se_to [;
		print "You return up the hallway as it curves around to the south.^";
		return InsideEntrance;
	],
	e_to SouthBoundary,
	n_to CeilingHole,
  has ~general;		! general means you've looked once.

Object InsideEntrance "Corridor By Entrance"
  with
	description [;
		print "The white corridor begins here, and curves away north.";
		if (escaping == 0)
			print " No one is about; the";
		else
			print " The";
		print " metal face of the entrance door stands closed to the west.^";
		rtrue;
	],
	w_to outerdoorin,
	out_to outerdoorin,
	n_to WhiteJunction,
	nw_to WhiteJunction;

! Matched with outerdoor in t-1.
Object -> outerdoorin "steel door"
  with
	name 'plain' 'steel' 'metal' 'entrance' 'door',
	description "It's a naked sheet of metal, a foot taller than you, as wide
		as your outstretched arms. Beside it is a black plate which is 
		twin to the one outside.",
	door_dir w_to,
	door_to InsideEntrance,
	door_try [;
		PronounNotice(self);
		"The door is very definitely closed.";
	],
	before [;
		Open: 
			"It doesn't open by itself.";
		Close:
			if (self hasnt open)
				"It's already closed.";
		Attack, KnockOn: 
			"You scrape your knuckles without result. There isn't
				even any sound; it's like knocking on the side of a mountain.";
		Push, Turn: 
			"The steel is immobile.";
		Pull: 
			"The door is flush with the wall, and there's no space around the 
				edges to work your fingers into.";
		Touch, Rub: 
			"The steel is smooth and cool.";
		ActivateTool:
			if (escaping)
				"^You reach the outside world, and win. Er. I think. [BUG]";
			if (location == InsideEntrance)
				print "^The door slides open, and daylight spills over you.
					So does a sharp buzzer; and, moments later, three armed
					guards.^";
			else
				print "^A buzzer sounds. Moments later, three guards charge
					towards you, weapons drawn.^";
			EndScene(-3, 1);
			rtrue;
	],
  has scenery door ~open;

Object -> outerdoorinplate
  class InteriorPlate,
  with
	work_target outerdoorin;

Object CeilingHole "Corner At Doors"
  with
	description [;
		print "The hallway runs both east and south from here.
			There's a featureless metal
			door to the west, which is closed; a more normal one stands";
		if (cornerdoor has open)
			print " open";
		else
			print " closed";
		print " to the north.";
		new_line;
		if (player in panelhole) {
			print "^One of the ceiling panels is missing, leaving a rectangular gap.
				You are clinging to the lip of the hole; your feet dangle a foot
				above the ground.^";
		}
		rtrue;
	],
	n_to cornerdoor,
	w_to cornermetaldoor,
	s_to WhiteJunction,
	e_to NorthBoundary,
	in_to [; <<Enter panelhole>>; ];

Object -> cornerdoor "normal door"
  with
	name 'north' 'northern' 'n//' 'normal' 'door' 'hinges' 'hinge' 'handle',
	door_dir n_to,
	door_to StorageCloset,
	door_try [;
		if (self hasnt open)
			"The door to the north is closed.";
	],
	description [;
		print "The northern door is comfortingly ordinary -- white paint,
			hinges, and a handle which needs nothing more sophisticated than
			fingers. The door is";
		if (self has open)
			print " open";
		else
			print " closed";
		".";
	],
  has scenery door ~open openable;	
	
Object -> cornermetaldoor "metal door"
  class InteriorDoor,
  with
	name 'w//' 'west' 'western',
	description "The door to the west is metal. It has no handle;
		another black plate is visible beside it. The door is closed.",
	door_dir w_to,
	before [;
		ActivateTool:
			if (escaping)
				"^The door opens, revealing a speakeasy. [BUG]";
			if (location == CeilingHole)
				print "^The metal door slides open. Beyond, several people
					are working at cluttered desks. One looks up absently,
					and then stares; and then a loud buzzer echoes down the hall.
					Moments later, three guards charge
					towards you, weapons drawn.^";
			else
				print "^A buzzer sounds. Moments later, three guards charge
					towards you, weapons drawn.^";
			EndScene(-3, 2);
			rtrue;
	],
  has scenery door ~open;

Object -> cornermetaldoorplate
  class InteriorPlate,
  with
	work_target cornermetaldoor;

Object -> concreteceiling "concrete ceiling"
  with
	name 'concrete' 'cement' 'ceiling' 'roof',
	description "A bare expanse of dirty concrete is visible through the gap.",
	before [;
		Examine, Search:
			rfalse;
		Touch, Rub:
			if (player notin panelhole)
				"The concrete ceiling is out of reach.";
			"The concrete is rough and unfinished.";
		default:
			if (player notin panelhole)
				"The concrete ceiling is out of reach.";
			rfalse;
	],
  has scenery;

Object -> supervent "ventilator grille"
  with
	parse_name [ num wd;
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, ventilator, name) ~= 0)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	description [;
		if (self hasnt open)
			<<Examine ventilator>>;
		print "A plastic grille is visible high on the wall, just below the
			ceiling. It's hanging open";
		if (player notin panelhole)
			", but you can't see in from this low angle.";
		if (child(self)) {
			print ". In the duct behind it, you can see ";
			WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		}
		else {
			"; the duct behind appears empty.";
		}
	],
	before [ fn;
		Examine:
			rfalse;
		Search:
			if (self hasnt open)
				<<Search ventilator>>;
			if (player notin panelhole)
				"You can't see into the grille from down here.";
			if (child(self)) {
				print "In the duct, you can see ";
				WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
				".";
			}
			else {
				"The ventilation duct appears empty.";
			}
		Enter:
			if (player notin panelhole)
				<<Touch ventilator>>;
			"The grille is barely a foot wide.";
		EmptyT:
			if (player notin panelhole)
				<<Touch ventilator>>;
			"Your position is precarious enough without that kind of juggling.";
		Empty:
			if (player notin panelhole)
				<<Touch ventilator>>;
			if (self hasnt open)
				rfalse;
			if (child(self) == nothing)
				"You can't see anything in the ventilation duct.";
			print "You reach into the duct with one arm...^";
		Open:
			if (self has open)
				print_ret (The) self, " is already open.";
			if (player notin panelhole)
				<<Touch ventilator>>;
			if (~~escaping) {
				if (self hasnt general) {
					give self general;
					fn = emphstring;
				}
				else {
					fn = normstring;
				}
				fn("The ventilator grille isn't important.");
				new_line;
				rtrue;
			}
			give self open;
			print "You shift your weight to one hand and reach out -- almost...
				you swing yourself desperately, kicking. Your
				fingers brush the grille. You claw at it, a wild swipe -- and
				the grille flops open.^";
			if (child(self)) {
				print "^Inside, you can see ";
				WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
				print ".^";
			}
			rtrue;
		Close:
			if (self hasnt open)
				print_ret (The) self, " is already closed.";
			if (player notin panelhole)
				<<Touch ventilator>>;
			give self ~open;
			"With a bit more flailing, you manage to flip the grille up into 
				place.";
		Listen:
			<<Listen ventilator>>;
		ThrownAt:
			rfalse;
		default: ! including LetGo
			if (player notin panelhole)
				<<Touch ventilator>>;
			rfalse;
	],
  has scenery container ~open; ! general means italic warning

Object -> panelhole "hole"
  with
	name 'hole' 'gap' 'lip' 'edge' 'space' 'missing' 'rectangle' 'rectangular' 
		'panel',
	describe [;
		"^One of the ceiling panels is missing, leaving a rectangular gap
			above you.";
	],
	description [;
		if (player in self)
			<<Examine panelcache>>;
		print "The hole is about two feet by three. Through it, you can see 
			the actual concrete ceiling, a few inches above the acoustical
			panelling.";
		if (self has general)
			print " A few drops of your blood are smeared at the edge of the hole.";
		new_line;
		rtrue;
	],
	vehicle_name " (hanging from the ceiling)",
	vehicle_status_name ", hanging from ceiling",
	ceiling_reachable true,
	react_before [;
		Jump:
			if (player in self)
				"You can't very well jump when you're hanging by your hands.";
			move player to self;
			move panelcache to self;
			self.number = 0;
			print "You bend and leap. Your fingers brush the
				edge of the hole -- catch, and you concentrate on holding on.
				Your feet swing gently a foot above the floor.^";
			if (self hasnt general) {
				give self general;
				move blood to location;
				print "^", (emphstring) "Uh!", " A sharp edge is digging into
					one finger. You shift your grasp hastily, but a few drops
					of blood smear across the hole's lip.^";
			}
			rtrue;
		Exit:
			if (player in self) {
				move player to location;
				remove panelcache;
				print "You drop lightly to the ground";
				if (self.number >= 3 && self.number < 5)
					print ", flexing your fingers";
				if (self.number >= 5 && self.number < 8)
					print ", flexing your stiff hands";
				else if (self.number >= 8)
					print ", and painfully massage your forearms";
				".";
			}
		Go:
			if (noun == u_obj or in_obj)
				<<Enter self>>;
			if (player notin self)
				rfalse;
			if (noun == d_obj or out_obj)
				<<Exit>>;
			"You'll have to come down first.";
		Open, Close, Take, Set, SetTo, Turn, Push, Pull, Touch, Switchon, Switchoff,
			Attack, Empty:
			if (player notin self)
				rfalse;
			if (UnreachableHanging(noun))
				"You can't reach that while you're hanging from the ceiling by
					your hands.";
			if (noun == supervent)
				rfalse;
			if (action == ##Pull && noun == panelhole)
				rfalse;
			WithOneHand();
			rfalse;
		AttackWith:
			if (player notin self)
				rfalse;
			if (second && second ofclass PulseGun)
				rfalse;
			if (UnreachableHanging(noun))
				"You can't reach ", (the) noun, " while you're hanging from the
					ceiling by your hands.";
			if (UnreachableHanging(second))
				"You can't reach ", (the) second, " while you're hanging from the
					ceiling by your hands.";
			WithOneHand();
			rfalse;
		Tie, Detach, BaseTouchTo, Lock, Unlock:
			if (player notin self)
				rfalse;
			if (UnreachableHanging(noun))
				"You can't reach ", (the) noun, " while you're hanging from the
					ceiling by your hands.";
			if (UnreachableHanging(second))
				"You can't reach ", (the) second, " while you're hanging from the
					ceiling by your hands.";
			WithOneHand();
			rfalse;
		Drop:
			if (player notin self)
				rfalse;
			if (noun == self)
				<<Exit>>;
			! duplicate DropSub, sort of
			if (noun in location) print_ret (The) noun, " is already there.";
			if (noun notin player) return L__M(##Drop,2,noun);
			if (noun has worn) {
				L__M(##Drop,3,noun);
				<Disrobe noun>;
				if (noun has worn) rtrue;
			}
			move noun to location;
			print_ret (The) noun, " falls to the ground.";
		Insert, PutOn:
			if (second == self) {
				if (noun == player)
					rfalse;
				if (player notin self)
					print_ret (string) HoleOutOfReach;
				<<(action) noun panelcache>>;
			}
			if (player notin self)
				rfalse;
			if (UnreachableHanging(noun))
				"You can't reach ", (the) noun, " while you're hanging from the
					ceiling by your hands.";
			if (UnreachableHanging(second))
				"You can't reach ", (the) second, " while you're hanging from the
					ceiling by your hands.";
			WithOneHand();
			rfalse;
		WaveHands:
			if (player in self)
				"Not unless you can levitate.";
	],
	before [;
		Enter, Climb:
			if (player in self) {
				"The space above the ceiling panels is only a few inches high.
					You can't fit into it.";
			}
			else {
				print_ret (string) HoleOutOfReach;
			}
		Empty:
			if (player notin self)
				print_ret (string) HoleOutOfReach;
			<<Empty panelcache>>;
		Search:
			if (player notin self)
				"From down here, you can see nothing through the hole except
					the concrete directly above it.";
			<<Search panelcache>>;
		EmptyT:
			if (player notin self)
				print_ret (string) HoleOutOfReach;
			"Your position is precarious enough without that kind of juggling.";
		Touch, Push, Turn:
			if (player notin self)
				print_ret (string) HoleOutOfReach;
			rfalse;
		Pull:
			if (player notin self)
				print_ret (string) HoleOutOfReach;
			<<Search panelcache>>;
		Take:
			if (player notin self)
				print_ret (string) HoleOutOfReach;
			else
				"You're already holding on to the edge of the hole.";
	],
	number 0, ! for each_turn 
	each_turn [;
		withonehandflag = false;
		if (player in self) {
			self.number++;
			switch (self.number) {
				3:
					if (random(11) <= 5)
						"^You shift your grip slightly, to ease the strain.";
					else
						"^You move your hands a bit, one at a time, to ease the
							strain.";
				5: 
					print "^Your fingertips ache dully.";
					if (powercut == 0)
						print " And a nearby ventilator grille seems to be
							hissing directly into your ear.";
					new_line;
					rtrue;
				8: "^The tendons of your fingers are complaining.";
				12: "^Your arms are beginning to feel numb.";
				16: "^You grimace, and ignore the pain in your arms.
					You've been through worse.";
			}
		}
	],
  has static enterable open container ~general; ! general means bloodied

Constant HoleOutOfReach "The hole is a foot out of reach.";

[ WithOneHand;
	if (withonehandflag)
		rtrue;
	withonehandflag = true;
	"(with one hand, hanging by the other)";
];

[ UnreachableHanging obj;
	if (player notin panelhole) {
		print "Your arms stretch from the hole to forever! [BUG]^";
		rfalse;
	}
	if (obj == nothing)
		rfalse;
	if (obj == player)
		rfalse;
	if (obj == panelhole or panelcache or concreteceiling or lowceiling
		or blood or supervent)
		rfalse;
	if (anywherein(obj, panelcache))
		rfalse;
	if (supervent has open && anywherein(obj, supervent))
		rfalse;
	if (anywherein(obj, player))
		rfalse;
	rtrue;
];

Object panelcache "hole"  ! exists only to be the panel storage thingie
  with
  	! no name, except for debugging purposes
  	! name 'cache',
	describe [;
		if (player notin panelhole)
			"^The space above the hole is hovering in midair! [BUG]";
		rtrue;
	],
	description [;
		<<Search self>>;
	],
	before [;
		Search:
			print "You strain, pulling yourself up with your arms, until you
				can see over the lip of the hole. The space over the acoustical
				panelling is only a few inches high; but it spreads out around
				you into darkness.";
			if (package in self)
				give package moved;
			if (child(self) == nothing) {
				"^^The space is empty as far as you can see.";
			}
			if (child(self) == package && children(self) == 1) {
				"^^A small package, wrapped in cloth, is sitting on the panelling,
					just a few inches from your face.";
			}
			print "^^In the space, you can see ";
			WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Examine, Receive, LetGo:
			rfalse;
		Empty:
			if (child(self) == nothing)
				"You can't see anything in the space above the panelling.";
			if (package in self)
				give package moved;
			print "You reach up into the space with one arm...^";
		default:
			"You can't refer to the hole that way. [BUG]";
	],
	after [;
		Receive:
			print_ret "Hanging from one hand, you toss ", (the) noun, 
				" up into the space above.";
	],
  has scenery container open;

Object package "wrapped package" panelcache
  with
	name 'wrapped' 'package' 'bundle' 'cloth',
	description "It's an oblong bundle of cloth, a bit larger than your palm.",
	before [;
		Touch:
			"Whatever's inside the bundle is rigid and rather heavy.";
		Open, Search:
			"It's not yet time.";
		Receive, Empty, EmptyT:
			"The bundle is still wrapped up.";
		Take, Drop:
			give self moved;
			rfalse;
	],
	data_cache 0,
	save_pos [ ptr;
		ptr = self.&data_cache;
		ptr-->0 = parent(self);
	],
	restore_pos [ ptr;
		ptr = self.&data_cache;
		set_parent(self, ptr-->0);
	],
	escape_pos [ loc;
		loc = 0;
		remove self;
	],
  has ~moved; ! moved means you've seen it (at all)
	
Object blood "smear of blood"
  with
	name 'drop' 'drops' 'smear' 'blood',
	description "A smear of your blood is visible on one of the light-strips
		that edge the missing panel.",
	before [;
		Examine, Search:
			rfalse;
		Take, Touch, Rub:
			if (player notin panelhole)
				"The smear of blood is out of reach.";
			"The blood only smears further as you rub at it.";
		default:
			if (player notin panelhole)
				"The smear of blood is out of reach.";
			rfalse;
	],
  has scenery;

Object gun "gun" supervent
  class PulseGun,
  with
	article "your",
	description "Your pulse gun is a little smaller than the guards' weapons.
		Its outline is sharp, clean, and beautiful.",
	answer_general [;
		if (self hasnt general) {
			give self general;
			print "You smile in the darkness.^^";
		}
		rtrue;
	],
  has ~general; ! used for the goofy message

Object StorageCloset "Storage Closet"
  with
	description [;
		print "This room is small and, perhaps, rarely used -- not dirty, but
			not quite as clean and white as the corridors. The door to the south
			is";
		if (cornerdoor has open)
			print " open";
		else
			print " closed";
		print ".^^Two rough wooden crates are backed in a corner of the closet.";
		new_line;
		rtrue;
	],
	s_to cornerdoorback,
	out_to cornerdoorback,
	cant_go "The only exit is south.";

Object -> cornerdoorback "normal door"
  with
	name 'normal' 'south' 'southern' 's//' 'door',
	door_dir s_to,
	door_to CeilingHole,
	door_try [;
		if (cornerdoor hasnt open)
			"The door is closed.";
	],
	description [;
		print "The door to the south is";
		if (cornerdoor has open)
			print " open";
		else
			print " closed";
		".";
	],
	before [;
		Open: <<Open cornerdoor>>;
		Close: <<Close cornerdoor>>;
	],
  has scenery door open;	! use cornerdoor for open-testing

Class StorageCrate
  with
	name 'rough' 'wood' 'wooden' 'crate' 'crates',
	!describe [;
	!	rtrue;
	!],
	ceiling_reachable true,
	react_before [;
		Exit:
			if (player in self) {
				move player to parent(self);
				if (keep_silent == 0)
					print "You get down off ", (the) self, ".^";
				rtrue;
			}
		Go:
			if (player in self && noun == d_obj)
				<<Exit>>;
	],
	before [;
		Search:
			print_ret (The) self, " is closed.";
		Open:
			print_ret (The) self, " is nailed shut. You can't pry it open with your
				hands.";
		Unlock:
			if (second == boltwrench)
				"It's a wrench, not a crowbar.";
			print_ret (The) second, " can't help you lever the crate open.";
		Close:
			"That's already closed.";
		Push, PushDir, Pull, Turn:
			<<Take self>>;
		Take:
			print_ret (The) self, " is too heavy to move.";
		LookUnder:
			print_ret "You can't see under ", (the) self, ".";
		Receive:
			if (receive_action == ##Insert)
				print_ret (The) self, " is closed.";
		Climb:
			<<Enter self>>;
		Empty, EmptyT:
			print_ret (The) self, " is closed.";
	],
	after [;
		Enter:
			print_ret "You climb up on ", (the) self, ".";
	],
  has scenery supporter enterable;

Object -> largecrate "larger crate"
  class StorageCrate,
  with
	name 'large' 'larger';

Object -> smallcrate "smaller crate"
  class StorageCrate,
  with
	name 'small' 'smaller',
	before [;
		Take:
			"Even the smaller crate is too heavy to move.";
	];

Object boltwrench "bolt wrench" largecrate
  with
	name 'heavy' 'steel' 'bolt' 'wrench',
	description "It's a heavy steel wrench.";

Constant CrossLine "You step across the line and continue down the corridor.^";

[ TryCrossLine rightspot   ix;

	if (anywherein(boltwrench, player)) {
		if (anywherein(scrambler, player) && scrambler has general) {
			print (string) CrossLine;
			EndScene(3, 0);
			rtrue;
		}
	
		print "As you step across the line, a sharp buzzer echoes through the
			corridors.^";
		EndScene(1, 0);
		rtrue;
	}
	
	if (rightspot == 0) {
		print "You step across the line and continue down the corridor... 
			into the sight of six guards or so, who are posted at the next
			intersection.^";
		EndScene(2);
		rtrue;
	}
	
	if (panelhole hasnt general) {
		! no blood
		print (string) CrossLine;
		EndScene(6);
		rtrue;
	}
	
	if (package hasnt moved) {
		! blood, but player/man never saw package
		print (string) CrossLine;
		EndScene(7);
		rtrue;
	}
	
	if (~~(anywherein(package, player))) {
		! blood, but player left package behind
		print (string) CrossLine;
		if (package in panelcache)
			EndScene(8);
		else
			EndScene(9);
		rtrue;
	}
	
	if (~~(boltwrench in largecrate)) {
		print (string) CrossLine;
		EndScene(4);
		rtrue;
	}
	
	ix = child(panelcache);
	if (ix) {
		if (children(panelcache) > 1)
			ix = 1;
		print (string) CrossLine;
		EndScene(10, ix);
		rtrue;
	}
	
	ix = LeftToolsBehind();
	if (ix) {
		print (string) CrossLine;
		EndScene(5, ix);
		rtrue;
	}
	
	! happy ending
	print (string) CrossLine;
	EndScene(20);
	rtrue;
];

Object SouthBoundary "Corridor Boundary"
  with
	description [;
		"The corridor angles here, and crosses a boundary of some sort as it does.
			A few strides down the southeast branch, a dotted red line crosses the
			floor. You can retreat from the boundary to the west.";
	],
	w_to WhiteJunction,
	se_to [;
		if (escaping) {
			return SouthFrontier;
		}
		return TryCrossLine(1);
	];

Object NorthBoundary "Corridor Boundary"
  with
	description [;
		"The corridor angles here, and crosses a boundary of some sort as it does.
			A few strides down the southeast branch, a dotted red line crosses the
			floor. You can retreat from the boundary to the west.";
	],
	w_to CeilingHole,
	se_to [;
		if (escaping) {
			return SharpCorner;
		}
		return TryCrossLine(0);
	];

Object boundaryline "red line"
  with
	name 'dotted' 'red' 'boundary' 'line' 'center' 'marking',
	found_in SouthBoundary NorthBoundary,
	description [;
		print "It's just a red marking, painted on the floor tiles southeast of
			you. The line is";
		if (location == NorthBoundary)
			print " very";
		" slightly scuffed in the center.";
	],
	react_before [;
		ThrowDir:
			if (escaping == 0) {
				if (noun == boltwrench && second == se_obj)
					<<ThrowAt noun self>>;
			}
	],
	before [;
		Enter, JumpOver:
			<<Go se_obj>>;
		Rub:
			"It's not visibly affected.";
		ThrownAt:
			if (escaping == 0 && noun == boltwrench) {
				if ((anywherein(scrambler, location) && scrambler has general)) {
					print "You toss the wrench across the line.^";
					EndScene(3, 1);
				}
				else {
					print "You toss the wrench across the line; a sharp buzzer
						immediately sounds.^";
					EndScene(1, 1);
				}
				rtrue;
			}
	],
  has scenery;

Object boundaryweb "metal-scan web"
  with
	name 'metal' 'glitter' 'metal-scan' 'scan' 'web' 'scan-web' 'webbing',
	found_in SouthBoundary NorthBoundary,
	description "To the southeast, beginning above the boundary line, the ceiling
		is lined with scan-web in addition to the lighting strips. The web's
		wide spacing indicates a metal-resonance scan.",
	before [;
		Examine:
			rfalse;
		default:
			"The webbing is part of the ceiling to the southeast. It's out of reach.";
	],
  has scenery;

