#charset "us-ascii"
#include <advlite.h>

// Note that the topics for ASL use are in the PDverbs file.

// The point of deriving our own class is so that makeFamiliar can be
// called from within dialog. Also, familiar is now nil by default
// rather than true.

class PDtopic: Topic
    familiar = nil
    makeFamiliar () { familiar = true; }
;

// ----------------------------------------------------------------
// Topics that are available during the opening chapters:
// ----------------------------------------------------------------

// Located in the player:
//tSamantha: PDtopic 'samantha;; daughter sam'
//    familiar = true
//;

// A useful testing tool, but for the release we'll make it
// hard to type:
tDummy: PDtopic 'psnxtl'
    familiar = true
;

tBoutique: PDtopic 'fashion boutique; hot; rags'
    familiar = true
;

tJellybeans: PDtopic 'jellybeans; jelly; beans'
    familiar = true
;

tSmoking: PDtopic 'smoking; ; cigarettes'
    familiar = (betsy.seen)
;

tBoyfriend: PDtopic 'boyfriend'
    familiar = (betsy.seen)
;

tCrystalBall: PDtopic 'crystal ball'
;

tScrimshaw: PDtopic 'scrimshaw; carved; carving ivory tusk tusks'
;

tJoe: PDtopic 'joe; homeless; (man)';

tArchibald: PDtopic 'archibald; (art); dealer';

tSteve: PDtopic 'bartender;; steve';

tBloviatsky: PDtopic 'fortune teller; madame; bloviatsky seeress';

tBetsy: PDtopic 'betsy; ; hairdresser';

tGuards: PDtopic 'guards; security; guard ray frank franklin';

tFlogg: PDtopic 'phineas flogg'
    familiar = (worldHeadquarters.seen)
;

tGrabby: PDtopic 'eustace grabby'
    familiar = (worldHeadquarters.seen)
;

tPlans: PDtopic 'plans'
;

tCards: PDtopic 'cards; tarot'
;

tPromDress: PDtopic 'prom dress'
    familiar = true
;

tStufftown: PDtopic 'stufftown; shopping; center'
    familiar = true
;

tOctagonalRoom: PDtopic 'octagonal room';

tLamborghini: PDtopic 'lamborghini; (sports); car';

tParade: PDtopic 'parade; lacrosse championship'
    familiar = true
;

tBeer: PDtopic 'beer; ; drink'
    familiar() {
        if (gPlayerChar.getOutermostRoom() == scootersPub) return true;
        return nil;
    }
;

tBilliardRoom: PDtopic 'billiard room'
    familiar() {
        if (gPlayerChar.getOutermostRoom() == scootersPub) return true;
        return nil;
    }
;

tPower: PDtopic 'power; electrical; junction box'
    familiar = (footOfPole.seen)
;

// ------------------------------------------------------------------
// Topics that will become available during the course of the game:
// ------------------------------------------------------------------

// This changes to familiar = true when seen through the telescope.
tCheating: PDtopic 'cheating; card players';

// This becomes familiar when you encounter Sir Ralph.
tGhost: PDtopic 'ghost ralph; sir; traveler';

tSummoning: PDtopic 'summoning; ; summon seance'
;

tMagic: PDtopic 'magic; ; wizardry spell spells sorcery'
    familiar = true
;

tPixies: PDtopic 'pixies; flying; sprites'
;

tIdentification: PDtopic 'identigivation; identity papers; id'
;

tWizard: PDtopic 'wizard; ; zarbolphung';

tAdventures: PDtopic
    'adventures;; travels explorations adventure travel exploration'
;
tMannequins: PDtopic 'mannequins';

tDiorama: PDtopic 'diorama'
    familiar = true
;
tTarzan: PDtopic 'tarzan'
    familiar = (travelAgency.seen)
;
tCapsule: PDtopic 'virtual capsule'
    familiar = (capsuleRoom.seen)
;
tMummy: PDtopic 'mummy'
    familiar = (ancientCrypt.seen)
;
 