/* Perdition's Flames - Civic Center portion */
// copyright (c) 1993, 2002 by Michael J. Roberts.

cyImmBuilding: fixeditem
    sdesc = "Immigration Building"
    adesc = "an Immigration Building"
    noun = 'building'
    adjective = 'immigration'
    location = courtyard
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(building); }
;

cyDmvBuilding: fixeditem
    sdesc = "DMV Building"
    noun = 'building' 'department'
    adjective = 'dmv' 'motor' 'vehicles'
    location = courtyard
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(dmv); }
;

cyCsBuilding: fixeditem
    sdesc = "Celestial Security Building"
    noun = 'building'  'office'
    adjective = 'celestial' 'security'
    location = courtyard
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(csOffice); }
;

courtyard: room
    sdesc = "Courtyard"
    ldesc = "You're in a large courtyard surrounded by buildings.
        To the south is the Immigration Building, to the east is
        the Department of Motor Vehicles, and to the west is a
        Celestial Security office.  An archway leads out of
        the courtyard to the north.  In the center of the courtyard
        is a vending machine."
    south = building
    east = dmv
    west = csOffice
    north = downtown
;

ticketmachine: fixeditem
    sdesc = "vending machine"
    noun = 'machine'
    adjective = 'vending'
    location = courtyard
    ldesc =
    {
        "It looks similar to a soft-drink vending machine, but
        it's labeled \"Space Needle Tickets\".  It has a slot
        labeled \"20 Hellmids\", and a small receptacle";
        if (ticket.location = ticketReceptacle)
            ", which contains a ticket";
        ".";
    }
;

ticketReceptacle: fixeditem, qcontainer
    ioPutIn(actor, dobj) =
    {
        if (dobj = ticket) pass ioPutIn;
        else "It doesn't fit.";
    }
    noun = 'receptacle'
    adjective = 'small'
    sdesc = "small receptacle"
    location = courtyard
;

ticketslot: fixeditem
    sdesc = "slot"
    noun = 'slot'
    location = courtyard
    ldesc = "It's labeled \"20 Hellmids\"."
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = twentyHellmids)
        {
            "You feed the twenty hellmid bill into the slot,
            and a motorized roller pulls the bill in.  A few
            seconds later, a ticket appears in the receptacle.";
            dobj.moveInto(nil);
            ticket.moveInto(ticketReceptacle);
        }
        else
            "You can't put that in the slot.";
    }
;

csBasket: fixeditem, qcontainer
    sdesc = "waste basket"
    noun = 'basket' 'can' 'wastebasket'
    adjective = 'waste' 'trash' 'garbage'
    location = csOffice
    Grab(obj) =
    {
        if (obj = csWastePaper)
        {
            if (maintUniform.isIn(Me) and maintUniform.isworn)
            {
                 if (recycleBin.isIn(Me))
                     pass verGrab;
                 else
                 {
                     "The Celestial Security officer doesn't seem
                     to take note of you at first, but then suddenly
                     looks up.  \"Hey!  Where's your recycling bin?
                     I'll bet you were about to throw those papers
                     away!  How wasteful!\" He won't let you take
                     the papers.";
                     exit;
                 }
            }
            else if (recycleBin.isIn(Me))
            {
                "The Celestial Security officer stops you. \"Hey!
                You're not our regular maintenance worker!  Where's
                your uniform?\" He makes you put the papers back.";
                exit;
            }
            else
            {
                "The Celestial Security officer doesn't let you.
                \"Those contain private information,\" he scolds you.
                \"Besides, we recycle all of our paper.  We're trying
                to be environmentally conscious.\"";
                exit;
            }
        }
        else
            pass grab;
    }
;

csWastePaper: readable
    sdesc = "waste paper"
    adesc = "some waste paper"
    noun = 'paper' 'form' 'forms' 'application' 'applications'
    adjective = 'application' 'waste' 'crumpled-up'
    location = csBasket
    lineDesc =
    [
        'Last name spelled backwards'
        'First Initial'
        'Age (years)'
        'Last name'
        'Current date (MM/DD/YY)'
        'First name'
        'Date of birth (DD-MM-YYYY)'
        'Number of letters in first name'
    ]
    ldesc =
    {
        csDisplay.setupList;
        if (location = csBasket)
            "The waste basket is full of crumpled-up application
            forms, evidently discarded due to errors made in preparation.";
        else
        {
            local i;

            "They all seem to be the same.  You pick one and look at it:
            \bCelestial Security Administration
            \nForm 19937/40.Z\b";
            for (i := 1 ; i <= length(lineDesc) ; ++i)
                "<< csDisplay.lineNumber[i] >>. << self.lineDesc[i] >>\n";
        }
    }
    verDoAnswer(actor) = { "It's been too crumpled up."; }
    doSynonym('Answer') = 'Fillout' 'Write'
;

csCounter: fixeditem, surface
    sdesc = "counter"
    noun = 'counter'
    location = csOffice
    verDoLookunder(actor) =
    {
        "You can't see anything under it, since the officer is
        in the way.";
    }
    verDoLookbehind(actor) = { "The officer won't let you."; }
;

csOfficer: Actor
    location = csOffice
    sdesc = "Celestial Security officer"
    ldesc = "He's dressed in a drab, light blue Celestial Security
        Administration uniform."
    actorDesc = nil
    noun = 'officer' 'employee' 'man'
    adjective = 'celestial' 'security'
    actorAction(v, d, p, i) =
    {
        "\"I'll be with you after I finish with this lady.
        Please wait your turn.\"";
        exit;
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "\"You'll have to wait your turn.  I can only help one
        person at a time.\"";
    }
    doSynonym('AskAbout') = 'TellAbout'
    isHim = true
;

csApplicant: Actor
    location = csOffice
    sdesc = "young woman"
    ldesc = "She looks to be in her mid-thirties."
    actorDesc = nil
    noun = 'woman' 'customer' 'applicant'
    adjective = 'young'
    isHer = true
    actorAction(v, d, p, i) =
    {
        "\"I'm busy with the application.\"";
        exit;
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "\"Please wait until I'm done here.\"";
    }
    doSynonym('AskAbout') = 'TellAbout'
;

csApplicant2: Actor
    sdesc = "middle-aged woman"
    ldesc = "She looks to be in her late forties."
    actorDesc = nil
    noun = 'woman' 'customer' 'applicant'
    adjective = 'middle-age' 'middle' 'age' 'aged' 'middle-age'
    isHer = true
    actorAction(v, d, p, i) =
    {
        "\"I'm busy with the application.\"";
        exit;
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "\"Please wait until I'm done here.\"";
    }
    doSynonym('AskAbout') = 'TellAbout'
;

csOffice: room
    sdesc = "Celestial Security Office"
    ldesc =
    {
        "You're in the Celestial Security Office.  At one end of
        the room is a counter, and next to the counter is a wastebasket";
        if (csWastePaper.location = csBasket)
            " that's full of crumpled up paper";
        ".  The exit is to the east, and a
        door behind the counter leads west.
        \n\tBehind the counter is a middle-aged
        man dressed in a light blue Celestial Security Administration
        uniform. ";

        if (not self.isseen)
        {
            "You're relieved to see that there's only one person
            in line. You were afraid that the line would be longer,
            with so many new people arriving at the same time you did,
            but this will obviously take no time.
            \n\tThe Celestial Security officer notices you enter,
            and looks up at you. \"I'll be right with you, after I
            finish with this applicant,\" he says.";
        }
        else if (self.applicant2)
            "He's helping a middle-aged woman fill out an application
            form.";
        else
            "He's helping a young woman fill out an application form.";
    }
    east = courtyard
    out = courtyard
    west =
    {
        "The Celestial Security officer moves to block your way.
        \"I'm sorry, only authorized personnel are allowed in the
        back office.\"";
        return(nil);
    }
    state = 1
    applicationList =
    [
        'What is your last name?'  'Simmons.'
        'What is your middle initial?'  'G.'
        'What was your date of birth?'  'Um, November 12, 1959.'
        'And your date of death?'  '$'   // display today's date
        'Do you have any deceased dependents?' 'No.'
        'Do you wear any prescription eyewear?' 'No.'
        'What is your IQ?' 'I\'m not sure.'
        'How many fingers am I holding up?' 'Three.'
        'Do you know your blood pressure?' '130 over 70.'
        'Have you ever filed a claim against your automobile,
        homeowner\'s, renter\'s, malpractice, health, or
        dental insurance?' 'I had an automobile accident in 1982,
        but it wasn\'t my fault, and I had regular dental checkups
        between 1981 and 1990 that were billed to my dental insurance.'
        'In what year did Columbus discover America?' '1492.'
        'Are you married?' 'Yes.'
        'Is your spouse living or dead?' 'Living.'
        'What is your spouse\'s life expectancy?' '72 years.'
        'Do you now or have you ever smoked?' 'No.'
        'Do you now or have you ever belonged to, endorsed,
        supported, aided and abetted, given comfort to, made a
        contribution to, sent back a business reply card from,
        or developed an advertising slogan for a \'light beer\'
        manufacturer?' 'No, never.'
        'Jane lives one mile from school, and Billy lives
        four miles away.  If Jill walks to school at three
        miles per hour, how fast must Billy ride his bike
        to arrive at school at the same time as Jane if they
        both leave home at the same time?' '12 miles per hour.'
        'Do you use a hearing aid?' 'No.'
        'Have you ever experienced palpitations, heart murmurs,
        shortness of breath, convulsions, seizures, paroxysms,
        blurred vision, dizziness, queasiness, or insomnia?'
        'Yes, I regularly have trouble sleeping.'
        'Hot enough for you?' 'Yes.'
        'Can you taste the difference between margarine and butter?'
        'No, not usually.'
        'Which of the following statements best describes you?
        I always vote Republican; I think math is hard; I always
        go around the house turning off the lights.' 'I think math is hard.'
    ]
    application =
    {
        state += 2;
        if (state > length(applicationList))
        {
            state := 1;
            "\bThe Celestial Security officer sighs. \"Oh, my,\"
            he says, \"I did it again!  I accidentally wrote down
            your last name in the space for your first name.  This
            form is just so confusing.\"  He crumples up the form
            and throws it into the wastebasket.  \"Oh, well,\"
            he says, \"we'll just have to start over.\"  He reaches
            beneath the counter and gets out a new form.";
        }
        else
        {
            "\bThe Celestial Security officer asks the
            << self.applicant2 ? "middle-aged" : "young" >> woman,
            \"<< applicationList[state] >>\"  The woman replies, \"";

            if (applicationList[state + 1] = '$')
            {
                local d := gettime();

            /* 
             *   for QA scripting, if 'randomize' is off, always use a
             *   fixed date - this will avoid a spurious diff in script
             *   comparisons 
             */
            if (global.noRandomize)
            {
                "April 11, 1999.";
            }
            else
            {
                "<< ['January' 'February' 'March' 'April' 'May' 'June' 'July'
                'August' 'September' 'October' 'November' 'December'][d[2]]
                >> << d[3] >>, << d[1] >>.";
            }
            }
            else if (state = 1 and self.applicant2)
                "Johnson.";
            else
                "<< applicationList[state + 1]>>";

            "\"  The officer slowly and carefully transcribes the information
            onto the application form.";
        }
    }
    enterRoom(actor) =
    {
        notify(self, &application, 0);
        pass enterRoom;
    }
    leaveRoom(actor) =
    {
        unnotify(self, &application);
        pass leaveRoom;
    }
;

csRoof: room
    sdesc = "Roof of Celestial Security Building"
    ldesc = "You're on the roof of the Celestial Security building.
        A stairway leads down."
    down = csBackRoom
;

csFilingcabinets: fixeditem
    sdesc = "filing cabinet"
    noun = 'cabinet' 'cabinets'
    adjective = 'filing'
    location = csBackRoom
    ldesc = "Every wall is lined floor to ceiling with filing cabinets."
    verDoOpen(actor) = { "You try a few, and find them all locked."; }
    verDoUnlock(actor) = { "You have no way to unlock them."; }
    verDoPryWith(actor, iobj) =
    {
        "You can't seem to find anywhere to wedge << iobj.thedesc >>.";
    }
    doSynonym('DoPryWith') = 'DoOpenWith'
;

csDesk: fixeditem, surface
    sdesc = "desk"
    noun = 'desk'
    adjective = 'metal'
    location = csBackRoom
    ldesc = "The desk is packed with equipment."
;

csMachine: fixeditem
    noun = 'machine' 'cardmaster'
    adjective = '2000'
    sdesc = "machine"
    location = csBackRoom
    ldesc = "The machine is labeled \"HadesCorp CardMaster 2000\".
        It has a computer-style keyboard, a video display
        (which is currently reading \"<<csDisplay.display>>\"),
        and a receptacle."
    verIoTypeOn(actor) = { csKeyboard.verIoTypeOn(actor); }
    ioTypeOn(actor, dobj) = { csKeyboard.ioTypeOn(actor, dobj); }
;

csDisplay: fixeditem, readable
    sdesc = "video display"
    noun = 'display'
    adjective = 'video'
    entryNum = 1
    ldesc = "It reads: \"<< self.display >>\"."
    display =
    {
        if (csKeyboard.soldOut)
            "*** Out of card stock ***";
        else
            "Enter line << self.lineNumber[self.lineOrder[entryNum]]
             >> from form 19937/40.Z";
    }
    location = csBackRoom
    setupList =
    {
        // set up line numbers randomly the first time they're needed
        if (self.lineNumber = nil)
        {
            local i, newval;

            for (self.lineNumber := [], self.lineOrder := [], i := 1 ;
                 i <= 8 ; ++i)
            {
                // pick values until we find one not already in the list
                for (;;)
                {
                    newval := rand(80) + 12;
                    if (find(self.lineNumber, newval) = nil) break;
                }
                self.lineNumber += newval;

                // do the same for the ordering array
                newval := rand(8);
                for (;;)
                {
                    if (find(self.lineOrder, newval) = nil) break;
                    ++newval;
                    if (newval > 8) newval := 1;
                }
                self.lineOrder += newval;
            }
        }
    }
;

csKeyboard: fixeditem
    sdesc = "keyboard"
    noun = 'keyboard'
    adjective = 'computer' 'style' 'computer-style'
    location = csBackRoom
    ldesc = "It's a standard computer-style keyboard."
    entryList = [0 0 0 0 0 0 0 0]
    verIoTypeOn(actor) = {}
    ioTypeOn(actor, dobj) =
    {
        if (dobj = strObj)
        {
            if (self.soldOut)
            {
                "The display just flashes \"*** Out of card stock ***\".";
                return;
            }

            self.entryList[csDisplay.lineOrder[csDisplay.entryNum]]
                := upper(dobj.value);
            csDisplay.entryNum++;
            
            if (csDisplay.entryNum > length(csDisplay.lineNumber))
            {
                local rev, i, validated;

                // validate entry - assume it will be valid
                validated := true;

                // first, check that line 1 = line 4 spelled backwards
                for (rev := '', i := length(entryList[1]) ; i >= 1 ; --i)
                    rev += substr(entryList[1], i, 1);
                if (rev <> entryList[4]) validated := nil;
                
                // check that first initial matches first name
                if (substr(entryList[6], 1, 1) <> entryList[2])
                    validated := nil;

                // check that length of first name matches
                if (length(entryList[6]) <> cvtnum(entryList[8]))
                    validated := nil;

                if (validated)
                {
                    self.soldOut := true;
                    csCard.moveInto(csReceptacle);
                    csCard.cardName := entryList[6] + ' ' + entryList[4];
                    
                    "The screen displays \"Analyzing data\" for
                    several seconds, then changes to read \"Printing
                    Card\".  You hear clicking and whirring from
                    within the machine for many seconds, then it
                    stops.  A small card appears in the receptacle.";

                    csApplicant.moveInto(nil);
                    csApplicant2.moveInto(csOffice);
                    csOffice.applicant2 := true;
                    awardPoints(25, self);
                }
                else
                {
                    csDisplay.entryNum := 1;
                    "You make your entry.  The display beeps and flashes
                    \"INVALID ENTRY\" for several seconds, then
                    clears and flashes \"*** Resetting ***\" for a few
                    seconds, then clears and displays \"<< csDisplay.display
                    >>.\"";
                }
            }
            else
                "You make the entry on the keyboard. The display
                now reads \"<< csDisplay.display >>\".";
        }
        else
            "You can't type that on the keyboard.
            Try something such as TYPE \"HELLO\" ON KEYBOARD.";
    }
    ioSynonym('TypeOn') = 'EnterOn' 'EnterIn' 'EnterWith'
;

csReceptacle: fixeditem, container
     location = csBackRoom
     sdesc = "receptacle"
     noun = 'receptacle'
     maxbulk = 1
;

csEquipment: fixeditem
    sdesc = "equipment"
    noun = 'equipment'
    location = csBackRoom
    ldesc =
    {
        "The most notable equipment is a large machine in
        the center of the desk. ";
        csMachine.ldesc;
    }
;

csBackRoom: room
    sdesc = "Celestial Security Office"
    ldesc = "You're in a back room of the Celestial Security office.
        Every wall is lined with filing cabinets that reach up to
        the ceiling.  In the center of the room is a metal
        desk packed with equipment.
        A doorway exits to the east, and a stairway leads up."
    east = csOffice
    up = csRoof
    enterRoom(actor) =
    {
        csDisplay.setupList;
        pass enterRoom;
    }
;

dmvCustomers: fixeditem
    sdesc = "customer"
    noun = 'customer' 'customers' 'person' 'people'
    location = dmv
    ldesc = "They all look like they've been standing there
        for a long time."
;

dmvCounter: fixeditem, surface
    sdesc = "counter"
    noun = 'counter'
    location = dmv
;

dmvWindow: decoration
    sdesc = "window"
    noun = 'window'
    location = dmv
;

dmvOfficial: Actor
    isHer = true
    sdesc = "DMV official"
    noun = 'official' 'employee'
    ldesc = "She's a middle-aged woman. She looks profoundly
        disinterested in being here."
    adjective = 'dmv'
    location = dmv
    actorAction(v, d, p, i) =
    {
        "The employee only stares at you, looking annoyed.";
        exit;
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "\"It's against policy to answer questions.\"";
    }
    verDoTellAbout(actor, iobj) = {}
    doTellAbout(actor, iobj) =
    {
        "\"Like I'm supposed to be impressed?\"";
    }
    state = 1
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = appointmentCard)
        {
            "\"Well, it's about time.\"  She carelessly tosses
            your appointment card onto the counter and hands you
            a test. \"Fill this out, and don't cheat. Bring it
            back to me when you're finished with it.\"";
            dmvTest.moveInto(Me);
            dobj.moveInto(dmvCounter);
            state := 2;
        }
        else if (dobj = dmvTest)
        {
            if (dmvTest.answers = nil or
                length(dmvTest.answers) <> length(dmvTest.correctAnswers))
                "\"This is all wrong. Do it again.\"";
            else
            {
                local i, total, cnt, pct;

                "She looks over your test skeptically. ";
                cnt := length(dmvTest.answers);
                for (i := 1, total := 0 ; i <= cnt ; ++i)
                    if (dmvTest.correctAnswers[i] = dmvTest.answers[i])
                        ++total;

                pct := (total*100) / cnt;
                if (pct >= 70)
                {
                    "\"Fine,\" she says, \"you got << pct >>\%.  You pass.\"
                    She takes out a camera and snaps a picture of you before
                    you realize what's going on. She walks away from the
                    counter (leaving the room totally devoid of employees)
                    and remains in a back room for several minutes.
                    Finally, she returns, and hands you your driver's
                    license!";

                    state := 4;    // no more prompting for the test
                    driversLicense.moveInto(Me);
                    driversLicense.driverName :=
                        dmvTest.firstName + ' ' + dmvTest.middleName
                        + ' ' + dmvTest.lastName;
                    driversLicense.driverAge := dmvTest.licenseAge;
                    awardPoints(25, self);
                    dmvTest.moveInto(nil);
                }
                else
                {
                    state := 3;    // ridicule
                    "\"You only got << pct >>\%.  You fail.\" She hands
                    you the test back. \"Do it again until you get it
                    right.\"";
                }
            }
        }
        else
            "\"What use would I have for that?\"";
    }
    ioSynonym('GiveTo') = 'ShowTo'
    actorDaemon =
    {
        switch(state)
        {
        case 1:
            "\bThe DMV employee says, \"Let's see your appointment
            card.  Service is by appointment only.\"";
            break;

        case 2:
            "\bThe DMV employee looks at you impatiently.
            \"Have you finished the test yet?\"";
            break;

        case 3:
            "\bThe DMV employee looks at you impatiently.
            \"Have you finished taking the test again yet? I could
            use another good laugh.\"";
            break;

        default:
            "\bThe DMV employee looks at you, obviously
            annoyed by your continued presence. \"What more
            could you want? Go bother someone else.\"";
            break;
        }
    }
;

dmv: room
    west = courtyard
    out = courtyard
    sdesc = "Department of Motor Vehicles"
    ldesc = "You're in a very large, very drab room.  In the
        center of the room is a long counter that runs the
        length of the room.  As is typical of such facilities,
        there is a customer at almost every window, and practically
        no employees to be seen behind the counter.  In fact,
        the only employee in sight is standing at a window
        with no customers, looking bored.  The exit is to the west."
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);
        "\bYou walk over to the window where the employee is standing.";
        notify(dmvOfficial, &actorDaemon, 0);
    }
    leaveRoom(actor) =
    {
        unnotify(dmvOfficial, &actorDaemon);
    }
;

dmvTest: readable
    noun = 'test'
    adjective = 'written'
    sdesc = "written test"
    answers = []
    question =
    [
        'What is the speed limit in a School Zone?
        \n\tA. 17\n\tB. 23\n\tC. 27\n\tD. 43\n\tE. 59'

        'What is the speed limit in a Hospital Zone?
        \n\tA. 17\n\tB. 23\n\tC. 27\n\tD. 43\n\tE. 59'

        'What is the speed limit in a Library Zone?
        \n\tA. 17\n\tB. 23\n\tC. 27\n\tD. 43\n\tE. 59'

        'What is the speed limit in a Freeway Zone?
        \n\tA. 17\n\tB. 23\n\tC. 27\n\tD. 43\n\tE. 59'

        'What is the speed limit in a Residential Zone?
        \n\tA. 17\n\tB. 23\n\tC. 27\n\tD. 43\n\tE. 59'

        'In which zone is the speed limit 17?
        \n\tA. School Zone
        \n\tB. Residential Zone
        \n\tC. Hospital Zone
        \n\tD. Library Zone
        \n\tE. Freeway Zone'

        'In which zone is the speed limit 23?
        \n\tA. School Zone
        \n\tB. Residential Zone
        \n\tC. Hospital Zone
        \n\tD. Library Zone
        \n\tE. Freeway Zone'

        'In which zone is the speed limit 59?
        \n\tA. School Zone
        \n\tB. Residential Zone
        \n\tC. Hospital Zone
        \n\tD. Library Zone
        \n\tE. Freeway Zone'

        'Given a regular pyramid with a square base, there is
        a sphere whose center is in the plane of the base of the pyramid
        and which is tangent to all edges of the pyramid. If each edge
        of the pyramid base is of length A, what is the height of the
        pyramid?
        \b\tA. A
        \n\tB. A/sqrt(2)
        \n\tC. A/2
        \n\tD. A*sqrt(2)
        \n\tE. A*2'

        'Given the pyramid and sphere from the previous question,
        what is the volume of the portion common to the sphere
        and the pyramid?
        \b\tA. (6*sqrt(2)/64 - 1/2) * pi * (A cubed)
        \n\tB. ((A/sqrt(2)) cubed)/3 * pi
        \n\tC. (7*sqrt(6)/54 - 1/4) * pi * (A cubed)
        \n\tD. (4/3) * pi * (A cubed)
        \n\tE. 4 * pi * (A cubed)'
    ]
    correctAnswers = ['B' 'C' 'E' 'D' 'A' 'B' 'A' 'D' 'B' 'C']
    ldesc =
    {
        local i, inp;

        "\b\t\tDMV Written Test
        \bThis test consists of 10 multiple-choice questions.
        Please consider each question carefully, and choose the
        letter of the answer that best completes the sentence or
        answers the question.
        \bThe minimum passing score is 70\% (7 out of 10) correct.
        \bWARNING: You are required to answer the questions on
        this test without any help. Anyone willfully giving answers
        to another person, or accepting answers from another person,
        is guilty of an immoral act. But, you're already in Hell,
        so who cares?\b
        \b*** APPLICANT MUST PROVIDE OWN NUMBER 2 PENCIL ***\b";

        if (not pencil.isIn(Me))
        {
            "Unfortunately, you don't seem to have a number 2 pencil, so
            you can't fill out the test.";
            return;
        }
        else if (not pencil.issharp)
        {
            "You luckily have a number 2 pencil, but unfortunately
            it's in need of sharpening.";
            return;
        }

        "Last Name: "; self.lastName := upper(input());
        "First Name: "; self.firstName := upper(input());
        "Middle Name: "; self.middleName := upper(input());
        "Age: "; self.licenseAge := input();

        self.oldanswers := answers;
        answers := [];
        for (i := 1 ; i <= length(question) ; ++i)
        {
            for (;;)
            {
                "\bQuestion << i >>:\b<< question[i] >>\b";
                if (length(oldanswers) >= i)
                    "Your original answer was << oldanswers[i]
                     >>.]  New answer [<< oldanswers[i] >>]:\ >";
                else
                    "Your answer:\ >";
                inp := upper(input());
                if (inp = '' and length(oldanswers) >= i)
                    inp := oldanswers[i];

                if (length(inp) <> 1 or find('ABCDE', inp) = nil)
                    "\bPlease enter the letter of your choice.\b";
                else
                    break;
            }
            answers += inp;
        }
    }
    verDoWrite(actor) = {}
    doWrite(actor) = { self.ldesc; }
    doSynonym('Write') = 'Fillout' 'Answer'
;

class archway: decoration
    sdesc = "archway"
    adesc = "an archway"
    noun = 'archway' 'arch'
;

archway1: archway
    ldesc = "It's simply an archway in the wall bounding the
        courtyard to the north."
    location = courtyard
;

archway2: archway
    ldesc = "It leads south."
    location = downtown
;

