/* Perdition's Flames - eastern Hell */
// copyright (c) 1993, 2002 by Michael J. Roberts.

suburbEast: room
    sdesc = "Outskirts"
    ldesc = "You're in a sparsely-populated rural area east of
        town.  The road leads west into the city, but ends here;
        to the east is an open field; you can also go south,
        where the terrain becomes rocky and hilly.  A small farmhouse
        lies to the north."
    north = farmhouse
    east = field
    south = rockyHills
    west = downtown2
;

fieldgrass: fixeditem
    sdesc = "scrubby grass"
    noun = 'grass' 'clump' 'clumps'
    adjective = 'scrubby'
    location = field
    ldesc = "It's brown and looks very tough."
;

mountainRange: distantItem
    sdesc = "mountain range"
    noun = 'range' 'volcano' 'mountains' 'mountain'
    adjective = 'mountain'
    location = field
    ldesc = "You can't make out much detail from this distance.
        The tallest point, to the southeast, looks like a volcano."
;

rabbit: Actor
    sdesc = "rabbit"
    noun = 'rabbit' 'jackrabbit'
    adjective = 'jack'
    ldesc = "It's a large jackrabbit.  It's hopping around happily,
        foraging for food."
    actorDesc = "There's a large jackrabbit hopping around, foraging
        for food."
    location = field
    actorDaemon =
    {
        "\bThe rabbit hops around the field.";
    }
    disavow = "Not surprisingly, the rabbit ignores your questions."
    verDoTake(actor) = {}
    doTake(actor) =
    {
        "The rabbit is too quick; it hops several feet away each
        time you get near it.";
    }
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) =
    {
        if (dobj = rope)
            self.ioThrowAt(actor, dobj);
        else
            "You can't get close enough to the rabbit.";
    }
    verDoLassoWith(actor, iobj) = {}
    doLassoWith(actor, iobj) = { self.ioThrowAt(actor, iobj); }
    doSynonym('LassoWith') = 'TakeWith'
    ioSynonym('PutOn') = 'TieTo' 'AttachTo' 'FastenTo'
    ioThrowAt(actor, dobj) =
    {
        if (dobj = rope)
        {
            actor.ropeSkill++;
            switch(actor.ropeSkill)
            {
            case 1:
                "You clumsily throw the rope at the rabbit, and miss
                by a mile.  You obviously need some practice at this.";
                break;

            case 2:
                "You throw the rope at the rabbit with a little more
                confidence, but the rabbit still easily evades the
                rope.";
                break;

            case 3:
                "You nearly catch the rabbit this time.  Maybe with
                a little more practice, you could snare it.";
                break;

            default:
                "You manage to catch the rabbit in the loop at the
                end of the rope!  You now feel quite confident with
                the rope.  (Wow!  Character development in
                a text adventure!  What will they think of next?)
                While you're standing there feeling smug, the rabbit
                wriggles its way out of the rope and runs off.";
                self.moveInto(nil);
                unnotify(self, &actorDaemon);
                break;
            }
        }
        else
        {
            "You miss.  The rabbit hops over to <<dobj.thedesc>> and
            sniffs it, then hops off a little ways.";
            dobj.moveInto(self.location);
        }
    }
;

field: room
    sdesc = "Field"
    ldesc = "You're in a large, open field.  The ground is peppered
        with clumps of scrubby grass.  A road lies to the west.
        You can see a tall mountain range in the distance to the
        southeast."
    west = suburbEast
    noexit =
    {
        "There's nothing in that direction except more of the
        same empty field.";
        return(nil);
    }
    enterRoom(actor) =
    {
        if (rabbit.location = self) notify(rabbit, &actorDaemon, 0);
        pass enterRoom;
    }
    leaveRoom(actor) =
    {
        if (rabbit.location = self) unnotify(rabbit, &actorDaemon);
        pass leaveRoom;
    }
;

radio: item
    sdesc = "portable radio"
    noun = 'radio' 'wavemaster' 'master'
    adjective = 'portable' '2000' 'wave' 'transistor'
    location = farmhouse
    ldesc = "It's a HadesCorp WaveMaster 2000 portable transistor radio.
        It has a dial that lets you set the frequency, and a switch
        for turning the radio on and off (the switch is currently
        in the << self.isActive ? "on" : "off" >> position).
        On the back is a small compartment."
    isActive = nil
    verDoTurnon(actor) = { if (self.isActive) "It's already on!"; }
    verDoTurnoff(actor) = { if (not self.isActive) "It's already off!"; }
    verIoPutIn(actor) = { radioCompartment.verIoPutIn(actor); }
    ioPutIn(actor, dobj) = { radioCompartment.ioPutIn(actor, dobj); }
    state = 0
    radioStations = [421 319]
    radioProg1 =
    {
        if (state > 7) state := 1;
        say([
        'The radio plays annoying heavy metal music.'
        'On the radio, an annoying heavy metal deejay talks
         about a radio contest.'
        'The radio blares a commercial for auto insurance.'
        'The radio blares a commercial for a guitar store.'
        'The radio blares a commercial for a diamond store that
         will give credit to anyone.'
        'The radio blares a commercial for an amulet store.'
        'On the radio, an annoying heavy metal "shock jock" makes
        a prank call to someone claiming that their sewer will back
        up unless they flush explosives down their toilets.'
        ][state]);
    }
    radioProg2 =
    {
        if (state > 18) state := 1;

        if (state <= 5)
        say([
        'The radio announces, "This is H-SPAN, the Hades Public Affairs
         Network. Next on: a discussion of the Motor Vehicle Code."'
        'An announcer on the radio says, "Welcome to Vehicle Code
        Forum. Today\'s topic is speed limits."'
        'A man on the radio says, "Many drivers find it very confusing
        that every type of zone has its own speed limit.  No two zones
        have the same speed limit.  In addition, there are too many
        types of zones -- we have School Zones, Hospital Zones, Library
        Zones, Residential Zones, and Freeway Zones.  This is more than
        we need."'
        'A woman on the radio says, "I believe that both Hospital Zones
        and 43 mile-per-hour zones need to be reconsidered."'
        'A man on the radio says, "Possibly, but I think it\'s a much
        more pressing problem that the color of speed limit signs in
        School Zones is blue."'
        ][state]);
        
        else if (state <= 10)
        say([
        'The woman on the radio responds, "What color would you suggest?  Green
        is already taken by 59 mile-per-hour zones."'
        'On the radio, a second woman enters the conversation. "Yes, but
        both School Zones and 27 mile-per-hour zones have large signs,
        while Library Zones -- not to mention 43 mile-per-hour zones --
        have only medium-sized signs. It doesn\'t seem appropriate somehow."'
        'The man on the radio says, "Now I\'ve forgotten -- is the speed
        limit in a residental zone 17 or 23 miles per hour?"'
        'The first woman on the radio says, "I can\'t remember, but
        I know that either School Zones or Hospital Zones are 23 miles
        per hour."'
        'The announcer comes back on the radio. "That\'s all the time
        we have for today\'s edition of Vehicle Code Forum. Next on,
        live coverage of the swearing-in ceremony for new civil servants
        in the Ministry of Information."'
        ][state - 5]);

        else
        say([
        'A man on the radio says, "Do you swear to uphold the
        procedures and policies of the Ministry of Information, to
        use appropriate rubber stamps on all forms, and to completely and
        accurately fill in all parts of forms marked Office Use
        Only and/or Do Not Write Above and/or Below Line?"'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        'Someone on the radio says, "I do."'
        ][state - 10]);
    }
    radioProgram = &radioProg1
    radioProgramList = [&radioProg1 &radioProg2]
    radioDaemon =
    {
        // don't announce anything if player not present, or battery missing
        if (not self.isVisible(Me) or goodBattery.location <> radioCompartment)
            return;

        "\b";

        // if set to bad station, emit some static
        if (radioProgram = nil)
        {
            "The radio emits static.";
            return;
        }

        ++state;
        self.(self.radioProgram);
    }
    doTurnon(actor) =
    {
        "The radio is now turned on.";
        notify(self, &radioDaemon, 0);
        self.isActive := true;
        if (goodBattery.location <> radioCompartment)
           " Nothing seems to happen, though.";
    }
    doTurnoff(actor) =
    {
        "The radio is now turned off.";
        unnotify(self, &radioDaemon);
        self.isActive := nil;
    }

    // redirect tune radio to number to turn radio dial to number
    verDoTuneTo(actor, iobj) = { radioDial.verDoTurnTo(actor, iobj); }
    doTuneTo(actor, iobj) = { radioDial.doTurnTo(actor, iobj); }

    // redirect open and close to the compartment
    verDoOpen(actor) = { radioCompartment.verDoOpen(actor); }
    doOpen(actor) = { radioCompartment.doOpen(actor); }
    verDoClose(actor) = { radioCompartment.verDoClose(actor); }
    doClose(actor) = { radioCompartment.doClose(actor); }
;

radioDial: dialItem
    noun = 'dial'
    adjective = 'radio'
    sdesc = "radio dial"
    location = radio
    maxsetting = 999
    setting = 421
    doTurnTo(actor, iobj) =
    {
        local station;

        // do the normal position setting
        inherited.doTurnTo(actor, iobj);

        // change program to match the setting
        station := find(radio.radioStations, self.setting);
        if (station = nil)
            radio.radioProgram := nil;
        else
            radio.radioProgram := radio.radioProgramList[station];
    }
;

radioSwitch: fixeditem
    noun = 'switch'
    adjective = 'radio' 'power' 'on-off'
    sdesc = "radio switch"
    location = radio
    ldesc = "It's currently << radio.isActive ? "on" : "off" >>."
    verDoTurnon(actor) = { radio.verDoTurnon(actor); }
    doTurnon(actor) = { radio.doTurnon(actor); }
    verDoTurnoff(actor) = { radio.verDoTurnoff(actor); }
    doTurnoff(actor) = { radio.doTurnoff(actor); }
;

radioCompartment: batteryCompartment, fixeditem
    noun = 'compartment'
    adjective = 'radio' 'small'
    sdesc = "radio compartment"
    location = radio
    isopen = nil
;

goodBattery: batteryItem
    adjective = 'durahell' 'type' 'hh'
    sdesc = "DuraHell battery"
    location = radioCompartment
    ldesc = "DuraHell type HH battery."
;

farmhouse: room
    sdesc = "Farmhouse"
    ldesc = "You're in a small, deserted, one-room farmhouse.  The
        building is very old and rickety, and all the paint has long
        since peeled off the walls.  You can go through doors to
        the south and east."
    south = suburbEast
    east = barnyard
;

barnyardWeeds: fixeditem
    noun = 'weed' 'weeds' 'plants' 'bunch'
    location = barnyard
    sdesc = "bunch of weeds"
    ldesc = "They're rather ugly, and not terribly interesting."
;

wellLever: fixeditem
    noun = 'lever'
    location = barnyard
    sdesc = "lever"
    verDoPull(actor) = {}
    doPull(actor) = { wellhead.doPump(actor); }
    doSynonym('Pull') = 'Push' 'Move' 'Pump'
;

wellSpout: fixeditem
    noun = 'spout'
    location = barnyard
    sdesc = "spout"
;    

wellhead: fixeditem
    noun = 'well' 'wellhead' 'head' 'pump'
    isqcontainer = true
    adjective = 'well' 'rusty' 'old'
    location = barnyard
    sdesc = "well"
    ldesc =
    {
        "It's a hand-pumped well.  It has a long lever, and a spout. ";
        if (bucket.location = self)
            "There's a bucket hanging from the well. ";
        "The pump looks very old and corroded. ";
    }
    verDoPump(actor) = {}
    doPump(actor) =
    {
        "You work the lever, to no avail; the well is long since dry.";
    }
;

bucketWater: fixeditem
    sdesc = "bucket water"
    adesc = "a quantity of water"
    noun = 'water' 'quantity'
    adjective = 'bucket'
    ldesc = "It's ordinary water."
    verDoPourOn(actor, iobj) = {}
    doPourOn(actor, iobj) =
    {
        "You pour the water. It immediately evaporates.";
        self.moveInto(nil);
    }
    doSynonym('PourOn') = 'PourIn' 'PutOn' 'PutIn'
    verDoDrink(actor) = {} 
    doDrink(actor) =
    {
        "You drink some of the water.  There's still plenty left.";
    }
    verIoDouseWith(actor) = {} 
    ioDouseWith(actor, dobj) = { dobj.doDouseWith(actor, self); }

    // throw water on foo is same as pour water on foo
    verDoThrowAt(actor, iobj) = {}
    verDoThrowOn(actor, iobj) = {}
    doThrowAt(actor, iobj) =
    {
        "You miss.  The water falls to the floor and evaporates.";
        self.moveInto(nil);
    }
;

bucket: item
    sdesc = "bucket"
    noun = 'bucket' 'pail'
    adjective = 'large' 'metal' 'rusty' 'old'
    location = wellhead
    ldesc =
    {
        "It's an old rusty metal bucket. It's ";
        if (self.contents <> [])
            "full of << contents[1].sdesc >>.";
        else
            "empty.";
    }
    verDoLookin(actor) = {}
    doLookin(actor) = { self.ldesc; }
    verIoPutIn(actor) =
    {
        if (self.contents <> []) "It's already full.";
    }
    ioPutIn(actor, dobj) =
    {
        if (dobj = lakeWater) self.doFillWith(actor, dobj);
        else "You can't put that in the bucket.";
    }
    verDoFillWith(actor, iobj) = { self.verIoPutIn(actor); }
    doFillWith(actor, iobj) =
    {
        if (iobj = lakeWater)
        {
            bucketWater.moveInto(self);
            "Okay, the bucket is now full of water.";
        }
        else
            "That doesn't seem to fit in the bucket.";
    }
    verDoEmpty(actor) =
    {
        if (self.contents = []) "There's nothing in the bucket.";
    }
    doEmpty(actor) =
    {
        "You pour the water onto the floor, where it quickly
        evaporates.";
        self.contents[1].moveInto(nil);
    }
;

barnyard: room
    sdesc = "Barnyard"
    ldesc =
    {
        "You're in a large yard outside an old, abandoned barn.
        The area is overgrown with weeds; it obviously hasn't been
        used in many years.  A rusty old wellhead sticks out of
        the weeds";
        if (bucket.location = wellhead)
            "; a large metal bucket is hanging from the well";
        ". ";

        "The farmhouse is to the west, and the
        entrance to the barn is to the north.";
    }
    north = barn
    west = farmhouse
;

barnStall: fixeditem
    sdesc = "stall"
    noun = 'stall' 'stalls'
    location = barn
    ldesc = "There's nothing interesting about them."
    verDoEnter(actor) =
    {
        "Why?  Hoping to return as a horse in your next life?";
    }
;

barnInsects: fixeditem
    sdesc = "insect"
    noun = 'insect' 'insects'
    location = barn
    ldesc = "You don't want to look too closely. These are the bugs
        from hell, after all."
;

pitchfork: item
    sdesc = "pitchfork"
    noun = 'pitchfork' 'fork' 'prong' 'prongs'
    adjective = 'pitch'
    location = barnHay
    ldesc = "It has a handle about five feet long, and three
        sharp metal prongs space about six inches apart."
    doTake(actor) =
    {
        inherited.doTake(actor);
        if (not self.istaken)
        {       
            " Now all you need is some horns and a pointy tail,
            and you'd own this place!";
            istaken := true;
        }
    }
    verIoTakeWith(actor) = {}
    ioTakeWith(actor, dobj) = { dobj.doTakeWith(actor, self); }
    ioSynonym('TakeWith') = 'MoveWith' 'PullWith' 'PushWith'
    verIoPryWith(actor) = {}
    ioPryWith(actor, dobj) =
    {
        "The pitchfork is too long and unwieldy.  You'll need
        something shorter.";
    }
    ioSynonym('PryWith') = 'OpenWith'
;

barnHay: fixeditem
    sdesc = "bale of hay"
    noun = 'bale' 'hay'
    location = barn
    isqcontainer = true
    ldesc =
    {
        "It's very old and damp, and many insects have made it
        their home.";
        if (not pitchfork.istaken) " There's a pitchfork stuck into it.";
    }
;

barn: room
    sdesc = "Barn"
    ldesc =
    {
        "You're in an old, rickety barn.  The area smells of
        rotting wood and damp decay.  The usual farm implements
        are scattered around the barn: ";

        if (pitchfork.location = barnHay)
            "a pitchfork stuck into ";

        "a bale of hay, several stalls for horses.
        \n\tIn the center of the barn is a small single-engine
        airplane.  It's
        an open-cockpit, high-wing tail-dragger.  It's painted
        a faded yellow.
        \n\tThe exit is to the south.";
    }
    south = barnyard
    out = barnyard
;

airplaneEngine: fixeditem
    sdesc = "engine"
    noun = 'engine'
    location = barn
    ldesc = "Several large pieces of the engine have been removed,
        and what's left is obviously not in airworthy condition."
;

airplane: fixeditem
    location = barn
    sdesc = "plane"
    noun = 'airplane' 'tail-dragger' 'cockpit' 'plane'
    adjective = 'high-wing' 'high' 'wing'
    ldesc = "It's a tail-dragger with an open cockpit.  Unfortunately,
        it doesn't look like there's any hope that it can be made
        to work; the engine looks dismantled and corroded.  It looks
        like you could get in the plane if you wanted, though. "
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(airplaneRoom); }
    doSynonym('Enter') = 'Board'
;

airplaneHole: fixeditem, qcontainer
    location = airplaneRoom
    noun = 'hole'
    adjective = 'gaping'
    sdesc = "gaping hole"
;

airplaneCompartment: fixeditem, openable
    location = airplaneRoom
    noun = 'compartment' 'panel' 'cover' 'door'
    sdesc = "storage compartment"
    adjective = 'large' 'storage'
    isjammed = true
    isopen = nil
    doOpen(actor) =
    {
        if (self.isjammed)
            "It's jammed shut; you'll need to get something to
            pry it open with.";
        else
            pass doOpen;
    }
    verDoPryWith(actor, iobj) =
    {
        if (self.isopen) "It's already open!";
        else if (not self.isjammed) "That's not necessary -- just open it.";
    }
    doPryWith(actor, iobj) =
    {
        if (iobj = crowbar)
        {
            isjammed := nil;
            "You jam the crowbar under the compartment door and
            start prying. After a few moments, you hear a loud
            snap, and the door pops open. ";
            self.doOpen(actor);
            awardPoints(13, self);
        }
    }
    doSynonym('PryWith') = 'OpenWith'
;    

fakeAirplane: closedRefItem
    noun = 'airplane' 'cockpit' 'plane' 'airframe'
    sdesc = "cockpit"
    location = airplaneRoom
 ;

airplaneRoom: closedNestedRoom
    myRefItem = fakeAirplane
    sdesc = "cockpit"
    ldesc = "You're in the cockpit of a very old airplane.  From here,
        you can see just how hopeless it would be to try to get it
        flying: the control stick has been removed, leaving a gaping
        hole in the floor, and the airframe is quite rotted.
        \n\tEven the seat has been removed.  At the rear of the
        cockpit area is a large compartment, which is <<
        airplaneCompartment.isopen ? "open" : "closed" >>."
    out = barn
    doSynonym('Unboard') = 'Climbdown'
;

volcano: decoration
    location = rockyHills
    noun = 'volcano'
    sdesc = "volcano"
    ldesc = "The volcano appears to be active, judging by the clouds
        of dark smoke rising steadily from the mouth."
;

volcanoSmoke: decoration
    location = rockyHills
    noun = 'smoke' 'cloud' 'clouds'
    adjective = 'dark'
    sdesc = "cloud of smoke"
;

rockyHills: room
    sdesc = "Rocky Hillside"
    ldesc = "You're on a gently sloping, rocky hillside at the base
        of a tall mountain.  The granite surface of the hillside hosts
        no vegetation.  Looming high above to the east is the steep
        cone of a volcano; clouds of dark smoke rise steadily above
        the cone.
        You can climb into the mountains to the east, and you can also
        go north, back to the road."
    north = suburbEast
    up = mountainside
    east = mountainside
    noexit =
    {
        "The terrain is too rocky that way.";
        return(nil);
    }
;

volcano2: decoration
    sdesc = "volcano"
    noun = 'volcano' 'cone'
    location = mountainside
    ldesc = "The volcano looms above to the east.  From this close range,
        you can see a red glow reflecting off of the cloud of smoke
        rising above the volcano.  You could probably climb up the cone."
;

tower2: decoration
    noun = 'tower' 'building'
    location = mountainside
    sdesc = "tower"
    ldesc = "From here, the tower looks like a silver thread
        against the black night sky. Even from this distance,
        you can't see how high the tower is -- it goes up
        into the sky as far as you can see."
;

mountainside: room
    sdesc = "Mountainside"
    ldesc = "You're fairly high up on the side of the mountain -- you'd
        guess that you're around two thousand feet up.  (Have you noticed
        that they use the English system of measurements in Hell?
        What else would you expect?)  You can go down the mountain
        to the west, and the volcano's cone looms above to the east.
        A small opening appears to lead into a cave to the south.
        You can also travel along a path to the north, and a narrow
        passage to the southeast.
        \n\tYou have an excellent view of
        Hell from here.  The tall buildings downtown all seem tiny
        from this distance and altitude, except for the Tower -- even
        from here, you can't see the top.  The Tower looks like a
        thin, gleaming string stretching from the ground up into the
        dark sky.  As your eyes follow the Tower up into the sky,
        you realize that you're high enough above the surface now
        that you can see stars above -- so many stars, all so bright,
        that it's quite well lit here."
    down = rockyHills
    west = rockyHills
    up = volcanoTop
    east = volcanoTop
    south = mountainCave
    north = mountainLake
    se = rockyPassage
;

volcano3: decoration
    sdesc = "mouth of the volcano"
    noun = 'volcano' 'mouth' 'cone'
    location = volcanoTop
    ldesc = "It's hard to see much, thanks to all of the
        steam and dust rising out of the cauldron, but
        you can see quite a lot of red-hot, glowing, molten
        rock."
    verDoLookin(actor) = {}
    doLookin(actor) = { self.ldesc; }
;

volcanoTop: room
    sdesc = "Top of Volcano"
    ldesc = "You're standing at the rim of the volcano.  Below,
        tons of glowing red-hot molten rock churn and bubble.
        You can climb down the mountain to the west."
    west = mountainside
    down = mountainside
    east =
    {
        "Even though you're already dead, you don't think
        jumping into the volcano would be very pleasant.";
        return(nil);
    }
;

mountainCave: room
    sdesc = "Lava Cave"
    ldesc = "You're in a large, cylindrical cave with smooth, black
        walls.  Running through the south end of the cave is a
        wide, swiftly-flowing river of lava, which flows downhill
        to the east.  The lava pours in through an orifice in the
        western wall.  An exit leads back outside to the north."
    north =
    {
        if (heatShield.location = lavaRiver)
        {
            "You take the heat shield back out of the lava as you leave.\b";
            heatShield.moveInto(Me);
        }
        return(mountainside);
    }
    out = { return(self.north); }
    east =
    {
        "If you want to swim in the river, just say so.";
        return(nil);
    }
    west = { return(east); }
    south = lavaRoom1
;

// Lava River Daemon - move the actor or the vehicle containing the
// actor downstream.  The 'boat' parameter is what is to be moved -
// it should be either Me or an appropriate vehicle.  We'll call
// the travelTo method in the boat in any case, so any vehicle
// that can travel in the laval river needs to define travelTo.
lavaDaemon: function(boat)
{
    // don't do anything if player is not in river
    if (boat <> Me and Me.location <> boat) return;

    // don't go anywhere on the first turn right after getting in the river
    if (not boat.lavaMoved)
    {
        boat.lavaMoved := true;
        "\bThe lava flow starts to carry you downstream.";
        return;
    }

    switch(boat.location)
    {
    case lavaRoom1:
        "\bThe swift river of lava sweeps you downstream to
        the east.\b";
        boat.travelTo(lavaRoom2);
        break;

    case lavaRoom2:
        "\bYou're carried rapidly to the south by the flowing
        lava.\b";
        boat.travelTo(lavaRoom3);
        break;

    case lavaRoom3:
        "\bThe lava sweeps you along to the south.\b";
        boat.travelTo(lavafall);
        break;

    case lavafall:
        "\bBefore you can do anything, the river carries you
        over the edge of the lavafall.  You fall and fall, tumbling
        and flailing your arms and legs, catching a glimpse of
        the bottom of the lavafall lost in the rocks far below.
        Suddenly, you hit something, and your fall stops
        abruptly.\b";

        // if the player is in a boat, separate them...
        if (boat <> Me) boat.moveInto(lavaLedge);
        Me.isInLava := nil;
        Me.travelTo(lavaLedge);
        remdaemon(lavaDaemon, boat);
    }
}

heatShield: vehicle
    reachable =
    {
        return(self.location.contents + self);
    }
    statusPrep = "in"
    isListed = nil
    sdesc = "heat shield"
    ldesc = "It's a big piece of a strange, black, flexible material,
       about half an inch thick.  It's shaped like a shallow bowl
       about three feet in diameter."
    location = rocketLab
    noun = 'shield' 'heatshield'
    adjective = 'heat'
    travelTo(loc) =
    {
        self.moveInto(loc);
        self.lookAround(true);
    }
    doTake(actor) =
    {
        inherited.doTake(actor);
        awardPoints(13, self);
        isListed := true;
    }
    verDoBoard(actor) =
    {
        if (self.isIn(actor)) "You'll have to drop it first.";
        pass verDoBoard;
    }
    doBoard(actor) =
    {
        inherited.doBoard(actor);
        if (isclass(location, lavaRiverItem))
        {
            self.lavaMoved := nil;
            self.moveInto(location.lavaDest);
            isListed := nil;
            Me.isInLava := true;
            setdaemon(lavaDaemon, self);
        }
    }
    leaveRoom(actor) =
    {
        isListed := true;
        pass leaveRoom;
    }
    doUnboard(actor) =
    {
        if (location.isLavaRiverRoom) "This isn't a very good place.";
        else pass doUnboard;
    }
    out =
    {
        if (location.isLavaRiverRoom)
        {
            "This really isn't a good place to get out.";
            return(nil);
        }
        else
            pass out;  // ha, ha!  funny TADS joke!
    }
;

// lava river that you're already in
class lavaRiverItem2: fixeditem
    verDoUnboard(actor) =
    {
        "It's not clear how to extricate yourself from the lava.";
    }
    noun = 'lava' 'river'
    sdesc = "river of lava"
    doSynonym('Inspect') = 'Lookin'
    verDoWade(actor) =
    {
        "You're already in the river of lava.";
    }
    doSynonym('Wade') = 'Swim' 'Enter' 'Board'
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        "There's no reason to let go of that here.";
    }
    ioSynonym('PutIn') = 'PutOn'
;

// lava river that you can enter
class lavaRiverItem: fixeditem
    isqcontainer = true
    sdesc = "river of lava"
    noun = 'river' 'lava'
    ldesc =
    {
        "It's a swiftly-flowing river of molten lava.
        It flows to the <<self.lavaDir>>.";

        if (heatShield.location = self)
            " The heat shield is floating in the lava (you're
            holding onto it, though, so it doesn't get carried
            away).";
    }
    doSynonym('Inspect') = 'Lookin'
    verDoWade(actor) = {}
    doWade(actor) = { actor.travelTo(self.lavaDest); }
    doSynonym('Wade') = 'Swim' 'Enter' 'Board'
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = heatShield)
        {
            "You put the heat shield in the lava -- it floats
            on the flowing lava, and seems easily able to
            withstand the heat.  You hold onto it so it
            doesn't float away.";
            dobj.moveInto(self);
        }
        else
            "Better not -- it would probably melt.";
    }
    ioSynonym('PutIn') = 'PutOn'
;

lavaRiver: lavaRiverItem
    location = mountainCave
    lavaDir = "east"
    lavaDest = lavaRoom1
;

lavafallobj: fixeditem
    sdesc = "lavafall"
    noun = 'lava' 'fall' 'lavafall'
    adjective = 'lava'
    location = lavaLedge
;

mountainledge: room
    sdesc = "Ledge"
    ldesc = "You're on a narrow ledge high up on the mountainside.
        The ledge continues to the southeast and northwest."
    se = lavaLedge
    nw =
    {
        "You walk carefully along the ledge, but you suddenly
        hit a loose spot.  You try to maintain your footing,
        but the rock crumbles under you, and you go sliding
        down the mountainside.  You finally stop falling,
        and you find yourself on a rocky hillside you've
        seen before.\b";
        return(rockyHills);
    }
;

lavaLedge: room
    sdesc = "Ledge near Lavafall"
    ldesc = "You're on a ledge just west of, and halfway up,
        a huge lavafall.  The lava pours down with a deafening
        rumbling sound. The narrow ledge seems to continue
        to the northwest."
    nw = mountainledge
    east =
    {
        "You try to get back into the lavafall, but the
        pressure of the lava pushes you back.  You're just
        as happy to stay out of the molten rock, anyway.";
        return(nil);
    }
;

lavafallRiver: lavaRiverItem2
    location = lavafall
;

lavafall: lavaRiverRoom
    sdesc = "Top of Lavafall"
    ldesc = "The cave abruptly opens into the night sky, and
        you realize that you're at the top of a cliff.  The
        lava is pouring over the edge of the cliff and falling
        hundreds of feet down the side of the mountain below."
    noexit = 
    {
        "The lava is moving too swiftly.";
        return(nil);
    }
;

lavaRiverRoom: room
    roomDrop(obj) =
    {
        "You let go of << obj.thedesc >>.  A faster current catches
        hold of it; << obj.thedesc >> disappears downriver.";
        obj.moveInto(lavaLedge);
    }
    isLavaRiverRoom = true
    enterRoom(actor) =
    {
        if (heatShield.location <> nil
            and isclass(heatShield.location, lavaRiverItem))
        {
            "(You retrieve the heat shield first.)\n";
            heatShield.moveInto(actor);
        }
        if (not Me.isInLava)
        {
            "The searing heat of the lava shoots through your body, making
            you try desperately to escape the river.  As you flail around,
            though, you start to realize that the lava isn't harming you,
            despite the intense pain.  As you start to get used to the
            blistering heat, you notice that you're being swept rapidly
            downstream...\b";

            setdaemon(&lavaDaemon, actor);
            Me.isInLava := true;
            actor.lavaMoved := nil;
        }
        pass enterRoom;
    }
;

goldDiskAmulet: amuletItem
    sdesc = "genuine gold disk"
    noun = 'disk' 'amulet'
    adjective = 'big' 'large' 'gold' 'genuine'
    location = lavaRoom4
    ldesc = "It's a large gold disk with complex etchings.  The
        pattern of etchings resembles a starburst:  a central circle
        with lines radiating.  The disk is attached to a gold chain,
        for wearing the amulet around the neck."
;

lavaRiver4: lavaRiverItem
    location = lavaRoom4
    lavaDir = "south"
    lavaDest = lavaRoom3
;

stalagmite2: fixeditem
    sdesc = "stalagmite"
    ldesc = "The particularly tall stalagmite is at least
        three feet tall."
    noun = 'stalagmite'
    adjective = 'tall' 'large' 'particularly'
    location = lavaRoom4
;

lavaRoom4: room
    sdesc = "Landing"
    ldesc = "You're on the shore of a lava river, which flows by
        to the east.  There is no exit from this cave apart from
        the river."
    east = lavaRoom3
;

stalagmite: fixeditem
    sdesc = "stalagmite"
    ldesc = "The particularly tall stalagmite is at least
        three feet tall. It's about ten feet away from you."
    noun = 'stalagmite'
    adjective = 'tall' 'large' 'particularly'
    location = lavaRoom3
    verDoTake(actor) =
    {
        "It's ten feet away!  You can't reach it from here.";
    }
    doSynonym('Take') = 'Grab'
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) =
    {
        if (dobj = rope)
            self.ioThrowAt(actor, dobj);
        else
            "The stalagmite is too far away -- you can't reach
            it from here.";
    }
    ioSynonym('PutOn') = 'TieTo' 'AttachTo' 'FastenTo'
    verDoLassoWith(actor, iobj) = {}
    doLassoWith(actor, iobj) = { self.ioThrowAt(actor, iobj); }
    doSynonym('LassoWith') = 'TakeWith'
    ioThrowAt(actor, dobj) =
    {
        if (dobj = rope)
        {
            if (actor.location = self.location)
                "You're up to your ears in lava.  You can't
                manage to throw the rope while submerged like this.";
            else if (actor.ropeSkill < 4)
            {
                "You throw the rope at the stalagmite, but your aim
                isn't good enough; the rope falls short.  You obviously
                could use some practice.";
            }
            else
            {
                "Your throw the rope at the stalagmite with a practiced
                aim.  The loop at the end of the rope hooks around the
                stalagmite.  You easily pull yourself to shore, get
                out of the heat shield, and untie the rope.\b";

                // actor is in some kind of boat - remove lavaDaemon
                remdaemon(lavaDaemon, actor.location);
                Me.isInLava := nil;

                // move actor to cave, and grab heat shield
                heatShield.moveInto(actor);
                actor.travelTo(lavaRoom4);
            }
        }
        else
            "It simply bounces off and falls into the river.  You manage
            to recover <<dobj.thedesc>> before it disappears in the lava.";
    }
    ioSynonym('ThrowAt') = 'PutOn' 'FastenTo' 'TieTo' 'LassoWith'
;

lavaRoom3River: lavaRiverItem2
    location = lavaRoom3
;

lavaRoom3: lavaRiverRoom
    sdesc = "River of Lava"
    ldesc = "The river of lava is flowing through the
        cave swiftly to the south.  To the west is
        a shore that appears to open into a cave.  The cave
        has many stalagmites sticking up from its floor; one
        particularly large stalagmite right on the shore -- only
        about ten feet away from you -- is
        at least three feet tall.
        \n\tThere's a faint light downstream, and you hear a
        loud rushing noise from the south."
    west =
    {
        "You try to make it up onto the shore, but the current
        is too strong for you.";
        return(nil);
    }
    noexit =
    {
        "The lava carries you along too quickly.";
        return(nil);
    }
;

lavaRoom2River: lavaRiverItem2
    location = lavaRoom2
;

lavaRoom2: lavaRiverRoom
    sdesc = "Bend in River"
    ldesc = "The river of lava turns from east to south
        here."
    noexit =
    {
        "You can't seem to escape from the river.";
        return(nil);
    }
;

lavaRoom1River: lavaRiverItem2
    location = lavaRoom1
;

lavaRoom1: lavaRiverRoom
    sdesc = "River of Lava"
    ldesc = "The river of lava is flowing swiftly downhill
        to the east."
    noexit =
    {
        "The lava is carrying you along too swiftly.";
        return(nil);
    }
;

flippers: clothingItem
    location = dumpsterRoom
    noun = 'flipper' 'flippers' 'pair'
    adjective = 'big' 'green'
    sdesc = "pair of flippers"
    ldesc = "They're big, green swimming flippers.  You'd probably
        be able to swim like a fish wearing them."
    moveInto(obj) =
    {
        if (self.location = dumpsterRoom) dummyFlippers.moveInto(nil);
        inherited.moveInto(obj);
        awardPoints(13, self);
    }
;

mountainLake: room
    sdesc = "Lake Shore"
    ldesc = "You're on the shore of a beautiful clear blue mountain lake.
        The lake is huge -- it looks like it's almost a mile across.
        The water is very still and clear.
        The lake is circled by high cliffs, except here, where you could
        easily wade into the water.  A path leads south."
    south = mountainside
    east = lake1
;

lakeWater: fixeditem
    sdesc = "lake water"
    noun = 'lake' 'water'
    adjective = 'clear' 'blue' 'beautiful' 'huge' 'big'
    location = mountainLake
    ldesc = "The lake is a beautiful clear blue.  The water looks
        very deep."
    verDoSwim(actor) = {}
    doSwim(actor) = { actor.travelTo(lake1); }
    doSynonym('Swim') = 'Wade' 'Enter' 'Board'
    verDoDrink(actor) = {}
    doDrink(actor) = { "The water is very cold and clean."; }

    // allow 'put water in bucket' or 'fill bucket with water'
    verIoFillWith(actor) = {}
    ioFillWith(actor, dobj) = { dobj.doFillWith(actor, self); }
    verDoPutIn(actor, iobj) =
    {
        if (iobj <> bucket and iobj <> toxicola)
            pass verDoPutIn;
    }
    verIoPutIn(actor) =
    {
        "Better not; it would just sink.";
    }
;

lakeDaemon: function(actor)
{
    switch(actor.location)
    {
    case lake1:
        "\bYou try to fight the undertow, but it's just too
        strong.  It drags you underwater.\b";
        actor.travelTo(lake3);
        break;

    case lake3:
        "\bThe undertow drags you down, away from the cave.\b";
        actor.travelTo(lakeFloor);
        break;

    case lake4:
        "\bThe undertow drags you down toward the lake floor.\b";
        actor.travelTo(lakeFloor);
        break;

    case lakeFloor:
        "\bYou're dragged helplessly toward the whirlpool.
        You try to swim against it, but it's too strong.  You
        get nearer and nearer the hole.  You start tumbling
        over and over in the turbulent waters; your head hits
        a rock, then your arm, then a leg.
        \n\tYou're barely able to see what's happening as
        you're battered against the rocks, but you realize that
        you're falling through a narrow tunnel.  You're on your back,
        moving head-first through the tunnel.
        \n\tYou lose track of how much time you're bounced
        around inside the tunnel, but you eventually emerge
        into a raging river pouring down the hillside.  You
        tumble and crash into even more rocks as you're washed
        down the rocky riverbed.
        \n\tYou pass under a bridge, trying to grab onto
        something but finding nothing to hold onto.  The water
        continues to drag you downstream.  You manage to get
        your head above water long enough to look at what's
        coming, and you see a dense tangle of tree branches
        up ahead.  You brace yourself just in time, and crash
        into the thicket.
        \n\tIt's difficult, but you manage to untangle yourself
        from the tree branches, and climb out onto the riverbank.\b";
        actor.travelTo(riverBank);
        remdaemon(lakeDaemon, actor);
        break;
    }
}

thicket: fixeditem
    sdesc = "thicket"
    noun = 'thicket' 'branch' 'branches' 'tangle' 'tree' 'trees'
    adjective = 'wood' 'tangled'
    location = riverBank
;

class riverBankRiverItem: fixeditem
    sdesc = "river"
    noun = 'river'
    ldesc = "The river is flowing very swiftly here."
    verDoEnter(actor) = { "The water is flowing too swiftly."; }
    doSynonym('Enter') = 'Swim' 'Wade'
;

riverBankRiver: riverBankRiverItem
    location = riverBank
;

riverBank: room
    sdesc = "River Bank"
    ldesc = "You're on the west bank of a river.  The river is blocked
        to the south by a dense tangle of tree branches.  A path leads
        north."
    north = riverBank2
    east = { "You can't get past the thicket."; return(nil); }
;

riverRocks: fixeditem
    noun = 'rock' 'rocks' 'boulder' 'boulders'
    sdesc = "rock"
    location = riverBank2
    ldesc = "They're just rocks."
;

riverBank2: room
    sdesc = "River Bank"
    ldesc = "You're on the west bank of a river.  The water
        pours rapidly over huge rocks in the river.  A bridge
        crosses the river to the east.  A narrow path climbs
        steeply up the hill to the northwest, and you can follow
        the river to the south."
    nw = riverPath
    up = riverPath
    east = bridge
    south = riverBank
;

riverBank2River: riverBankRiverItem
    location = riverBank2
;

class riverBankBridgeItem: fixeditem
    sdesc = "bridge"
    noun = 'bridge'
;

riverBank2Bridge: riverBankBridgeItem
    ldesc = "The bridge crosses the river to the east."
    location = riverBank2
;

riverBank3Bridge: riverBankBridgeItem
    ldesc = "The bridge crosses the river to the west."
    location = riverBank3
;

riverBridgeBridge: riverBankBridgeItem
    ldesc = "You're standing on it."
    location = bridge
;

riverPathRiver: distantItem
    sdesc = "river"
    noun = 'river'
    location = riverPath
;

riverPath: room
    sdesc = "Steep Path"
    ldesc = "You're on a path that climbs up a sheer cliff face.
        The path goes down to the river to the southeast, and climbs steeply
        to the southwest."
    se = riverBank2
    sw = riverPath2
    up = (self.sw)
    down = (self.se)
;

riverPath2: room
    sdesc = "Clifftop"
    ldesc = "You're on a steeply climbing path near the top of a cliff.
        The path descends to the northeast, and continues to the west."
    west = rockyPassage
    ne = riverPath
    down = (self.ne)
;

rockyPassage: room
    sdesc = "Rocky Passage"
    ldesc = "You're in a narrow passage among the rocks.  You can
        squeeze through to the east and northwest."
    east = riverPath2
    nw = mountainside
;

rockyPassageRocks: fixeditem
    sdesc = "rock"
    noun = 'rock' 'rocks' 'boulder'
    ldesc = "They're just big rocks."
    location = rockyPassage
;

bridgeRiver: riverBankRiverItem
    location = riverBank
;

bridge: room
    sdesc = "Bridge"
    ldesc = "You're at the center of a bridge that travels
        east and west across a raging rapids below."
    east = 
    {
        if (troll.satisfied)
        {
            "The Troll steps aside with an elaborate bow,
            allowing you to pass.\b";
            return(riverBank3);
        }
        else
        {
            "The troll blocks your path.";
            return(nil);
        }
    }
    leaveRoom(actor) =
    {
        unnotify(troll, &actorDaemon);
        pass leaveRoom;
    }
    enterRoom(actor) =
    {
        notify(troll, &actorDaemon, 0);
        pass enterRoom;
    }
    west = riverBank2
;

trollAxe: fixeditem
    sdesc = "axe"
    noun = 'axe'
    location = bridge
    ldesc = "It looks viscous.  You wouldn't want to be caught along
        its line of travel, especially when wielded by the Troll."
;

troll: Actor
    isHim = true      // well, it seems reasonable anyway
    sdesc = "Troll"
    noun = 'troll'
    adjective = 'evil'
    location = bridge
    actorDesc =
    {
        if (self.satisfied)
            "There's a large Troll standing guard on the bridge.
            He is making way for you to pass.";
        else
            "There's a large hairy Troll standing in the
            center of the bridge, blocking your way.";
    }
    ldesc = "It's a huge beast, standing ten feet high,
        covered with bristly black hair and wielding a
        double-edged axe."
    actorDaemon =
    {
        if (self.satisfied)
            "\bThe Troll stands guard, watching for impostors.";
        else
            "\bThe Troll watches you suspiciously.";
    }
    actorAction(v, dobj, prep, iobj) =
    {
        "The Troll doesn't appear to speak your language.
        Your statements just seem to agitate it.";
        exit;
    }
    verDoAskAbout(actor, iobj) =
    {
        "The Troll doesn't appear to speak your language.
        Your questions just seem to agitate it.";
    }
    verIoShowTo(actor) = {}
    ioShowTo(actor, dobj) =
    {
        if (dobj = goldskull)
        {
            "The Troll takes << dobj.thedesc >> from you.  He's obviously
            impressed; he inspects <<dobj.thedesc>> carefully,
            turning it over in his hands and examining
            the detail.  Evidently convinced of its authenticity, he
            hands it back to you, then stands back and waves you past.";

            self.satisfied := true;
            awardPoints(19, self);
        }
        else
            "The Troll takes one look at <<dobj.thedesc>> and rejects your
            offer with a snarl, shoving it away with a backhanded slap.";
    }
    ioSynonym('ShowTo') = 'GiveTo'
;

lakeSwim: function(dest)
{
    if (flippers.isIn(Me) and flippers.isworn)
        return(dest);
    else
    {
        "You try to swim against the undertow, but the
        current drags you down.";
        return(nil);
    }
}

lake1: room
    sdesc = "Swimming on the lake"
    ldesc = "You're swimming on the lake.  The shore is to
        the west.  A rocky ledge to the north prevents travel
        in that direction, but you can go east or south.
        \n\tYou didn't notice from the shore, but there seems
        to be a very strong undertow pulling you underwater."
    enterRoom(actor) =
    {
        setdaemon(lakeDaemon, actor);
        pass enterRoom;
    }
    west = { return(lakeSwim(mountainLake)); }
    down = { return(lakeSwim(lake3)); }
    noexit = { "It's too rocky that way."; return(nil); }
;

lake3: room
    sdesc = "Underwater"
    ldesc = "You're underwater in the lake.  To the north
        is a rocky wall, but there's an opening that could
        be the mouth of a cave.  The rocky wall of the shore
        is to the west, but you can go east and south. You
        are well below the surface, but the lake floor is
        still a ways below."
    down = { return(lakeSwim(lake4)); }
    east = { return(lakeSwim(lake4)); }
    north = { return(lakeSwim(lakeCave)); }
    noexit = { "The undertow is too strong."; return(nil); }
;

jewelAmulet: amuletItem
    location = lakeCave
    sdesc = "genuine jewel stone"
    noun = 'stone' 'amulet'
    adjective = 'jewel' 'light' 'blue' 'clear' 'genuine'
    ldesc = "It's a large, multi-faceted, clear blue jewel stone.
        It's attached to a gold chain, for wearing it around the neck."
;

lakeCave: room
    sdesc = "Underwater Cave"
    ldesc = "You're in an underwater cave, which is fully submerged.
        The only exit leads
        back into the lake to the south."
    enterRoom(actor) =
    {
        local first_time := not self.isseen;

        inherited.enterRoom(actor);
        if (first_time)
        {
            "\bYou notice that's it's been quite a while since you
            were able to inhale air.  As you think about this, you
            become faint, and reach for something for support.  After
            a few moments, though, you realize that, apart from the
            great discomfort of holding your breath for an extended
            period, you're quite capable of going on without breathing.";
        }
    }
    south = lake3
;

lake4: room
    sdesc = "Underwater"
    ldesc = "You're underwater in the lake. You are far below
       the surface, but the lake floor is still a ways below."
    down = { return(lakeSwim(lakeFloor)); }
    noexit = { "The undertow is too strong."; return(nil); }
;

lakeFloor: room
    sdesc = "Lake Floor"
    ldesc = "You're deep underwater, just above the rocky bottom of
        the lake.  The water is swirling violently around a depression
        in the rocky floor -- you realize that it's a whirlpool!"
    noexit = { "You can't swim against the whirlpool current."; return(nil); }
;

class riverBankTrees: fixeditem
    sdesc = "forest"
    noun = 'tree' 'trees' 'forest' 'woods'
    adjective = 'dense'
    ldesc = "It's a very dense forest. You probably wouldn't
        have much luck traveling through the thick undergrowth
        off the path."
    verDoClimb(actor) =
    {
        "Sorry, but the High Energy Software Adventure Style Guide
        specifies that no extraneous activities shall be implemented
        in the denoument section of the game.";
    }
;

riverBank3River: riverBankRiverItem
    location = riverBank3
;

riverBank3Trees: riverBankTrees
    location = riverBank3
;

riverBank3: room
    sdesc = "River Bank"
    ldesc = "You're on the east bank of a river. A bridge
        leads over the river to the west.  A dense forest
        lines this side of the river.  A path leads into the
        forest to the southeast."
    west = bridge
    se = forestClearing
;

forestClearingTrees: riverBankTrees
    location = forestClearing
;

class forestGate: doorway
    sdesc = "gate"
    noun = 'gate'
    adjective = 'iron'
    isopen = true
;

forestGate1: forestGate
    location = forestClearing
    otherside = forestGate2
    doordest = clubLawn
;

forestWall: fixeditem
    sdesc = "brick wall"
    noun = 'wall'
    adjective = 'short' 'brick'
    location = forestClearing
    ldesc = "It's about four feet high.  It appears to be merely
        decorative."
;

forestClearing: room
    sdesc = "Forest Clearing"
    ldesc = "You're in a forest clearing.  To the south is an iron
        gate (which is <<forestGate.isopen ? "open" : "closed">>) set
        into a short brick wall; beyond the gate is a lush green lawn.
        A path leads into the forest to the northwest."
    south = forestGate1
    nw = riverBank3
;

mansion: fixeditem
    sdesc = "mansion"
    noun = 'mansion' 'house'
    adjective = 'stately'
    location = clubLawn
    ldesc = "It's a large manor house built of brick and dark
        wood."
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(clubHouse); }
;

forestGate2: forestGate
    location = clubLawn
    otherside = forestGate1
    doordest = forestClearing
;

clubLawnLawn: decoration
    sdesc = "lawn"
    noun = 'lawn' 'grass'
    adjective = 'lush' 'green'
    location = clubLawn
;

clubLawn: room
    sdesc = "Lawn"
    ldesc = "You're on a large, lush green lawn outside a
        stately mansion; the entrance to the mansion is to the
        south.  To the north is a gate leading back out
        into the surrounding forest."
    north = forestGate2
    south = clubHouse
    in = clubHouse
;

clubWestDoor: doorway
    isopen = nil
    noAutoOpen = true
    islocked = true
    doordest = clubPier
    location = clubHouse
    sdesc = "door"
    noun = 'door'
    verDoUnlock(actor) = { "It's not obvious how to do that."; }
    verDoUnlockWith(actor, iobj) = { "You can't."; }
;

clubHouse: room
    sdesc = "Entryway"
    ldesc = "You're in a wide hallway.  A door (which is
        << clubWestDoor.isopen ? "open" : "closed" >>)
        is to the west, and the hallway continues to the
        south.  The exit is to the north."
    north = clubLawn
    out = (self.north)
    west = clubWestDoor
    south = clubRoom
;

clubTrophies: fixeditem
    location = clubRoom
    sdesc = "trophy"
    noun = 'trophy' 'trophies'
    ldesc = "They're mostly hunting trophies; there's nothing too
        notable about them."
;

clubChairs: chairitem
    location = clubRoom
    sdesc = "chair"
    noun = 'chair' 'chairs'
    adjective = 'leather' 'dark'
;

clubWindows: fixeditem
    location = clubRoom
    sdesc = "window"
    noun = 'window' 'windows'
    adjective = 'large' 'numerous'
    doSynonym('Inspect') = 'Lookthru'
    ldesc = "The windows provide a nice view of the surrounding lawn."
;

clubWindowLawn: distantItem
    location = clubRoom
    noun = 'lawn'
    adjective = 'surrounding'
    sdesc = "lawn"
;

clubRoom: room
    sdesc = "Club Room"
    ldesc = "You're in a spacious, warm room.  The oak-paneled walls
        are decorated with various trophies, and many dark leather chairs
        are placed
        around the room.  Numerous large windows provide the room
        with plenty of light and a relaxing view of the grounds.
        The exit is to the north."
    north = clubHouse
    out = (self.north)
    enterRoom(actor) =
    {
        local first_time := not self.isseen;

        inherited.enterRoom(actor);
        if (first_time)
        {
            "\n\tAs you enter, a portly, white-haired man dressed
            in a safari outfit walks over to you. \"Good day!\"
            he says, shaking your hand. \"My name's Samuels.
            You must be our new member.  Congratulations!
            I'm so glad you made it
            in time for today's expedition.  We'll be leaving
            in just a few minutes.  In fact, I was just on my
            way out to the boat.\"
            \n\tHe looks at his watch. \"Good lord, look at the
            time.  Best not dawdle!\"  He starts out of the
            room, then turns back to you. \"Oh, it's down the hall,
            then out the door to the west.  See you on the boat!\"
            He disappears down the hall.";

            clubWestDoor.isopen := true;
            clubWestDoor.islocked := nil;
        }
    }
;

clubPierRiver: fixeditem
    sdesc = "river"
    noun = 'river' 'water'
    location = clubPier
    ldesc = "It's a narrow, swiftly-flowing river. The water
        is very clear."
    verDoEnter(actor) = { "Why don't you enter the boat instead?"; }
    doSynonym('Enter') = 'Swim' 'Wade'
;

clubPierBoat: fixeditem
    sdesc = "rowboat"
    noun = 'rowboat' 'boat'
    location = clubPier
    ldesc = "Several people are in the boat, among them Samuels,
        the man who you met in the club room. They appear to
        be getting ready to leave."
    verDoBoard(actor) = {}
    doBoard(actor) = { clubPier.west; }
    doSynonym('Board') = 'Enter'
;

clubPierPeople: fixeditem
    sdesc = "people"
    noun = 'people' 'samuels'
    adjective = 'several'
    location = clubPier
    ldesc = "There are several people in the boat, getting ready
        to set out."
    actorAction(v, d, p, i) =
    {
        "They can't hear you from here; you should enter the boat.";
        exit;
    }
    verIoShowTo(actor) = { "You'll have to enter the boat first."; }
    ioSynonym('ShowTo') = 'GiveTo'
    verDoAskAbout(actor, iobj) = { "You'll have to enter the boat first."; }
    doSynonym('AskAbout') = 'TellAbout'
;

clubPierPier: decoration
    sdesc = "pier"
    noun = 'pier'
    location = clubPier
;

clubPier: room
    sdesc = "Pier"
    ldesc = "You're on a pier outside a large mansion.  The
        pier leads out to a rowboat floating on a narrow,
        swiftly-flowing river.
        The entrance to the mansion is to the east."
    east = clubHouse
    west =
    {
        awardPoints(13, self);

        "\bAs you enter the boat, Samuels invites you to sit
        down. \"This must be your first trip -- well, your
        second, really, but your first with the Society.
        Don't worry, you'll find it much less confusing this time.\"
        \n\tAnticipating your question, he continues, \"I suppose you're
        wondering where we're off to?  Well, we're not exactly sure
        ourselves -- it wouldn't be much of an exploration if we already
        knew what we were going to find!
        \n\t\"You see, there are many visions of Heaven and Hell.
        Most don't seem to be as, hmm, well, as wacky as this one.
        But some are much stranger, and great danger and excitement
        are to be found.\"
        \n\tThe oarsman pushes the boat away from the shore, and
        the rapid current starts pulling the boat downriver.  The
        boat picks up speed.  Ahead, the surface of the river is
        obscured by fog.  The boat slips into the fog, silently
        skimming along on the surface of the clear water.
        \b\b\b\b\b\bAll is dark and quiet.
        \b\bYou are on a boat.
        \b\b\b\b\bPerdition's Flames
                \b\b\bThe End\b\b\b";
                
        scoreRank();
        exitOptions();
    }
;


