#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
#include "qtalk.h"
//Quip template "desc"? "reply"?;

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// ARGUMENT: Pseudo-location
// ARGUMENT: Preliminaries
// ARGUMENT: The main menus and submenus
// ARGUMENT: "Set 1": "You bet I'm agitated!"
// ARGUMENT: "Set 2": "Well? Say something!"
// ARGUMENT: "Set 3"
// ARGUMENT: Main menu ("Set 5") and its submenus
// ARGUMENT: Quips in the submenu "Ask about the earth"
// ARGUMENT: Quips in the submenu "Ask about history"
// ARGUMENT: Quips in the submenu "Ask about culture"
// ARGUMENT: Quips in the submenu "Ask about the aliens' maze game"
// ARGUMENT: Quips in the submenu "Ask about a different game"
// DEBUG STUFF
// JUNK

// -------------------------------------------------------------------
// ARGUMENT: Pseudo-location
// -------------------------------------------------------------------

// This stuff is just here for the sake of the status line.

fakeDreamRoom: Room 'Dream Room'
;

fakeDreamCouch: Bed 'couch' 'couch' @fakeDreamRoom
;

// -------------------------------------------------------------------
// ARGUMENT: Preliminaries
// -------------------------------------------------------------------

modify glob
  // if desired during testing, change this to always be nil.
  noApparentZero = (argZeroOptionDefault.flag)
;

//modify glob
//  wakeUpAfterMazes =
//    "You open your eyes. After a moment of disorientation, 
//      the room comes into focus. You are lying on your back 
//      on the couch, with the metal bulb just above your head. ";
//;

// -------------------------------------------------------------------
// ARGUMENT: The main menus and submenus
// -------------------------------------------------------------------

argMain: QMain
  reply {
    //if (!hasShownReply)
    if (!bot.isIn(fakeDreamRoom)) {
      // fix status line appropriately
      //bot.moveInto(fakeDreamCouch);
      //bot.makePosture(lying);
      //statusLine.showStatusLine();
      "And with that, you wake up. You are lying on your back on
          the metal couch. 
        <p><b>Dream Room <<true ? '(lying on the couch)' : ''>></b>
        <br>This is a spartan room, in the middle of which is 
          a metal couch.
        <p>Neton and Ovan are standing here.
        <p>Although your head is still fuzzy, you strain 
          to pull yourself up off the couch. Then you whirl 
          to confront Neton and Ovan.
        <p>Finally, this is it: your chance to tell them off. ";
      bot.moveInto(fakeDreamRoom);
      bot.makePosture(standing);
      statusLine.showStatusLine();
      //"<p>Although your head is still fuzzy, you strain to
      //    pull yourself up off the couch. Then, turning around,
      //    you see Neton and Ovan, standing there and staring
      //    back at you. ";
    }
    //hasShownReply = true;
  }
  hasShownReply = nil
  options = [
     argAgitated
    ,argSoylent
    ,argCapitulate
    ,argUltraviolence
    ,argMongrels
//#ifdef __DEBUG
//    ,argDisembark
//#endif // __DEBUG
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;

argMainTwo: QSub
  reply() { glob.zeroDest = self; }
  options = [
     argSaySomething
    ,argSerious
    ,argTalkative
    ,argNavigated
    ,argAssaultotron
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;

argMainThree: QSub
  reply() { glob.zeroDest = self; }
  options = [
     //argSlap,
     argPunch
    ,argShake
    ,argMime
    ,argRun
    ,argDoNothing
  ]
  //killQ = true
  quipQuestion = 'What would you like to do? '
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionThree
;

argMainFour: QSub
  reply() { glob.zeroDest = self; }
  options = [
     argAgitated
    ,argSoylent
    ,argCapitulate
    ,argUltraviolence
    ,argImMad
    ,argIAmAMan
    ,argBite
    ,argExplain
    ,argImStuck
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;

argYowzers: Quip
  "<.q>Yowzers.<./q> "
  "<.q>Yowzers,<./q> you say.
    <p>Neton and Ovan nod. "
  transfer = argMainFive
;

argZeroOptionDefault: Quip
  reply() { 
    if (!flag)
      "This is odd. You find yourself literally 
        unable to remain silent. You cannot figure out why. 
        It seems that your only choice now is to select from 
        among the following options. ";
    else
      "Oddly, you find yourself unable to remain silent. ";
    //if (gKey()) { local k=0;k=k/k; }
    flag = true;
  }
  transfer = glob.zeroDest
  flag = nil
;

argZeroOptionThree: Quip
  reply() { 
    if (!argZeroOptionDefault.flag)
      "This is odd. You find yourself literally 
        unable to refrain from doing one of the small 
        number of choices that come to mind. You cannot 
        figure out why. ";
    else
      "Oddly, you find yourself unable to refrain from
        doing one of the choices that come to mind. ";
    argZeroOptionDefault.flag = true;
  }
  transfer = glob.zeroDest
;

/*
argMainZeroOption: Quip
  reply() { 
    replyText;
    //glob.knowsThereIsNoZeroOption = true;
  }
  replyText = "This is odd. You find yourself literally 
    unable to remain silent. You cannot figure out why. 
    It seems that your only choice now is to select from 
    among the following options. "
  transfer = argMain
;
argMainFourZeroOption: Quip
  reply() { 
    argMainZeroOption.replyText;
    //glob.knowsThereIsNoZeroOption = true;
  }
  transfer = argMainFour
;
argMainFiveZeroOption: Quip
  reply() { 
    argMainZeroOption.replyText;
    //glob.knowsThereIsNoZeroOption = true;
  }
  transfer = argMainFive
;
*/
/*
class Outburst: Quip
  reply() {
    glob.outburstCount++;
    replyText;
    
    if (!argMongrels.isOn && glob.outburstCount >= 2) {
      glob.moreThanJustOutbursts();
    }
    if (glob.outburstCount < glob.howManyOutbursts) {
      "<p>"; irrelevantText;
    }
    //say (glob.outburstCount);
    //if (glob.outburstCount > 3)
  }
  replyText = "" // override
  transfer = argMain
;
*/

modify glob
  //knowsThereIsNoZeroOption = nil
  outburstCountOne = 0
  outburstCountTwo = 0
  outburstCountThree = 0
  mongrelsCount = 0
  howManyOutburstsInOne = 4
  howManyOutburstsInTwo = 4
  zeroDest = argMain
  isFirstOutburst(str1, str2) {
    if (glob.outburstCountOne + glob.outburstCountTwo <= 1)
      return str1;
    if (str2 != nil) return str2;
    else return '';
  }
  tellAFewOrMore() {
    local val;
    val = glob.outburstCountOne + glob.outburstCountTwo;
    switch (val) {
      case 0: case 1:
        return 'a few';
      case 2:
        return 'more';
      default:
        //return 'still more';
        return 'more';
    }
  }
;

// -------------------------------------------------------------------
// ARGUMENT: "Set 1": "You bet I'm agitated!"
// -------------------------------------------------------------------

class OutburstInSetOne: Quip
  reply() {
    if (argMongrels.isOn)
      glob.outburstCountOne++;
    else
      glob.outburstCountTwo++;
    //if ()
    //  glob.outburstCountThree++;
    replyText;
    //if (!argMongrels.isOn && glob.outburstCount >= 2) {
    //  glob.moreThanJustOutbursts();
    //}
    if (!argMongrels.isOn &&
      glob.outburstCountOne + glob.outburstCountTwo >= 2) {
      argImStuck.isOn = true;
    }
    if ((argMongrels.isOn &&
          glob.outburstCountOne < glob.howManyOutburstsInOne)
     || (!argMongrels.isOn &&
          glob.outburstCountOne + glob.outburstCountTwo <
          glob.howManyOutburstsInOne + glob.howManyOutburstsInTwo )) {
      "<p>"; irrelevantText;
    }
    isOn = nil;
  }
  replyText = "" // override
  transfer() {
    if (argMongrels.isOn) return argMain;
    else return argMainFour;
  }
;

class OutburstInSetFour: Quip
  reply() {
    glob.outburstCountTwo++;
    replyText;
    if (!argMongrels.isOn &&
      glob.outburstCountOne + glob.outburstCountTwo >= 2) {
      argImStuck.isOn = true;
    }
    if (glob.outburstCountOne + glob.outburstCountTwo <
     glob.howManyOutburstsInOne + glob.howManyOutburstsInTwo) {
      "<p>"; irrelevantText;
    }
    isOn = nil;
  }
  replyText = "" // override
  transfer = argMainFour
;

argAgitated: OutburstInSetOne
  "<.q>You bet I<./s>m agitated! I may be surrounded by insanity, 
    but I am not insane!<./q> "
  replyText = 
    "<.q>You bet I<./s>m agitated!<./q> you shout. <.q>I may be 
        surrounded by insanity, but I am not insane!<./q> 
      <p>Neton and Ovan regard you with blank stares. 
      <p>After a long pause, Neton replies, <.q>I had not 
        previously imagined that you might be psychotic, 
        but--well, I<./s>ll give you the benefit of the doubt. 
        At least for now.<./q> "
  irrelevantText = "You<./s>d like to explain to him 
    why you said that, but 
    instead<<glob.isFirstOutburst(', for some reason,','')>> 
    all you can think to say are <<glob.tellAFewOrMore>> 
    irrelevant remarks. "
  qOff = [argAgitated]
;
argSoylent: OutburstInSetOne
  "<.q>Soylent Green is made out of people! They<./s>re making 
    our food out of people!<./q> "
  replyText = 
    "<.q>Soylent Green is made out of people!<./q> 
        you scream. <.q>They<./s>re making our food 
        out of people!<./q> 
      <p>Ovan gives you a blank stare, then shrugs, saying,
        <.q>Whatever you say. I<./s>ve never heard of 
        Soylent Green.<./q> 
      <p>Neton adds, <.q>As far as making food out of
        people--well, I don<./s>t think I<./s>d like
        that very much. I never thought of humans 
        as a very appetizing dish.<./q> "
  irrelevantText = "You are a bit flabbergasted. As a result, 
    all you can think to say are <<glob.tellAFewOrMore>> 
    irrelevant remarks. "
  qOff = [argSoylent]
;
argCapitulate: OutburstInSetOne
  "<.q>I<./s>m the last man left, and I<./s>ll stay that way 
    to the end! I<./s>ll never give in!<./q> "
  replyText = 
    "<.q>I<./s>m the last man left,<./q> you shout, 
        shaking your fist in the air, <.q>and I<./s>ll stay 
        that way to the end! I will never give in!<./q> 
      <p>Neton looks at you quizzically. Then he says,
        <.q>Well, I<./s>d make a distinction there.
        Perhaps you are the only cryogenically frozen man
        who<./s>s played interactive fiction, but 
        you are hardly the last man left.<./q>
      <p><.q>There are plenty of humans left, both
        male and female,<./q> says Ovan.
        <.q>Most of them are hunter-gatherer types,
        but they<./s>re still human.<./q> "
  irrelevantText = "You shake your head in desperation. 
    Yet<<glob.isFirstOutburst(', oddly enough,','')>>
    all you can think to say are <<glob.tellAFewOrMore>> 
    irrelevant remarks. "
  qOff = [argCapitulate]
;
argUltraviolence: OutburstInSetOne
  "<.q>All this ultraviolence and killing is wrong, wrong, 
    and terribly wrong!<./q> "
  replyText = 
    "<.q>All this ultraviolence and killing is 
        wrong, wrong, and terribly wrong!<./q> you cry. 
      <p>Ovan looks to Neton for a moment and asks, 
        <.q>Did he say <.s>ultraviolet<./s>?<./q> 
      <p><.q>I believe so,<./q> says Neton. <.q>This human
        is from the early twenty-first century,
        when the Earth<./s>s ozone layer was still
        fairly thick. In comparative terms, today<./s>s
        UV rays are far stronger, and indeed more lethal 
        to some species.<./q> 
      <p><.q>Hmmpf,<./q> says Ovan. <.q>Some species need to learn
        how to genetically modify themselves for UV 
        resistance.<./q> 
      <p><.q>Ha! Good one!<./q> says Neton, and the two of them
        get a good chuckle. "
  irrelevantText = "Instead of trying to explain, you
    decide to respond with <<glob.tellAFewOrMore>>
    irrelevant remarks. "
  qOff = [argUltraviolence]
;
argImMad: OutburstInSetFour
  "<.q>I<./s>m mad as hell, and I<./s>m not gonna take this 
    anymore!<./q> "
  replyText = 
    "<.q>I<./s>m mad as hell, and I<./s>m not gonna take this 
        anymore!<./q> you shout. 
      <p><.q>Very well,<./q> says Neton. 
      <p><.q>Fine by me,<./q> adds Ovan. "
  irrelevantText = "You try to think of some clever response,
    but come up blank. Instead, you can only think of 
    <<glob.tellAFewOrMore>> irrelevant remarks. "
  qOff = [argImMad]
;
argIAmAMan: OutburstInSetFour
  "<.q>I am not an animal! I am a human being! I am a man!<./q> "
  replyText = 
    "<.q>I am not an animal!<./q> you shout. <.q>I am a 
        human being! I am a man!<./q> 
      <p>Neton and Ovan look at each other for a moment, then 
        burst out into raucous laughter.
      <p><.q>Of all the senseless things!<./q> says Ovan, 
        giggling hysterically. 
      <p><.q>As though the irrelevance of this remark were not 
        enough,<./q> says Neton, <.q>it falsely implies that 
        <.s>man<./s> and <.s>animal<./s> are mutually
        exclusive categories.<./q> 
      <p><.q>I am not a plant!<./q> Ovan sneers.
        <.q>I am a tree! I am a Norway pine!<./q> "
  irrelevantText = "You try to think of a decent comeback, 
    but<<glob.isFirstOutburst(' for some reason','')>> 
    all you can think of are <<glob.tellAFewOrMore>> 
    irrelevant remarks. "
  qOff = [argIAmAMan]
;
argBite: OutburstInSetFour
  "<.q>Come back here and take what<./s>s 
    coming to you! I<./s>ll bite your legs off!<./q> "
  replyText = 
    "<.q>Come back here and take what<./s>s coming to you!<./q> 
        you exclaim. <.q>I<./s>ll bite your legs off!<./q> 
      <p><.q>We<./s>re only six feet away, and 
        directly facing you,<./q> 
        Neton says. <.q>What do you mean, <.s>Come back
        here<./s>?<./q> 
      <p>Ovan adds, <.q>If you<./s>re really as hungry
        as all that, just 
        find a food dispenser. You don<./s>t need to bite 
        anyone<./s>s legs off.<./q> "
  irrelevantText = "You try to think of a comeback, but fail.
    Instead, you can only think of <<glob.tellAFewOrMore>> 
    irrelevant remarks. "
  qOff = [argBite]
;
argExplain: OutburstInSetFour
  "<.q>If I<./s>m crazy, then how do you explain THIS!<./q> "
  replyText = 
    "<.q>If I<./s>m crazy, then how do you 
        explain THIS!<./q> you say triumphantly. 
      <p><.q>Explain what?<./q> says Neton,
        adjusting his green jacket. 
      <p>Damn, you hadn<./s>t thought that far ahead. "
  irrelevantText = "Now all you can think of are 
    <<glob.tellAFewOrMore>> irrelevant remarks. "
  qOff = [argExplain]
;
/*
argFree: Outburst
  "<.q>Don<./s>t you want to be free and men? Don<./s>t you even 
    understand what manhood and freedom are?<./q> "
  replyText =
    "<.q>Don<./s>t you want to be free and men?<./q> you 
      shout. <.q>Don<./s>t you even understand what manhood and 
      freedom are?<./q> <p>
      <.q>Reply.<./q> "
  qOff = [argFree]
;
argOperating: Outburst
  "<.q>I<./s>m a human being, a person--with parents and memories 
    and a history--and I was before you ever wheeled me 
    into that operating room!<./q> "
  replyText =
    "<.q>I<./s>m a human being, a person--with 
      parents and memories and a history--and I was 
      before you ever wheeled me into that operating room!<./q> 
      you shout. <p>
      <.q>Reply.<./q> "
  irrelevantText = ""
  qOff = [argOperating]
;
*/
argMongrels: Quip
  "<.q>People have rights, you maze-hungry mongrels! People 
    have rights!<./q> "
  reply() {
    "You shout, <.q>People have rights, you maze-hungry 
        mongrels! People have rights!<./q> 
      <p>Your words echo through the air, followed
        by silence. Neton and Ovan remain utterly still. 
      <p>After several seconds, you feel compelled to say
        something. ";
    glob.zeroDest = argMainTwo;
    //if (glob.outburstCount >= 2) glob.moreThanJustOutbursts();
  }
  qOff = [argMongrels]
  transfer = argMainTwo
;
argDisembark: Quip
  "Get out of this conversation menu "
  "Okay! Leaving the conversation menu\ .\ .\ . "//;
;

argImStuck: Quip
  "<.q>Hey, wait a minute. This is weird, how little control
    I have over what I say. It<./s>s like one of those 
    conversation menus, the kind they have in 
    <i>Monkey Island.<./q></i> "
  reply() {
    "<.q>Hey, wait a minute,<./q> you say. 
        <.q>This is weird, how little control I have over what
        I say. It<./s>s like one of those conversation menus,
        the kind they have in <i>Monkey Island.<./q></i> 
      <p><.q>That<./s>s <i>exactly</i> what it is!<./q> says Ovan,
        his eyes gleaming. 
      <p><.q>At last, our human has correctly assessed the
        situation,<./q> Neton agrees. 
      <p><.q>You managed to get through the mazes in our game,
        but I doubt you<./s>ll get through this maze of 
        conversation options!<./q> cries Ovan. ";
    glob.zeroDest = argMainFive;
  }
  isOn = nil
  //qOff = [argAgitated, argSoylent, argCapitulate,
  //  argUltraviolence, argBite, argImMad, argIAmAMan, 
  //  //argFree, argOperating, 
  //  argMongrels]
  transfer = argMainFive
;

// -------------------------------------------------------------------
// ARGUMENT: "Set 2": "Well? Say something!"
// -------------------------------------------------------------------

class QuipInSetTwo: Quip
  reply() {
    "You try to speak, but all that comes out is
        coughing and wheezing. You pause, catch your 
        breath, and try harder, but you fail, doubling
        over in a torrent of hoarse coughing. 
      <p>What is wrong? All of a sudden you can<./s>t even
        speak? 
      <p>Worse yet, when you glance over at Neton and Ovan,
        they<./s>re smiling, apparently amused by your plight.
      <p>Okay, enough talk. Time for some action. ";
    glob.zeroDest = argMainThree;
  }
  //killQ = true
  quipQuestion = 'What would you like to do? '
  transfer = argMainThree
  //zeroOption = argZeroOptionDefault
;
argSaySomething: QuipInSetTwo
  "<.q>Well? Say something!<./q> "
  qOff = [argSaySomething]
;
argSerious: QuipInSetTwo
  "<.q>I<./s>m serious! People have rights!<./q> "
  qOff = [argSerious]
;
argTalkative: QuipInSetTwo
  "<.q>Not so talkative, are you, now that the advantage
    is mine!<./q> "
  qOff = [argTalkative]
;
argNavigated: QuipInSetTwo
  "<.q>Yeah, I made it through your mazes. Was that the
    best you could do?<./q> "
  qOff = [argNavigated]
;
argAssaultotron: QuipInSetTwo
  "<.q>Okay, my turn. There<./s>s a game I<./s>d like you 
    to play. It<./s>s called <i>Annoyotron V: 
    Assaultotron.<./q></i> "
  qOff = [argAssaultotron]
;

// -------------------------------------------------------------------
// ARGUMENT: "Set 3"
// -------------------------------------------------------------------

class QuipInSetThree: Quip
  reply() {
    firstSentence;
    "<p>After a few moments, you get the impression that 
      your power of speech has returned. ";
    glob.zeroDest = argMainFour;
  }
  firstSentence = "You try hard to <<quipAction>>,
    but your body fails to respond as it normally would.
    Something odd is happening. "
  quipAction = 'do so'
  transfer = argMainFour
  //zeroOption = argZeroOptionThree
;
argSlap: QuipInSetThree
  "Slap the two aliens in the face. "
  quipAction = 'slap the aliens'
;
argPunch: QuipInSetThree
  "Give them each a hard punch in the gut. "
  quipAction = 'punch the aliens'
;
argShake: QuipInSetThree
  "Shake their hands, to make them think there<./s>s 
    no hard feelings."
  quipAction = 'shake the aliens<./s> hands'
;
argMime: QuipInSetThree
  "Use mime gestures to say you<./s>d like to 
    play <i>Oblivion</i> next."
  quipAction = 'do mime gestures'
;
argRun: QuipInSetThree
  "Run away. "
  quipAction = 'run away'
;
argDoNothing: QuipInSetThree
  "Do nothing. "
  firstSentence = "Okay, you do nothing. "
  quipAction = 'do nothing'
;
arg: Quip
  "<.q><./q> "
  "<.q><./q> <p>
    <.q><./q> "
;

// -------------------------------------------------------------------
// ARGUMENT: Main menu ("Set 5") and its submenus
// -------------------------------------------------------------------

argMainFive: QSub
  reply() { glob.zeroDest = self; }
  options = [
     argStuck
    ,argProgram
    ,argMemory
    ,argInescapable
    
    ,argSubEarth
    ,argSubHistory
    ,argSubCulture
    ,argSubNbm
    ,argSubGame
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;

class QuipInSetFive: Quip
  transfer = argMainFive
;

argStuck: QuipInSetFive
  "<.q>But if I<./s>m stuck in this conversation, 
    surely you are too.<./q> "
  reply {
    "<.q>But if I<./s>m stuck in this conversation, 
        surely you are too,<./q> you say.
      <p><.q>Surely, we are not stuck anywhere,<./q>
        says Neton.
      <p><.q>Of course we aren<./s>t,<./q> says Ovan.
        <.q>What you see here are mere representations
        of us. You<./s>re the only one whose consciousness
        is trapped here.<./q>
      <p><.q>We--that is, the real we--aren<./s>t
        even controlling these representations,<./q>
        says Neton. <.q>The controlling is done by a 
        computer program.<./q>
      <p><.q>A computer program that I wrote,<./q> 
        says Ovan, beaming proudly. ";
    if (!argMemory.hasBeenUttered)
      argMemory.isOn = true;
  }
  qOff = [argStuck]
  qOn = [argProgram]
;
argProgram: QuipInSetFive
  "<.q>Ovan, you said you wrote this program?<./q> "
  "<.q>Ovan, you said you wrote this program?<./q>
      you ask.
    <p><.q>You bet,<./q> says Ovan proudly. 
      <.q>You are now inside a computer program that 
      I wrote.<./q>
    <p><.q>He wrote it, I might add, using a computer
      programming language that I developed,<./q>
      says Neton. "
  qOff = [argProgram]
  isOn = nil
;
argMemory: QuipInSetFive
  "<.q>Will the <i>real</i> Neton and Ovan have any
    memory of this conversation?<./q> "
  reply {
    "<.q>Will the <i>real</i> Neton and Ovan have any
        memory of this conversation?<./q> you ask. ";
    if (!glob.aliensKnowPcCheated)
      "<p><.q>The real Neton and Ovan won<./s>t have 
        experienced this conversation for themselves,<./q> 
        says Neton, <.q>but they may be monitoring it 
        out there in the real world. And even if 
        they<./s>re not, they<./s>ll probably go through 
        the transcript of this conversation before 
        waking you up. Rest assured, the real Neton and Ovan 
        can find out anything they want to 
        about this conversation.<./q> ";
    else
      "<p><.q>Oh, don<./s>t you worry about that,<./q> 
        says Neton, glaring at you. <.q>The real 
        Neton and Ovan may not have <i>experienced</i> 
        this conversation, but they<./s>re probably 
        monitoring it, and if not, they<./s>ll 
        definitely go through the transcript of it 
        before they wake you up. Rest assured, 
        the real Neton and Ovan will find out everything 
        they need to know.<./q> ";
    hasBeenUttered = true;
  }
  qOff = [argMemory]
  hasBeenUttered = nil
  isOn = nil
;
argInescapable: QuipInSetFive
  "<.q>Why did you say you doubt that I<./s>ll escape this
    conversation?<./q> "
  "<.q>Why did you say you doubt that I<./s>ll escape this
      conversation?<./q> you ask.
    <p><.q>Well, that<./s>s easy!<./q> says Ovan,
      smiling cheerfully. <.q>You won<./s>t escape
      this conversation because I made it 
      utterly impossible for you to escape!<./q> 
    <p><.q>The whole <i>purpose</i> of this conversation 
      is to be inescapable,<./q> says Neton. 
      <.q>In the event that a human actually finished 
      our game, we had to make sure he wouldn<./s>t wake up
      while we were unprepared.<./q>
    <p><.q>We could have just written a program that kept
      you in a box, or we could have simply taken away 
      your unconscious,<./q>
      says Ovan. <.q>But where would be the fun in that? 
      This way, at least you get to be entertained 
      until we wake you up.<./q>
    <p><i><.q>If</i> we wake you up,<./q> adds Neton
      ominously. "
  qOff = [argInescapable]
;

modify glob
  aliensKnowPcCheated = nil
;


//argYoureStuck: QuipInSetFive
//  "<.q>But if I<./s>m stuck in this conversation menu maze,
//    then surely you are too.<./q> "
//  "<.q>Ha!<./q> says Ovan, and he and Neton burst out into
//      hoarse laughter. 
//    <p><.q>We aren<./s>t stuck anywhere, obviously,<./q> 
//      says Neton. <.q>What you see are mere representations 
//      of us, contained in a program that only you inhabit.<./q> 
//    <p><.q>We--that is, the real <.s>we<./s>--are not 
//      even controlling these representations,<./q>
//      says Ovan. <.q>We have better things to do with our 
//      time.<./q>
//    <p><.q>The controlling is done by a computer program.<./q> 
//    <p><.q>A program that I wrote, I might add,<./q> 
//      says Ovan. "
//  qOff = [argYoureStuck]
//  qOn = [argYouWroteProgram]
//;
//
//argYouWroteProgram: QuipInSetFive
//  "<.q>You wrote this program?<./q> "
//  "<.q>Yes,<./q> says Ovan, beaming with pride. 
//    <p><.q>I might add,<./q> says Neton, <.q>that he wrote it 
//      using a development system that I created.<./q> "
//  isOn = nil
//  qOff = [argYouWroteProgram]
//;
//
//argCantEscape: QuipInSetFive
//  "<.q>You said that it<./s>s utterly impossible for me to 
//    escape?<./q> "
//  "<.q>Oh, come now,<./q> says Neton. <.q>Would we ever admit
//      to having said something like that?<./q> 
//    <p>Ovan says, <.q>I know I wouldn<./s>t admit such a 
//      thing.<./q> "
//  qoff = [argCantEscape]
//;
//
//argImTheFirst: QuipInSetFive
//  "<.q>I bet I<./s>m the first person to have beat your 
//    game!<./q> "
//  "Neton scowls at you. 
//    <p><.q>Yeah, congratulations,<./q> says Ovan. 
//      <.q>We<./s>d give you a cookie, but we<./s>re all out 
//      right now. Sorry.<./q> "
//  qoff = [argImTheFirst]
//;










argSubEarth: QSub
  "Ask about the Earth . . . "
  reply() { glob.zeroDest = self; }
  options = [
     argTerrorists // > argPrewar
    ,argPresident  // > argPrewar
    ,argSurvivors  // > argPostwar
    ,argHelp       // > argPostwar
    ,argRevived    // > argRecent
    ,argStasis     // > argRecent
    ,argPrewar
    ,argWar
    ,argPostwar
    ,argRecent
    ,argBackToMain
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;
argSubHistory: QSub
  "Ask about Oo history . . . "
  reply() { glob.zeroDest = self; }
  options = [
     argMission      // > argArrival
    ,argReturn       // > argArrival
    ,argInterstellar // > argScience
    ,argArrival
    ,argScience
    ,argHomeworld
    ,argRaces
    ,argBackToMain
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;
argSubCulture: QSub
  "Ask about Oo art and culture . . . "
  reply() { glob.zeroDest = self; }
  options = [
     argUniversity
    ,argArt
    ,argIf
    ,argMazes
    ,argBackToMain
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;
argSubNbm: QSub
  "Ask about the aliens<./s> maze game . . . "
  reply() { glob.zeroDest = self; }
  options = [
     argCheat         // > argFirst, argSheila
    ,argNondisclosure // > argSheila
    ,argDisclosure    // > argSheila
    ,argFirst
    ,argBad
    ,argGood
    ,argNext
    ,argSheila
    ,argHacman
    ,argBackToMain
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
;

class QuipInArgSub: Quip
  transfer {
    // If the submenu in question has at least one option
    // available -- excluding the "back to the main menu" 
    // option -- then go to the submenu.
    for (local a = 1; a <= transferSub.options.length - 1; a++) {
      if (transferSub.options[a].isOn) {
        return transferSub;
      }
    }
    // If, however, the submenu in question has NO meaningful
    // options remaining, then (1) go directly back to 
    // the main menu, and (2) deactivate the submenu.
    transferSub.isOn = nil;
    return argMainFive;
  }
;

class QuipInArgSubEarth: QuipInArgSub
  transferSub = argSubEarth
;
class QuipInArgSubHistory: QuipInArgSub
  transferSub = argSubHistory
;
class QuipInArgSubCulture: QuipInArgSub
  transferSub = argSubCulture
;
class QuipInArgSubNbm: QuipInArgSub
  transferSub = argSubNbm
;
argBackToMain: Quip
  "(Go back to the main menu.) "
  transfer = argMainFive
;

// -------------------------------------------------------------------
// ARGUMENT: Quips in the submenu "Ask about the earth"
// -------------------------------------------------------------------

modify glob
  prewarCount = 0
;
class QuipConcerningPrewar: QuipInArgSubEarth
  prewarSentence = ""
  desc = "<.q><<prewarSentence>>.<./q> "
  reply {
    "<.q><<prewarSentence>>,<./q> you say. ";
    glob.prewarCount++;
    if (glob.prewarCount <= 1)
      "<p>Shaking his head, Neton says, <.q>I<./s>m afraid 
          you have us at a bit of a loss. As I said, 
          Ovan and I are scholars of the humanities. 
          History is more of a social science, 
          at least by our reckoning. As such, 
          we are far from expert on the subject.<./q>
        <p><.q>Personally, I never liked history 
          much,<./q> says Ovan. <.q>So little of it 
          seems to have to do with interactive fiction.<./q> ";
    else
      "<p><.q>I can see you have a genuine interest 
          in this subject, and that<./s>s commendable,
          I suppose,<./q> says Neton. <.q>However, 
          it<./s>s time for me to come clean with you. 
          We<./s>re actually not allowed to talk to you 
          about pre-war Earth history. The arch-dean 
          was very clear on this point. 
          No offense or anything, but we don<./s>t feel 
          we can trust a species that can<./s>t even 
          avoid blowing up its own planet.<./q> ";
  }
  isOn = nil
;

argTerrorists: QuipConcerningPrewar
  prewarSentence = "Tell me about the terrorists 
    who were involved with the nuclear war"
  //"<.q>Tell me about the terrorists who were involved
  //  with the nuclear war.<./q> "
  //"<.q>Tell me about the terrorists who were involved
  //    with the nuclear war,<./q> you say.
  //  <p><.q>Reply.<./q> "
  qOff = [argTerrorists]
;
argPresident: QuipConcerningPrewar
  prewarSentence = "Tell me about the American president 
    who was involved with the nuclear war"
  //"<.q>Tell me about the American president who was
  //  involved with the nuclear war.<./q> "
  //"<.q>Tell me about the American president who was
  //    involved with the nuclear war,<./q> you say.
  //  <p><.q>Reply.<./q> "
  qOff = [argPresident]
;
argSurvivors: QuipInArgSubEarth
  "<.q>Tell me about the survivors of the nuclear 
    war.<./q> "
  "<.q>Tell me about the survivors of the nuclear 
      war,<./q> you say.
    <p><.q>I<./s>m not sure know how many survivors there are 
      today,<./q> says Neton. <.q>There are 
      a few tribes here in Australia, 
      as well as some in Africa and South America. 
      That<./s>s all I know.<./q>
    <p><.q>I was going to try to recruit 
      some of the native humans to test our game,<./q> 
      says Ovan, <.q>but then I realized 
      they were completely uneducated, 
      and probably wouldn<./s>t be very good at 
      interactive fiction.<./q>
    <p><.q>Sorry we can<./s>t tell you more, 
      but this is outside our area of expertise,<./q> 
      says Neton. <.q>We are scholars of 
      the humanities, not anthropology.<./q> "
  isOn = nil
  qOff = [argSurvivors]
;
argHelp: QuipInArgSubEarth
  "<.q><<helpSentence>><./q> "
  reply {
    "<.q><<helpSentence>><./q> you ask. ";
    if (!glob.pcKnowsAboutRule && !glob.pcKnowsMoreAboutRule) {
      "<p>Neton and Ovan give you a long, blank stare. 
        <p>Then Neton replies, <.q>Uh, yes. 
          In a sense, perhaps it might be desirable 
          to help the surviving humans a bit. 
          The problem is, though, we are bound 
          by a directive that we call Rule Number One. 
          According to this rule, we are not allowed 
          to interfere with the natural development 
          of other alien cultures--unless we 
          really feel like it.<./q>
        <p><.q>And, you see, this is a case 
          where we don<./s>t really feel like it,<./q> 
          says Ovan, smiling cheerfully. ";
      glob.pcKnowsAboutRule = true;
      // We do not deactivate this quip in this case.
    }
    else if (!glob.pcKnowsMoreAboutRule) {
      "<p><.q>Well, we already told you about 
          Rule Number One,<./q> says Neton. 
          <.q>Nevertheless, I think I understand 
          your question. As you know, Rule Number One 
          says that we can't interfere with alien 
          cultures unless we feel like it. 
          Perhaps this sounds like an open-ended rule 
          that permits just anything, but that 
          is not the case. The rule is extremely 
          strict. If Ovan or I didn<./s>t feel 
          like interfering with an alien culture, 
          but did so anyway, the dean of CESAC 
          would find out, and he would almost certainly 
          give us a severe reprimand.<./q> 
        <p>Ovan adds, <.q>And it<./s>s not as simple 
          as lying to the dean, either. He has access 
          to the campus<./s>s brain-wave pattern scanner, 
          so he can find out what we truly 
          want to do. So, as it turns out, 
          until we really develop a genuine desire 
          to help out humans, our hands are tied.<./q> ";
      glob.pcKnowsMoreAboutRule = true;
      isOn = nil; // deactivate this quip
    }
    else {
      "<p>Neton shakes his head and sighs. <.q>No, no.
          We already told you about Rule Number One. 
          According to this rule, we are not allowed
          to interfere with alien cultures--unless
          we really feel like it,<./q> he says. 
        <p><.q>And, as we said before, this is a case
          where we don<./s>t really feel like it,<./q>
          says Ovan. ";
      isOn = nil; // deactivate this quip
    }
    hasBeenUttered = true;
  }
  hasBeenUttered = nil
  helpSentence {
    if (!hasBeenUttered)
      return 'Surely you plan to help the human survivors.
        How has that gone?';
    else
      return 'Seriously, though, why won<./s>t you help 
        the human survivors?';
  }
  isOn = nil
  //qOff = [argHelp]
;
argRevived: QuipInArgSubEarth
  "<.q>How many humans have you revived so far?<./q> "
  "<.q>How many humans have you revived so far?<./q>
      you ask.
    <p><.q>Five at this university so far,<./q> 
      says Ovan.
    <p><.q>And I doubt others have been revived at 
      other universities,<./q> adds Neton. 
      <.q>If that had happened, I<./s>m sure I would
      have heard about it.<./q> "
  isOn = nil
  qOff = [argRevived]
;
argStasis: QuipInArgSubEarth
  "<.q>How many humans remain in cryo-stasis?<./q> "
  "<.q>How many humans remain in cryo-stasis?<./q>
      you ask.
    <p>Neton thinks, then asks Ovan, <.q>How many 
      were there again?<./q> 
    <p><.q>About ninety or so, if I remember right,<./q>
      Ovan replies. "
  isOn = nil
  qOff = [argStasis]
;
argPrewar: QuipInArgSubEarth
  "Ask about the events that led up to the nuclear war. "
  "<.q>Earlier you mentioned some events that led up
      to the nuclear war,<./q> you say. <.q>What more
      can you tell me about that?<./q>
    <p>Neton and Ovan exchange glances for a moment.
    <p>Then Neton says, <.q>Uh, yes. Come to think of it, 
      I guess I did mention that. Some terrorists 
      were involved with that, as was the 
      American president, in his own way. 
      However, I wouldn<./s>t worry about that
      if I were you. That was over a hundred years ago,
      and it has little to do with life today.<./q>
    <p><.q>Frankly, that period of history is
      downright depressing,<./q> says Ovan. 
      <.q>You should look on the bright side! 
      Maybe your planet had a rocky past, but the future
      looks good! Just think--for centuries to come, 
      you get to share the planet with us!<./q> "
  qOff = [argPrewar]
  qOn = [argTerrorists, argPresident]
;
argWar: QuipInArgSubEarth
  "Ask about the nuclear war itself. "
  "<.q>What can you tell me about the nuclear war 
      itself?<./q> you ask.
    <p><.q>I don<./s>t know all the details,<./q> 
      says Neton. <.q>Basically, though, the world 
      was devastated. Some places were blasted 
      directly by missiles; most other areas 
      were laid waste by nuclear fallout.<./q>
    <p><.q>It took a while even for even 
      the Southern Hemisphere to recover,<./q> 
      says Ovan. <.q>As for the Northern Hemisphere, 
      it is largely uninhabitable even now.<./q>
    <p><.q>Such are the consequences of nuclear war,<./q> 
      Neton concludes. "
  qOff = [argWar]
;
argPostwar: QuipInArgSubEarth
  "Ask about the aftermath of the nuclear war. "
  "<.q>What can you tell me about the aftermath of the
      nuclear war?<./q> you ask.
    <p><.q>Well, nuclear fallout rained down 
      everywhere,<./q> says Neton. <.q>As a result, 
      there were massive agricultural failures, 
      followed by years of famine,
      followed by the death of at least ninety-nine
      percent of the human species.<./q>
    <p><.q>What<./s>s more, those who
      did survive had little time for anything
      but mere subsistence,<./q> says Ovan. 
      <.q>As a result, learning and culture 
      dwindled drastically.<./q>
    <p><.q>There are still a few scattered humans 
      out there, but they live by hunting, 
      gathering, and scavenging,<./q> says Neton. 
      <.q>There is practically nothing left of 
      human civilization as you knew it.<./q> "
  qOff = [argPostwar]
  qOn = [argSurvivors, argHelp]
;
argRecent: QuipInArgSubEarth
  "Ask about recent events. "
  "<.q>What can you tell me about recent events 
      on Earth?<./q> you ask.
    <p>Neton replies, <.q>Well, as far as recent events,
      surely the most significant was what 
      I told you about before: the discovery 
      of some North American cryogenic facilities 
      with viable frozen humans.<./q>
    <p><.q>That really did cause a sensation,<./q> 
      says Ovan. <.q>After we found out, we could 
      hardly contain our excitement. It opened up 
      whole new research possibilities.<./q> "
  qOff = [argRecent]
  qOn = [argRevived, argStasis]
;

// -------------------------------------------------------------------
// ARGUMENT: Quips in the submenu "Ask about history"
// -------------------------------------------------------------------

argMission: QuipInArgSubHistory
  "<.q>You said the Oo who discovered Earth had a 
    <.s>primary mission.<./s> What was that?<./q> "
  reply {
    "<.q>You said the Oo who discovered Earth had a 
        <.s>primary mission.<./s> What was that?<./q> 
        you ask. ";
    if (!nocOoMission.hasBeenUttered)
      "Ovan furrows his brow. <.q>Hey, that<./s>s 
          a good question, actually. What was 
          their mission?<./q>
        <p>Neton leans closer to Ovan and lowers 
          his voice. <.q>Ask me that sometime 
          when the human is not around. Obviously, 
          he doesn<./s>t have that kind of security 
          clearance.<./q>
        <p><.q>Ah yes, good point,<./q> says Ovan. ";
    else
      "<.q>It<./s>s funny you should ask, because 
          Neton and I were just discussing that 
          today,<./q> says Ovan. <.q>Their 
          mission--<./q>
        <p><.q>Their mission is absolutely no concern 
          of his,<./q> Neton interrupts, glaring at Ovan 
          fiercely. <.q>As I said before, the human 
          does not have that kind of security clearance. 
          Seriously, Ovan, if you can<./s>t remember 
          what information is off limits, you<./s>ll 
          just have to let me do the talking.<./q>
        <p>Ovan hangs his head and frowns sadly. ";
  }
  isOn = nil
  qOff = [argMission]
;
argReturn: QuipInArgSubHistory
  "<.q>You said you're waiting for another 
    spaceship to take you back home?<./q> "
  "<.q>You said you're waiting for another 
      spaceship to take you back home?<./q> you ask.
    <p><.q>Yes,<./q> says Neton. <.q>When our grandparents 
      decided to settle here, they were promised 
      that a spaceship would return for them eventually. 
      It might take centuries, but that spaceship 
      will come. And when it does, we will return home.<./q> "
  isOn = nil
  qOff = [argReturn]
;
argInterstellar: QuipInArgSubHistory
  "<.q>How did you achieve the technology that led
    to interstellar travel?<./q> "
  reply {
    "<.q>How did you achieve the technology that led
        to interstellar travel?<./q> you ask. ";
    if (!nocOoInterstellar.hasBeenUttered)
      "<p><.q>That<./s>s a very good question, and it has to 
          do with a pivotal moment in 
          Oo science,<./q> says Neton, suddenly
          becoming excited. 
          <.q>You see, for decades our scientists 
          were working as hard as they could 
          to <i>oolesona</i> <i>avenatos,</i> or at least 
          <i>bavoona</i> <i>teek</i> <i>eefoms,</i>
          in an effort to achieve <i>tooloval,</i>
          without much success. Then, finally, a scientist 
          named Tero came along said, <.s>Hey, wait a 
          minute. What if, instead of busting our tails to
          <i>oolesona</i> these <i>avenatos,</i> 
          we just <i>koroomaed</i> a bunch of 
          <i>toofomavalekeesokanos?</i>
          Then, if we were careful to align the
          <i>sarekoonatasokanos</i> with perfect precision, 
          we might well achieve <i>tooloval</i> 
          as a natural consequence.<./s> That was the crucial 
          insight. After that--<./q>
        <p>At this point Ovan raises his hand and interrupts.
          <.q>Pardon me, Neton, but I don<./s>t think
          our language infusion process uses the 
          vocabulary for understanding modern physics.
          Most likely, this human doesn<./s>t understand a word
          you<./s>re saying.<./q>
        <p><.q>Oh,<./q> says Neton. <.q>Well, in that case,
          nevermind.<./q> ";
    else
      "<p><.q>We already talked about this earlier,<./q> 
          says Ovan. <.q>The problem is, I don<./s>t think 
          you were infused with the necessary vocabulary 
          for understanding modern physics.<./q>
        <p><.q>Even if you had been,<./q> says Neton, 
          <.q>I don't think you<./s>d understand the 
          <i>koroomatics</i> of it, to say nothing of 
          the <i>oolesonology.</i> Until you<./s>ve learned 
          the rudiments of modern physics, I<./s>m afraid 
          we won<./s>t be able to help you.<./q> ";
  }
  isOn = nil
  qOff = [argInterstellar]
;
argArrival: QuipInArgSubHistory
  "Ask about the Oo arrival on Earth. "
  "<.q>Earlier you mentioned the Oo arrival on Earth,<./q>
      you say. <.q>Can you tell me more about that?<./q>
    <p>Neton says, <.q>Well, it<./s>s like we said before. 
      About ninety years ago, a few decades 
      after your nuclear war, one of our Oo spaceships 
      noticed signs of life on Earth, so they 
      flew down to investigate.<./q>
    <p><.q>Most of the crew didn<./s>t want to be 
      diverted from their primary mission, 
      so they left Earth orbit soon after that,<./q> 
      says Ovan. <.q>But a few wanted to investigate 
      Earth further, so they stayed on the planet. 
      We are the grandchildren of those 
      investigators.<./q>
    <p><.q>And so, until another spaceship arrives 
      to take us back home, we make a life for 
      ourselves here, studying the texts of ancient 
      Earth,<./q> says Neton. "
  qOff = [argArrival]
;
argScience: QuipInArgSubHistory
  "Ask about Oo science. "
  "<.q>What can you tell me about Oo science<./q>?
      you ask.
    <p>Neton stares at you for a moment. <.q>Well, 
      where should I begin? In molecular biology, 
      we<./s>ve learned how to genetically modify 
      almost any life form. In neuroscience, 
      we<./s>ve learned how to infuse knowledge 
      directly into the brain, not to mention 
      virtual experiences. In physics, 
      we<./s>ve discovered the principles of 
      <i>oolesonology,</i> which eventually led 
      to the technology of interstellar space 
      flight.<./q> "
  qOff = [argScience]
;
argHomeworld: QuipInArgSubHistory
  "Ask about the Oo homeworld. "
  "<.q>What can you tell me about your homeworld?<./q>
      you ask.
    <p>Neton says, <.q>Our homeworld is the second planet 
      orbiting the star which humans once called 
      <<ooStar.starName>>.<./q>
    <p><.q>Ah yes, what a catchy name,<./q> says Ovan. 
      <.q>Of course, we just call it the Oo Sun. 
      And we call our planet Oo.<./q>
    <p><.q>Our homeworld is similar to Earth 
      in a number of ways,<./q> says Neton. 
      <.q>Its size, chemical composition, 
      rotational velocity, and atmosphere 
      all closely accord with those of Earth.<./q>
    <p><.q>From what I<./s>ve heard, our homeworld<./s>s 
      plant and animal life is similar to stuff 
      here on Earth, too,<./q> says Ovan. 
      <.q>Plus or minus a nuclear holocaust, that is.<./q>
    <p><i><.q>Somewhat</i> similar, perhaps,<./q> 
      says Neton cautiously. <.q>That is, 
      our homeworld<./s>s <.s>plants<./s> photosynthesize, 
      and its <.s>animals<./s> feed on plants, 
      just as on Earth,<./q> says Neton.
    <p><.q>Of course, bear in mind that we<./s>ve 
      never actually visited our homeworld,<./q> 
      says Ovan. <.q>We were born and raised 
      right here on Earth. We<./s>re just telling you 
      what we<./s>ve read.<./q> "
  qOff = [argHomeworld]
;
argRaces: QuipInArgSubHistory
  "Ask about other alien races. "
  "<.q>Have you met any other alien races?<./q> you ask.
    <p>Neton and Ovan exchange glances.
    <p>Finally Neton says, <.q>If you must know, 
      there is one other planet, aside from Earth and Oo,
      that is inhabited by intelligent creatures. 
      The planet is called Zdad, or, as your ancient 
      Earth astronomers would have it, 18 Scorpii II. 
      However, to be honest, we'd rather not talk 
      about that.<./q>
    <p><.q>About a thousand years ago, the Oo 
      offered to help govern Zdad, 
      as a gesture of good will,<./q> says Ovan. 
      <.q>For some reason, the Zdadis refused our help. 
      So the next time we went to see them, 
      we tried even harder to persuade them. 
      And just for good measure, we also brought 
      the largest space fleet we had ever assembled. 
      Unfortunately, not only did the Zdadis deny us 
      again; they also destroyed our fleet. 
      So naturally Zdad is a bit of a sore spot for us, 
      even today.<./q> "
  qOff = [argRaces]
;

// -------------------------------------------------------------------
// ARGUMENT: Quips in the submenu "Ask about culture"
// -------------------------------------------------------------------

argUniversity: QuipInArgSubCulture
  "Ask about the Oo university system. "
  "<.q>What can you tell me about your university
      system?<./q> you ask.
    <p><.q>This campus you<./s>re sitting in 
      is the oldest Oo university campus on Earth,<./q> 
      says Neton. <.q>It was founded in 2102, 
      shortly after the Oo landed here. 
      Eventually other campuses were founded 
      in Africa, South America, and so on, 
      and then this campus became known as 
      the Center for Earthological Studies, 
      Australian Campus, or CESAC for short.<./q>
    <p><.q>In many ways our university isn<./s>t 
      all that different from a human university,<./q> 
      says Ovan. <.q>We have different ranks 
      of professors, administrators, and students. 
      And we teach classes, grant degrees, and 
      apply for research grants so we can play more 
      interactive fiction. The usual stuff.<./q> "
  qOff = [argUniversity]
;
argArt: QuipInArgSubCulture
  "Ask about art, literature, and music. "
  "<.q>If I remember right, you said you don<./s>t
      like art, literature, or music,<./q> you say.
      <.q>Is that really true?<./q>
    <p><.q>Overall, yes,<./q> says Neton. 
      <.q>Don't get me wrong; 
      ancient non-interactive media do have a 
      certain historical importance. 
      But, non-interactive as they are, 
      they are now seen as dull, quaint, 
      and virtually obsolete.<./q> "
  qOff = [argArt]
;
argIf: QuipInArgSubCulture
  "Ask about interactive fiction. "
  "<.q>You said you deem interactive fiction the highest
      form of art,<./q> you say. <.q>Why is that?<./q>
    <p><.q>If not interactive fiction, 
      then what else?<./q> asks Neton. 
      <.q>What else is so interactive, while also being 
      so steeped in the proud traditions 
      of the narrative arts?<./q>
    <p><.q>For me, it comes down to this,<./q> 
      says Ovan. <.q>Aside from interactive fiction, 
      no other form of art includes many mazes. 
      And personally, I can<./s>t summon much enthusiasm 
      for works without mazes.<./q> "
  qOff = [argIf]
;
argMazes: QuipInArgSubCulture
  "Ask about mazes. "
  reply {
    "<.q>Why do you have such a fascination with mazes,
        anyway?<./q> you ask. ";
    if (!glob.philistinismEnunciated) {
      "<p>Ovan sighs. 
        <p><.q>Indeed, one does not <i>have</i> 
          to like mazes,<./q> Neton says. 
          <.q>One does not <i>have</i> to like art, literature, 
          or even interactive fiction, for that matter. 
          There is nothing stopping you from being 
          a philistine and a nihilist, if that is what suits you. 
          Yes, by all means, feel free to dislike mazes.<./q> 
        <p><.q>You don<./s>t look like a nihilist to me,<./q>
          says Ovan. <.q>I<./s>m sure after you have
          a chance to think about it, you<./s>ll see the 
          appeal of mazes.<./q> ";
      // Change this variable, for what it's worth, although 
      // I don't think its value is ever checked again.
      glob.philistinismEnunciated = true;
    }
    else {
      "<.q>Yes, we discussed this before,<./q> says Neton. 
          <.q>If you<./s>re truly blind to the value 
          of mazes, then I fear we may not be able 
          to help you.<./q>
        <p><.q>I know how to help!<./q> says Ovan excitedly. 
          <.q>You should play <i>The 77 Identical Mazes 
          of Avotero.</i> That game is so fun, 
          nobody could play it without experiencing 
          the joy of mazes!<./q> ";
    }
  }
  qOff = [argMazes]
;
modify glob
  aliensKnowPcCheated = nil
;

// -------------------------------------------------------------------
// ARGUMENT: Quips in the submenu "Ask about the aliens' maze game"
// -------------------------------------------------------------------

argCheat: QuipInArgSubNbm
  "<.q>What is this <.s>cheat<./s> mode you speak 
    of?<./q> "
  reply {
    "<.q>What is this <.s>cheat<./s> mode you speak 
        of?<./q> you ask. ";
    if (!glob.aliensKnowPcCheated) {
      "Ovan replies, <.q>Oh, nothing big. 
          Just something I whipped up to help us 
          debug the game. Nothing you need 
          to worry about.<./q>
        <p><.q>Indeed, he does <i>not</i> need 
          to worry about it,<./q> says Neton. 
          <.q>Ovan, I wish you wouldn<./s>t 
          mention things like that.<./q>
        <p>Ovan glances away sheepishly. ";
    }
    else {
      "<.q>No, no,<./q> says Neton, giving you 
          a piercing glare. <.q>There<./s>s no use 
          protesting your innocence. 
          You brought up the subject of Sheila, 
          and you couldn<./s>t possibly have known 
          about her unless you had access 
          to the game<./s>s <.s>cheat<./s> mode. 
          Instead of experiencing the game 
          as it was meant to be experienced, 
          you played it on a tablet device, which gave you full access 
          to all the game's maps. ";
      if (beachChairM.isInExe)
        "Perhaps you even enjoyed the game from 
            the comfort of your very own beach chair. ";
      "Is this starting to sound familiar?<./q> 
          You say nothing, but Neton concludes, 
          <.q>Yes, human, you know all about 
          <.s>cheat<./s> mode.<./q> ";
    }
    // Don't just turn off this quip; *permanently*
    // turn it off.
    hasBeenUttered = true;
  }
  hasBeenUttered = nil
  isOn = nil
  qOff = [argCheat]
;
argNondisclosure: QuipInArgSubNbm
  "<.q>I<./s>ll never tell you how I cheated!<./q> "
  reply {
    "<.q>I<./s>ll never tell you how I cheated!<./q>
        you proclaim.
      <p><.q>Maybe not,<./q> says Neton. 
        <.q>That will pose an inconvenience 
        for the real Neton and Ovan, but not for long. 
        With a little effort, the real Neton and Ovan 
        can get access to the campus<./s>s 
        brain-wave pattern scanner, 
        which they can then use to extract 
        the information from your brain. 
        The process is long, and for humans 
        it is incredibly painful.<./q>
      <p><.q>From what I heard, the last human 
        subjected to the scanner raised an enormous 
        racket,<./q> says Ovan. 
        <.q>They could hear his howls of pain 
        all the way over in the school of medicine. 
        Apparently the med students were 
        seriously annoyed by it.<./q>
      <p><.q>But, as you say, you<./s>ll never tell,<./q> 
        says Neton. <.q>So the med students 
        will just have to suffer.<./q> ";
    // At this point we want to not only turn off, but 
    // *permanently* turn off argCheat.
    argCheat.hasBeenUttered = true;
  }
  isOn = nil
  qOff = [argNondisclosure, argDisclosure, argCheat]
;
argDisclosure: QuipInArgSubNbm
  "<.q>Let me tell you how I cheated.<./q> "
  reply {
    "For a moment, you consider telling Neton and Ovan 
        about how you hacked into their computer.
      <p>But then you realize that if you tell them, 
        you might be casting a death sentence 
        on any future people who might get subjected 
        to the maze game. In fact, for that matter,
        one of those people might be you. 
        So you change your mind and decide to remain 
        silent. ";
    // At this point we want to not only turn off, but 
    // *permanently* turn off argCheat.
    argCheat.hasBeenUttered = true;
  }
  isOn = nil
  qOff = [argNondisclosure, argDisclosure, argCheat]
;
argFirst: QuipInArgSubNbm
  "<.q>I bet I<./s>m the first person to have beat
    your game!<./q> "
  reply {
    "<.q>I bet I<./s>m the first person to have beat
        your game!<./q> you say. ";
    if (!glob.aliensKnowPcCheated) {
      "<p>Neton and Ovan exchange glances.
        <p>Then Neton says, <.q>If by <.s>person<./s> 
          you mean <.s>human,<./s> then indeed, 
          that is correct.<./q>
        <p><.q>Not only that, but until now, 
          nobody, human or Oo, has ever beaten the game 
          without using <.s>cheat<./s> mode,<./q> 
          says Ovan, furrowing his brow in perplexity.
        <p><.q>And for good reason. The odds of winning 
          without cheating are about 0.01 percent,<./q> 
          says Neton, who now starts to eye you 
          with suspicion. ";
      if (!argCheat.hasBeenUttered)
        argCheat.isOn = true;
    }
    else {
      "<p>Neton glares at you. <.q>If by <.s>person<./s> 
          you mean <.s>human,<./s> then indeed, 
          that is correct. However, since you cheated, 
          that is not much of an accomplishment.<./q>
        <p>Ovan nods in agreement. ";
    }
  }
  qOff = [argFirst]
;
argBad: QuipInArgSubNbm
  "<.q>Sorry to say this, but your game sucked.<./q> "
  "<.q>Sorry to say this, but your game sucked,<./q>
      you say.
    <p>Ovan gapes at you in dismay.
    <p>Neton shakes his head, then says, 
      <.q>I suppose I should have expected this. 
      This from a species that ignores the virtues 
      of repetitive mazes, while dolloping praise on
      <.s>mimesis,<./s> <.s>dynamic NPCs,<./s>
      and <.s>multilinear plots.<./s> 
      Well, human, now that you<./s>ve insulted our game, 
      what do I have to say? Only this: 
      go play a game with a plot! 
      Go play a game that fritters away its energy on 
      <.s>atmosphere,<./s> <.s>characterization,<./s> 
      and <.s>story.<./s> 
      In short, human, go play an Earth game!<./q>
    <p><.q>Wow, that<./s>s really telling him!<./q>
      shouts Ovan excitedly. "
  qOff = [argBad, argGood]
;
argGood: QuipInArgSubNbm
  "<.q>Your game was, uh, good. Yeah, 
    that<./s>s it.<./q> "
  "<.q>Your game was, uh, good,<./q> you say. <.q>Yeah, 
      that<./s>s it.<./q>
    <p><.q>Great!<./q> says Ovan, offering an enormous grin. 
      <.q>I<./s>m extremely glad to hear it!<./q>
    <p>Neton glances at you quizzically, 
      perhaps not sure whether to believe you. "
  qOff = [argBad, argGood]
;
argNext: QuipInArgSubNbm
  "<.q>Now that I<./s>ve finished your game,
    what happens to me next?<./q> "
  reply {
    "<.q>Now that I<./s>ve finished your game,
        what happens to me next?<./q> you ask.
      <p><.q>Well, you sit here, engage in this 
        conversation, and wait for us to 
        wake you up!<./q> says Ovan.
      <p><.q>I think he means after that,<./q>
        says Neton. Turning to you, he adds, ";
    if (!glob.aliensKnowPcCheated)
      "<.q>To be honest, we still haven<./s>t decided 
          what to do with you. For now, however, 
          you do still remain useful to us, 
          so no doubt we<./s>ll keep you around 
          a little while longer, at least.<./q> ";
    else
      "<.q>Well, I can say this much, human. 
          You cheated at our game, and we<./s>re 
          going to have to find out how you did it. 
          After we do that, I<./s>m not sure whether
          you<./s>ll be of any use to us. 
          And that leaves me in the position of 
          not being able to guarantee your health 
          and well-being for very much longer.<./q> ";
  }
  qOff = [argNext]
;
argSheila: QuipInArgSubNbm
  "<.q>What can you tell me about Sheila?<./q> "
  reply {
    "<.q>What can you tell me about Sheila?<./q>
        you ask.
      <p>Neton stares at you incredulously, then shouts, 
        <.q>What! You mean you know about Sheila?<./q> 
        Turning to Ovan, he shouts, <.q>How could this 
        have happened?<./q>
      <p>Ovan, looking confused, says, 
        <.q>I--uh--well, uh--I guess I don't know.<./q>
      <p>Neton sighs and shakes his head for a few seconds. 
        Then he says to Ovan, <.q>All right. <i>Somehow,</i> 
        the human got access to <.s>cheat<./s> mode, 
        but we don't know how. Therefore, our next task 
        is to find out. However long it takes, 
        we<./s>ll get that information out of him.<./q>
      <p>Looking around him, Ovan says, <.q>Without 
        a brain-wave pattern scanner?<./q>
      <p>Neton scowls, then says, <.q>No, no. 
        <i>We</i>--you and I here in this 
        conversation--don<./s>t need to do anything. 
        We<./s>ll save the interrogation for 
        the real Neton and the real Ovan, 
        after they wake up the human in the real world.<./q>
      <p><.q>Ah yes, good idea,<./q> says Ovan. 
        Then, musing, he adds, <.q>You know, 
        it<./s>s a good thing we made this 
        conversation menu inescapable. 
        It<./s>d be really bad if somehow the human 
        woke up before the real Neton and Ovan 
        figured all of this stuff out.<./q>
      <p><.q>Don<./s>t worry about that,<./q> says Neton. 
        <.q>Unless you designed this conversation 
        improperly, there<./s>s no way for that 
        to happen.<./q> ";
    glob.aliensKnowPcCheated = true;
    if (!argCheat.hasBeenUttered)
      argCheat.isOn = true;
    if (!argMemory.hasBeenUttered)
      argMemory.isOn = true;
  }
  qOff = [argSheila]
  qOn = [argNondisclosure, argDisclosure]
;
argHacman: QuipInArgSubNbm
  "<.q>What was the big idea with that Net-Hac-Man
    segment?<./q> "
  "<.q>What was the big idea with that Net-Hac-Man
      segment?<./q> you ask.
    <p>Neton glares at Ovan and shouts, 
      <.q>What! You actually left in that 
      ridiculous segment?<./q>
    <p><.q>But it's so cool!<./q> Ovan protests
      petulantly. <.q>I mean, I hate
      Earth games as much as the next guy, but 
      Pac-Man and NetHack--I mean, they both have mazes!
      Sure, they both have their bad parts, but 
      get rid of those, turn it
      into interactive fiction, and--well,
      you can<./s>t go wrong!<./q>
    <p><.q>That is the dumbest idea I<./s>ve ever
      heard!<./q> Neton howls. 
      <.q>I say it again: get rid of that ridiculous segment! 
      Really do it this time! Have you forgotten 
      that I can fire you if I want?<./q>
    <p>Ovan hangs his head sadly. "
  qOff = [argHacman]
;

//argSubNetonOvan: QSub
//;
//argSubSpecies: QSub
//;
//argSubEarth: QSub
//;
//argSubIF: QSub
//;

// -------------------------------------------------------------------
// ARGUMENT: Quips in the submenu "Ask about a different game"
// -------------------------------------------------------------------

argSubGame: QSub
  "Ask about a 
    <<argSubNbm.isOn ? 'different ' : ''>>game . . . "
  reply() { 
    glob.zeroDest = self; 
    //"What game would you like to ask about?";
  }
  options = [
     argGameAdventure
    ,argGameBorder
    ,argGameCave
    ,argGameCounterpoint
    ,argGameDeadline
    ,argGameEnchanter
    ,argGameFuture
    ,argGameGalatea
    ,argGameHunter //,argGameHitchhikers
    ,argGameInfidel
    ,argGameJigsaw
    ,argGameKnight
    ,argGameLosing
    ,argGameMindwheel
    ,argGameNord
    ,argGameOnce
    ,argGamePlanetfall //,argGamePawn
    ,argGameQuest
    ,argGameReturn
    ,argGameSlouching //,argGameSoFar
    ,argGameTimequest
    ,argGameUnnkulian
    ,argGameVaricella
    ,argGameWonderland //,argGameWorlds
    ,argGameXenos
    ,argGameYangtze
    ,argGameZork
    ,argBackToMain
    
    // argYowzers
    
    //,argCapitulate
    //,argUltraviolence
    //,argImMad
    //,argIAmAMan
    //,argBite
    //,argExplain
    //,argImStuck
  ]
  killZ = (glob.noApparentZero)
  zeroOption = argZeroOptionDefault
  //killQ = true
  quipQuestion = 'Which game would you like to ask about? '
  gameCounter = 0
;

class GameQuip: Quip
  desc = "<i><<gameTitle>></i>"
  transfer = argSubGame
  reply() {
    argSubGame.gameCounter++;
    if (argSubGame.gameCounter >= 6) {
      "<.q>Look,<./q> says Neton, <.q>we could talk about 
          Earth games all day. Some are better, some are worse.
          But in the final analysis, we<./s>ve never played 
          a game by an Earthling that we<./s>ve found truly 
          satisfying.<./q> 
        <p><.q>Don<./s>t feel bad,<./q> says Ovan. 
          <.q>Not every planet can produce a game as fantastic 
          as <i>Cave Maze VII.<./q></i> ";
      dontLikeIfIsWrittenByEarthling.execute;
    }
    else {
      initQuestion;
      initReply;
      badReason;
    }
    //"<p>What game would you like to ask about? ";
    argGameCave.isOn = true;
  }
  //initReply() { }
  initReply() {
    //"<.q>In some ways, <i><<gameTitleNoPunc>></i> 
    //    is not bad,<./q> says Neton. 
    //  <p><.q>However,<./q> says Ovan, ";
  }
  badReason() {
    local num;
    if (argSubGame.gameCounter >= howManyBadReasons)
      num = howManyBadReasons;
    else
      num = argSubGame.gameCounter;
    switch (num) {
      case 1:
        badReason1;
        break;
      case 2:
        badReason2;
        break;
      case 3:
        badReason3;
        break;
      default:
        badReason1;
        break;
    }
  }
  initQuestion() {
    //"<.q>";
    say(rand(
       '<.q>So, what do you think of <i>' + gameTitleNoPunc 
         + '?<./q></i> you ask. '
      ,'<.q>What do you think of <i>' + gameTitleNoPunc 
         + '?<./q></i> you ask. '
      //,'<.q>So, how did you like <i>' + gameTitleNoPunc 
      //   + '?<./q></i> you ask. '
      //,'<.q>How did you like <i>' + gameTitleNoPunc 
      //   + '?<./q></i> you ask. '
      ,'<.q>So, what<./s>s your opinion of <i>' 
        + gameTitleNoPunc + '?<./q></i> you ask. '
    ));
    "<p>";
  }
  sayHasMultipleAuthors() {
    "<.q>The thing that sucks about 
        <i><<gameTitleNoPunc>></i> is, it has a 
        definite incoherence,<./q> Neton says. <.q>You can 
        just tell it<./s>s because more than one author 
        worked on the game.<./q> 
      <p><.q>We don<./s>t like games by more than one author,<./q> 
        says Ovan. <.q>By contrast, <i>Cave Maze VII</i> 
        was written by exactly one author.<./q> ";
  }
  sayHasMagic() {
    
  }
  sayIsSetOnEarth() {
    "<.q>In some ways, <i><<gameTitleNoPunc>></i> 
        is not so bad,<./q> says Neton, 
        <.q>but it also has a certain parochial 
        narrowness. The game is set entirely on the planet Earth.
        How are we supposed to care about what happens
        in some petty backwater of the galaxy?<./q> 
      <p><.q>That<./s>s right,<./q> says Ovan. <.q>We don<./s>t 
        usually like games set on Earth.<./q> 
      <p><.q>On the other hand, we do like 
        <i>Cave Maze VII,</i> which is not set on 
        Earth,<./q> says Neton. ";
  }
  sayIsPost1997() {
    "<.q>In all honesty,<./q> says Neton, 
        <i><.q><<gameTitleNoPunc>></i> is pretty much 
        bad all the way around. It<./s>s not a treasure
        hunt, it doesn<./s>t contain any mazes, and in general 
        it doesn<./s>t even try to do anything that we find 
        enjoyable.<./q> He shakes his head sadly. <.q>In short, 
        it<./s>s your typical post-1997 Earth game.<./q>
      <p><.q>When it comes to Earth games,<./q> agrees Ovan, 
        <.q>we avoid the ones after 1997 as a Zdadi livestock 
        farmer would avoid the deadly Allbole virus.<./q> 
      <p><.q>On the other hand,<./q> says Neton, <.q>The same 
        is not true of games written in other star systems.<./q> 
      <p><.q>Not at all,<./q> says Ovan. <i><.q>Cave Maze 
        VII</i> was written long after 1997, and already 
        it is a classic.<./q> ";
  }
  //sayHasGraphics() {
  //  "<.q>There<./s>s something I don<./s>t get about 
  //      <i><<gameTitleNoPunc>>,<./q></i>
  //      says Neton. <.q>It contains graphics.<./q> 
  //    <p><.q>What<./s>s the point in a text adventure, 
  //      if it<./s>s going to contain graphics?<./q> asks Ovan.
  //    <p><.q>It goes without saying,<./q> says Neton, 
  //      <.q>that we turn up our noses to such <.s>graphical 
  //      text adventures.<./s><./q>
  //    <p><.q>It also goes without saying that, whatever 
  //      else you mg.";
  //}
  
  //// Border Zone
  //sayIsMystery(true, 'that one spy game', 
  //  'spying around and stuff');
  //// Counterpoint
  //sayIsMystery(nil, 'that crime-solving game, the one from about 2030', 
  //  'solving crimes ond stuff');
  //// Deadline
  //sayIsMystery(nil, 'that game where you solve the murder',
  //  'solving murders and stuff'); 
  //// Yangtze Blues
  //sayIsMystery(nil, 'that crime-solving game, the one from about 2055', 
  //  'solving crimes and stuff');
  sayIsMystery(espionage, description, emphasis) {
    // espionage = true/nil
    // description and emphasis are single-quoted strings
    "<.q>You mean <<description>>,<./q> says Ovan.
        <.q>To be honest, I didn<./s>t like that game much.
        It placed way too much emphasis on--well,
        <<emphasis>>.<./q> 
      <p><.q>Maybe so,<./q> says Neton. 
        <.q>But surely you realize that was on purpose.
        Back in the old days, humans referred
        to such games as 
        <.s><<espionage ? 'spy thrillers' : 'mysteries'>>.<./s><./q> 
      <p><.q>Yeah, I know,<./q> says Ovan. 
        <.q>And I know this was before 
        <<espionage ? 'spies' : 'cops'>>
        had brain-wave pattern scanners. 
        But that<./s>s just it.
        I can<./s>t see the appeal of reading about
        <<espionage ? 'spies' : 'crime solvers'>>
        floundering about in the dark using Stone Age
        technology.<./q>
      <p><.q>Good point,<./q> says Neton.
        <.q>Come to think of it, not only 
        <.s><<espionage ? 'spy thrillers' : 'mysteries'>>,<./s>
        but also
        <.s><<espionage ? 'mysteries' : 'spy thrillers'>><./s>
        are flawed in this regard. 
        Such games certainly do appear dated now. 
        Especially when compared with, say,
        <i>Cave Maze VII.<./q></i>
      <p><.q>Yeah, no contest there,<./q> says Ovan. ";
  }
  sayLacksCave(advantage) {
    "<i><.q><<gameTitleNoPunc>></i> isn<./s>t all bad,<./q> 
        says Neton.
        <.q><<advantage>>Unfortunately, however,
        the game has a fatal flaw: 
        it doesn<./s>t have any cave.<./q>
      <p><.q>I<./s>ve said it once, and I<./s>ll
        say it again. No game is complete 
        without a cave!<./q> Ovan shouts.
      <p><.q>Indeed, I think games without caves
        are often hard-pressed to sustain the player<./s>s 
        interest,<./q> says Neton. <.q>I mean, 
        take <i>Cave Maze VII,</i> for instance. 
        It has a gigantic cave, and it is already a classic. 
        <i>Annoyotron,</i> however, has no cave, 
        and it is not quite as good. Coincidence? 
        I think not.<./q> ";
  }
  //sayIsNotTreasureHunt() {
  //}
  sayLacksMaze() {
    "<.q>Aside from its poor setting, its so-so story,
        and its generally uninteresting subject 
        matter,<./q> says Neton, <.q>the worst thing about 
        <i><<gameTitleNoPunc>></i> is that it 
        doesn<./s>t have any maze.<./q> 
      <p><.q>I don<./s>t get it,<./q> 
        says Ovan. <.q>If you<./s>re
        not going to include a maze, 
        why write a game at all?<./q> 
      <p>Then, musing, Neton adds, <.q>You know, I wonder 
        if the game was supposed to be satirical.
        Perhaps the purpose of <i><<gameTitleNoPunc>></i>
        was to show people just how unsatisfying
        a game can be if it stubbornly refuses
        to include a maze.<./q>
      <p>Shaking his head, Ovan says,
        <.q>Yeah, well, I wouldn<./s>t overthink the issue.
        No matter how you slice it, <i><<gameTitleNoPunc>></i>
        has no maze, so I<./s>m going to avoid it
        the way a Zdadi livestock farmer
        would avoid the deadly Allbole virus.<./q>
      <p><.q>Yeah, me too,<./q> Neton admits. ";
  }
  sayIsHistorical(setWhen) {
    "<i><.q><<gameTitleNoPunc>></i> has a kind of 
        quaint charm,<./q> says Neton, <.q>but unfortunately, 
        <<setWhen>>. Personally, I didn<./s>t 
        like that aspect of it.<./q> 
      <p><.q>Me neither,<./q> says Ovan. 
        <.q>In fact, I think what bothered me is that the game
        took place before the advent of interactive fiction.
        Maybe it<./s>s just me, but I can<./s>t summon 
        much enthusiasm for a world without IF.<./q>
      <p><.q>Not even for <i>playing an IF game</i>
        about a world without IF?<./q> asks Neton.
      <p><.q>No,<./q> says Ovan decisively. 
      <p><.q>I see,<./q> says Neton. 
        <.q>Well, for my part, I thought the game evinced a certain 
        parochial narrowness. Unless you have a special
        interest in Earth history, you<./s>re probably
        not going to like <i><<gameTitleNoPunc>>.<./q></i>
      <p><.q>Good point,<./q> says Ovan. <.q>Well, 
        it<./s>s just too bad
        the author<<hasMultipleAuthors ? 's' : ''>> 
        of that game never played 
        <i>Cave Maze VII.</i> If 
        <<hasMultipleAuthors ? 'they had, then they' : 'he had, then he'>>
        would have learned how it<./s>s done.<./q>
      <p><.q>Indeed,<./q> says Neton. <.q>If there<./s>s any
        game that avoids being set in the past, it<./s>s 
        <i>Cave Maze VII.<./q></i> ";
  }
  sayIsSurreal() {
    "<i><.q><<gameTitleNoPunc>>?<./q></i> says Ovan. 
        <.q>I didn<./s>t understand that game at all.<./q> 
      <p><.q>It certainly did depict events that were 
        impossible, random, and hard to understand,<./q> 
        says Neton. 
        <.q>However, some humans like that sort of thing. 
        They call it <.s>surreal.<./s><./q> 
      <p><.q>Oh, that<./s>s just great,<./q> says Ovan, 
        rolling his eyes. <.q>I think I<./s>ll write a game 
        about a jellyfish that learns to bake a chocolate cake. 
        When people complain,  I<./s>ll call it 
        <.s>surreal.<./s><./q> 
      <p><.q>Good one,<./q> says Neton, chuckling.
        <.q>To be fair, however, remember that humans 
        never had exposure
        to games as eminently logical as <i>Cave Maze VII.</i> 
        How could they have known that there were higher standards
        to aim for?<./q>
      <p>Ovan shrugs, acknowledging the point. ";
  }
  sayHasCheese(cheeseStr) {
    "<.q>Of all the bad things to be found in 
        <i><<gameTitleNoPunc>>,<./q></i>
        says Neton, <.q>what bothers me most is that it 
        contains <<cheeseStr>> ";
    sayHasCheese2;
  }
  sayHasCheese2 {
    "I don<./s>t know about you, 
        but I think cheese is more than a little bit 
        disturbing.<./q> 
      <p><.q>Me too,<./q> says Ovan. <.q>If computer 
        games were lunch counters, I<./s>d say, 
        <.s>Hold the cheese.<./s><./q> 
      <p><.q>I don<./s>t care what kind of game
        you want me to play,<./q>
        says Neton. <.q>If it contains cheese, 
        I<./s>m not interested.<./q>
      <p><.q>I agree,<./q> says Ovan. <.q>I mean,
        look at <i>Cave Maze VII.</i> It<./s>s got more rooms
        than any other game, but no cheese anywhere.
        If it can do it, any game can.<./q> ";
  }
  gameTitle = ''
  gameTitleNoPunc = gameTitle
  gameTitlePlural(str) {
    return gameTitleNoPunc + '</i>s' + str + '<i>';
  }
  howManyBadReasons = 3
  hasMultipleAuthors = nil
  hasMagic = nil
  isSetOnEarth = nil
  isPost1997 = nil // Non-Earth games don't count for this.
  hasGraphics = nil
  isMystery = nil // includes espionage too
  lacksCave = nil
  isNotTreasureHunt = nil
  lacksMaze = nil
  isHistorical = nil // for any game set in the past rather than the present or future
  isSurreal = nil
  hasCheese = nil
  isWrittenByEarthling = true
;


argGameAdventure: GameQuip
  gameTitle = 'Adventure'
  qOff = [argGameAdventure]
  initReply() {
    "<.q>In many ways,<./q> Neton says, 
        <i><.q>Adventure</i> seems the 
        perfect game. It<./s>s got cruel mazes, 
        randomized combat, loads of treasure--<./q> 
      <p><.q>--and one really huge cave!<./q> cries Ovan. ";
  }
  hasMultipleAuthors = true
  hasMagic = true
  isSetOnEarth = true
  hasCheese = true // Swiss Cheese Room
  badReason1 {
    "<p><.q>Unfortunately, however,<./q> says Neton, 
        <.q><i>Adventure</i> has a fatal flaw. 
        It contains a room called 
        the <.s>Swiss Cheese Room.<./s> ";
    sayHasCheese2;
    dontLikeIfHasCheese.execute;
  }  
  howManyBadReasons = 1
;
argGameBorder: GameQuip
  gameTitle = 'Border Zone'
  qOff = [argGameBorder]
  isSetOnEarth = true
  isMystery = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  initReply() {
  }
  badReason1 {
    sayIsMystery(true, 'that one spy game', 
      'spying around and stuff');
    //"<.q>We generally don<./s>t like games about espionage,<./q> 
    //    says Neton. 
    //  <p><.q>Or mystery games, either,<./q> adds Ovan. 
    //  <p><.q>For instance, take <i>Cave Maze VII.</i> 
    //    It<./s>s not an espionage game.<./q> 
    //  <p><.q>And not a mystery, either,<./q> says Ovan. 
    //  <p><.q>Exactly.<./q> "; 
    dontLikeIfIsMystery.execute;
  }
  badReason2 {
    sayLacksCave('It has some high-tech spy gear, which is always nice. ');
    dontLikeIfLacksCave.execute;
  }
  badReason3 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
;
argGameCave: GameQuip
  gameTitle = 'Cave Maze VII'
  isOn = nil
  //qOff = [argGameCave]
  roomCount = 64
  highestPermissibleNumber = 65536
  quipCount = 1
  multiplicationFactor = 4
  errorMessage = nil
  transfer = (errorMessage ? nil : argSubGame)
  reply() {
    if (roomCount <= highestPermissibleNumber) {
      "<.q>So what do you think of <i>Cave Maze VII?<./q></i>
          you ask. 
        <p><<ovanCaveQuips[quipCount]>> 
        <p><<netonCaveQuips[quipCount]>>
        <p><.q>Why, <<mazeNames[quipCount]>> probably 
          contain<<mazeNames[quipCount].toLower.find('mines') ? '' : 's'>>
          <<commaNumber(roomCount)>> rooms!<./q> says Ovan gleefully.
        <p><.q>Feel free to ask about <i>Cave Maze VII</i>
          as much as you want,<./q> says Neton. 
          <.q>We never get tired of talking about
          <<gameDescriptions[quipCount]>>.<./q> ";
      quipCount++;
      roomCount = roomCount * multiplicationFactor;
    }
    else {
      "<.q>So what do you think of <i>Cave Maze VII?<./q></i>
          you ask. 
        <p><<ovanCaveQuips[quipCount]>> 
        <p><<netonCaveQuips[quipCount]>>
        <p><.q>Why, <<mazeNames[quipCount]>> probably contains
        <p>SUBSCRIPT OUT OF RANGE: ARGUMENT.M, LINE 16339
        <p>OK ";
      // When errorMessage is set to true, transfer is set to nil,
      // and thus the conversation ends.
      errorMessage = true;
    }
  }
  ovanCaveQuips = [
     '<.q>Ooh, I can<./s>t say enough about <i>Cave Maze VII!<./q></i> 
       says Ovan. <.q>It<./s>s the ultimate game!<./q> '
    ,'<i><.q>Cave Maze VII,</i> a real masterpiece!<./q> says Ovan. 
       <.q>Even better than <i>The Forever Mazes!<./q></i> '
    ,'<.q>I just love <i>Cave Maze VII!<./q></i> says Ovan. 
       <.q>It<./s>s the best!<./q> '
    ,'<.q>I can<./s>t get enough of <i>Cave Maze VII!<./q></i> 
       says Ovan. <.q>I could play it all day long!<./q> '
    ,'<i><.q>Cave Maze VII</i> is my all-time favorite!<./q> 
       says Ovan. <.q>What an awesome game!<./q> '
    ,'<.q>There<./s>s never been a better game than <i>Cave Maze VII!<./q></i> 
       says Ovan. <.q>What an exceptional game!<./q> '
    ,'<i><.q>Cave Maze VII</i> is the best game ever written!<./q> 
       says Ovan. <.q>A real original!<./q> '
    ,'<i><.q>Cave Maze VII,</i> an outstanding game!<./q> says Ovan. 
       <.q>It<./s>s beyond compare!<./q> '
  ]
  netonCaveQuips = [
     '<.q>Indeed, the virtues of <i>Cave Maze VII</i> would be hard 
       to enumerate,<./q> says Neton. <.q>It<./s>s got more rooms 
       than any other game, and I can think of no higher praise 
       than that.<./q> '
    ,'<.q>Indeed, no other game really comes close to 
       <i>Cave Maze VII,<./q></i> says Neton. <.q>It<./s>s been called 
       the apotheosis of all games.<./q> '
    ,'<.q>Indeed, it<./s>s hard to think of a better game than 
       <i>Cave Maze VII,<./q></i> says Neton. <.q>The complexity 
       of its mazes is second to none.<./q> '
    ,'<.q>Indeed, <i>Cave Maze VII</i> is remarkable in a number 
       of ways,<./q> says Neton. <.q>It makes unparalleled use 
       of hunger timers, sleep timers, and even, in some cases, 
       oxygen timers.<./q> '
    ,'<.q>Indeed, one would be hard-pressed to think of a better game 
       than <i>Cave Maze VII,<./q></i> says Neton. <.q>It<./s>s got 
       excellent examples of every major classification of maze.<./q> '
    ,'<.q>Indeed, <i>Cave Maze VII</i> is a brilliant exemplar 
       of a game,<./q> says Neton. <.q>Speaking as a theoretician, 
       I think no other game that offers as much potential for analysis 
       and criticism.<./q> '
    ,'<.q>Indeed, <i>Cave Maze VII</i> is a real masterpiece,<./q> 
       says Neton. <.q>It perfectly demonstrates the full 
       artistic potential of mazes.<./q> '
    ,'<.q>Indeed, no game has come closer to achieving perfection 
       than <i>Cave Maze VII,<./q></i> says Neton. <.q>It will go down 
       in history as one of the best games ever.<./q> '
  ]
  gameDescriptions = [
     'the greatest game ever written'
    ,'the best game ever'
    ,'such a true masterpiece'
    ,'the greatest game ever written'
    ,'such a true masterpiece'
    ,'the best game ever'
    ,'such a true masterpiece'
    ,'the best game ever'
  ]
  mazeNames = [
     'just the Maze of Mirrors'
    ,'just the Maze of Wishing'
    ,'just the House of Corridors'
    ,'the Emperor<./s>s Maze alone'
    ,'just the Maze of Darkness'
    ,'the Salt Mines alone'
    ,'just the Circular Maze'
    ,'the Cube Maze alone'
    ,'just the Maze of Diamonds'
  ]
  isWrittenByEarthling = nil
;
commaNumber(num) {
  local str = toString(num);
  local position;
  if (str.length <= 3)
    return str;
  for (local a = 1; a <= (str.length - 1) / 3; a++) {
    position = str.length + 1 - (3 * a);
    str = str.substr(1, position - 1) + ',' + str.substr(position);
  }
  return str;
}
argGameCounterpoint: GameQuip
  gameTitle = 'Counterpoint'
  qOff = [argGameCounterpoint]
  hasMultipleAuthors = true
  hasMagic = true
  isSetOnEarth = true
  isPost1997 = true
  hasGraphics = true
  isMystery = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  isHistorical = true
  isSurreal = true
  hasCheese = true
  hasGarlic = true
  initReply() { 
    //"<.q>Counterpoint<./q> "; 
  }
  badReason1 {
    sayIsMystery(nil, 'that crime-solving game, the one from about 2030', 
      'solving crimes ond stuff');
    //"<i><.q>Counterpoint?<./q></i> says Ovan. <.q>That<./s>s 
    //    one of those mysteries, isn<./s>t it, from the 
    //    early twenty-first century?<./q> 
    //  <p><.q>Who cares what century it<./s>s from!<./q> 
    //    says Neton with a scowl. <.q>If you<./s>re going to play 
    //    a mystery, you might as well play a spy thriller.<./q> 
    //  <p><.q>By contrast,<./q> says Ovan, 
    //    <i><.q>Cave Maze VII</i> is not a mystery.<./q> 
    //  <p><.q>It<./s>s not a spy thriller, either,<./q> 
    //    says Neton. ";
    dontLikeIfIsMystery.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 2
;
argGameDeadline: GameQuip
  gameTitle = 'Deadline'
  qOff = [argGameDeadline]
  isSetOnEarth = true
  isMystery = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  initReply() {
    //"<.q><./q> ";
  }
  badReason1 {
    sayIsMystery(nil, 'that game where you solve the murder',
      'solving murders and stuff'); 
    dontLikeIfIsMystery.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 2
;
argGameEnchanter: GameQuip
  gameTitle = 'Enchanter'
  qOff = [argGameEnchanter]
  hasMultipleAuthors = true
  hasMagic = true
  lacksCave = true
  isNotTreasureHunt = true
  initReply() {
    //"<.q><./q> ";
  }
  badReason1 {
    //sayLacksCave('It has a generic fantasy setting, which is always nice. ');
    "Neton shakes his head and sighs. <i><.q>Enchanter</i> 
        is one of those sad cases. It<./s>s one of those 
        early games that drove text adventures away from 
        the pure treasure-hunting joy of games like 
        <i>Adventure</i> and <i>Zork.<./q></i> 
      <p><.q>Not just that, but <i>Enchanter</i> 
        has no cave at all!<./q> cries Ovan. 
        <.q>If I<./s>ve said it once, I<./s>ve said it
        1,024 times! No game is ever complete without a cave!<./q>
      <p><.q>Indeed, I think games without caves
        are often hard-pressed to sustain the player<./s>s 
        interest,<./q> says Neton. <.q>I mean, 
        take <i>Cave Maze VII,</i> for instance. 
        It has a gigantic cave, and it is already a classic. 
        <i>Annoyotron,</i> however, has no cave, 
        and it is not quite as good. Coincidence? 
        I think not.<./q> ";
    dontLikeIfLacksCave.execute;
  }
  howManyBadReasons = 1
;
argGameFuture: GameQuip
  gameTitle = 'Future Boy!'
  qOff = [argGameFuture]
  gameTitleNoPunc = 'Future Boy'
  isSetOnEarth = true
  isPost1997 = true
  hasGraphics = true
  lacksCave = true
  isNotTreasureHunt = true
  hasCheese = true // "Wheel of Cheese" is mentioned in that one radio segment.
  lacksMaze = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 1
;
argGameGalatea: GameQuip
  gameTitle = 'Galatea'
  qOff = [argGameGalatea]
  isSetOnEarth = true
  isPost1997 = true
  lacksCave = true
  hasCheese = true // You can ask Galatea about cheese.
  isNotTreasureHunt = true
  lacksMaze = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    // Note the empty string argument in sayLacksCave(). This 
    // indicates that I have given up on trying to name something
    // about Galatea that Neton would consider a good quality. 
    // It's too far removed from the kind of thing he likes.
    sayLacksCave('');
    //sayLacksCave('I especially like the title, because 
    //  <.s>galatea<./s> is also the word for an exceptionally unique 
    //  flamingo-like mammal on the planet Zdad. ');
    dontLikeIfLacksCave.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 2
;
argGameHunter: GameQuip
  gameTitle = 'Hunter, in Darkness'
  qOff = [argGameHunter]
  //hasMultipleAuthors = nil
  //hasMagic = nil
  //isSetOnEarth = nil
  isPost1997 = true // Non-Earth games don't count for this.
  isNotTreasureHunt = true
  badReason1 {
    "<.q>When I first started playing <i>Hunter,
        in Darkness,</i> I thought it was going to be great,<./q>
        says Ovan. 
        <.q>Nothing but a huge cave, with a big maze
        to boot! But then, 
        the more I played it, the more it started to 
        seem--well, <i>wrong,</i> somehow.<./q>
      <p>Neton adds, <.q>The whole reason why  caves are so
        great for IF is that, being dark, they provide
        an excellent excuse to omit any sensory details
        that might otherwise engage the player<./s>s imagination.<./q>
      <p><.q>I don<./s>t like games that try to engage 
        my imagination,<./q> says Ovan. <.q>It makes it harder
        for me to treat the game as a completely generic
        puzzlefest.<./q>
      <p><.q>If there<./s>s anything Ovan and I agree on,
        it<./s>s that we don<./s>t like games without caves,<./q>
        says Neton. <.q>But just having a cave 
        is insufficient. The cave has to be reported 
        in a typical cave-crawl fashion, not 
        like the one in <i>Hunter, in Darkness.<./q></i> ";
    dontLikeIfLacksCave.execute;
  }  
  howManyBadReasons = 1
;
argGameInfidel: GameQuip
  gameTitle = 'Infidel'
  qOff = [argGameInfidel]
  isSetOnEarth = true
  lacksCave = true
  lacksMaze = true
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsHistorical('it is set in the 1920s');
    dontLikeIfIsHistorical.execute;
  }  
  //badReason2 {
  //  "<.q>I kind of liked some aspects of <i>Infidel,<./q></i> 
  //      says Neton. <.q>It<./s>s a big treasure hunt, just 
  //      like <i>Cave Maze VII.</i> Ultimately, however, 
  //      <i>Infidel</i> is of only minor interest 
  //      to non-Earthlings. I mean, who really cares about 
  //      the types of treasures to be found here on Earth?<./q> 
  //    <p><.q>We don<./s>t usually like games set on the 
  //      planet Earth,<./q> says Ovan. 
  //    <p><.q>On the other hand, we do like <i>Cave Maze VII,</i> 
  //      which is not set on Earth,<./q> says Neton. ";
  //  dontLikeIfIsSetOnEarth.execute;
  //}  
  howManyBadReasons = 1
;
argGameJigsaw: GameQuip
  gameTitle = 'Jigsaw'
  qOff = [argGameJigsaw]
  hasMagic = true
  isSetOnEarth = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  //hasCheese = true // It has cheesecake. Does that count?
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsHistorical('it is set in various time 
      periods in the twentieth century');
    dontLikeIfIsHistorical.execute;
  }  
  badReason2 {
    sayLacksCave('You certainly can<./s>t fault it for lack of cruel puzzles. ');
    dontLikeIfLacksCave.execute;
  }
  howManyBadReasons = 2
;
argGameKnight: GameQuip
  gameTitle = 'Knight Orc'
  qOff = [argGameKnight]
  hasMagic = true
  hasGraphics = true
  hasGarlic = true // The walkthrough says Knight Orc contains garlic.
  //lacksMaze = true //Robb Sherwin tells me that it does in fact have a maze.
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    //sayLacksCave('It has a generic fantasy setting, not to mention a dragon, which is always nice. ');
    "<.q>On the surface, it would seem that <i>Knight Orc</i>
        has an awful lot going for it,<./q> says Neton.
        <.q>It<./s>s got a maze, it<./s>s got a castle--heck,
        it<./s>s even got a dragon. For that matter,
        it also has a cave, but unfortunately, therein
        lies the problem.<./q>
      <p><.q>No kidding,<./q> says Ovan. <.q>That cave
        in <i>Knight Orc</i>--why, it<./s>s barely a cave
        at all, just a single room.<./q>
      <p><.q>If there<./s>s anything Ovan and I agree on,
        it<./s>s that we don<./s>t like games without caves,<./q>
        says Neton. <.q>But just having a cave 
        is insufficient. The cave has to be really big, not 
        like the one in <i>Knight Orc.<./q></i> ";
    dontLikeIfLacksCave.execute;
  }  
  howManyBadReasons = 1
;
argGameLosing: GameQuip
  gameTitle = 'Losing Your Grip'
  qOff = [argGameLosing]
  isSetOnEarth = true
  isPost1997 = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  hasCheese = true // there's cheese on a banquet table
  isSurreal = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsSurreal;
    dontLikeIfIsSurreal.execute;
  }  
  badReason2 {
    sayLacksCave('You certainly can<./s>t fault it for lack of cruel puzzles. ');
    dontLikeIfLacksCave.execute;
  }
  badReason3 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
;
argGameMindwheel: GameQuip
  gameTitle = 'Mindwheel'
  qOff = [argGameMindwheel]
  isSetOnEarth = true
  lacksCave = true
  isNotTreasureHunt = true
  hasCheese = true // the game understands the word "cheese," so it must have cheese somewhere
  isSurreal = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsSurreal;
    dontLikeIfIsSurreal.execute;
  }  
  badReason2 {
    sayLacksCave('You certainly can<./s>t fault it for lack of puzzles. ');
    dontLikeIfLacksCave.execute;
  }  
  howManyBadReasons = 2
;
argGameNord: GameQuip
  gameTitle = 'Nord and Bert Couldn<./s>t Make Head or Tail of It'
  //gameTitlePlural = 'Nord and Bert</i>s<i>'
  gameTitlePlural(str) { return 'Nord and Bert</i>s' + str + '<i>'; }
  qOff = [argGameNord]
  isSetOnEarth = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true 
  // I TXD'd the game. Aside from a simile where a rat's teeth are said
  // to be as big as cheese wedges, the word "cheese" is not used.
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayLacksCave('You certainly can<./s>t fault it for lack of puzzles. ');
    dontLikeIfLacksCave.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 2
;
argGameOnce: GameQuip
  gameTitle = 'Once and Future'
  qOff = [argGameOnce]
  hasMagic = true
  isPost1997 = true
  isNotTreasureHunt = true
  lacksMaze = true // a look at the walkthrough seemed to indicate this
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsHistorical('the game opens during the Vietnam War, 
      and also contains other references to the 1960s');
    dontLikeIfIsHistorical.execute;
  }  
  howManyBadReasons = 1
;
argGamePlanetfall: GameQuip
  gameTitle = 'Planetfall'
  qOff = [argGamePlanetfall]
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true // a huge sprawling complex of rooms, but no real maze.
  // Searching the decompiled source reveals no cheese.
  // I repeat, no cheese. The can says "Spam 'n Egz,"
  // not "Spam 'n Cheez" or whatever.
  badReason1 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  badReason2 {
    sayLacksCave('You certainly can<./s>t fault it for lack of puzzles. ');
    dontLikeIfLacksCave.execute;
  }
  howManyBadReasons = 2
;
argGameQuest: GameQuip
  gameTitle = 'Quest for the Sangraal'
  qOff = [argGameQuest]
  hasMagic = true
  isSetOnEarth = true
  isNotTreasureHunt = true
  isHistorical = true
  hasCheese = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayHasCheese('an enormous Dutch cheese.');
    dontLikeIfHasCheese.execute;
  }
  howManyBadReasons = 1
;
argGameReturn: GameQuip
  gameTitle = 'Return to Pirate<./s>s Island'
  qOff = [argGameReturn]
  isSetOnEarth = true
  lacksCave = true
  lacksMaze = true
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsHistorical('since it is a pirate game,
      I gather that it is set in Earth<./s>s past');
    dontLikeIfIsHistorical.execute;
  }  
  howManyBadReasons = 1
;
argGameSlouching: GameQuip
  gameTitle = 'Slouching Towards Bedlam'
  qOff = [argGameSlouching]
  hasMultipleAuthors = true
  isSetOnEarth = true
  isPost1997 = true
  isNotTreasureHunt = true
  isHistorical = true // alternate history
  // decompiling it and searching the source reveals no cheese references
  badReason1 {
    sayIsHistorical('although it depicts an alternate history,
      it<./s>s still obviously set in the nineteenth century');
    dontLikeIfIsHistorical.execute;
  }  
  howManyBadReasons = 1
;
argGameTimequest: GameQuip
  gameTitle = 'Timequest'
  qOff = [argGameTimequest]
  isSetOnEarth = true
  hasGraphics = true
  isNotTreasureHunt = true
  lacksMaze = true
  lacksCave = true
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsHistorical('it is set in various different time 
      periods in Earth<./s>s past, mostly between 1361 BC 
      and 1940 AD');
      // 2090 AD, actually.
    dontLikeIfIsHistorical.execute;
  }  
  howManyBadReasons = 1
;
argGameUnnkulian: GameQuip
  gameTitle = 'Unnkulian Underworld: The Unknown Unventure'
  qOff = [argGameUnnkulian]
  gameTitleNoPunc = 'Unnkulian Underworld'
  hasMagic = true
  isNotTreasureHunt = true
  hasCheese = true // the ubiquitous "Cheez"
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayHasCheese('references to an 
      abominable substance called <.s>cheez.<./s>');
    dontLikeIfHasCheese.execute;
  }  
  howManyBadReasons = 1
;
argGameVaricella: GameQuip
  gameTitle = 'Varicella'
  qOff = [argGameVaricella]
  isSetOnEarth = true
  isPost1997 = true
  hasGraphics = true
  isNotTreasureHunt = true
  lacksMaze = true
  hasCheese = true // You can order a pizza. It is thrown and lands cheese-side down.
  isHistorical = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  //badReason1 {
  //  "<.q>dontLikeIfHasGraphics.<./q> ";
  //  dontLikeIfHasGraphics.execute;
  //}  
  badReason1 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 1
;
argGameWonderland: GameQuip
  gameTitle = 'Wonderland'
  qOff = [argGameWonderland]
  hasMagic = true
  hasGraphics = true
  lacksCave = true
  isNotTreasureHunt = true // Questionable, perhaps. But I'll say it's not a treasure hunt.
  lacksMaze = true
  isSurreal = true
  // type "x cheese" and the game says "I don't understand cheese"
  badReason1 {
    // amend - say that the rabbit hole doesn't count as a cave
    sayLacksCave('You certainly can<./s>t fault it for lack of cruel puzzles. ');
    dontLikeIfLacksCave.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }
  howManyBadReasons = 2
;
argGameXenos: GameQuip
  gameTitle = 'Xenos'
  //gameTitlePlural = 'Xenos</i>es<i>'
  gameTitlePlural(str) { return 'Xenos</i>es' + str + '<i>'; }
  qOff = [argGameXenos]
  isSetOnEarth = true
  lacksCave = true
  isNotTreasureHunt = true
  initReply() {
    "<.q>I can<./s>t say enough about <i>Xenos!<./q></i> 
        Ovan shouts, his eyes gleaming. <.q>When my life was 
        at its lowest, that game turned it all around 
        and inspired me to make something of myself. 
        If you only play one Earth game in your entire life, 
        it must be this one!<./q> 
      <p>Neton raises his eyebrows indulgently. 
        <.q>Certainly, Ovan. But while the game has 
        its strengths, it is not flawless. ";
  }
  badReason1 {
    //sayLacksCave('You certainly can<./s>t fault it for lack of cruel puzzles. ');
    "For instance, <i>Xenos</i> is devoid of any cave. 
        No game is complete without a cave.<./q> 
      <p>Ovan hangs his head and nods in agreement. 
      <p><.q>As a general rule,<./q> says Neton, 
        <.q>We don<./s>t like games unless they have caves. 
        Take <i>Cave Maze VII,</i> for instance. 
        It has a cave, and we love it. <i>Annoyotron,</i> 
        however, has no cave, and it is not quite as good. 
        Coincidence? I think not.<./q> ";
    dontLikeIfLacksCave.execute;
  }  
  //badReason2 {
  //  sayIsSetOnEarth;
  //  dontLikeIfIsSetOnEarth.execute;
  //}  
  howManyBadReasons = 1
;
argGameYangtze: GameQuip
  gameTitle = 'Yangtze Blues'
  //gameTitlePlural = 'Yangtze Blues</i>es<i>'
  gameTitlePlural(str) { return 'Yangtze Blues</i>es' + str + '<i>'; }
  qOff = [argGameYangtze]
  isSetOnEarth = true
  isPost1997 = true
  isMystery = true
  lacksCave = true
  isNotTreasureHunt = true
  lacksMaze = true
  isHistorical = true
  hasCheese = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsMystery(nil, 'that crime-solving game, the one from about 2055', 
      'solving crimes and stuff');
    //"<i><.q>Yangtze Blues?<./q></i> says Ovan. <.q>That<./s>s 
    //    one of those mysteries, isn<./s>t it, from the early 
    //    twenty-first century?<./q> 
    //  <p><.q>Who cares what century,<./q> says Neton 
    //    with a scowl. <.q>If you<./s>re going to play a 
    //    mystery, you might as well play a spy thriller.<./q> 
    //  <p><.q>By contrast,<./q> says Ovan, 
    //    <i><.q>Cave Maze VII</i> is not a mystery.<./q> 
    //  <p><.q>It<./s>s not a spy thriller, either,<./q> 
    //    says Neton. ";
    dontLikeIfIsMystery.execute;
  }  
  badReason2 {
    sayIsHistorical('it is set in the late 1940s');
    dontLikeIfIsHistorical.execute;
  }  
  badReason3 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }
;
argGameZork: GameQuip
  gameTitle = 'Zork'
  qOff = [argGameZork]
  hasMultipleAuthors = true
  hasMagic = true
  hasGarlic = true
  initReply() {
    "<.q>When I first heard about <i>Zork,</i> it sounded
        extremely promising,<./q> says Neton. 
        <.q>Treasures, mazes, dungeons, mines, and 
        caves--now <i>that<./s>s</i> a winning combination. ";
  }
  badReason1 {
    "But then I played the game, and within minutes
        I found that it contained a clove of garlic.<./q>
      <p><.q>What is it with humans and garlic?<./q> 
        cries Ovan. <.q>It<./s>s bad enough that they had
        to dump it in their food, without putting it on display
        in works of interactive fiction.<./q>
      <p><.q>As far as I<./s>m concerned,<./q> says Neton, 
        <.q>no game can
        overcome the sad reputation that comes from
        depicting unsavory substances like garlic.<./q>
      <p><.q>If only the makers of <i>Zork</i> had played
        <i>Cave Maze VII,<./q></i> muses Ovan.
        <.q>That game is a shining example
        of how to omit garlic.<./q> ";
    dontLikeIfHasGarlic.execute;
  }  
  howManyBadReasons = 1
;

argGameHitchhikers: GameQuip
  gameTitle = 'The Hitchhiker<./s>s Guide to the Galaxy'
  //gameTitlePlural = 'Hitchhiker<./s>s Guide</i>s<i>'
  gameTitlePlural(str) {
    return 'Hitchhiker<./s>s Guide</i>s' + str + '<i>';
  }
  qOff = [argGameHitchhikers]
  hasMultipleAuthors = true
  isNotTreasureHunt = true
  hasCheese = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayHasCheese('a cheese sandwich.');
    dontLikeIfHasCheese.execute;
  }
  //badReason2 {
  //  sayHasMultipleAuthors;
  //  dontLikeIfHasMultipleAuthors.execute;
  //}  
  //badReason3 {
  //  sayIsPost1997;
  //  dontLikeIfIsPost1997.execute;
  //}
  howManyBadReasons = 1
;
argGamePawn: GameQuip
  gameTitle = 'The Pawn'
  //gameTitlePlural = 'Pawn</i>s<i>'
  gameTitlePlural(str) { return 'Pawn</i>s' + str + '<i>'; }
  qOff = [argGamePawn]
  hasMagic = true
  hasGraphics = true
  //hasCheese = true
  isNotTreasureHunt = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    "<.q>In some ways, <i>The Pawn</i> is not bad,<./q> 
        Neton says. <.q>For instance, it contains a dragon, 
        which is certainly a plus. It also contains a maze. 
        Unfortunately, however, therein lies the problem.<./q> 
      <p><.q>It<./s>s not really a maze at all!<./q> 
        cries Ovan, with an expression of despair. 
      <p><.q>First of all, the game<./s>s maze is openly 
        declared to be an <.s>irrelevant maze,<./s><./q> 
        Neton says, and heaves a long sigh. 
      <p><.q><.s>Irrelevant maze,<./s><./q> says Ovan. 
        <.q>What is that supposed to mean, anyway? 
        Irrelevant to what?<./q> 
      <p><.q>On the contrary, it was the story that was 
        irrelevant,<./q> Neton says. <.q>It had nothing 
        to do with the maze at all.<./q> 
      <p>Ovan sighs and shakes his head sadly. 
      <p><.q>In addition,<./q> says Neton, <.q>the maze itself 
        was extremely problematic. You can<./s>t win it 
        except by cheating.<./q> 
      <p><.q>Believe me, I tried,<./q> says Ovan, his eyes 
        getting moist. 
      <p><.q>We<./s>re completely against that sort of 
        thing,<./q> says Neton. <.q>We don<./s>t like games 
        unless they have mazes, but they have to be real mazes, 
        like the ones in <i>Cave Maze VII,</i> not any 
        of this pseudo-maze nonsense, like they have in 
        <i>The Pawn.<./q></i> ";
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 1
;
argGameSoFar: GameQuip
  gameTitle = 'So Far'
  qOff = [argGameSoFar]
  hasMagic = true
  isNotTreasureHunt = true
  isSurreal = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsSurreal;
    dontLikeIfIsSurreal.execute;
  }  
  howManyBadReasons = 1
;
argGameWorlds: GameQuip
  gameTitle = 'Worlds Apart'
  qOff = [argGameWorlds]
  hasMagic = true
  isPost1997 = true
  isNotTreasureHunt = true
  //initReply() {
  //  "<.q><./q> ";
  //}
  badReason1 {
    sayIsPost1997;
    dontLikeIfIsPost1997.execute;
  }  
  badReason2 {
    sayLacksMaze;
    dontLikeIfLacksMaze.execute;
  }  
  howManyBadReasons = 2
;



class DontLike: object
  execute() {
    //"\n";
    for(local cur=firstObj(GameQuip); cur != nil; cur=nextObj(cur,GameQuip)) {
      if (cur.(self.badProperty)) {
        cur.isOn = nil;
        //"<<cur.gameTitle>> is BBBAAADD!: multiple authors!!\n";
      }
      //else "<<cur.gameTitle>> is good: no multiple authors\n";
    }
  }
  badProperty = nil
;
//dontLikeGamesThatHaveMultipleAuthors() {
//  for(local cur=firstObj(GameQuip); cur != nil; cur=nextObj(cur,GameQuip)) {
//    if (cur.hasMultipleAuthors) { cur.isOn = nil; }
//  }
//}


dontLikeIfHasMultipleAuthors: DontLike
  badProperty = &hasMultipleAuthors
;
dontLikeIfHasMagic: DontLike
  badProperty = &hasMagic
;
dontLikeIfIsSetOnEarth: DontLike
  badProperty = &isSetOnEarth
;
dontLikeIfIsPost1997: DontLike
  badProperty = &isPost1997
;
dontLikeIfHasGraphics: DontLike
  badProperty = &hasGraphics
;
dontLikeIfIsMystery: DontLike
  badProperty = &isMystery
;
dontLikeIfLacksCave: DontLike
  badProperty = &lacksCave
;
dontLikeIfIsNotTreasureHunt: DontLike
  badProperty = &isNotTreasureHunt
;
dontLikeIfLacksMaze: DontLike
  badProperty = &lacksMaze
;
dontLikeIfIsHistorical: DontLike
  badProperty = &isHistorical
;
dontLikeIfIsSurreal: DontLike
  badProperty = &isSurreal
;
dontLikeIfHasCheese: DontLike
  badProperty = &hasCheese
;
dontLikeIfHasGarlic: DontLike
  badProperty = &hasGarlic
;
dontLikeIfIsWrittenByEarthling: DontLike
  badProperty = &isWrittenByEarthling
;





// dontLikeIfHasMultipleAuthors hasMultipleAuthors = true
// dontLikeIfHasMagic hasMagic = true
// dontLikeIfIsSetOnEarth isSetOnEarth = true
// dontLikeIfIsPost1997 isPost1997 = true
// dontLikeIfHasGraphics hasGraphics = true
// dontLikeIfIsMystery isMystery = true
// dontLikeIfLacksCave lacksCave = true
// dontLikeIfIsNotTreasureHunt isNotTreasureHunt = true
// dontLikeIfLacksMaze lacksMaze = true
// dontLikeIfIsHistorical isHistorical = true
// dontLikeIfIsSurreal isSurreal = true
// dontLikeIfHasCheese hasCheese = true


asdfasdfasdf: object
  page1 =
  "<.q>But if I<./s>m stuck in this conversation menu maze,
      then surely you are too,<./q> you say.
    <p>Ovan snorts with laughter.
    <p><.q>Surely, we are not stuck anywhere,<./q>
      says Neton.
    <p><.q>What you see here are mere representations 
      of us,<./q> says Ovan. <.q>You<./s>re the only one
      whose consciousness is actually trapped here.<./q>
    <p><.q>We--that is, the real we--need not
      even concern ourselves with <i>controlling</i> these
      representations, much less inhabiting them,<./q> 
      says Neton, a bit snootily. <.q>The controlling
      is done by a computer program.<./q>
    <p><.q>A computer program that I wrote,<./q>
      says Ovan, beaming proudly. "
  page2 =
  "<.q>Ovan, you wrote this program?<./q> you ask.
    <p><.q>You bet,<./q> says Ovan proudly. 
      <.q>You are now inside a computer program that 
      I wrote.<./q>
    <p><.q>I might add, however, that he wrote it using
      a computer language that <i>I</i> developed,<./q>
      adds Neton. "
  page3 =
  "<.q>Why did you say that you doubt I<./s>ll escape
      this conversation menu?<./q> you ask.
    <p>Grinning, Ovan says, <.q>Well, for one thing,
      I specifically designed this conversation menu
      so that it<./s>s impossible to escape.<./q>
    <p><.q>Making it impossible to escape was the whole
      <i>purpose,<./q></i> says Neton. 
      <.q>Unlikely as it might be that a human 
      would actually finish our game, we still 
      had to be prepared for the contingency.<./q>
    <p><.q>We had to make sure we kept you occupied
      until we were ready to take you out of 
      stasis,<./q> says Ovan.
      <.q>We could have just written a program that 
      kept you in an empty box, 
      but where would be the style in that?
      This way, at least you<./s>ll be a little 
      entertained until we wake you up.<./q>
    <p><i><.q>If</i> we wake you up, that is,<./q> 
      says Neton significantly. "
  page4 =
  " "
  page5 =
  " "
  page6 =
  " "
  page7 =
  " "
  page8 =
  " "
  page9 =
  " "
  page10 =
  " "
  page11 =
  " "
  page12 =
  " "
  page13 =
  " "
  page14 =
  " "
  page15 =
  " "
  page16 =
  " "
  page17 =
  " "
  page18 =
  " "
  page19 =
  " "
  page20 =
  " "
  page21 =
  " "
  page22 =
  " "
  page23 =
  " "
  page24 =
  " "
  page25 =
  " "
  page26 =
  " "
  page27 =
  " "
  page28 =
  " "
  page29 =
  " "
  page30 =
  " "
  page31 =
  " "
  page32 =
  " "
  page33 =
  " "
  page34 =
  " "
  page35 =
  " "
  page36 =
  " "
  page37 =
  " "
  page38 =
  " "
  page39 =
  " "
  page40 =
  " "
  page41 =
  " "
  page42 =
  " "
  page43 =
  " "
  page44 =
  " "
  page45 =
  " "
  page46 =
  " "
  page47 =
  " "
  page48 =
  " "
  page49 =
  " "
  page50 =
  " "
  page51 =
  " "
  page52 =
  " "
  page53 =
  " "
  page54 =
  " "
  page55 =
  " "
  page56 =
  " "
  page57 =
  " "
  page58 =
  " "
  page59 =
  " "
  page60 =
  " "
;

hugo:   object text='Hugo'   generalText='Hugo'  ;
tads2:  object text='Tads2'  generalText='Tads2' ;
tads3:  object text='Tads3'  generalText='Tads3' ;
inform: object text='Inform' generalText='Inform';
zcode:  object text='Zcode'  generalText='Zcode' ;
glulx:  object text='Glulx'  generalText='Glulx' ;
agt:    object text='AGT'    generalText='AGT'   ;
adrift: object text='ADRIFT' generalText='ADRIFT';
alan:   object text='Alan'   generalText='Alan'  ;

class BasicIFGameQuip: Quip
  title = ''
  author = ''
;

class IFGameQuip: BasicIFGameQuip;

class AlienIFGameQuip: BasicIFGameQuip;

argFallacy: IFGameQuip
  title = 'Fallacy of Dawn'
  author = 'Robb Sherwin'
  progLang = hugo
  platform = hugo
  year = 2001
  isSciFi = true
  isRPG = true
  isHumor = true
  isGraphical = true
  hasFeelies = true
  //step1 = elimHugo
  //step2 = elimRPG
  //step3 = elimAmerican
;

class Elimination: object
;

//elimHugo: Elimination elimProp =
//  
//;

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineLiteralAction(Noof)
  execAction() {
    //local dontProp = nil;
    local lst = nil;
    local game = nil;
    local prop = nil;
    //local k = 0; k=k/k;
    switch (getLiteral.toLower.substr(1,3)) {
      case 'che':
        lst = glob.dontLikeIfHasCheeseList;
        //dontProp = &dontLikeIfHasCheese;
        break;
      case 'his':
        lst = glob.dontLikeIfIsHistoricalList;
        //dontProp = &dontLikeIfIsHistorical;
        break;
      case 'mys':
        lst = glob.dontLikeIfIsMysteryList;
        //dontProp = &dontLikeIfIsMystery;
        break;
      case 'sur':
        lst = glob.dontLikeIfIsSurrealList;
        //dontProp = &dontLikeIfIsSurreal;
        break;
      case 'cav':
        lst = glob.dontLikeIfLacksCaveList;
        //dontProp = &dontLikeIfLacksCave;
        break;
      case 'maz':
        lst = glob.dontLikeIfLacksMazeList;
        //dontProp = &dontLikeIfLacksMaze;
        break;
      case 'gar':
        lst = glob.dontLikeIfHasGarlicList;
        //dontProp = &dontLikeIfHasGarlic;
        break;
    }
    if (!lst) {
      "I don<./s>t understand what you want to noof. ";
      return;
    }
    for (local a = 1; a <= lst.length; a++) {
      "-------------------------------<p>";
      game = lst[a][1];
      prop = lst[a][2];
      game.initQuestion;
      game.initReply;
      game.(prop);
      if (a < lst.length) {
        inputManager.getKey(nil,nil);
        "<P>";
      }
    }
  }
;
VerbRule(Noof)
  'noof' singleLiteral
  : NoofAction
  verbPhrase = 'noof/noofing (what)'
;
modify glob
  dontLikeIfHasCheeseList = [
     [argGameAdventure    ,&badReason1] // dontLikeIfHasCheese
    ,[argGameQuest        ,&badReason1] // dontLikeIfHasCheese
    ,[argGameUnnkulian    ,&badReason1] // dontLikeIfHasCheese
  ]
  dontLikeIfHasGarlicList = [
     [argGameZork         ,&badReason1] // dontLikeIfHasMultipleAuthors
  ]
  dontLikeIfIsHistoricalList = [
     [argGameInfidel      ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameJigsaw       ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameOnce         ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameReturn       ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameSlouching    ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameTimequest    ,&badReason1] // dontLikeIfIsHistorical
    ,[argGameYangtze      ,&badReason2] // dontLikeIfIsHistorical
  ]
  dontLikeIfIsMysteryList = [
     [argGameBorder       ,&badReason1] // dontLikeIfIsMystery
    ,[argGameCounterpoint ,&badReason1] // dontLikeIfIsMystery
    ,[argGameDeadline     ,&badReason1] // dontLikeIfIsMystery
    ,[argGameYangtze      ,&badReason1] // dontLikeIfIsMystery
  ]
  dontLikeIfIsSurrealList = [
     [argGameLosing       ,&badReason1] // dontLikeIfIsSurreal
    ,[argGameMindwheel    ,&badReason1] // dontLikeIfIsSurreal
  ]
  dontLikeIfLacksCaveList = [
     [argGameBorder       ,&badReason2] // dontLikeIfLacksCave
    ,[argGameEnchanter    ,&badReason1] // dontLikeIfLacksCave
    ,[argGameGalatea      ,&badReason1] // dontLikeIfLacksCave
    ,[argGameHunter       ,&badReason1] // dontLikeIfLacksCave
    ,[argGameJigsaw       ,&badReason2] // dontLikeIfLacksCave
    ,[argGameKnight       ,&badReason1] // dontLikeIfLacksCave
    ,[argGameLosing       ,&badReason2] // dontLikeIfLacksCave
    ,[argGameMindwheel    ,&badReason2] // dontLikeIfLacksCave
    ,[argGameNord         ,&badReason1] // dontLikeIfLacksCave
    ,[argGamePlanetfall   ,&badReason2] // dontLikeIfLacksCave
    ,[argGameWonderland   ,&badReason1] // dontLikeIfLacksCave
    ,[argGameXenos        ,&badReason1] // dontLikeIfLacksCave
  ]
  dontLikeIfLacksMazeList = [
     [argGameBorder       ,&badReason3] // dontLikeIfLacksMaze
    ,[argGameCounterpoint ,&badReason2] // dontLikeIfLacksMaze
    ,[argGameDeadline     ,&badReason2] // dontLikeIfLacksMaze
    ,[argGameFuture       ,&badReason1] // dontLikeIfLacksMaze
    ,[argGameGalatea      ,&badReason2] // dontLikeIfLacksMaze
    ,[argGameLosing       ,&badReason3] // dontLikeIfLacksMaze
    ,[argGameNord         ,&badReason2] // dontLikeIfLacksMaze
    ,[argGamePlanetfall   ,&badReason1] // dontLikeIfLacksMaze
    ,[argGameVaricella    ,&badReason1] // dontLikeIfLacksMaze
    ,[argGameWonderland   ,&badReason2] // dontLikeIfLacksMaze
    ,[argGameYangtze      ,&badReason3] // dontLikeIfLacksMaze
  ]
;


DefineIAction(Boink)
  execAction() {
    //argSubGame.select();
    local game;
    //argSubGame.gameCounter--;
    
    if (glob.gameObj <= 0) {
      "Invalid value in glob.gameObj. ";
      return;
    }
    if (glob.gameObj > 26) {
      "Already finished. ";
      return;
    }
    game = glob.gameList[glob.gameObj];
    
    //switch (glob.gameObj) {
    //  case  1: game = argGameAdventure;    break;
    //  case  2: game = argGameBorder;       break;
    //  case  3: game = argGameCounterpoint; break;
    //  case  4: game = argGameDeadline;     break;
    //  case  5: game = argGameEnchanter;    break;
    //  case  6: game = argGameFuture;       break;
    //  case  7: game = argGameGalatea;      break;
    //  case  8: game = argGameHitchhikers;  break;
    //  case  9: game = argGameInfidel;      break;
    //  case 10: game = argGameJigsaw;       break;
    //  case 11: game = argGameKnight;       break;
    //  case 12: game = argGameLosing;       break;
    //  case 13: game = argGameMindwheel;    break;
    //  case 14: game = argGameNord;         break;
    //  case 15: game = argGameOnce;         break;
    //  case 16: game = argGamePawn;         break;
    //  case 17: game = argGameQuest;        break;
    //  case 18: game = argGameReturn;       break;
    //  case 19: game = argGameSoFar;        break;
    //  case 20: game = argGameTimequest;    break;
    //  case 21: game = argGameUnnkulian;    break;
    //  case 22: game = argGameVaricella;    break;
    //  case 23: game = argGameWorlds;       break;
    //  case 24: game = argGameXenos;        break;
    //  case 25: game = argGameYangtze;      break;
    //  case 26: game = argGameZork;         break;
    //}
    if (game.howManyBadReasons > glob.gameProp) {
      glob.gameProp++;
    }
    else {
      glob.gameObj++;
      glob.gameProp = 1;
      if (glob.gameObj <= 0) {
        "Invalid value in glob.gameObj. ";
        return;
      }
      if (glob.gameObj > 26) {
        "Already finished. ";
        return;
      }
      game = glob.gameList[glob.gameObj];
      //switch (glob.gameObj) {
      //  case  1: game = argGameAdventure;    break;
      //  case  2: game = argGameBorder;       break;
      //  case  3: game = argGameCounterpoint; break;
      //  case  4: game = argGameDeadline;     break;
      //  case  5: game = argGameEnchanter;    break;
      //  case  6: game = argGameFuture;       break;
      //  case  7: game = argGameGalatea;      break;
      //  case  8: game = argGameHitchhikers;  break;
      //  case  9: game = argGameInfidel;      break;
      //  case 10: game = argGameJigsaw;       break;
      //  case 11: game = argGameKnight;       break;
      //  case 12: game = argGameLosing;       break;
      //  case 13: game = argGameMindwheel;    break;
      //  case 14: game = argGameNord;         break;
      //  case 15: game = argGameOnce;         break;
      //  case 16: game = argGamePawn;         break;
      //  case 17: game = argGameQuest;        break;
      //  case 18: game = argGameReturn;       break;
      //  case 19: game = argGameSoFar;        break;
      //  case 20: game = argGameTimequest;    break;
      //  case 21: game = argGameUnnkulian;    break;
      //  case 22: game = argGameVaricella;    break;
      //  case 23: game = argGameWorlds;       break;
      //  case 24: game = argGameXenos;        break;
      //  case 25: game = argGameYangtze;      break;
      //  case 26: game = argGameZork;         break;
      //  default: "Already finished. "; return;
      //}
    }
    
    game.initQuestion;
    game.initReply;
    switch (glob.gameProp) {
      case 1:
        game.badReason1;
        break;
      case 2:
        game.badReason2;
        break;
      case 3:
        game.badReason3;
        break;
      default:
        game.badReason1;
        break;
    }
    
  }
;
VerbRule(Boink)
  'boink'
  : BoinkAction
  verbPhrase = 'boink/boinking'
;
modify glob
  gameObj = 1
  gameProp = 0
  gameList = [
     argGameAdventure
    ,argGameBorder
    ,argGameCounterpoint
    ,argGameDeadline
    ,argGameEnchanter
    ,argGameFuture
    ,argGameGalatea
    ,argGameHunter //,argGameHitchhikers
    ,argGameInfidel
    ,argGameJigsaw
    ,argGameKnight
    ,argGameLosing
    ,argGameMindwheel
    ,argGameNord
    ,argGameOnce
    ,argGamePlanetfall //,argGamePawn
    ,argGameQuest
    ,argGameReturn
    ,argGameSlouching //,argGameSoFar
    ,argGameTimequest
    ,argGameUnnkulian
    ,argGameVaricella
    ,argGameWonderland //,argGameWorlds
    ,argGameXenos
    ,argGameYangtze
    ,argGameZork
  ]
;

greg: Person 'greg boettcher/guy/man' 'Greg'
  @kitchen
  "Greg looks weary. "
  isHim = true
  isProperName = true
  dobjFor(TalkTo) {
    action() {
      argMain.select();
      
      /*
      local game, prop;
      for (local a = 1; a <= 26; a++) {
        switch (a) {
          case  1: game = argGameAdventure;    break;
          case  2: game = argGameBorder;       break;
          case  3: game = argGameCounterpoint; break;
          case  4: game = argGameDeadline;     break;
          case  5: game = argGameEnchanter;    break;
          case  6: game = argGameFuture;       break;
          case  7: game = argGameGalatea;      break;
          case  8: game = argGameHitchhikers;  break;
          case  9: game = argGameInfidel;      break;
          case 10: game = argGameJigsaw;       break;
          case 11: game = argGameKnight;       break;
          case 12: game = argGameLosing;       break;
          case 13: game = argGameMindwheel;    break;
          case 14: game = argGameNord;         break;
          case 15: game = argGameOnce;         break;
          case 16: game = argGamePawn;         break;
          case 17: game = argGameQuest;        break;
          case 18: game = argGameReturn;       break;
          case 19: game = argGameSoFar;        break;
          case 20: game = argGameTimequest;    break;
          case 21: game = argGameUnnkulian;    break;
          case 22: game = argGameVaricella;    break;
          case 23: game = argGameWorlds;       break;
          case 24: game = argGameXenos;        break;
          case 25: game = argGameYangtze;      break;
          case 26: game = argGameZork;         break;
        }
        for (local b = 1; b <= game.howManyBadReasons; b++) {
          switch (b) {
            case 1: prop = &badReason1; break;
            case 2: prop = &badReason2; break;
            case 3: prop = &badReason3; break;
            default: "ERROR! ERROR! "; break;
          }
          if 
        }
      }
      */
    }
  }
;
#endif // __DEBUG

// -------------------------------------------------------------------
// JUNK
// -------------------------------------------------------------------

// a post-1997 surreal mystery game, containing cheese but 
// lacking mazes or caves, all or part of which is set in the past, 
// written by multiple authors, all of whom are Earthlings.

/*
dontLikeIfHasMultipleAuthors: DontLike
dontLikeIfIsPost1997: DontLike
dontLikeIfIsMystery: DontLike
dontLikeIfLacksCave: DontLike
dontLikeIfLacksMaze: DontLike
dontLikeIfIsHistorical: DontLike
dontLikeIfIsSurreal: DontLike
dontLikeIfHasCheese: DontLike
dontLikeIfIsWrittenByEarthling: DontLike
*/



