/* ex:set ts=4 sw=4:
 *
 * askme.t: makes the puppets talk
 *
 * This module provides a framework for asking actors about things in
 * the game.  First, each actor has a personal method name which is
 * reserved for their knowledge of objects.  The address of this method
 * should be stored in actor.askme (see example below).  An actor doesn't
 * have to have one but for knowledge specific to an actor, it is essential
 *
 * Next, every object that can be asked about should have that method
 * populated with either a string or a method which answers the question.
 *
 * If the method is a 'string', it will be display as
 *
 *		The actor says "string".
 *
 * If its code or a "string", it is just invoked with no other formatting.
 *
 * Since multiple actors may exist within the program and it is quite
 * tedious to establish seperate knowledge bases, you can provide a general
 * method called 'askAnybody(a)' on the objects.  So, basically if you type
 * "ask actor about object", then it tries object.(actor.askme) (unless the
 * actor has no askme method) and then tries object.askAnybody(actor)
 *
 *		simon.askme = &askSimon
 *		bruce.askme = &askBruce
 *
 *		object.askSimon = "This is what Simon will say when asked"
 *		object.askAnybody(a) = "This is what Bruce and Frank will say"
 *
 * This module is Copyright (c) 1994 Jeff Laing.  Permission to use any or all
 * of this code in other TADS games is granted provided credit is given in
 * your "CREDITS" command for this code and that you leave this copyright
 * message in the source whenever distributed.  Please make all changes in
 * an backward compatible manner (where possible) and make them available
 * for free (like I did ;-)
 */
askmeVersion : versionTag
	id="$Id: askme.t_v 1.4 1994/05/04 07:40:53 jeffl Exp jeffl $\n"
	author='Jeff Laing'
	func='actor dialog'
;

/*
 * we modify the player to include a number of gags.
 */
modify basicMe

	// <a>, ask player about <i>
	verDoAskAbout(a,i) = {
		if (a=Me) 
			"Asking yourself questions is healthy.  Expecting answers is
			weird!\n";
		else
			"It doesn't look as though <<a.thedesc>> is interested.\n";
	}

	// <a>, ask <o> about player
	ioAskAbout(a,d) = {
		if (a.isHer and d.isHer) {
			"<<d.thedesc>> whispers something to <<a.thedesc>> and they
			both begin to giggle";
		} else if (a.isHim and d.isHim) {
			"<<d.thedesc>> and <<a.thedesc>> seem to be pointing over at
			you and muttering something";
		} else {
			"\^<<d.thedesc>> tells %you% that basically you know all there
			is to know about %yourself%";
		}
		".\n";
	}
;

/*
 * now all our actors are sub-classes of the standard movableActor
 */
modify class realactor 

	// actors don't mind being asked about
	verIoAskAbout(a) = {}

	// asking an actor about something is ok.  each actor has a property
	// called 'askme' which is a pointer to another method.
	verDoAskAbout(a,io) = {
		if (a=self)
			"If %you% ask%s% %yourself% questions, who do you think answers?";
	}
	doAskAbout(a,io) = {

		/*
		 * look for property-pointer in actor.askme.  If it is of type
		 * "property-pointer", then we consider that this actor can be
		 * asked.  If what it points to is a "string" or a {method} then
		 * we invoke it.  If its a 'string', we print it in quotes
		 */
		if (datatype(self.askme)=13) {			// if the pointer is legal
			switch(proptype(io,self.askme)) {	// check what it points to
			case 3:								// 'string'
				"\^<<self.thedesc>> says \""; say(io.(self.askme)); "\".\n";
				return;

			case 6: case 9:				// "string" & {method} get invoked
				io.(self.askme);
				return;
			}
		}

		/*
		 * If its not, then we look for a generic method (askAnybody) instead.
		 */
		switch(proptype(io,&askAnybody)) {	// look to see if its there
		case 3:								// 'string' - we wrap quotes around
			"\^<<self.thedesc>> says \""; say(io.askAnybody(self)); "\".\n";
			return;

		case 6: case 9:					// "string" & {method} - we just invoke
			io.askAnybody(self);
			return;
		}

		/*
		 * if there was a bad pointer or the answer is not an acceptable
		 * method, we bail out with a general message
		 */
		if (a<>Me) "<<a.thedesc>> asks <<self.thedesc>> but ";
		else "\^";
		"<<self.thedesc>> doesn't seem to know anything.\n";
	}
;

/*
 * make sure we can ask about the curtains regardless of whether they are
 * decorations (which object to just about any action) or not.
 */
modify class decoration
	verIoAskAbout(a) = {}
;
