// Menu module
// It gives a menu, where the menu choices are objects in a room.  Picking
// the menu choice returns the corresponding object.
//

class menu: thing
sdesc = "Generic menu"               // title of the menu
ldesc = "This is a generic menu."    // and its description

choices = []  // items that may appear on the menu

quitMsg = "Exit from menu" // the "exit menu" choice description
enterMsg = "Enter choice:\ " // the "pick a choice" description
illegalMsg = "Bad choice. Please re-enter." // the "bad menu choice" 
                                            // description
;

class menuChoice: thing
sdesc = "Generic choice" // this is what shows up in the menu listing

display = true  // if this menu item should only show up sometimes, make
                // this a function. for instance:
                // secretChoice: menuChoice
                //   showSelf = { return (Me.secretFound = true); }
                // This gets called several each time a menu item is 
                // displayed, so it's a Bad Idea to have it change game state.

exitAfter = nil // should we quit the menu 

// Chosen is what gets called when the menu item is selected.
// It could print a message, like it does now, or do anything else, even
// call displayMenu on a different menu (ie, a sub-menu)
Chosen =
{
  "\bNot a valid choice. Whoopsies.\b";
}
;

displayMenu: function( M )  // display menu M, prompt for a choice
{
  local i, count, sp, index, ret;

 REPEAT:  // labels are naughty. don't use 'em at home, kids.

// A call to clearscreen was here, but it seems to cause problems on some 
// interpreters, so I'm leaving it out. Feel free to try it, though.

//    clearscreen();


  // Display the menu's name and description
  "\b"; M.sdesc; "\n"; M.ldesc;

  if (length(M.choices) = 0)
  {
    "\b??Menu with no choices??\n";
    return;
  }

  // first count how many menu items there are.
  count := 0;
  for (i := 1; i <= length(M.choices); i++)
    if (M.choices[i].display)
      count++;

  count := cvtstr(count); // turn count into a string.

  // now print them out.
  "\b";  

  index := 1;

  for (i := 1; i <= length(M.choices); i++)
    if (M.choices[i].display)
    {
      local l := cvtstr(index++); // advance the index and convert to string
      
      while (length(l) < length(count))
	l := ' ' + l; // pad the number with spaces so they're all same length

      l += ':\ ';
      
      "\t"; say(l); M.choices[i].sdesc; "\n";
    }

  "\tQ:\ <<M.quitMsg>>\n"; // and the quit choice

  "\b";

  //  ok. so get some input.
  ret := nil;
  count := cvtnum(count); // put this back into a number

  while( ret = nil )
  {
    "\nEnter choice:\ ";
    ret := input();

    if (ret = 'Q' or ret = 'q' or ret = 'quit' or ret = '0')
      return;
    else
    {
      ret := cvtnum(ret);

      if ((ret <= 0) or (ret > count)) // bad choice
      {
	"<<M.illegalMsg>>\n";
      }
      else // good choice. find it.
      {
	local allCount, shownCount := 1;

	for (allCount := 1; allCount <= count; allCount++)
	  if (M.choices[allCount].display)
	    if (shownCount++ = ret)
	      break;

	// found it:
	M.choices[allCount].Chosen;

	if (M.choices[allCount].exitAfter) // quit after running?
	  return;
      }

      goto REPEAT;
    }
  }
}
