#ifndef DETECTOR
#define DETECTOR
#pragma C+

/*
** Detect.t detects when the player has used save, restore, undo, &c. and
**  allows you to rerandomize behavior, &c. so the player can't use these
**  verbs to solve a puzzle.  Put the detector object in the room where you
**  want to watch for players saving/restoring.
** I have recently rewritten it incorporating ideas that I got after seeing
**  Jeff Laing's modules.  His modules are great; I just didn't want to throw
**  away my old code.  I've credited him in the version object below.
** Copyright (c) 1995, 1996 Stephen Granade
** You are permitted to distribute this module freely, as long as 1) my name
** is left on it, and 2) you keep all files together.  You may also use
** this module in any game you like in any form you like.  Hack away at
** it, if you so desire.  All I ask is that you credit me and Jeff Laing in
** some way in your game.
** I would welcome any comments on or suggestions for this module.  I can be
** reached at:
**  Duke University Physics Department
**  Box 90305
**  Durham, NC  27708-0305
**  U.S.A.
**  sgranade@phy.duke.edu
**
** Version history:
**  7 Aug 94 -- Initial release
**  23 Dec 95 -- Added version tracking using Jeff Laing's routines and
**               rewrote much of the code using his ideas
*/

#include "sysfuncs.t"

detectVersion: versionTag,initialization
    id="$Id: detect.t v1.1  23 Dec 95\n"
    func='sysverb detection'
    author='Jeff Laing and Stephen Granade'

    detectList = []
    preinit_phase={
        local o;

        self.detectList = [];

        // make a list of all detectors
        for (o = firstobj(detector); o != nil;o = nextobj(o,detector)) {
            self.detectList += o;
        }
    }

    init_phase={}
;

class detector: object
    saveGame(loc) = "\b\([ERROR: NO DEFAULT SAVE ACTION GIVEN.]\)\b"
    restoreGame(loc) = "\b\([ERROR: NO DEFAULT RESTORE ACTION GIVEN.]\)\b"
    undoMove(loc) = "\b\([ERROR: NO DEFAULT UNDO ACTION GIVEN.]\)\b"
;

sysverbDetected: function( method )
{
    local obj,list;

    list = detectVersion.detectList;// copy the list
    while (length(list)>0) {        // while it's not empty
        obj = car(list);            // send its leader
        list = cdr(list);           // and then move to the next one
        obj.(method)                // a message (passed as a parameter)
          (obj.location==Me.location);    // with a flag
    }
}

modify saveVerb
    saveGame(actor) = {
        local retn;

        if ((retn = inherited.saveGame(actor)))
            sysverbDetected(&saveGame);
        return retn;
    }
;

modify restoreVerb
    restoreGame(actor) = {
        local retn;

        if ((retn = inherited.restoreGame(actor)))
            sysverbDetected(&restoreGame);
        return retn;
    }
;

modify undoVerb
    undoMove(actor) = {
        inherited.undoMove(actor);
        sysverbDetected(&undoMove);
        abort;
    }
;

modify basicStrObj
    doSave( actor ) = {
        if (inherited.saveGame(actor))
            sysverbDetected(&saveGame);
        abort;
    }

    doRestore( actor ) = {
        if (inherited.restoreGame(actor))
            sysverbDetected(&restoreGame);
        abort;
    }
;

#endif
