#ifndef PLURALS
#define PLURALS

//
// Plural-Singular TADS 2.2 Utility by Andrew Pontious  1996

// In general, this changes all error or informational messages written up in
// ADV.t so that they are sensitive to the true/false property isThem. If
// isThem = true for an object, any error message generated by ADV.t will give
// it the plural designation. The one message generated by the parser itself
// dealing with object pronouns is when you don't include an indirect object
// in a verb which requires one, for example, if you write "put ball" and
// that's it. The parser will say, "What do you want to put it on?" There's no
// way to make the pronoun isThem-sensitive in this version of TADS, so
// instead I change the pronoun entirely to "that" (see the end of this
// utility). WorldClass's way of dealing with this is to take out the pronoun
// entirely, so you'd get a parser response like "On What?"

// Also the original code has been tightened up and streamlined
// using the << >> marks for embedding expressions in a string and the
// <<{condition} ? {true-expression} : {false-expression}>> for embedding
// conditional text-printing in a string, instead of ending the string and
// switching to if/else statements. Compare this to the original ADV.t
// to see the difference.

// Last change! The format strings were reworked so they would reflect
// isThem; while I was at it, I decided to have them reflect isHer.
// If you don't set isHer, isHim, or isThem, I've made the format strings
// say "it," WHICH IS DIFFERENT from the Actor default, which was to use
// the "he" variants. I decided to do so that you wouldn't have to fiddle
// with the strings to have them say "it" (say for a swamp monster, etc.),
// you'd just have to add isHim to all your masculine actors who have been
// getting by using the default in the past.

// Note: there seems to be a typo in ADV.t's showcontcont routine. It
// flips around the isqcontainer test so that it shows the contents
// of isqcontainer = true object and doesn't show them when it's false!
// This is in direct contradiction to the directions in the notes before
// listcontcont, which say to set isqcontainer to true if you don't want
// the contents listed. In my modification, I fixed this.

// Note #2: normal ADV.t has no error message if you try to lock a
// lockable with a key when it doesn't need a key and it's not already locked.
// If it is locked, you get "It's already locked" or something similar, but
// nothing otherwise. That case "falls through the cracks." Same for unlock.
// So I added appropriate error messages to lockable.
// Any questions, comments, or bug reports can go to byzantium@tuna.net
//
// [SRG: I have made changes, which I will note with my initials. The major
//  changes are: I have removed the fix to the lockable item (Note #2
//  above) and the fix to showcontcont, since both are covered in bugs.t.
//  I have also changed the parseError bit to use parseerr.t.
//  Stephen Granade]

//
// Modified Functions from ADV.t
//

#pragma C-

// SRG: Version tracking and parseError encapsulation added
#include "parseerr.t"

pluralsVersion : versionTag
    id="$Id: plurals.t v1.0  21 Aug 96\n"
    author = 'Andrew Pontious'
    func = 'better handling of plurals'
;

/*
** Modified Objects from ADV.t
*/

// Modifications to Thing: Object

modify thing

    // Automatically leave off "a" from adesc if plural
    adesc = {
        "<<self.isThem ? "" : "a ">><<self.sdesc>>";
    }
    // Automatically leave off "s" from end of pluraldesc if plural
    pluraldesc = {
        "<<self.sdesc>><<self.isThem ? "" : "s">>";
    }
    // Probably best to change this rather than leave this default.
    ldesc = {
        "<<self.isThem ? "They look" : "It looks">> like <<
        self.isThem ? "" : "an">> ordinary <<self.sdesc>> to %me%.";
    }
    circularMessage(io) = {
        local cont;

        "%You% can't put <<thedesc>> in <<io.thedesc>>, because
        <<io.thedesc>> <<io.isThem ? "are" : "is"
        >> <<io.location = self ? "already" : ""
        >> <<io.location.issurface ? "on" : "in">> <<io.location.thedesc>>";
        for (cont := io.location ; cont <> self ; cont := cont.location) {
            ", which <<cont.isThem ? "are" : "is">> ";
            if (cont.location = self) "already ";
            "<<cont.location.issurface ? "on" : "in"
            >> <<cont.location.thedesc>>";
        }
        ".";
    }
    verDoPutIn( actor, io ) = {
        if ( io = nil ) return;

        if ( self.location = io ) {
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> already
            in <<io.thedesc>>! ";
        }
        else if (io = self) {
            "%You% can't put <<self.thedesc>> in <<self.isThem ? "themselves" :
            "itself">>! ";
        }
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove( actor );
    }
    verDoPutOn( actor, io ) = {
        if ( io = nil ) return;

        if ( self.location = io ) {
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> already
            on <<io.thedesc>>! ";
        }
        else if (io = self) {
            "%You% can't put <<self.thedesc>> on <<self.isThem ? "themselves" :
            "itself">>! ";
        }
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove( actor );
    }
    verDoTakeOut( actor, io ) = {
        if ( io <> nil and not self.isIn( io )) {
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">>n't
                in <<io.thedesc>>. ";
        }
        self.verDoTake(actor);         /* ensure object can be taken at all */
    }
    verDoTakeOff( actor, io ) = {
        if ( io <> nil and not self.isIn( io )) {
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">>n't
                on <<io.thedesc>>. ";
        }
        self.verDoTake(actor);         /* ensure object can be taken at all */
    }
    verDoAskAbout( actor, io ) = {
        "Surely, %you% can't think <<self.thedesc>> know<<self.isThem ? 
            "" : "s">> anything about <<io.isThem ? "them" : "it">>! ";
    }
    verDoTellAbout( actor, io ) = {
        "It doesn't look as though <<self.thedesc>> <<self.isThem ? 
            "are" : "is">> interested. ";
    }
    verDoEat( actor ) = {
        "\^<<self.thedesc>> do<<self.isThem ? "": "es">>n't appear
            appetizing. ";
    }
    verDoDrink( actor ) = {
        "\^<<self.thedesc>> do<<self.isThem ? "": "es">>n't appear
            appetizing. ";
    }
    doShowTo( actor, io ) = {
        if( io <> nil )
            "\^<<io.thedesc>> <<io.isThem ? "are" : "is">>n't impressed. ";
    }
    verIoShowTo( actor ) = {
        "\^<<self.thedesc>> <<self.isThem ? "are" : "is">>n't impressed. ";
    }
    verDoClean( actor ) = {
        "\^<<self.thedesc>> look<<self.isThem ? "" : "s">> a bit cleaner now. ";
    }
    doCleanWith( actor, io ) = {
        "\^<<self.thedesc>> look<<self.isThem ? "" : "s">> a bit cleaner now. ";
    }
    verIoMoveWith( actor ) = {
        "\^<<self.thedesc>> do<<self.isThem ? "": "es">>n't seem to help. ";
    }
;

// Modifications to SwitchItem: Fixeditem

modify switchItem
    doSwitch( actor ) = {
        self.isActive := not self.isActive;
        "Okay, <<self.thedesc>> <<self.isThem ? "are" : "is">> now switched ";
        if ( self.isActive ) "on"; else "off";
        ". ";
    }
    verDoTurnon( actor ) = {
        /*
           You can't turn on something in the dark unless you're carrying
           it.  You also can't turn something on if it's already on.
        */
        if (not actor.location.islit and not actor.isCarrying(self))
            "It's pitch black.";
        else if ( self.isActive )
            "<<self.isThem ? "They're" : "It's">> already turned on! ";
    }
    doTurnon( actor ) = {
        self.isActive := true;
        "Okay, <<self.isThem ? "they're" : "it's">> now turned on. ";
    }
    verDoTurnoff( actor ) = {
        if ( not self.isActive ) "<<self.isThem ? "They're" : "It's">> already turned off! ";
    }
    doTurnoff( actor ) = {
        self.isActive := nil;
        "Okay, <<self.isThem ? "they're" : "it's">> now turned off. ";
    }
;

// Modifications to Actor: MovableActor: Qcontainer

modify movableActor
    actorAction( v, d, p, i ) = {
        "\^<<self.thedesc>> do<<self.isThem ? "" : "es">>n't appear interested. ";
        exit;
    }
    actorDesc = {
        "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> here. ";
    }
    verGrab( item ) = {
        "\^<<self.thedesc>> <<self.isThem ? "are" : "is"
            >> carrying <<item.thedesc>> and won't let %youm% have <<
            item.isThem ? "them" : "it">>. ";
    }
    verDoFollow( actor ) = {
        "But <<self.thedesc>> <<self.isThem ? "are" : "is">> right here! ";
    }

    // these properties are for the format strings
    // See the note at the very beginning.

    fmtYou = {
        if (self.isThem) "they";
        else if (self.isHer) "she";
        else if (self.isHim) "he";
        else "it";
    }
    fmtYour = {
        if (self.isThem) "their";
        else if (self.isHer) "her";
        else if (self.isHim) "his";
        else "its";
    }
    fmtYoure = {
        if (self.isThem) "they're";
        else if (self.isHer) "she's";
        else if (self.isHim) "he's";
        else "it's";
    }
    fmtYoum = {
        if (self.isThem) "them";
        else if (self.isHer) "her";
        else if (self.isHim) "him";
        else "it";
    }
    fmtYouve = {
        if (self.isThem) "they've";
        else if (self.isHer) "she's";
        else if (self.isHim) "he's";
        else "it's";
    }
    fmtS = "<<self.isThem ? "" : "s">>"
    fmtEs = "<<self.isThem ? "" : "es">>"
    fmtHave = "<<self.isThem ? "have" : "has">>"
    fmtDo = "<<self.isThem ? "do" : "does">>"
    fmtAre = "<<self.isThem ? "are" : "is">>"
    fmtMe = { self.thedesc; }

    disavow = "\"<<self.isThem ? "We" : "I">> don't know much about that.\""
    ioGiveTo(actor, dobj) = {
        "\^<<self.thedesc>> reject<<self.isThem ? "" : "s">> the offer.";
    }
    sayLeaving = "\n\t\^<<self.thedesc>> leave<<self.isThem ? "" : "s">> the
        area."
    sayArriving = "\n\t\^<<self.thedesc>> enter<<self.isThem ? "" : "s">> the
        area."
;

// Modifications to Follower: Actor

modify follower
    ldesc = "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> no longer
        here. "
    dobjGen(a, v, i, p) = {
        if (v <> followVerb) {
            "\^<< self.myactor.thedesc >> <<self.isThem ? "are" : "is">> no
                longer here.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        "\^<< self.myactor.thedesc >> <<self.isThem ? "are" : "is">> no
            longer here.";
        exit;
    }
;

// Modifications to Decoration: Fixeditem

modify decoration
    dobjGen(a, v, i, p) = {
        if (v <> inspectVerb) {
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">>n't important.";
            exit;
        }
    }
;

// Modification to DistantItem: Fixeditem

modify distantItem
    dobjGen(a, v, i, p) = {
        if (v <> inspectVerb) {
            "<<self.isThem ? "They're" : "It's">> too far away. ";
            exit;
        }
    }
;

// Modifications to Doorway: Fixeditem, Obstacle

modify doorway
    verDoOpen( actor ) = {
        if ( self.isopen ) "<<self.isThem ? "They're" : "It's">> already
            open. ";
        else if ( self.islocked ) "<<self.isThem ? "They're" : "It's"
            >> locked. ";
    }
    verDoClose( actor ) = {
        if ( not self.isopen ) "<<self.isThem ? "They're" : "It's">> already
            closed. ";
    }
    verDoLock( actor ) = {
        if ( self.islocked ) "<<self.isThem ? "They're" : "It's">> already
            locked! ";
        else if ( not self.islockable ) "<<self.isThem ? "They" : "It">> can't
            be locked. ";
        else if ( self.isopen ) "%You%'ll have to close <<self.isThem ?
            "them" : "it">> first. ";
    }
    verDoUnlock( actor ) = {
        if ( not self.islocked ) "<<self.isThem ? "They're" : "It's">> not
            locked! ";
    }
    verDoLockWith( actor, io ) = {
        if ( self.islocked ) "<<self.isThem ? "They're" : "It's">> already
            locked. ";
        else if ( not self.islockable ) "<<self.isThem ? "They" : "It">> can't
            be locked. ";
        else if ( self.mykey = nil )
            "%You% %do%n't need anything to lock <<self.isThem ? "them" :
                "it">>. ";
        else if ( self.isopen ) "%You%'ll have to close <<self.isThem ?
            "them" : "it">> first. ";
    }
    doLockWith( actor, io ) = {
        if ( io = self.mykey ) {
            "Locked. ";
            self.islocked := true;
            if ( self.otherside ) self.otherside.islocked := true;
        }
        else "<<io.isThem ? "They do" : "It does">>n't fit the lock. ";
    }
    verDoUnlockWith( actor, io ) = {
        if ( not self.islocked ) "<<self.isThem ? "They're" : "It's">> not
            locked! ";
        else if ( self.mykey = nil )
            "%You% %do%n't need anything to unlock <<self.isThem ? "them" :
                "it">>. ";
    }
    doUnlockWith( actor, io ) = {
        if ( io = self.mykey ) {
            "Unlocked. ";
            self.islocked := nil;
            if ( self.otherside ) self.otherside.islocked := nil;
        }
        else "<<io.isThem ? "They do" : "It does">>n't appear to be locked.";
    }
    ldesc = {
        if (self.isopen) "<<self.isThem ? "They're" : "It's">> open. ";
        else {
            if (self.islocked)
                "<<self.isThem ? "They're" : "It's">> closed and locked. ";
            else "<<self.isThem ? "They're" : "It's">> closed. ";
        }
    }
;

// Modifications to Openable: Container

modify openable
    replace ldesc = {
        "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> <<
            self.isopen ? "open" : "closed">>. ";

            /* if it's transparent, list its contents anyway */
        if (self.isclosed and isclass(self, transparentItem))
            pass ldesc;
    }
    verDoOpen(actor) = {
        if (self.isopen)
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> already open! ";
    }
    verDoClose(actor) = {
        if (not self.isopen)
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> already
                closed! ";
    }
    verIoPutIn(actor) = {
        if (not self.isopen)
            "\^<<self.thedesc>> <<self.isThem ? "are" : "is">> closed. ";
    }
    verDoLookin(actor) = {
        /* we can look in it if either it's open or it's transparent */
        if (not self.isopen and not isclass(self, transparentItem))
           "<<self.isThem ? "They're" : "It's">> closed. ";
    }
;

// Modify Lockable: Openable

modify lockable
    verDoOpen(actor) = {
        if (self.islocked)
            "<<self.isThem ? "They're" : "It's">> locked. ";
        else pass verDoOpen;
    }
    verDoLock(actor) = {
        if (self.islocked)
            "<<self.isThem ? "They're" : "It's">> already locked! ";
    }
    doLock(actor) = {
        if (self.isopen)
            "%You%'ll have to close <<self.thedesc>> first. ";
        else {
            "Locked. ";
            self.islocked := true;
        }
    }
    verDoUnlock(actor) = {
        if (not self.islocked) 
            "<<self.isThem ? "They're" : "It's">> not locked! ";
    }
    verDoLockWith(actor, io) = {
        if ( self.islocked )
            "<<self.isThem ? "They're" : "It's">> already locked. ";
        // ** New ** ADV.t forgot that you need error message here for
        // lockables if you try to lock WITH something
        else if (self.mykey = nil)
            "%You% %do%n't need anything to lock <<self.isThem ? "them" : 
                "it">>. ";
    }
    verDoUnlockWith(actor, io) = {
        if (not self.islocked)
            "<<self.isThem ? "They're" : "It's">> not locked! ";
        // ** New ** ADV.t forgot that you need error message here for
        // lockables if you try to unlock WITH something
        else if (self.mykey = nil)
            "%You% %do%n't need anything to unlock <<self.isThem ? "them" :
                "it">>. ";
    }
;

// Modifications to KeyedLockable: Lockable

modify keyedLockable
    doLockWith(actor, io) = {
        if (self.isopen)
            "%You% can't lock <<self.thedesc>> when <<self.isThem ? 
                "they're" : "it's">> open. ";
        else if (io = self.mykey) {
            "Locked. ";
            self.islocked := true;
        }
        else "<<io.isThem ? "They do" : "It does">>n't fit the lock. ";
    }
    doUnlockWith(actor, io) = {
        if (io = self.mykey) {
            "Unlocked. ";
            self.islocked := nil;
        }
        else "<<io.isThem ? "They do" : "It does">>n't fit the lock. ";
    }
;

//
// Use of 2.2 Feature ParseError: [N.B. Not really a 2.2 feature :) SRG]
// [Also has been changed to use parseErrorItem.  SRG]
//

pluralsParseError: parseErrorItem
    myParseError(num, str) = {
        if(num = 141) return ' that ';
        return nil;
    }
;

#endif
