/*
 * T2 Combat sample game, based on Mike Roberts' starter game.
 */

#define USE_HTML_STATUS
#define USE_HTML_PROMPT
#include <adv.t>
#include <gameinfo.t>
#include "t2c_rap.t"
#include <std.t>
#include "t2combat.t"

/* The rooms and objects:
 */
startroom: room

    sdesc = "Entryway"

    ldesc =
    {
        "This large, formal entryway is slightly intimidating:
        the walls are lined with somber portraits of gray-haired
        men from decades past";

        if (!suitOfArmor.isListed) {
            "; a medieval suit of armor";

            /* if the axe is in the armor, list it specially */
            if (axe.isIn(suitOfArmor))
                ", posed with battle axe at the ready,";

            " towers over a single straight-backed wooden chair. ";
        }
        "The front door leads back outside to the south.  A
        hallway leads north.";
    }

    north = hallway
    south = frontDoor
    out = frontDoor
;

frontDoor: doorway
    location = startroom
    noun = 'door'
    adjective = 'front'
    sdesc = "front door"
    doordest =
    {
        "You'd rather stay in the house for now. ";
        return startroom;
    }
;

chair: chairitem
    location = startroom
    sdesc = "wooden chair"
    noun = 'chair'
    adjective = 'straight-backed' 'wooden'
;

suitOfArmor: armor
    AC = 5
    location = startroom
    sdesc = "suit of armor"
    noun = 'suit' 'armor'
    adjective = 'medieval'
    ldesc =
    {
        "It's a suit of plate-mail armor that looks suitable
        for a very tall knight. ";

        /* if I'm holding the axe, so note */
        if (axe.isIn(self))
            "The armor is posed with a huge battle-axe held
            at the ready. ";
    }
    isqcontainer = true
    isListed = nil
    doTake(actor) = {
        self.isListed := true;
        if (axe.isIn(self)) {
            "\n(also taking the axe)\n";
            execCommand(actor, takeVerb, axe);
        }
        pass doTake;
    }
;

axe: weapon
    sdesc = "battle axe"
    location = suitOfArmor
    noun = 'axe' 'blood' 'blade' 'edge'
    adjective = 'steel' 'battle' 'dried'
    ldesc = "It's a large steel battle axe.  A little bit of
             dried blood on the edge of the blade makes the authenticity
             of the equipment quite credible. "
;

portraits: fixeditem
    location = startroom
    noun = 'portraits' 'pictures' 'men'
    adjective = 'somber' 'gray-haired'
    sdesc = "portraits"

    isThem = true
    adesc = "a portrait"
;

hallway: room
    sdesc = "Hallway"
    ldesc = "This broad, dimly-lit corridor runs north and south. "

    south = startroom
    north = kitchen
;


troglodyte: monster
    sdesc = "troglodyte"
    noun = 'troglodyte'
    ldesc = "It's an ugly troll-like creature wielding a large club. "
    location = hallway
    aggressive = true
    dice = 1
    sides = 4
;

club: weapon
    sdesc = "club"
    noun = 'club'
    ldesc = "It's a basic wooden club. "
    location = troglodyte
    dice = 1
    sides = 6
;

kitchen: room
    sdesc = "Kitchen"
    ldesc = "This is a surprisingly cramped kitchen, equipped with
             antiques: the stove is a huge black iron contraption,
             and there doesn't even seem to be a refrigerator.  A
             hallway lies to the south. "
    south = hallway
;

stove: fixeditem, openable
    location = kitchen
    noun = 'stove' 'oven' 'contraption' 'door'
    adjective = 'huge' 'black' 'iron' 'stove'
    sdesc = "stove"
    ldesc =
    {
        "It's a huge black iron cube, with a front door that swings
        open sideways.  The door is currently <<
        self.isopen ? "open" : "closed">>. ";

        /* list my contents if there's anything inside */
        if (self.isopen && itemcnt(self.contents) != 0)
            "Inside the stove you can see <<listcont(self)>>. ";
    }

    /* it starts off closed */
    isopen = nil
;

loaf: fooditem
    location = stove
    sdesc = "loaf of bread"
    ldesc = "It's a fresh loaf with a golden-brown crust. "
    noun = 'loaf' 'bread' 'crust'
    adjective = 'fresh' 'golden-brown' 'brown'

    /* 
     *   override the "doEat" method - this is called when the player eats
     *   the item 
     */
    doEat(actor) =
    {
        "You tear off a piece and eat it; it's delicious.  You tear off
        a little more, then a little more, and before long the whole loaf
        is gone.\b";

        /* The bread will fully heal the eater.
         */
        if (actor.endurance < actor.maxendurance) {
            "It magically rejuvenates you.\n";
            actor.endurance := actor.maxendurance;
        }

        /* make the bread vanish by moving it to "nil" */
        self.moveInto(nil);
    }
;

chicken: monster, rapper
    sdesc = "chicken"
    noun = 'chicken'
    ldesc = "It's a regular old chicken. "
    location = kitchen
    dice = 1
    sides = 1
    wimpy = true
    aggressive = nil

    createcorpse() = {
        /* One would use this technique to make a corpse as well. */
        "You hear a strange sound in the distance: \"Bok! Bok!
        Boooooooookkkkkkk!\" The corpse magically dissolves, and in
        its place appears a ring.\n";
        ring.moveInto(location);
        self.moveInto(nil);
    }

    /* This is the daemon that controls the RAP behavior of the chicken.
     * Basically, it hunts the player after the player uses the testverb
     * 'bok'.
     */
    bokhunt = {
        self.rapAct(rAttacking, Me);
        self.hunting := true;
    }

    /* flag to make sure we accept only one deul. */
    hunting = nil

    /* we don't print anything to indicate to the player we have no
     * plan to execute.
     */
     rIdleDesc = nil
;

/* This verb is a testverb for taunting the chicken into a deul.
 */
bokVerb: darkVerb
    verb = 'bok'
    action(actor) = {
        if (chicken.location) {
            if (chicken.hunting)
                "You have already challenged the chicken to a deul. ";
            else {
                "You shout, loudly, \"Bok!\"\n
                You have challenged the chicken to a deul. Run as you
                will, it will chase you down, and may the best, ah,
                man win!\n";
                notify(chicken, &bokhunt, 0);
            }
        }
        else
            "You have already won the duel with the chicken. ";
    }
;

ring: armor // super armor
    sdesc = "ring"
    noun = 'ring'
    AC = 10
;

/* Standard stuff:
 */

replace commonInit: function
{
    /* display the special code sequence to turn on HTML recognition */
    "\H+";
}

getGameInfo: function
{
    /* build and return the game information list */
    return ['Name', 'T2 Combat Sample Game',
            'Byline', 'by Steve Breslin',
            'Desc', 'This is a simple game written as an example for
                    the T2 Combat module.',
            'Version', '1.0',
            'ReleaseDate', getGameInfoToday(),
            'Language', 'en-US'];
}

modify version
    sdesc = "T2 Combat: Sample Game --\n
            A simple game written as an example for the T2 Combat
            module.\b";
;
