/* The Complex Inventory Module:
 *	The complex inventory module changes the format of the inventory
 * display.  Instead of:
 * 	You have a bracelet (worn), a dagger (wielded), an elephant, and a
 * lantern (lit).
 *
 *      You see:
 *  You are holding:
 *  An elephant
 *  A lantern (lit)
 *
 *  You are wielding:
 *  A dagger
 *
 *  You are wearing:
 *  A bracelet
 */


modify iVerb
    action( actor ) =
    {
        if (length( actor.contents ))
        {
         "%You% %have%:\n"; mylistcont();
         listcontcont( actor );
        }
	else
            "%You% %have%:\nNothing\n";
    }
;

mylistcont: function
{
    local i, count, tot, list, cur;
    list := Me.contents;
    tot := length( list );
    i := 1;
    count := 0;
    while ( i <= tot )
    {
        cur := list[i];
        "\n";
        if ( cur.isListed and Me.ready <> cur and not cur.isworn)
        {
     	    caps();               // Make it look nice.
            cur.sdesc;            // list this object
	    count += 1;
            if ( cur.islamp and cur.islit ) " (providing light)";
            "\n";
        }
        i := i + 1;
    }
    if (count = 0) "Nothing\n";
#ifdef BITTY_COMBAT
    i := 1;		// This is only if using the 'wielded' module.
    count := 0;
        "\n\bYour wielded weapon is:\n";
    while ( i <= tot )
    {
        cur := list[i];
        if ( Me.ready = cur )
        {
            count += 1;
     	    caps();               // Make it look nice.
            cur.sdesc;            // list this object
            if ( cur.islamp and cur.islit ) " (providing light)";
            "\n";
        }
        i := i + 1;
    }
    if (count = 0) "Nothing\n";
#endif
    i := 1;
    count := 0;
        "\n\bYou are wearing:\n";
    while ( i <= tot )
    {
        cur := list[i];
        if ( cur.isworn )
        {
     	    caps();               // Make it look nice.
            cur.sdesc;            // list this object
            count += 1;
            if ( cur.islamp and cur.islit ) " (providing light)";
            "\n";
        }
        i := i + 1;
    }
    if (count = 0) "Nothing\n";
    "\b";
}

