/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ObjectMatch {
    private static final Vector EVERYTHING = new Vector();
    private int _count;
    private int _flags;
    private Vector _matches;
    private ObjectMatch[] _except;
    private int _size;
    private Vector _words;

    public ObjectMatch(int n) {
        this(n, 1, null);
    }

    public ObjectMatch(int n, int n2, Vector vector) {
        this._count = n2;
        this._size = n;
        this._words = new Vector();
        if (vector != null) {
            this._matches = new Vector(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                this._matches.addElement(new VocObj((TObject)vector.elementAt(i), 0));
            }
        } else {
            this._matches = EVERYTHING;
        }
    }

    public int get_count() {
        if ((this._flags & 0x80) != 0) {
            return 1;
        }
        return this._count;
    }

    public void set_count(int n) {
        this._count = n;
    }

    public int get_size() {
        return this._size;
    }

    public boolean is_ambig() {
        int n = 225;
        return (this._flags & n) == 0;
    }

    public int num_matches() {
        return this._matches.size();
    }

    public Vector get_matches() {
        if (this._matches == EVERYTHING) {
            return EVERYTHING;
        }
        Vector<TObject> vector = new Vector<TObject>(this._matches.size());
        for (int i = 0; i < this._matches.size(); ++i) {
            vector.addElement(((VocObj)this._matches.elementAt((int)i)).obj);
        }
        return vector;
    }

    public int get_match_flag(int n) {
        if (n < 0 || n >= this._matches.size()) {
            return -1;
        }
        return ((VocObj)this._matches.elementAt((int)n)).flags;
    }

    public int get_match_flag(TObject tObject) {
        for (int i = 0; i < this._matches.size(); ++i) {
            if (((VocObj)this._matches.elementAt((int)i)).obj != tObject) continue;
            return ((VocObj)this._matches.elementAt((int)i)).flags;
        }
        String string = tObject == null ? "null" : Integer.toString(tObject.get_id());
        Jetty.out.print_error("Requested flags for unknown object: " + string, 1);
        Thread.dumpStack();
        return 0;
    }

    public Vector get_words() {
        return this._words;
    }

    public String get_phrase() {
        String string = "";
        for (int i = 0; i < this._words.size(); ++i) {
            string = string + (i > 0 ? " " : "") + ((VocabWord)this._words.elementAt(i)).get_word();
        }
        return string;
    }

    public int get_flags() {
        return this._flags;
    }

    public boolean test_flags(int n) {
        return (this._flags & n) != 0;
    }

    public void set_flags(int n) {
        this._flags = n;
    }

    public ObjectMatch[] get_except() {
        return this._except;
    }

    public void set_except(ObjectMatch[] objectMatchArray) {
        int n;
        if (this._except != null) {
            for (n = 0; n < this._except.length; ++n) {
                this._size -= this._except[n].get_size();
            }
        }
        this._except = objectMatchArray;
        if (this._except != null) {
            for (n = 0; n < this._except.length; ++n) {
                this._size += this._except[n].get_size();
            }
        }
    }

    public void inc_size(int n) {
        this._size += n;
    }

    public boolean add_word(VocabWord vocabWord, String string, int n) throws HaltTurnException {
        Object object;
        int n2;
        int n3;
        VocabWord vocabWord2 = null;
        if (vocabWord.is_number()) {
            vocabWord2 = Jetty.state.lookup_vocab("#");
        } else if (vocabWord.is_unknown()) {
            this._words.addElement(vocabWord);
            ++this._size;
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        Vector<VocObj> vector = null;
        for (n3 = 0; n3 < Constants.vocab_prop_flags.length; ++n3) {
            if ((n & Constants.vocab_prop_flags[n3][1]) == 0) continue;
            Jetty.out.print_error("Doing " + Constants.vocab_names[n3] + " match of '" + vocabWord.get_word() + "'", 2);
            n2 = 0;
            if (Constants.vocab_prop_flags[n3][0] == 4 && (n & 4) != 0) {
                n2 |= 0x1000;
            }
            object = vocabWord.get_objects(Constants.vocab_prop_flags[n3][0], string);
            if (vocabWord2 != null) {
                int[] nArray = vocabWord2.get_objects(Constants.vocab_prop_flags[n3][0], string);
                if (object == null) {
                    object = nArray;
                } else if (nArray != null) {
                    int[] nArray2 = new int[((E)object).length + nArray.length];
                    System.arraycopy(object, 0, nArray2, 0, ((E)object).length);
                    System.arraycopy(nArray, 0, nArray2, ((E)object).length, nArray.length);
                    object = nArray2;
                }
            }
            if (object == null) {
                Jetty.out.print_error("(no matching objects)", 2);
                continue;
            }
            boolean bl3 = false;
            for (int i = 0; i < ((E)object).length; ++i) {
                VocObj vocObj = null;
                if (this._matches == EVERYTHING) {
                    TObject tObject = Jetty.state.lookup_object((int)object[i]);
                    if (!tObject.is_class()) {
                        vocObj = new VocObj(tObject, n2);
                        if (vector == null) {
                            vector = new Vector();
                        }
                        vector.addElement(vocObj);
                        bl3 = true;
                        Jetty.out.print_error("adding obj=" + (int)object[i] + " since matches=EVERYTHING", 2);
                    } else {
                        Jetty.out.print_error("not adding obj=" + (int)object[i] + " because it's a class", 2);
                    }
                } else {
                    for (int j = 0; j < this._matches.size(); ++j) {
                        vocObj = (VocObj)this._matches.elementAt(j);
                        if (vocObj.obj != null && vocObj.obj.get_id() == object[i]) {
                            vocObj.flags |= n2;
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.addElement(vocObj);
                            bl3 = true;
                            Jetty.out.print_error("adding obj=" + (int)object[i] + " since it was in matches", 2);
                            break;
                        }
                        vocObj = null;
                    }
                }
                if (vocObj == null || !vocabWord.is_truncated()) continue;
                boolean bl4 = false;
                Vector vector2 = vocObj.obj.get_vocab();
                for (int j = 0; j < vector2.size(); ++j) {
                    if (!((VocabWord)vector2.elementAt(j)).get_word().equals(vocabWord.get_word())) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                vocObj.flags |= 0x2000;
            }
            if (!bl3) continue;
            if (Constants.vocab_prop_flags[n3][0] == 7) {
                bl2 = true;
            }
            if (Constants.vocab_prop_flags[n3][0] != 3) continue;
            bl = true;
        }
        if (vocabWord.is_specword("N")) {
            if (vector == null) {
                vector = this._matches;
            }
            bl = true;
        } else if (vocabWord.is_specword("P")) {
            if (vector == null) {
                vector = this._matches;
            }
            bl2 = true;
        }
        if (bl2 && !bl) {
            this._flags |= 0x40;
        }
        if (vector == null) {
            vector = new Vector<VocObj>(0);
        } else {
            for (n3 = 1; n3 < vector.size(); ++n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (((VocObj)vector.elementAt((int)n3)).obj.get_id() >= ((VocObj)vector.elementAt((int)n2)).obj.get_id()) continue;
                    object = vector.elementAt(n3);
                    vector.setElementAt((VocObj)vector.elementAt(n2), n3);
                    vector.setElementAt((VocObj)object, n2);
                }
            }
        }
        this._matches = vector;
        this._words.addElement(vocabWord);
        ++this._size;
        return true;
    }

    public void append_word(VocabWord vocabWord) {
        this._words.addElement(vocabWord);
        ++this._size;
    }

    public void prepend_word(VocabWord vocabWord) {
        this._words.insertElementAt(vocabWord, 0);
        ++this._size;
    }

    public void add_object(TObject tObject) {
        this.add_object(tObject, 0);
    }

    public void add_object(TObject tObject, int n) {
        if (this._matches == EVERYTHING) {
            this._matches = new Vector();
        }
        for (int i = 0; i < this._matches.size(); ++i) {
            VocObj vocObj = (VocObj)this._matches.elementAt(i);
            if (vocObj.obj != tObject) continue;
            vocObj.flags = n;
            return;
        }
        this._matches.addElement(new VocObj(tObject, n));
    }

    public boolean merge(ObjectMatch objectMatch) {
        int n;
        Vector<VocObj> vector = null;
        if (this._matches == EVERYTHING && objectMatch._matches == EVERYTHING) {
            vector = EVERYTHING;
        } else if (this._matches == EVERYTHING) {
            vector = objectMatch._matches;
        } else if (objectMatch._matches == EVERYTHING) {
            vector = this._matches;
        } else {
            for (n = 0; n < this._matches.size(); ++n) {
                VocObj vocObj = (VocObj)this._matches.elementAt(n);
                for (int i = 0; i < objectMatch._matches.size(); ++i) {
                    VocObj vocObj2 = (VocObj)objectMatch._matches.elementAt(i);
                    if (vocObj.obj != vocObj2.obj) continue;
                    if (vector == null) {
                        vector = new Vector<VocObj>();
                    }
                    vector.addElement(vocObj);
                    vocObj.flags |= vocObj2.flags;
                }
            }
        }
        if (vector == null) {
            return false;
        }
        this._matches = vector;
        for (n = 0; n < objectMatch._words.size(); ++n) {
            this._words.addElement(objectMatch._words.elementAt(n));
        }
        return true;
    }

    public void copy_words(ObjectMatch objectMatch) {
        this._words = (Vector)objectMatch._words.clone();
        this._size = objectMatch._size;
    }

    public String toString() {
        int n;
        String string = "count=" + this._count;
        string = string + " objects=[";
        if (this._matches == EVERYTHING) {
            string = string + "EVERYTHING";
        } else {
            for (n = 0; n < this._matches.size(); ++n) {
                VocObj vocObj = (VocObj)this._matches.elementAt(n);
                string = string + (n == 0 ? "" : " ") + (vocObj.obj == null ? "NIL" : Integer.toString(vocObj.obj.get_id())) + "(" + vocObj.flags + ")";
            }
        }
        string = string + "] flags=" + this._flags;
        string = string + "\nsize=" + this._size + " words=[";
        for (n = 0; n < this._words.size(); ++n) {
            string = string + (n == 0 ? "" : " ") + ((VocabWord)this._words.elementAt(n)).get_word();
        }
        string = string + "]";
        return string;
    }

    private static class VocObj {
        public TObject obj = null;
        public int flags = 0;

        public VocObj(TObject tObject, int n) {
            this.obj = tObject;
            this.flags = n;
        }
    }
}

