/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ObjectMatch {
    private static final Vector EVERYTHING = new Vector();
    private int _count;
    private int _flags;
    private Vector _matches;
    private ObjectMatch[] _except;
    private int _size;
    private Vector _words;

    public ObjectMatch(int n) {
        this(n, 1, null);
    }

    public ObjectMatch(int n, int n2, Vector vector) {
        this._count = n2;
        this._size = n;
        this._words = new Vector();
        if (vector != null) {
            this._matches = new Vector(vector.size());
            int n3 = 0;
            while (n3 < vector.size()) {
                this._matches.addElement(new VocObj((TObject)vector.elementAt(n3), 0));
                ++n3;
            }
        } else {
            this._matches = EVERYTHING;
        }
    }

    public int get_count() {
        if ((this._flags & 0x80) != 0) {
            return 1;
        }
        return this._count;
    }

    public void set_count(int n) {
        this._count = n;
    }

    public int get_size() {
        return this._size;
    }

    public boolean is_ambig() {
        int n = 225;
        return (this._flags & n) == 0;
    }

    public int num_matches() {
        return this._matches.size();
    }

    public Vector get_matches() {
        if (this._matches == EVERYTHING) {
            return EVERYTHING;
        }
        Vector<TObject> vector = new Vector<TObject>(this._matches.size());
        int n = 0;
        while (n < this._matches.size()) {
            vector.addElement(((VocObj)this._matches.elementAt((int)n)).obj);
            ++n;
        }
        return vector;
    }

    public int get_match_flag(int n) {
        if (n < 0 || n >= this._matches.size()) {
            return -1;
        }
        return ((VocObj)this._matches.elementAt((int)n)).flags;
    }

    public int get_match_flag(TObject tObject) {
        int n = 0;
        while (n < this._matches.size()) {
            if (((VocObj)this._matches.elementAt((int)n)).obj == tObject) {
                return ((VocObj)this._matches.elementAt((int)n)).flags;
            }
            ++n;
        }
        String string = tObject == null ? "null" : Integer.toString(tObject.get_id());
        Jetty.out.print_error("Requested flags for unknown object: " + string, 1);
        Thread.dumpStack();
        return 0;
    }

    public Vector get_words() {
        return this._words;
    }

    public String get_phrase() {
        String string = "";
        int n = 0;
        while (n < this._words.size()) {
            string = string + (n > 0 ? " " : "") + ((VocabWord)this._words.elementAt(n)).get_word();
            ++n;
        }
        return string;
    }

    public int get_flags() {
        return this._flags;
    }

    public boolean test_flags(int n) {
        return (this._flags & n) != 0;
    }

    public void set_flags(int n) {
        this._flags = n;
    }

    public ObjectMatch[] get_except() {
        return this._except;
    }

    public void set_except(ObjectMatch[] objectMatchArray) {
        int n;
        if (this._except != null) {
            n = 0;
            while (n < this._except.length) {
                this._size -= this._except[n].get_size();
                ++n;
            }
        }
        this._except = objectMatchArray;
        if (this._except != null) {
            n = 0;
            while (n < this._except.length) {
                this._size += this._except[n].get_size();
                ++n;
            }
        }
    }

    public void inc_size(int n) {
        this._size += n;
    }

    public boolean add_word(VocabWord vocabWord, String string, int n) throws HaltTurnException {
        Object object;
        int n2;
        VocabWord vocabWord2 = null;
        if (vocabWord.is_number()) {
            vocabWord2 = Jetty.state.lookup_vocab("#");
        } else if (vocabWord.is_unknown()) {
            this._words.addElement(vocabWord);
            ++this._size;
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        Vector<VocObj> vector = null;
        int n3 = 0;
        while (n3 < Constants.vocab_prop_flags.length) {
            if ((n & Constants.vocab_prop_flags[n3][1]) != 0) {
                Jetty.out.print_error("Doing " + Constants.vocab_names[n3] + " match of '" + vocabWord.get_word() + "'", 2);
                n2 = 0;
                if (Constants.vocab_prop_flags[n3][0] == 4 && (n & 4) != 0) {
                    n2 |= 0x1000;
                }
                Object object2 = vocabWord.get_objects(Constants.vocab_prop_flags[n3][0], string);
                if (vocabWord2 != null) {
                    object = vocabWord2.get_objects(Constants.vocab_prop_flags[n3][0], string);
                    if (object2 == null) {
                        object2 = object;
                    } else if (object != null) {
                        int[] nArray = new int[((int[])object2).length + ((E)object).length];
                        System.arraycopy(object2, 0, nArray, 0, ((int[])object2).length);
                        System.arraycopy(object, 0, nArray, ((int[])object2).length, ((E)object).length);
                        object2 = nArray;
                    }
                }
                if (object2 == null) {
                    Jetty.out.print_error("(no matching objects)", 2);
                } else {
                    boolean bl3 = false;
                    int n4 = 0;
                    while (n4 < ((int[])object2).length) {
                        VocObj vocObj = null;
                        if (this._matches == EVERYTHING) {
                            TObject tObject = Jetty.state.lookup_object(object2[n4]);
                            if (!tObject.is_class()) {
                                vocObj = new VocObj(tObject, n2);
                                if (vector == null) {
                                    vector = new Vector();
                                }
                                vector.addElement(vocObj);
                                bl3 = true;
                                Jetty.out.print_error("adding obj=" + object2[n4] + " since matches=EVERYTHING", 2);
                            } else {
                                Jetty.out.print_error("not adding obj=" + object2[n4] + " because it's a class", 2);
                            }
                        } else {
                            int n5 = 0;
                            while (n5 < this._matches.size()) {
                                vocObj = (VocObj)this._matches.elementAt(n5);
                                if (vocObj.obj != null && vocObj.obj.get_id() == object2[n4]) {
                                    vocObj.flags |= n2;
                                    if (vector == null) {
                                        vector = new Vector();
                                    }
                                    vector.addElement(vocObj);
                                    bl3 = true;
                                    Jetty.out.print_error("adding obj=" + object2[n4] + " since it was in matches", 2);
                                    break;
                                }
                                vocObj = null;
                                ++n5;
                            }
                        }
                        if (vocObj != null && vocabWord.is_truncated()) {
                            boolean bl4 = false;
                            Vector vector2 = vocObj.obj.get_vocab();
                            int n6 = 0;
                            while (n6 < vector2.size()) {
                                if (((VocabWord)vector2.elementAt(n6)).get_word().equals(vocabWord.get_word())) {
                                    bl4 = true;
                                    break;
                                }
                                ++n6;
                            }
                            if (!bl4) {
                                vocObj.flags |= 0x2000;
                            }
                        }
                        ++n4;
                    }
                    if (bl3) {
                        if (Constants.vocab_prop_flags[n3][0] == 7) {
                            bl2 = true;
                        }
                        if (Constants.vocab_prop_flags[n3][0] == 3) {
                            bl = true;
                        }
                    }
                }
            }
            ++n3;
        }
        if (vocabWord.is_specword("N")) {
            if (vector == null) {
                vector = this._matches;
            }
            bl = true;
        } else if (vocabWord.is_specword("P")) {
            if (vector == null) {
                vector = this._matches;
            }
            bl2 = true;
        }
        if (bl2 && !bl) {
            this._flags |= 0x40;
        }
        if (vector == null) {
            vector = new Vector<VocObj>(0);
        } else {
            n2 = 1;
            while (n2 < vector.size()) {
                int n7 = 0;
                while (n7 < n2) {
                    if (((VocObj)vector.elementAt((int)n2)).obj.get_id() < ((VocObj)vector.elementAt((int)n7)).obj.get_id()) {
                        object = vector.elementAt(n2);
                        vector.setElementAt((VocObj)vector.elementAt(n7), n2);
                        vector.setElementAt((VocObj)object, n7);
                    }
                    ++n7;
                }
                ++n2;
            }
        }
        this._matches = vector;
        this._words.addElement(vocabWord);
        ++this._size;
        return true;
    }

    public void append_word(VocabWord vocabWord) {
        this._words.addElement(vocabWord);
        ++this._size;
    }

    public void prepend_word(VocabWord vocabWord) {
        this._words.insertElementAt(vocabWord, 0);
        ++this._size;
    }

    public void add_object(TObject tObject) {
        this.add_object(tObject, 0);
    }

    public void add_object(TObject tObject, int n) {
        if (this._matches == EVERYTHING) {
            this._matches = new Vector();
        }
        int n2 = 0;
        while (n2 < this._matches.size()) {
            VocObj vocObj = (VocObj)this._matches.elementAt(n2);
            if (vocObj.obj == tObject) {
                vocObj.flags = n;
                return;
            }
            ++n2;
        }
        this._matches.addElement(new VocObj(tObject, n));
    }

    public boolean merge(ObjectMatch objectMatch) {
        int n;
        Vector<VocObj> vector = null;
        if (this._matches == EVERYTHING && objectMatch._matches == EVERYTHING) {
            vector = EVERYTHING;
        } else if (this._matches == EVERYTHING) {
            vector = objectMatch._matches;
        } else if (objectMatch._matches == EVERYTHING) {
            vector = this._matches;
        } else {
            n = 0;
            while (n < this._matches.size()) {
                VocObj vocObj = (VocObj)this._matches.elementAt(n);
                int n2 = 0;
                while (n2 < objectMatch._matches.size()) {
                    VocObj vocObj2 = (VocObj)objectMatch._matches.elementAt(n2);
                    if (vocObj.obj == vocObj2.obj) {
                        if (vector == null) {
                            vector = new Vector<VocObj>();
                        }
                        vector.addElement(vocObj);
                        vocObj.flags |= vocObj2.flags;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (vector == null) {
            return false;
        }
        this._matches = vector;
        n = 0;
        while (n < objectMatch._words.size()) {
            this._words.addElement(objectMatch._words.elementAt(n));
            ++n;
        }
        return true;
    }

    public void copy_words(ObjectMatch objectMatch) {
        this._words = (Vector)objectMatch._words.clone();
        this._size = objectMatch._size;
    }

    public String toString() {
        int n;
        String string = "count=" + this._count;
        string = string + " objects=[";
        if (this._matches == EVERYTHING) {
            string = string + "EVERYTHING";
        } else {
            n = 0;
            while (n < this._matches.size()) {
                VocObj vocObj = (VocObj)this._matches.elementAt(n);
                string = string + (n == 0 ? "" : " ") + (vocObj.obj == null ? "NIL" : Integer.toString(vocObj.obj.get_id())) + "(" + vocObj.flags + ")";
                ++n;
            }
        }
        string = string + "] flags=" + this._flags;
        string = string + "\nsize=" + this._size + " words=[";
        n = 0;
        while (n < this._words.size()) {
            string = string + (n == 0 ? "" : " ") + ((VocabWord)this._words.elementAt(n)).get_word();
            ++n;
        }
        string = string + "]";
        return string;
    }

    private static class VocObj {
        public TObject obj = null;
        public int flags = 0;

        public VocObj(TObject tObject, int n) {
            this.obj = tObject;
            this.flags = n;
        }
    }
}

