//
//  XTHtmlTagOl.m
//  TadsTerp
//
//  Created by Rune Berg on 21/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagOl.h"
#import "XTOutputFormatterProtocol.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlListAttrs.h"
#import "XTBaseTextHandler.h"


@interface XTHtmlTagOl ()

@property NSUInteger itemIndex;

@end


@implementation XTHtmlTagOl

- (instancetype)init
{
	self = [super init];
	if (self) {
		_itemIndex = 1;
	}
	return self;
}

+ (NSString *)name
{
	return @"ol";
}

- (NSUInteger)getItemIndex
{
	return self.itemIndex;
}

- (NSUInteger)incItemIndex
{
	self.itemIndex += 1;
	return self.itemIndex;
}

- (void)setItemIndexForContinue:(NSUInteger)itemIndexForContinue
{
	if ([self hasAttribute:@"continue"]) {
		self.itemIndex = itemIndexForContinue;
	}
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	[super format:formatter textHandler:textHandler];

	NSArray *formattedElements = [formatter handleHtmlTagOlOpen:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [super makeFormattingSpecificationFrom:formattingSpec];
	
	res.listBulletType = XT_LIST_BULLET_TYPE_OL_DECIMAL;
	
	for (XTPair *attrNameAndValue in self.attributesArray) {

		if ([self attributeNameAndValue:attrNameAndValue hasName:@"plain"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_PLAIN;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"1"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_DECIMAL;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"a"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_LOWER_ALPHA;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"A"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_UPPER_ALPHA;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"i"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_LOWER_ROMAN;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:XT_LIST_BULLET_TYPE_ATTR_NAME withCaseSensitiveValue:@"I"]) {
			res.listBulletType = XT_LIST_BULLET_TYPE_OL_UPPER_ROMAN;
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:@"start"]) {
			[self setItemIndexFromAttribute:@"start"];
		} else if ([self attributeNameAndValue:attrNameAndValue hasName:@"seqnum"]) {
			[self setItemIndexFromAttribute:@"seqnum"];
		}
	}

	return res;
}

- (void)setItemIndexFromAttribute:(NSString *)attrName
{
	NSNumber *attrValue = [self attributeAsNumber:attrName];
	[self setItemIndexFromValue:attrValue];
}

- (void)setItemIndexFromValue:(NSNumber *)attrValue
{
	if (attrValue != nil) {
		NSInteger num = attrValue.integerValue;
		if (num < 0) {
			num = 0;
		}
		self.itemIndex = num;
	}
}

@end
