//
//  XTHtmlUtils.h
//  XTads
//
//  Created by Rune Berg on 15/03/2019.
//  Copyright © 2019 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlTag.h"
#import "XTHtmlTagContainer.h"
#import "XTHtmlTagListContainer.h"


@interface XTHtmlUtils : NSObject

+ (BOOL)tagIsEnclosedByDivOrCenter:(XTHtmlTag *)tag;

+ (BOOL)tagIsEnclosedByListOrListItem:(XTHtmlTag *)tag;

+ (BOOL)tag:(XTHtmlTag *)tag hasParentOfClass:(Class)aClass;

+ (XTHtmlTagListContainer *)listContainerFor:(XTHtmlTag *)tag;

+ (XTHtmlTagContainer *)findAncestorTagContainerOfClass:(Class)aClass
									   forDescendantTag:(XTHtmlTag *)descendantTag
									  includeDescendant:(BOOL)includeDescendant;

+ (void)extractHtmlFontSizeFromTag:(XTHtmlTag *)tag toFormattingSpec:(XTFormattingSpecification *)formattingSpec;

+ (void)extractBaseHtmlFontSizeFromTag:(XTHtmlTag *)tag toFormattingSpec:(XTFormattingSpecification *)formattingSpec;

+ (void)extractHtmlFontFaceFromTag:(XTHtmlTag *)tag toFormattingSpec:(XTFormattingSpecification *)formattingSpec;

+ (void)extractHtmlFontColorFromTag:(XTHtmlTag *)tag toFormattingSpec:(XTFormattingSpecification *)formattingSpec;

@end
