//
//  XTScrollView.m
//  XTads
//
//  Created by Rune Berg on 28/01/16.
//  Copyright © 2016 Rune Berg. All rights reserved.
//

#import "XTScrollView.h"
#import "XTAllocDeallocCounter.h"


@implementation XTScrollView

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (BOOL)isCompatibleWithResponsiveScrolling
{
	// https://developer.apple.com/library/mac/documentation/Cocoa/Reference/ApplicationKit/Classes/NSView_Class/index.html#//apple_ref/occ/clm/NSView/isCompatibleWithResponsiveScrolling
	return YES;
}

- (instancetype)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame:frameRect];
	if (self != nil) {
		_allowUserScrolling = YES;
	}
	return self;
}

- (void)scrollWheel:(NSEvent *)theEvent
{
	if (self.allowUserScrolling) {
		[super scrollWheel:theEvent];
	}
}

@end
