//
//  XTLogAppenderBase.m
//  TadsTerp
//
//  Created by Rune Berg on 15/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTLogAppenderBase.h"
#import "XTLoggerLevel.h"


@implementation XTLogAppenderBase

static NSDictionary *levelNameByLevel;

+ (void)initialize
{
	levelNameByLevel = @{
	   [NSNumber numberWithInteger:XT_LEVEL_TRACE] : @"T",
	   [NSNumber numberWithInteger:XT_LEVEL_DEBUG] : @"D",
	   [NSNumber numberWithInteger:XT_LEVEL_INFO] : @"I",
	   [NSNumber numberWithInteger:XT_LEVEL_WARN] : @"W",
	   [NSNumber numberWithInteger:XT_LEVEL_ERROR] : @"E",
	   [NSNumber numberWithInteger:XT_LEVEL_FATAL] : @"F"
	};
}

- (NSString *)nameForLevel:(XTLoggerLevel)level
{
	NSString *res = levelNameByLevel[[NSNumber numberWithInteger:level]];
	if (res == nil) {
		res = @"?";
	}
	return res;
}

@end
