//
//  XTTabStopModelEntry.h
//  XTads
//
//  Created by Rune Berg on 06/02/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSInteger, XTTabStopAlignment) {
	XTTABSTOP_ALIGN_LEFT,
	XTTABSTOP_ALIGN_CENTER,
	XTTABSTOP_ALIGN_RIGHT,
	XTTABSTOP_ALIGN_DEC_POINT
};

// Keys for custom attributes on XTTextTab
#define XT_TAB_TYPE_KEY @"xtads.tabType"
#define XT_TAB_MODEL_ENTRY_KEY @"xtads.tabModelEntry"
#define XT_TAB_ID_KEY @"xtads_tabstop_id"
#define XT_TAB_MULTIPLE_KEY @"xtads.tabMultiple"
//TODO !!! adapt: is this used for anything real?

// Values for custom attributes on NSTextTab
#define XT_TAB_TYPE_RHS_OF_VIEW @"xtads.tabRhsOfView"
#define XT_TAB_TYPE_HALFWAY_TO_RHS_OF_VIEW @"xtads.tabHalfwayToRhsOfView"
#define XT_TAB_TYPE_TO_ID @"xtads.tabToId"
#define XT_TAB_TYPE_MULTIPLE @"xtads.tabAtMultiple"
#define XT_TAB_TYPE_FIXED_POS @"xtads.tabFixedPos"

#define XT_TABSTOP_DEFAULT_DEC_CHAR @"."


@interface XTTabStopModelEntry : NSObject <NSCopying>

@property NSString *ident;
@property NSNumber *position;
@property CGFloat positionAdjustmentForDecimalPoint;
@property NSNumber *alignment;
@property NSString *decimalChar;
@property (readonly) NSString *effectiveDecimalChar;

@property (readonly) BOOL decimalPointAligned;

@property (readonly) NSTextAlignment nsTextAlignment;

@property (readonly) NSDictionary<NSString *,id> *nsTextAlignmentOptions;

- (NSDictionary<NSString *,id> *)getCustomOptions;

@end
