//
//  XTHtmlTagLi.m
//  TadsTerp
//
//  Created by Rune Berg on 21/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTag_private.h"
#import "XTHtmlTagLi.h"
#import "XTHtmlTagOl.h"
#import "XTHtmlTagUl.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagLi

+ (NSString *)name
{
	return @"li";
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	//TODO exp. what about <li> ouside <ol>/<ul>?
	//TODO only if in <ol> or <ul> !!
	
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	[super format:formatter textHandler:textHandler];

	NSArray *formattedElements = [formatter handleHtmlTagLiOpen:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagLiClose:self];
	[textHandler receiveFormattedElements:formattedElements];

	[super formatExit:formatter textHandler:textHandler];
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.inListItem = YES;
	return res;
}

- (XTHtmlTagContainer *)findCorrectContainer:(XTHtmlTagContainer *)defaultContainer
{
	XTHtmlTagContainer *res = defaultContainer;
	
	for (XTHtmlTagContainer *container = defaultContainer;
		 container != nil;
		 container = container.container) {
		
		if ([container isKindOfClass:[XTHtmlTagOl class]] || [container isKindOfClass:[XTHtmlTagUl class]]) {
			// Our nearest <ol> or <ul> is the one
			res = container;
			break;
		}
	}
	
	return res;
}

@end
