//
//  XTHtmlTagFont.m
//  TadsTerp
//
//  Created by Rune Berg on 20/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagFont.h"
#import "XTOutputFormatterProtocol.h"
#import "XTHtmlColor.h"


@implementation XTHtmlTagFont

+ (NSString *)name
{
	return @"font";
}

+ (BOOL)standalone
{
	return NO;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];

	NSInteger sign;
	NSUInteger htmlSize;
	if ([self attribute:@"size" asOptionalSign:&sign andUint:&htmlSize]) {
		if (htmlSize < 1 || htmlSize > 7) {
			htmlSize = 3;
		}
		if (sign != 0) {
			// relative size
			if (sign < 0) {
				res.htmlSize -= htmlSize;
			} else {
				res.htmlSize += htmlSize;
			}
			if (res.htmlSize < 1) {
				res.htmlSize = 1;
			} else if (res.htmlSize > 7) {
				res.htmlSize = 7;
			}
		} else {
			// fixed size
			res.htmlSize = htmlSize;
		}
	}
	
	NSArray *htmlFontFaceList = [self attributeAsCommaSeparatedStrings:@"face"];
	if (htmlFontFaceList != nil && htmlFontFaceList.count >= 1) {
		res.htmlFontFaceList = htmlFontFaceList;
	}
	
	NSString *colorAttr = [self attributeAsString:@"color"];
	if (colorAttr != nil) {
		res.fontColor = [XTHtmlColor forAttributeValue:colorAttr];
	}
	
	NSString *bgColorAttr = [self attributeAsString:@"bgcolor"];
	if (bgColorAttr != nil) {
		res.backgroundColor = [XTHtmlColor forAttributeValue:bgColorAttr];
	}
	
	//TODO !!! inherited behaviour like htmltags.cpp l.3408 ?
	
	return res;
}

@end
