//
//  osxtads_support.m
//  XTads
//
//  Created by Rune Berg on 11/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "osxtads_support.h"
#import "XTLogger.h"
#import "XTAppDelegateProvider.h"
#import "XTAppDelegate.h"

extern void osxtads_dirs_init();


static XTLogger *osifc_logger;
static XTAppDelegate *appDelegate;


void osxtads_init()
{
	osifc_logger = [XTLogger loggerForName:@"osxtads"];

	osxtads_dirs_init();
}

XTLogger *osifcLogger()
{
	return osifc_logger;
};

id<XTGameRunnerProtocol> getGameRunner()
{
	if (appDelegate == nil) {
		XTAppDelegateProvider *provider = [XTAppDelegateProvider new];
		appDelegate = [provider getAppDelegate];
	}

	id<XTGameRunnerProtocol> gr = [appDelegate getGameRunner];
	return gr;
}
