//
//  XTDirectoryHelper.h
//  TadsTerp
//
//  Created by Rune Berg on 31/10/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSInteger, XTadsFileNameDialogFileType) {
	XTadsFileNameDialogFileTypeGame,
	XTadsFileNameDialogFileTypeSavedGame,
	XTadsFileNameDialogFileTypeTranscript,
	XTadsFileNameDialogFileTypeCommandScript,
	XTadsFileNameDialogFileTypeGeneral
};


@interface XTFileNameHelper : NSObject

+ (id)helper;

- (NSURL*)findDefaultDirectoryForFileType:(XTadsFileNameDialogFileType)fileType;

- (void)noteUsedDirectory:(NSURL *)dirUrl
			  forFileType:(XTadsFileNameDialogFileType)fileType;

- (NSString*)findDefaultFileBasenameForGameFileUrl:(NSURL *)gameFileUrl
										  fileType:(XTadsFileNameDialogFileType)fileType;

@end
