//
//  XTHtmlTagLh.m
//  XTads
//
//  Created by Rune Berg on 16/02/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagLh.h"
#import "XTHtmlTagListContainer.h"


@implementation XTHtmlTagLh

+ (NSString *)name
{
	return @"lh";
}

+ (BOOL)standalone
{
	return NO;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	
	XTHtmlTag *container = [self getContainer];
	if ([container isKindOfClass:[XTHtmlTagListContainer class]]) {
		res.inListHeader = YES;
		res.bold = YES;
	}
	return res;
}

@end
