//
//  XTMainTextHandler.h
//  TadsTerp
//
//  Created by Rune Berg on 28/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"
#import "XTCommandHistory.h"
#import "XTGameWindowController.h"
#import "XTFormattedOutputElement.h"


@interface XTMainTextHandler : XTBaseTextHandler

@property (weak) NSView *rootBannerContainerView; // for main area's banner handler only

@property NSMutableString *gameTitle;

@property XTCommandHistory *commandHistory;
@property NSUInteger commandPromptPosition;
@property void *activeTagBannerHandle;
@property NSUInteger statusLineMode;

+ (instancetype)handler;

- (void)removeHandler;

- (void)setIsForT3:(BOOL)isForT3;

- (void)resetToDefaults;

- (void)setNonstopMode:(BOOL)nonstopMode;

- (void)resetForGameHasEndedMsg;

- (BOOL)appendOutput:(NSString *)string;

- (void)appendOutputNewlineAfterCommand:(NSString *)string;

- (void)flushOutput;

- (void)hardFlushOutput;

- (void)appendInput:(NSString *)string;

- (void)handleCommandLinkClicked:(NSString *)linkString atIndex:(NSUInteger)charIndex;

- (void)ensureInputFontIsInEffect;

- (void)clearText;

- (void)mainThread_getCommand:(NSMutableArray *)returnValue;

- (void)mainThread_cancelTimedOutCommand:(NSArray *)args;

- (void)createTextViewForMainOutputArea;

- (void)configureViews;

// the index where new input text is appended
- (NSInteger)insertionPoint;

- (NSInteger)minInsertionPoint;

- (void)moveCursorToStartOfCommand;

- (BOOL)cursorIsInCommand;

- (BOOL)cursorIsAtMinInsertionPosition;

- (BOOL)cursorIsInCommandButNotAtMinInsertionPosition;

- (void)replaceCommandText:(NSString *)newCommandText;

- (void)mainThread_restoreCommandInProgressAtTimeout;

- (void)mainThread_captureCommandInProgressAtTimeout;

- (BOOL)allowTextInsertion:(NSRange)affectedCharRange;

- (void)goToPreviousCommand;

- (void)goToNextCommand;

//TODO clumsy to have this here
- (void)exitingStatusLineMode:(XTFormattedOutputElement *)outputElement;

- (void)setStatusLineModeNow:(NSUInteger)statusLineMode;

- (void)exitingTagBanner;

- (void)processFormattedElementQueueGameTitleElement:(XTFormattedOutputElement *)outputElement;

- (NSString *)hardNewline;

@end
