//
//  XTFormattingSpecification.h
//  XTads
//
//  Created by Rune Berg on 02/06/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextAlignMode.h"
#import "XTTextVerticalAlignMode.h"
#import "XTTextTable.h"
#import "XTHtmlColor.h"
#import "XTHtmlListAttrs.h"

@class XTHtmlTagA;
@class XTOutputFormatterProtocol;


@interface XTFormattingSpecification : NSObject

//TODO !!! tons more state - see CHtmlFontDesc, htmlsys.h l. 72

@property BOOL bold;
@property BOOL italic;
@property BOOL underline;
@property BOOL tt;
@property BOOL cite;
@property BOOL code;
@property BOOL em;
@property BOOL strong;
@property BOOL strikethrough;
@property BOOL superscript;
@property BOOL subscript;
@property BOOL t2Hilite;
@property BOOL t2Italics;
@property NSInteger baseHtmlSize;
@property NSInteger htmlSize;
@property NSArray *htmlFontFaceList;
@property XTHtmlColor *fontColor;
@property XTHtmlColor *backgroundColor;

//TODO !!! do these belong in this class? {
@property (weak) XTHtmlTagA *activeTagA;

@property (weak) XTTextTable *activeTextTable;
	//probably not right?
@property NSTextTableBlock *activeTextTableCell;
@property NSUInteger tableRowIndexPlusOne;
@property NSUInteger tableColumnIndexPlusOne;
@property XTHtmlColor *textTableRowHtmlColor;
@property XTHtmlColor *textTableCellHtmlColor;
@property NSNumber *trHeightAsPercentage;
@property NSNumber *trHeightAsPoints;
@property BOOL trHeightStar;
@property XTTextVerticalAlignMode tableVerticalAlignMode;

@property XTHtmlListBulletType listBulletType;
@property NSUInteger listLevel;
@property BOOL inListHeader;
@property BOOL inListItem;
@property BOOL inListItemAfterFirstParagraph;

@property NSUInteger blockquoteLevel;

@property NSUInteger dlLevel;
@property BOOL dd;

@property BOOL credit;
@property BOOL address;

@property BOOL dfn;
@property BOOL var;

@property BOOL verbatim;
// }

@property BOOL inAboutBox;

@property XTTextAlignMode textAlignMode;
	//TODO !!! not quite how html tads does it...
@property (readonly) NSString *textAlignModeAsString;

@property BOOL isInHeader;

@property BOOL hasRightAlignedTab;

+ (instancetype)specificationWithDefaults;

+ (instancetype)specificationFrom:(XTFormattingSpecification *)original;

- (void)resetForNextCommand;

- (void)setTotalHeadIndent:(CGFloat)totalHeadIndent;
- (CGFloat)totalHeadIndent;

- (void)setTotalTailIndent:(CGFloat)totalTailIndent;
- (CGFloat)totalTailIndent;

@end
