//
//  XTPrefsItemBoolLinksUnderline.m
//  XTads
//
//  Created by Rune Berg on 06/06/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTPrefsItem_private.h"
#import "XTPrefsItemBoolLinksUnderline.h"


@implementation XTPrefsItemBoolLinksUnderline

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;
{
	return [XTPrefsItemBoolLinksUnderline itemWithDefaultValue:defaultValue userDefaultsKey:userDefaultsKey valueTransformer:nil];
}

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer
{
	XTPrefsItemBoolLinksUnderline *item = [XTPrefsItemBoolLinksUnderline new];
	item.defaultValue = defaultValue;
	item.userDefaultsKey = userDefaultsKey;
	item.valueTransformer = valueTransformer;
	item.value = [item copyOfDefaultValue];
	item.skipResetToDefault = NO;
	return item;
}

@end
